/*
 * Decompiled with CFR 0.152.
 */
package jcuda.runtime;

import jcuda.CudaException;
import jcuda.LibUtils;
import jcuda.LogLevel;
import jcuda.Pointer;
import jcuda.runtime.cudaArray;
import jcuda.runtime.cudaChannelFormatDesc;
import jcuda.runtime.cudaDeviceProp;
import jcuda.runtime.cudaError;
import jcuda.runtime.cudaEvent_t;
import jcuda.runtime.cudaExtent;
import jcuda.runtime.cudaFuncAttributes;
import jcuda.runtime.cudaGraphicsResource;
import jcuda.runtime.cudaMemcpy3DParms;
import jcuda.runtime.cudaMemcpy3DPeerParms;
import jcuda.runtime.cudaPitchedPtr;
import jcuda.runtime.cudaPointerAttributes;
import jcuda.runtime.cudaStream_t;
import jcuda.runtime.dim3;
import jcuda.runtime.surfaceReference;
import jcuda.runtime.textureReference;

public class JCuda {
    public static final int CUDART_VERSION = 4000;
    public static final int cudaHostAllocDefault = 0;
    public static final int cudaHostAllocPortable = 1;
    public static final int cudaHostAllocMapped = 2;
    public static final int cudaHostAllocWriteCombined = 4;
    public static final int cudaHostRegisterDefault = 0;
    public static final int cudaHostRegisterPortable = 1;
    public static final int cudaHostRegisterMapped = 2;
    public static final int cudaPeerAccessDefault = 0;
    public static final int cudaPeerDevicePointerDefault = 0;
    public static final int cudaPeerRegisterDefault = 0;
    public static final int cudaPeerRegisterMapped = 2;
    public static final int cudaEventDefault = 0;
    public static final int cudaEventBlockingSync = 1;
    public static final int cudaEventDisableTiming = 2;
    public static final int cudaDeviceScheduleAuto = 0;
    public static final int cudaDeviceScheduleSpin = 1;
    public static final int cudaDeviceScheduleYield = 2;
    public static final int cudaDeviceScheduleBlockingSync = 4;
    public static final int cudaDeviceBlockingSync = 4;
    public static final int cudaDeviceMapHost = 8;
    public static final int cudaDeviceLmemResizeToMax = 16;
    public static final int cudaDeviceMask = 31;
    public static final int cudaArrayDefault = 0;
    public static final int cudaArrayLayered = 1;
    public static final int cudaArraySurfaceLoadStore = 2;
    private static boolean initialized = false;
    private static boolean exceptionsEnabled = false;

    static {
        JCuda.initialize();
    }

    private JCuda() {
    }

    public static void setEmulation(boolean emulation) {
    }

    public static void initialize() {
        if (!initialized) {
            LibUtils.loadLibrary("JCudaRuntime");
            initialized = true;
        }
    }

    public static void setLogLevel(LogLevel logLevel) {
        JCuda.setLogLevel(logLevel.ordinal());
    }

    private static native void setLogLevel(int var0);

    public static void setExceptionsEnabled(boolean enabled) {
        exceptionsEnabled = enabled;
    }

    private static int checkResult(int result) {
        if (exceptionsEnabled && result != 0) {
            throw new CudaException(cudaError.stringFor(result));
        }
        return result;
    }

    public static int cudaGetDeviceCount(int[] count) {
        return JCuda.checkResult(JCuda.cudaGetDeviceCountNative(count));
    }

    private static native int cudaGetDeviceCountNative(int[] var0);

    public static int cudaSetDevice(int device) {
        return JCuda.checkResult(JCuda.cudaSetDeviceNative(device));
    }

    private static native int cudaSetDeviceNative(int var0);

    public static int cudaSetDeviceFlags(int flags) {
        return JCuda.checkResult(JCuda.cudaSetDeviceFlagsNative(flags));
    }

    private static native int cudaSetDeviceFlagsNative(int var0);

    public static int cudaSetValidDevices(int[] device_arr, int len) {
        return JCuda.checkResult(JCuda.cudaSetValidDevicesNative(device_arr, len));
    }

    private static native int cudaSetValidDevicesNative(int[] var0, int var1);

    public static int cudaGetDevice(int[] device) {
        return JCuda.checkResult(JCuda.cudaGetDeviceNative(device));
    }

    private static native int cudaGetDeviceNative(int[] var0);

    public static int cudaGetDeviceProperties(cudaDeviceProp prop, int device) {
        return JCuda.checkResult(JCuda.cudaGetDevicePropertiesNative(prop, device));
    }

    private static native int cudaGetDevicePropertiesNative(cudaDeviceProp var0, int var1);

    public static int cudaChooseDevice(int[] device, cudaDeviceProp prop) {
        return JCuda.checkResult(JCuda.cudaChooseDeviceNative(device, prop));
    }

    private static native int cudaChooseDeviceNative(int[] var0, cudaDeviceProp var1);

    public static int cudaMalloc3D(cudaPitchedPtr pitchDevPtr, cudaExtent extent) {
        return JCuda.checkResult(JCuda.cudaMalloc3DNative(pitchDevPtr, extent));
    }

    private static native int cudaMalloc3DNative(cudaPitchedPtr var0, cudaExtent var1);

    public static int cudaMalloc3DArray(cudaArray arrayPtr, cudaChannelFormatDesc desc, cudaExtent extent) {
        return JCuda.cudaMalloc3DArray(arrayPtr, desc, extent, 0);
    }

    public static int cudaMalloc3DArray(cudaArray arrayPtr, cudaChannelFormatDesc desc, cudaExtent extent, int flags) {
        return JCuda.checkResult(JCuda.cudaMalloc3DArrayNative(arrayPtr, desc, extent, flags));
    }

    private static native int cudaMalloc3DArrayNative(cudaArray var0, cudaChannelFormatDesc var1, cudaExtent var2, int var3);

    public static int cudaMemset3D(cudaPitchedPtr pitchDevPtr, int value, cudaExtent extent) {
        return JCuda.checkResult(JCuda.cudaMemset3DNative(pitchDevPtr, value, extent));
    }

    private static native int cudaMemset3DNative(cudaPitchedPtr var0, int var1, cudaExtent var2);

    public static int cudaMemsetAsync(Pointer devPtr, int value, long count, cudaStream_t stream) {
        return JCuda.checkResult(JCuda.cudaMemsetAsyncNative(devPtr, value, count, stream));
    }

    private static native int cudaMemsetAsyncNative(Pointer var0, int var1, long var2, cudaStream_t var4);

    public static int cudaMemset2DAsync(Pointer devPtr, long pitch, int value, long width, long height, cudaStream_t stream) {
        return JCuda.checkResult(JCuda.cudaMemset2DAsyncNative(devPtr, pitch, value, width, height, stream));
    }

    private static native int cudaMemset2DAsyncNative(Pointer var0, long var1, int var3, long var4, long var6, cudaStream_t var8);

    public static int cudaMemset3DAsync(cudaPitchedPtr pitchedDevPtr, int value, cudaExtent extent, cudaStream_t stream) {
        return JCuda.checkResult(JCuda.cudaMemset3DAsyncNative(pitchedDevPtr, value, extent, stream));
    }

    private static native int cudaMemset3DAsyncNative(cudaPitchedPtr var0, int var1, cudaExtent var2, cudaStream_t var3);

    public static int cudaMemcpy3D(cudaMemcpy3DParms p) {
        return JCuda.checkResult(JCuda.cudaMemcpy3DNative(p));
    }

    private static native int cudaMemcpy3DNative(cudaMemcpy3DParms var0);

    public static int cudaMemcpy3DPeer(cudaMemcpy3DPeerParms p) {
        return JCuda.checkResult(JCuda.cudaMemcpy3DPeerNative(p));
    }

    private static native int cudaMemcpy3DPeerNative(cudaMemcpy3DPeerParms var0);

    public static int cudaMemcpy3DAsync(cudaMemcpy3DParms p, cudaStream_t stream) {
        return JCuda.checkResult(JCuda.cudaMemcpy3DAsyncNative(p, stream));
    }

    private static native int cudaMemcpy3DAsyncNative(cudaMemcpy3DParms var0, cudaStream_t var1);

    public static int cudaMemcpy3DPeerAsync(cudaMemcpy3DPeerParms p, cudaStream_t stream) {
        return JCuda.checkResult(JCuda.cudaMemcpy3DPeerAsyncNative(p, stream));
    }

    private static native int cudaMemcpy3DPeerAsyncNative(cudaMemcpy3DPeerParms var0, cudaStream_t var1);

    public static int cudaHostAlloc(Pointer ptr, long size, int flags) {
        return JCuda.checkResult(JCuda.cudaHostAllocNative(ptr, size, flags));
    }

    private static native int cudaHostAllocNative(Pointer var0, long var1, int var3);

    public static int cudaHostRegister(Pointer ptr, long size, int flags) {
        return JCuda.checkResult(JCuda.cudaHostRegisterNative(ptr, size, flags));
    }

    private static native int cudaHostRegisterNative(Pointer var0, long var1, int var3);

    public static int cudaHostUnregister(Pointer ptr) {
        return JCuda.checkResult(JCuda.cudaHostUnregisterNative(ptr));
    }

    private static native int cudaHostUnregisterNative(Pointer var0);

    public static int cudaHostGetDevicePointer(Pointer pDevice, Pointer pHost, int flags) {
        return JCuda.checkResult(JCuda.cudaHostGetDevicePointerNative(pDevice, pHost, flags));
    }

    private static native int cudaHostGetDevicePointerNative(Pointer var0, Pointer var1, int var2);

    public static int cudaMalloc(Pointer devPtr, long size) {
        return JCuda.checkResult(JCuda.cudaMallocNative(devPtr, size));
    }

    private static native int cudaMallocNative(Pointer var0, long var1);

    public static int cudaMallocHost(Pointer ptr, long size) {
        return JCuda.checkResult(JCuda.cudaMallocHostNative(ptr, size));
    }

    private static native int cudaMallocHostNative(Pointer var0, long var1);

    public static int cudaMallocPitch(Pointer devPtr, long[] pitch, long width, long height) {
        return JCuda.checkResult(JCuda.cudaMallocPitchNative(devPtr, pitch, width, height));
    }

    private static native int cudaMallocPitchNative(Pointer var0, long[] var1, long var2, long var4);

    public static int cudaMallocArray(cudaArray array, cudaChannelFormatDesc desc, long width, long height) {
        return JCuda.cudaMallocArray(array, desc, width, height, 0);
    }

    public static int cudaMallocArray(cudaArray array, cudaChannelFormatDesc desc, long width, long height, int flags) {
        return JCuda.checkResult(JCuda.cudaMallocArrayNative(array, desc, width, height, flags));
    }

    private static native int cudaMallocArrayNative(cudaArray var0, cudaChannelFormatDesc var1, long var2, long var4, int var6);

    public static int cudaFree(Pointer devPtr) {
        return JCuda.checkResult(JCuda.cudaFreeNative(devPtr));
    }

    private static native int cudaFreeNative(Pointer var0);

    public static int cudaFreeHost(Pointer ptr) {
        return JCuda.checkResult(JCuda.cudaFreeHostNative(ptr));
    }

    private static native int cudaFreeHostNative(Pointer var0);

    public static int cudaFreeArray(cudaArray array) {
        return JCuda.checkResult(JCuda.cudaFreeArrayNative(array));
    }

    private static native int cudaFreeArrayNative(cudaArray var0);

    public static int cudaMemcpy(Pointer dst, Pointer src, long count, int cudaMemcpyKind_kind) {
        return JCuda.checkResult(JCuda.cudaMemcpyNative(dst, src, count, cudaMemcpyKind_kind));
    }

    private static native int cudaMemcpyNative(Pointer var0, Pointer var1, long var2, int var4);

    public static int cudaMemcpyPeer(Pointer dst, int dstDevice, Pointer src, int srcDevice, long count) {
        return JCuda.checkResult(JCuda.cudaMemcpyPeerNative(dst, dstDevice, src, srcDevice, count));
    }

    private static native int cudaMemcpyPeerNative(Pointer var0, int var1, Pointer var2, int var3, long var4);

    public static int cudaMemcpyToArray(cudaArray dst, long wOffset, long hOffset, Pointer src, long count, int cudaMemcpyKind_kind) {
        return JCuda.checkResult(JCuda.cudaMemcpyToArrayNative(dst, wOffset, hOffset, src, count, cudaMemcpyKind_kind));
    }

    private static native int cudaMemcpyToArrayNative(cudaArray var0, long var1, long var3, Pointer var5, long var6, int var8);

    public static int cudaMemcpyFromArray(Pointer dst, cudaArray src, long wOffset, long hOffset, long count, int cudaMemcpyKind_kind) {
        return JCuda.checkResult(JCuda.cudaMemcpyFromArrayNative(dst, src, wOffset, hOffset, count, cudaMemcpyKind_kind));
    }

    private static native int cudaMemcpyFromArrayNative(Pointer var0, cudaArray var1, long var2, long var4, long var6, int var8);

    public static int cudaMemcpyArrayToArray(cudaArray dst, long wOffsetDst, long hOffsetDst, cudaArray src, long wOffsetSrc, long hOffsetSrc, long count, int cudaMemcpyKind_kind) {
        return JCuda.checkResult(JCuda.cudaMemcpyArrayToArrayNative(dst, wOffsetDst, hOffsetDst, src, wOffsetSrc, hOffsetSrc, count, cudaMemcpyKind_kind));
    }

    private static native int cudaMemcpyArrayToArrayNative(cudaArray var0, long var1, long var3, cudaArray var5, long var6, long var8, long var10, int var12);

    public static int cudaMemcpy2D(Pointer dst, long dpitch, Pointer src, long spitch, long width, long height, int cudaMemcpyKind_kind) {
        return JCuda.checkResult(JCuda.cudaMemcpy2DNative(dst, dpitch, src, spitch, width, height, cudaMemcpyKind_kind));
    }

    private static native int cudaMemcpy2DNative(Pointer var0, long var1, Pointer var3, long var4, long var6, long var8, int var10);

    public static int cudaMemcpy2DToArray(cudaArray dst, long wOffset, long hOffset, Pointer src, long spitch, long width, long height, int cudaMemcpyKind_kind) {
        return JCuda.checkResult(JCuda.cudaMemcpy2DToArrayNative(dst, wOffset, hOffset, src, spitch, width, height, cudaMemcpyKind_kind));
    }

    private static native int cudaMemcpy2DToArrayNative(cudaArray var0, long var1, long var3, Pointer var5, long var6, long var8, long var10, int var12);

    public static int cudaMemcpy2DFromArray(Pointer dst, long dpitch, cudaArray src, long wOffset, long hOffset, long width, long height, int cudaMemcpyKind_kind) {
        return JCuda.checkResult(JCuda.cudaMemcpy2DFromArrayNative(dst, dpitch, src, wOffset, hOffset, width, height, cudaMemcpyKind_kind));
    }

    private static native int cudaMemcpy2DFromArrayNative(Pointer var0, long var1, cudaArray var3, long var4, long var6, long var8, long var10, int var12);

    public static int cudaMemcpy2DArrayToArray(cudaArray dst, long wOffsetDst, long hOffsetDst, cudaArray src, long wOffsetSrc, long hOffsetSrc, long width, long height, int cudaMemcpyKind_kind) {
        return JCuda.checkResult(JCuda.cudaMemcpy2DArrayToArrayNative(dst, wOffsetDst, hOffsetDst, src, wOffsetSrc, hOffsetSrc, width, height, cudaMemcpyKind_kind));
    }

    private static native int cudaMemcpy2DArrayToArrayNative(cudaArray var0, long var1, long var3, cudaArray var5, long var6, long var8, long var10, long var12, int var14);

    public static int cudaMemcpyToSymbol(String symbol, Pointer src, long count, long offset, int cudaMemcpyKind_kind) {
        return JCuda.checkResult(JCuda.cudaMemcpyToSymbolNative(symbol, src, count, offset, cudaMemcpyKind_kind));
    }

    private static native int cudaMemcpyToSymbolNative(String var0, Pointer var1, long var2, long var4, int var6);

    public static int cudaMemcpyFromSymbol(Pointer dst, String symbol, long count, long offset, int cudaMemcpyKind_kind) {
        return JCuda.checkResult(JCuda.cudaMemcpyFromSymbolNative(dst, symbol, count, offset, cudaMemcpyKind_kind));
    }

    private static native int cudaMemcpyFromSymbolNative(Pointer var0, String var1, long var2, long var4, int var6);

    public static int cudaMemcpyAsync(Pointer dst, Pointer src, long count, int cudaMemcpyKind_kind, cudaStream_t stream) {
        return JCuda.checkResult(JCuda.cudaMemcpyAsyncNative(dst, src, count, cudaMemcpyKind_kind, stream));
    }

    private static native int cudaMemcpyAsyncNative(Pointer var0, Pointer var1, long var2, int var4, cudaStream_t var5);

    public static int cudaMemcpyPeerAsync(Pointer dst, int dstDevice, Pointer src, int srcDevice, long count, cudaStream_t stream) {
        return JCuda.checkResult(JCuda.cudaMemcpyPeerAsyncNative(dst, dstDevice, src, srcDevice, count, stream));
    }

    private static native int cudaMemcpyPeerAsyncNative(Pointer var0, int var1, Pointer var2, int var3, long var4, cudaStream_t var6);

    public static int cudaMemcpyToArrayAsync(cudaArray dst, long wOffset, long hOffset, Pointer src, long count, int cudaMemcpyKind_kind, cudaStream_t stream) {
        return JCuda.checkResult(JCuda.cudaMemcpyToArrayAsyncNative(dst, wOffset, hOffset, src, count, cudaMemcpyKind_kind, stream));
    }

    private static native int cudaMemcpyToArrayAsyncNative(cudaArray var0, long var1, long var3, Pointer var5, long var6, int var8, cudaStream_t var9);

    public static int cudaMemcpyFromArrayAsync(Pointer dst, cudaArray src, long wOffset, long hOffset, long count, int cudaMemcpyKind_kind, cudaStream_t stream) {
        return JCuda.checkResult(JCuda.cudaMemcpyFromArrayAsyncNative(dst, src, wOffset, hOffset, count, cudaMemcpyKind_kind, stream));
    }

    private static native int cudaMemcpyFromArrayAsyncNative(Pointer var0, cudaArray var1, long var2, long var4, long var6, int var8, cudaStream_t var9);

    public static int cudaMemcpy2DAsync(Pointer dst, long dpitch, Pointer src, long spitch, long width, long height, int cudaMemcpyKind_kind, cudaStream_t stream) {
        return JCuda.checkResult(JCuda.cudaMemcpy2DAsyncNative(dst, dpitch, src, spitch, width, height, cudaMemcpyKind_kind, stream));
    }

    private static native int cudaMemcpy2DAsyncNative(Pointer var0, long var1, Pointer var3, long var4, long var6, long var8, int var10, cudaStream_t var11);

    public static int cudaMemcpy2DToArrayAsync(cudaArray dst, long wOffset, long hOffset, Pointer src, long spitch, long width, long height, int cudaMemcpyKind_kind, cudaStream_t stream) {
        return JCuda.checkResult(JCuda.cudaMemcpy2DToArrayAsyncNative(dst, wOffset, hOffset, src, spitch, width, height, cudaMemcpyKind_kind, stream));
    }

    private static native int cudaMemcpy2DToArrayAsyncNative(cudaArray var0, long var1, long var3, Pointer var5, long var6, long var8, long var10, int var12, cudaStream_t var13);

    public static int cudaMemcpy2DFromArrayAsync(Pointer dst, long dpitch, cudaArray src, long wOffset, long hOffset, long width, long height, int cudaMemcpyKind_kind, cudaStream_t stream) {
        return JCuda.checkResult(JCuda.cudaMemcpy2DFromArrayAsyncNative(dst, dpitch, src, wOffset, hOffset, width, height, cudaMemcpyKind_kind, stream));
    }

    private static native int cudaMemcpy2DFromArrayAsyncNative(Pointer var0, long var1, cudaArray var3, long var4, long var6, long var8, long var10, int var12, cudaStream_t var13);

    public static int cudaMemcpyToSymbolAsync(String symbol, Pointer src, long count, long offset, int cudaMemcpyKind_kind, cudaStream_t stream) {
        return JCuda.checkResult(JCuda.cudaMemcpyToSymbolAsyncNative(symbol, src, count, offset, cudaMemcpyKind_kind, stream));
    }

    private static native int cudaMemcpyToSymbolAsyncNative(String var0, Pointer var1, long var2, long var4, int var6, cudaStream_t var7);

    public static int cudaMemcpyFromSymbolAsync(Pointer dst, String symbol, long count, long offset, int cudaMemcpyKind_kind, cudaStream_t stream) {
        return JCuda.checkResult(JCuda.cudaMemcpyFromSymbolAsyncNative(dst, symbol, count, offset, cudaMemcpyKind_kind, stream));
    }

    private static native int cudaMemcpyFromSymbolAsyncNative(Pointer var0, String var1, long var2, long var4, int var6, cudaStream_t var7);

    public static int cudaMemset(Pointer mem, int c, long count) {
        return JCuda.checkResult(JCuda.cudaMemsetNative(mem, c, count));
    }

    private static native int cudaMemsetNative(Pointer var0, int var1, long var2);

    public static int cudaMemset2D(Pointer mem, long pitch, int c, long width, long height) {
        return JCuda.checkResult(JCuda.cudaMemset2DNative(mem, pitch, c, width, height));
    }

    private static native int cudaMemset2DNative(Pointer var0, long var1, int var3, long var4, long var6);

    public static int cudaGetChannelDesc(cudaChannelFormatDesc desc, cudaArray array) {
        return JCuda.checkResult(JCuda.cudaGetChannelDescNative(desc, array));
    }

    private static native int cudaGetChannelDescNative(cudaChannelFormatDesc var0, cudaArray var1);

    public static cudaChannelFormatDesc cudaCreateChannelDesc(int x, int y, int z, int w, int cudaChannelFormatKind_f) {
        return JCuda.cudaCreateChannelDescNative(x, y, z, w, cudaChannelFormatKind_f);
    }

    private static native cudaChannelFormatDesc cudaCreateChannelDescNative(int var0, int var1, int var2, int var3, int var4);

    public static int cudaGetLastError() {
        return JCuda.checkResult(JCuda.cudaGetLastErrorNative());
    }

    private static native int cudaGetLastErrorNative();

    public static int cudaPeekAtLastError() {
        return JCuda.checkResult(JCuda.cudaPeekAtLastErrorNative());
    }

    private static native int cudaPeekAtLastErrorNative();

    public static String cudaGetErrorString(int error) {
        return JCuda.cudaGetErrorStringNative(error);
    }

    private static native String cudaGetErrorStringNative(int var0);

    public static int cudaStreamCreate(cudaStream_t stream) {
        return JCuda.checkResult(JCuda.cudaStreamCreateNative(stream));
    }

    private static native int cudaStreamCreateNative(cudaStream_t var0);

    public static int cudaStreamDestroy(cudaStream_t stream) {
        return JCuda.checkResult(JCuda.cudaStreamDestroyNative(stream));
    }

    private static native int cudaStreamDestroyNative(cudaStream_t var0);

    public static int cudaStreamWaitEvent(cudaStream_t stream, cudaEvent_t event, int flags) {
        return JCuda.checkResult(JCuda.cudaStreamWaitEventNative(stream, event, flags));
    }

    private static native int cudaStreamWaitEventNative(cudaStream_t var0, cudaEvent_t var1, int var2);

    public static int cudaStreamSynchronize(cudaStream_t stream) {
        return JCuda.checkResult(JCuda.cudaStreamSynchronizeNative(stream));
    }

    private static native int cudaStreamSynchronizeNative(cudaStream_t var0);

    public static int cudaStreamQuery(cudaStream_t stream) {
        return JCuda.checkResult(JCuda.cudaStreamQueryNative(stream));
    }

    private static native int cudaStreamQueryNative(cudaStream_t var0);

    public static int cudaEventCreate(cudaEvent_t event) {
        return JCuda.checkResult(JCuda.cudaEventCreateNative(event));
    }

    private static native int cudaEventCreateNative(cudaEvent_t var0);

    public static int cudaEventCreateWithFlags(cudaEvent_t event, int flags) {
        return JCuda.checkResult(JCuda.cudaEventCreateWithFlagsNative(event, flags));
    }

    private static native int cudaEventCreateWithFlagsNative(cudaEvent_t var0, int var1);

    public static int cudaEventRecord(cudaEvent_t event, cudaStream_t stream) {
        return JCuda.checkResult(JCuda.cudaEventRecordNative(event, stream));
    }

    private static native int cudaEventRecordNative(cudaEvent_t var0, cudaStream_t var1);

    public static int cudaEventQuery(cudaEvent_t event) {
        return JCuda.checkResult(JCuda.cudaEventQueryNative(event));
    }

    private static native int cudaEventQueryNative(cudaEvent_t var0);

    public static int cudaEventSynchronize(cudaEvent_t event) {
        return JCuda.checkResult(JCuda.cudaEventSynchronizeNative(event));
    }

    private static native int cudaEventSynchronizeNative(cudaEvent_t var0);

    public static int cudaEventDestroy(cudaEvent_t event) {
        return JCuda.checkResult(JCuda.cudaEventDestroyNative(event));
    }

    private static native int cudaEventDestroyNative(cudaEvent_t var0);

    public static int cudaEventElapsedTime(float[] ms, cudaEvent_t start, cudaEvent_t end) {
        return JCuda.checkResult(JCuda.cudaEventElapsedTimeNative(ms, start, end));
    }

    private static native int cudaEventElapsedTimeNative(float[] var0, cudaEvent_t var1, cudaEvent_t var2);

    public static int cudaDeviceReset() {
        return JCuda.checkResult(JCuda.cudaDeviceResetNative());
    }

    private static native int cudaDeviceResetNative();

    public static int cudaDeviceSynchronize() {
        return JCuda.checkResult(JCuda.cudaDeviceSynchronizeNative());
    }

    private static native int cudaDeviceSynchronizeNative();

    public static int cudaDeviceSetLimit(int limit, long value) {
        return JCuda.checkResult(JCuda.cudaDeviceSetLimitNative(limit, value));
    }

    private static native int cudaDeviceSetLimitNative(int var0, long var1);

    public static int cudaDeviceGetLimit(long[] pValue, int limit) {
        return JCuda.checkResult(JCuda.cudaDeviceGetLimitNative(pValue, limit));
    }

    private static native int cudaDeviceGetLimitNative(long[] var0, int var1);

    public static int cudaDeviceGetCacheConfig(int[] pCacheConfig) {
        return JCuda.checkResult(JCuda.cudaDeviceGetCacheConfigNative(pCacheConfig));
    }

    private static native int cudaDeviceGetCacheConfigNative(int[] var0);

    public static int cudaDeviceSetCacheConfig(int cacheConfig) {
        return JCuda.checkResult(JCuda.cudaDeviceSetCacheConfigNative(cacheConfig));
    }

    private static native int cudaDeviceSetCacheConfigNative(int var0);

    public static int cudaThreadExit() {
        return JCuda.checkResult(JCuda.cudaThreadExitNative());
    }

    private static native int cudaThreadExitNative();

    public static int cudaThreadSynchronize() {
        return JCuda.checkResult(JCuda.cudaThreadSynchronizeNative());
    }

    private static native int cudaThreadSynchronizeNative();

    public static int cudaThreadSetLimit(int limit, long value) {
        return JCuda.checkResult(JCuda.cudaThreadSetLimitNative(limit, value));
    }

    private static native int cudaThreadSetLimitNative(int var0, long var1);

    public static int cudaThreadGetCacheConfig(int[] pCacheConfig) {
        return JCuda.checkResult(JCuda.cudaThreadGetCacheConfigNative(pCacheConfig));
    }

    private static native int cudaThreadGetCacheConfigNative(int[] var0);

    public static int cudaThreadSetCacheConfig(int cacheConfig) {
        return JCuda.checkResult(JCuda.cudaThreadSetCacheConfigNative(cacheConfig));
    }

    private static native int cudaThreadSetCacheConfigNative(int var0);

    public static int cudaThreadGetLimit(long[] pValue, int limit) {
        return JCuda.checkResult(JCuda.cudaThreadGetLimitNative(pValue, limit));
    }

    private static native int cudaThreadGetLimitNative(long[] var0, int var1);

    public static int cudaGetSymbolAddress(Pointer devPtr, String symbol) {
        return JCuda.checkResult(JCuda.cudaGetSymbolAddressNative(devPtr, symbol));
    }

    private static native int cudaGetSymbolAddressNative(Pointer var0, String var1);

    public static int cudaGetSymbolSize(long[] size, String symbol) {
        return JCuda.checkResult(JCuda.cudaGetSymbolSizeNative(size, symbol));
    }

    private static native int cudaGetSymbolSizeNative(long[] var0, String var1);

    public static int cudaBindTexture(long[] offset, textureReference texref, Pointer devPtr, cudaChannelFormatDesc desc, long size) {
        return JCuda.checkResult(JCuda.cudaBindTextureNative(offset, texref, devPtr, desc, size));
    }

    private static native int cudaBindTextureNative(long[] var0, textureReference var1, Pointer var2, cudaChannelFormatDesc var3, long var4);

    public static int cudaBindTexture2D(long[] offset, textureReference texref, Pointer devPtr, cudaChannelFormatDesc desc, long width, long height, long pitch) {
        return JCuda.checkResult(JCuda.cudaBindTexture2DNative(offset, texref, devPtr, desc, width, height, pitch));
    }

    private static native int cudaBindTexture2DNative(long[] var0, textureReference var1, Pointer var2, cudaChannelFormatDesc var3, long var4, long var6, long var8);

    public static int cudaBindTextureToArray(textureReference texref, cudaArray array, cudaChannelFormatDesc desc) {
        return JCuda.checkResult(JCuda.cudaBindTextureToArrayNative(texref, array, desc));
    }

    private static native int cudaBindTextureToArrayNative(textureReference var0, cudaArray var1, cudaChannelFormatDesc var2);

    public static int cudaUnbindTexture(textureReference texref) {
        return JCuda.checkResult(JCuda.cudaUnbindTextureNative(texref));
    }

    private static native int cudaUnbindTextureNative(textureReference var0);

    public static int cudaGetTextureAlignmentOffset(long[] offset, textureReference texref) {
        return JCuda.checkResult(JCuda.cudaGetTextureAlignmentOffsetNative(offset, texref));
    }

    private static native int cudaGetTextureAlignmentOffsetNative(long[] var0, textureReference var1);

    public static int cudaGetTextureReference(textureReference texref, String symbol) {
        return JCuda.checkResult(JCuda.cudaGetTextureReferenceNative(texref, symbol));
    }

    private static native int cudaGetTextureReferenceNative(textureReference var0, String var1);

    public static int cudaBindSurfaceToArray(surfaceReference surfref, cudaArray array, cudaChannelFormatDesc desc) {
        return JCuda.checkResult(JCuda.cudaBindSurfaceToArrayNative(surfref, array, desc));
    }

    private static native int cudaBindSurfaceToArrayNative(surfaceReference var0, cudaArray var1, cudaChannelFormatDesc var2);

    public static int cudaGetSurfaceReference(surfaceReference surfref, String symbol) {
        return JCuda.checkResult(JCuda.cudaGetSurfaceReferenceNative(surfref, symbol));
    }

    private static native int cudaGetSurfaceReferenceNative(surfaceReference var0, String var1);

    public static int cudaConfigureCall(dim3 gridDim, dim3 blockDim, long sharedMem, cudaStream_t stream) {
        return JCuda.checkResult(JCuda.cudaConfigureCallNative(gridDim, blockDim, sharedMem, stream));
    }

    private static native int cudaConfigureCallNative(dim3 var0, dim3 var1, long var2, cudaStream_t var4);

    public static int cudaSetupArgument(Pointer arg, long size, long offset) {
        return JCuda.checkResult(JCuda.cudaSetupArgumentNative(arg, size, offset));
    }

    private static native int cudaSetupArgumentNative(Pointer var0, long var1, long var3);

    public static int cudaFuncGetAttributes(cudaFuncAttributes attr, String func) {
        return JCuda.checkResult(JCuda.cudaFuncGetAttributesNative(attr, func));
    }

    private static native int cudaFuncGetAttributesNative(cudaFuncAttributes var0, String var1);

    public static int cudaLaunch(String symbol) {
        return JCuda.checkResult(JCuda.cudaLaunchNative(symbol));
    }

    private static native int cudaLaunchNative(String var0);

    public static int cudaGLSetGLDevice(int device) {
        return JCuda.checkResult(JCuda.cudaGLSetGLDeviceNative(device));
    }

    private static native int cudaGLSetGLDeviceNative(int var0);

    public static int cudaGraphicsGLRegisterImage(cudaGraphicsResource resource, int image, int target, int Flags) {
        return JCuda.checkResult(JCuda.cudaGraphicsGLRegisterImageNative(resource, image, target, Flags));
    }

    private static native int cudaGraphicsGLRegisterImageNative(cudaGraphicsResource var0, int var1, int var2, int var3);

    public static int cudaGraphicsGLRegisterBuffer(cudaGraphicsResource resource, int buffer, int Flags) {
        return JCuda.checkResult(JCuda.cudaGraphicsGLRegisterBufferNative(resource, buffer, Flags));
    }

    private static native int cudaGraphicsGLRegisterBufferNative(cudaGraphicsResource var0, int var1, int var2);

    public static int cudaGLRegisterBufferObject(int bufObj) {
        return JCuda.checkResult(JCuda.cudaGLRegisterBufferObjectNative(bufObj));
    }

    private static native int cudaGLRegisterBufferObjectNative(int var0);

    public static int cudaGLMapBufferObject(Pointer devPtr, int bufObj) {
        return JCuda.checkResult(JCuda.cudaGLMapBufferObjectNative(devPtr, bufObj));
    }

    private static native int cudaGLMapBufferObjectNative(Pointer var0, int var1);

    public static int cudaGLUnmapBufferObject(int bufObj) {
        return JCuda.checkResult(JCuda.cudaGLUnmapBufferObjectNative(bufObj));
    }

    private static native int cudaGLUnmapBufferObjectNative(int var0);

    public static int cudaGLUnregisterBufferObject(int bufObj) {
        return JCuda.checkResult(JCuda.cudaGLUnregisterBufferObjectNative(bufObj));
    }

    private static native int cudaGLUnregisterBufferObjectNative(int var0);

    public static int cudaGLSetBufferObjectMapFlags(int bufObj, int flags) {
        return JCuda.checkResult(JCuda.cudaGLSetBufferObjectMapFlagsNative(bufObj, flags));
    }

    private static native int cudaGLSetBufferObjectMapFlagsNative(int var0, int var1);

    public static int cudaGLMapBufferObjectAsync(Pointer devPtr, int bufObj, cudaStream_t stream) {
        return JCuda.checkResult(JCuda.cudaGLMapBufferObjectAsyncNative(devPtr, bufObj, stream));
    }

    private static native int cudaGLMapBufferObjectAsyncNative(Pointer var0, int var1, cudaStream_t var2);

    public static int cudaGLUnmapBufferObjectAsync(int bufObj, cudaStream_t stream) {
        return JCuda.checkResult(JCuda.cudaGLUnmapBufferObjectAsyncNative(bufObj, stream));
    }

    private static native int cudaGLUnmapBufferObjectAsyncNative(int var0, cudaStream_t var1);

    public static int cudaDriverGetVersion(int[] driverVersion) {
        return JCuda.checkResult(JCuda.cudaDriverGetVersionNative(driverVersion));
    }

    private static native int cudaDriverGetVersionNative(int[] var0);

    public static int cudaRuntimeGetVersion(int[] runtimeVersion) {
        return JCuda.checkResult(JCuda.cudaRuntimeGetVersionNative(runtimeVersion));
    }

    private static native int cudaRuntimeGetVersionNative(int[] var0);

    public static int cudaPointerGetAttributes(cudaPointerAttributes attributes, Pointer ptr) {
        return JCuda.checkResult(JCuda.cudaPointerGetAttributesNative(attributes, ptr));
    }

    private static native int cudaPointerGetAttributesNative(cudaPointerAttributes var0, Pointer var1);

    public static int cudaDeviceCanAccessPeer(int[] canAccessPeer, int device, int peerDevice) {
        return JCuda.checkResult(JCuda.cudaDeviceCanAccessPeerNative(canAccessPeer, device, peerDevice));
    }

    private static native int cudaDeviceCanAccessPeerNative(int[] var0, int var1, int var2);

    public static int cudaDeviceEnablePeerAccess(int peerDevice, int flags) {
        return JCuda.checkResult(JCuda.cudaDeviceEnablePeerAccessNative(peerDevice, flags));
    }

    private static native int cudaDeviceEnablePeerAccessNative(int var0, int var1);

    public static int cudaDeviceDisablePeerAccess(int peerDevice) {
        return JCuda.checkResult(JCuda.cudaDeviceDisablePeerAccessNative(peerDevice));
    }

    private static native int cudaDeviceDisablePeerAccessNative(int var0);

    public static int cudaPeerRegister(Pointer peerDevicePointer, int peerDevice, int flags) {
        throw new UnsupportedOperationException("This function is not available in CUDA 4.0 RC2");
    }

    private static native int cudaPeerRegisterNative(Pointer var0, int var1, int var2);

    public static int cudaPeerUnregister(Pointer peerDevicePointer, int peerDevice) {
        throw new UnsupportedOperationException("This function is not available in CUDA 4.0 RC2");
    }

    private static native int cudaPeerUnregisterNative(Pointer var0, int var1);

    public static int cudaPeerGetDevicePointer(Pointer pDevice, Pointer peerDevicePointer, int peerDevice, int flags) {
        throw new UnsupportedOperationException("This function is not available in CUDA 4.0 RC2");
    }

    private static native int cudaPeerGetDevicePointerNative(Pointer var0, Pointer var1, int var2, int var3);

    public static int cudaGraphicsUnregisterResource(cudaGraphicsResource resource) {
        return JCuda.checkResult(JCuda.cudaGraphicsUnregisterResourceNative(resource));
    }

    private static native int cudaGraphicsUnregisterResourceNative(cudaGraphicsResource var0);

    public static int cudaGraphicsResourceSetMapFlags(cudaGraphicsResource resource, int flags) {
        return JCuda.checkResult(JCuda.cudaGraphicsResourceSetMapFlagsNative(resource, flags));
    }

    private static native int cudaGraphicsResourceSetMapFlagsNative(cudaGraphicsResource var0, int var1);

    public static int cudaGraphicsMapResources(int count, cudaGraphicsResource[] resources, cudaStream_t stream) {
        return JCuda.checkResult(JCuda.cudaGraphicsMapResourcesNative(count, resources, stream));
    }

    private static native int cudaGraphicsMapResourcesNative(int var0, cudaGraphicsResource[] var1, cudaStream_t var2);

    public static int cudaGraphicsUnmapResources(int count, cudaGraphicsResource[] resources, cudaStream_t stream) {
        return JCuda.checkResult(JCuda.cudaGraphicsUnmapResourcesNative(count, resources, stream));
    }

    private static native int cudaGraphicsUnmapResourcesNative(int var0, cudaGraphicsResource[] var1, cudaStream_t var2);

    public static int cudaGraphicsResourceGetMappedPointer(Pointer devPtr, long[] size, cudaGraphicsResource resource) {
        return JCuda.checkResult(JCuda.cudaGraphicsResourceGetMappedPointerNative(devPtr, size, resource));
    }

    private static native int cudaGraphicsResourceGetMappedPointerNative(Pointer var0, long[] var1, cudaGraphicsResource var2);

    public static int cudaGraphicsSubResourceGetMappedArray(cudaArray arrayPtr, cudaGraphicsResource resource, int arrayIndex, int mipLevel) {
        return JCuda.checkResult(JCuda.cudaGraphicsSubResourceGetMappedArrayNative(arrayPtr, resource, arrayIndex, mipLevel));
    }

    private static native int cudaGraphicsSubResourceGetMappedArrayNative(cudaArray var0, cudaGraphicsResource var1, int var2, int var3);

    public static int cudaProfilerInitialize(String configFile, String outputFile, int outputMode) {
        return JCuda.checkResult(JCuda.cudaProfilerInitializeNative(configFile, outputFile, outputMode));
    }

    private static native int cudaProfilerInitializeNative(String var0, String var1, int var2);

    public static int cudaProfilerStart() {
        return JCuda.checkResult(JCuda.cudaProfilerStartNative());
    }

    private static native int cudaProfilerStartNative();

    public static int cudaProfilerStop() {
        return JCuda.checkResult(JCuda.cudaProfilerStopNative());
    }

    private static native int cudaProfilerStopNative();
}

