/*
 * Decompiled with CFR 0.152.
 */
package jcuda.runtime;

import java.util.Arrays;
import jcuda.runtime.cudaComputeMode;

public class cudaDeviceProp {
    public byte[] name = new byte[256];
    public long totalGlobalMem;
    public long sharedMemPerBlock;
    public int regsPerBlock;
    public int warpSize;
    public long memPitch;
    public int maxThreadsPerBlock;
    public int[] maxThreadsDim = new int[3];
    public int[] maxGridSize = new int[3];
    public int clockRate;
    public long totalConstMem;
    public int major;
    public int minor;
    public long textureAlignment;
    public int deviceOverlap;
    public int multiProcessorCount;
    public int kernelExecTimeoutEnabled;
    public int integrated;
    public int canMapHostMemory;
    public int computeMode;
    public int maxTexture1D;
    public int[] maxTexture2D = new int[2];
    public int[] maxTexture3D = new int[3];
    public int[] maxTexture1DLayered = new int[2];
    public int[] maxTexture2DLayered = new int[3];
    public long surfaceAlignment;
    public int concurrentKernels;
    public int ECCEnabled;
    public int pciBusID;
    public int pciDeviceID;
    public int tccDriver;
    public int asyncEngineCount;
    public int unifiedAddressing;
    public int memoryClockRate;
    public int memoryBusWidth;
    public int l2CacheSize;
    public int maxThreadsPerMultiProcessor;

    public String getName() {
        return cudaDeviceProp.createString(this.name);
    }

    public void setName(String nameString) {
        byte[] bytes = nameString.getBytes();
        int n = Math.min(this.name.length, bytes.length);
        System.arraycopy(bytes, 0, this.name, 0, n);
    }

    public String toString() {
        return "cudaDeviceProp[" + this.createString(",") + "]";
    }

    public String toFormattedString() {
        return "Device properties:\n    " + this.createString("\n    ");
    }

    private String createString(String f) {
        return "name=" + cudaDeviceProp.createString(this.name) + f + "totalGlobalMem=" + this.totalGlobalMem + f + "sharedMemPerBlock=" + this.sharedMemPerBlock + f + "regsPerBlock=" + this.regsPerBlock + f + "warpSize=" + this.warpSize + f + "memPitch=" + this.memPitch + f + "maxThreadsPerBlock=" + this.maxThreadsPerBlock + f + "maxThreadsDim=" + Arrays.toString(this.maxThreadsDim) + f + "maxGridSize=" + Arrays.toString(this.maxGridSize) + f + "clockRate=" + this.clockRate + f + "totalConstMem=" + this.totalConstMem + f + "major=" + this.major + f + "minor=" + this.minor + f + "textureAlignment=" + this.textureAlignment + f + "deviceOverlap=" + this.deviceOverlap + f + "multiProcessorCount=" + this.multiProcessorCount + f + "kernelExecTimeoutEnabled=" + this.kernelExecTimeoutEnabled + f + "integrated=" + this.integrated + f + "canMapHostMemory=" + this.canMapHostMemory + f + "computeMode=" + cudaComputeMode.stringFor(this.computeMode) + f + "maxTexture1D=" + this.maxTexture1D + f + "maxTexture2D=" + Arrays.toString(this.maxTexture2D) + f + "maxTexture3D=" + Arrays.toString(this.maxTexture3D) + f + "maxTexture1DLayered=" + Arrays.toString(this.maxTexture1DLayered) + f + "maxTexture2DLayered=" + Arrays.toString(this.maxTexture2DLayered) + f + "surfaceAlignment=" + this.surfaceAlignment + f + "concurrentKernels=" + this.concurrentKernels + f + "ECCEnabled=" + this.ECCEnabled + f + "pciBusID=" + this.pciBusID + f + "pciDeviceID=" + this.pciDeviceID + f + "tccDriver=" + this.tccDriver + f + "asyncEngineCount=" + this.asyncEngineCount + f + "unifiedAddressing=" + this.unifiedAddressing + f + "memoryClockRate=" + this.memoryClockRate + f + "memoryBusWidth=" + this.memoryBusWidth + f + "l2CacheSize=" + this.l2CacheSize + f + "maxThreadsPerMultiProcessor=" + this.maxThreadsPerMultiProcessor + f;
    }

    private static String createString(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (Character.isLetterOrDigit(b) || Character.isWhitespace(b)) {
                sb.append((char)b);
            }
            ++n2;
        }
        return sb.toString();
    }
}

