/*
 * Decompiled with CFR 0.152.
 */
package jcuda.jcublas;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import jcuda.CudaException;
import jcuda.LibUtils;
import jcuda.LogLevel;
import jcuda.Pointer;
import jcuda.cuComplex;
import jcuda.cuDoubleComplex;
import jcuda.jcublas.cublasStatus;
import jcuda.runtime.cudaStream_t;

public class JCublas {
    private static boolean initialized = false;
    private static boolean exceptionsEnabled = false;
    private static int lastResult = 0;

    static {
        JCublas.initialize();
    }

    private JCublas() {
    }

    public static void setEmulation(boolean emulation) {
    }

    public static void initialize() {
        if (!initialized) {
            LibUtils.loadLibrary((String)"JCublas");
            initialized = true;
        }
    }

    public static void setLogLevel(LogLevel logLevel) {
        JCublas.setLogLevelNative(logLevel.ordinal());
    }

    private static native void setLogLevelNative(int var0);

    public static void setExceptionsEnabled(boolean enabled) {
        exceptionsEnabled = enabled;
    }

    private static int checkResult(int result) {
        if (exceptionsEnabled && result != 0) {
            throw new CudaException(cublasStatus.stringFor(result));
        }
        return result;
    }

    private static void checkResultBLAS() {
        if (exceptionsEnabled && (lastResult = JCublas.cublasGetErrorNative()) != 0) {
            throw new CudaException(cublasStatus.stringFor(lastResult));
        }
    }

    public static int cublasInit() {
        return JCublas.checkResult(JCublas.cublasInitNative());
    }

    private static native int cublasInitNative();

    public static int cublasShutdown() {
        return JCublas.checkResult(JCublas.cublasShutdownNative());
    }

    private static native int cublasShutdownNative();

    public static int cublasGetError() {
        if (exceptionsEnabled) {
            int returnedResult = lastResult;
            lastResult = 0;
            return returnedResult;
        }
        return JCublas.cublasGetErrorNative();
    }

    private static native int cublasGetErrorNative();

    public static int cublasAlloc(int n, int elemSize, Pointer ptr) {
        return JCublas.checkResult(JCublas.cublasAllocNative(n, elemSize, ptr));
    }

    private static native int cublasAllocNative(int var0, int var1, Pointer var2);

    public static int cublasFree(Pointer ptr) {
        return JCublas.checkResult(JCublas.cublasFreeNative(ptr));
    }

    private static native int cublasFreeNative(Pointer var0);

    public static native void printVector(int var0, Pointer var1);

    public static native void printMatrix(int var0, Pointer var1, int var2);

    private static native int cublasSetVectorNative(int var0, int var1, Pointer var2, int var3, Pointer var4, int var5);

    private static native int cublasGetVectorNative(int var0, int var1, Pointer var2, int var3, Pointer var4, int var5);

    private static native int cublasSetMatrixNative(int var0, int var1, int var2, Pointer var3, int var4, Pointer var5, int var6);

    private static native int cublasGetMatrixNative(int var0, int var1, int var2, Pointer var3, int var4, Pointer var5, int var6);

    private static native int cublasSetVectorAsyncNative(int var0, int var1, Pointer var2, int var3, Pointer var4, int var5, cudaStream_t var6);

    private static native int cublasGetVectorAsyncNative(int var0, int var1, Pointer var2, int var3, Pointer var4, int var5, cudaStream_t var6);

    private static native int cublasSetMatrixAsyncNative(int var0, int var1, int var2, Pointer var3, int var4, Pointer var5, int var6, cudaStream_t var7);

    private static native int cublasGetMatrixAsyncNative(int var0, int var1, int var2, Pointer var3, int var4, Pointer var5, int var6, cudaStream_t var7);

    public static int cublasSetVector(int n, int elemSize, Pointer x, int incx, Pointer y, int incy) {
        return JCublas.checkResult(JCublas.cublasSetVectorNative(n, elemSize, x, incx, y, incy));
    }

    public static int cublasSetVector(int n, cuComplex[] x, int offsetx, int incx, Pointer y, int incy) {
        ByteBuffer byteBufferx = ByteBuffer.allocateDirect(x.length * 4 * 2);
        byteBufferx.order(ByteOrder.nativeOrder());
        FloatBuffer floatBufferx = byteBufferx.asFloatBuffer();
        int indexx = offsetx;
        int i = 0;
        while (i < n) {
            floatBufferx.put(indexx * 2 + 0, x[indexx].x);
            floatBufferx.put(indexx * 2 + 1, x[indexx].y);
            ++i;
            indexx += incx;
        }
        return JCublas.checkResult(JCublas.cublasSetVectorNative(n, 8, Pointer.to((Buffer)floatBufferx).withByteOffset((long)(offsetx * 4 * 2)), incx, y, incy));
    }

    public static int cublasGetVector(int n, int elemSize, Pointer x, int incx, Pointer y, int incy) {
        return JCublas.checkResult(JCublas.cublasGetVectorNative(n, elemSize, x, incx, y, incy));
    }

    public static int cublasGetVector(int n, Pointer x, int incx, cuComplex[] y, int offsety, int incy) {
        ByteBuffer byteBuffery = ByteBuffer.allocateDirect(y.length * 4 * 2);
        byteBuffery.order(ByteOrder.nativeOrder());
        FloatBuffer floatBuffery = byteBuffery.asFloatBuffer();
        int status = JCublas.cublasGetVectorNative(n, 8, x, incx, Pointer.to((Buffer)floatBuffery).withByteOffset((long)(offsety * 4 * 2)), incy);
        if (status == 0) {
            floatBuffery.rewind();
            int indexy = offsety;
            int i = 0;
            while (i < n) {
                y[indexy].x = floatBuffery.get(indexy * 2 + 0);
                y[indexy].y = floatBuffery.get(indexy * 2 + 1);
                ++i;
                indexy += incy;
            }
        }
        return JCublas.checkResult(status);
    }

    public static int cublasSetMatrix(int rows, int cols, int elemSize, Pointer A, int lda, Pointer B, int ldb) {
        return JCublas.checkResult(JCublas.cublasSetMatrixNative(rows, elemSize, cols, A, lda, B, ldb));
    }

    public static int cublasSetMatrix(int rows, int cols, cuComplex[] A, int offsetA, int lda, Pointer B, int ldb) {
        ByteBuffer byteBufferA = ByteBuffer.allocateDirect(A.length * 4 * 2);
        byteBufferA.order(ByteOrder.nativeOrder());
        FloatBuffer floatBufferA = byteBufferA.asFloatBuffer();
        int i = 0;
        while (i < A.length) {
            floatBufferA.put(A[i].x);
            floatBufferA.put(A[i].y);
            ++i;
        }
        return JCublas.checkResult(JCublas.cublasSetMatrixNative(rows, cols, 8, Pointer.to((Buffer)floatBufferA).withByteOffset((long)(offsetA * 4 * 2)), lda, B, ldb));
    }

    public static int cublasGetMatrix(int rows, int cols, int elemSize, Pointer A, int lda, Pointer B, int ldb) {
        return JCublas.checkResult(JCublas.cublasGetMatrixNative(rows, cols, elemSize, A, lda, B, ldb));
    }

    public static int cublasGetMatrix(int rows, int cols, Pointer A, int lda, cuComplex[] B, int offsetB, int ldb) {
        ByteBuffer byteBufferB = ByteBuffer.allocateDirect(B.length * 4 * 2);
        byteBufferB.order(ByteOrder.nativeOrder());
        FloatBuffer floatBufferB = byteBufferB.asFloatBuffer();
        int status = JCublas.cublasGetMatrixNative(rows, cols, 8, A, lda, Pointer.to((Buffer)floatBufferB).withByteOffset((long)(offsetB * 4 * 2)), ldb);
        if (status == 0) {
            floatBufferB.rewind();
            int c = 0;
            while (c < cols) {
                int r = 0;
                while (r < rows) {
                    int index = c * ldb + r + offsetB;
                    B[index].x = floatBufferB.get(index * 2 + 0);
                    B[index].y = floatBufferB.get(index * 2 + 1);
                    ++r;
                }
                ++c;
            }
        }
        return JCublas.checkResult(status);
    }

    public static int cublasSetVector(int n, cuDoubleComplex[] x, int offsetx, int incx, Pointer y, int incy) {
        ByteBuffer byteBufferx = ByteBuffer.allocateDirect(x.length * 8 * 2);
        byteBufferx.order(ByteOrder.nativeOrder());
        DoubleBuffer doubleBufferx = byteBufferx.asDoubleBuffer();
        int indexx = offsetx;
        int i = 0;
        while (i < n) {
            doubleBufferx.put(indexx * 2 + 0, x[indexx].x);
            doubleBufferx.put(indexx * 2 + 1, x[indexx].y);
            ++i;
            indexx += incx;
        }
        return JCublas.checkResult(JCublas.cublasSetVectorNative(n, 16, Pointer.to((Buffer)doubleBufferx).withByteOffset((long)(offsetx * 8 * 2)), incx, y, incy));
    }

    public static int cublasGetVector(int n, Pointer x, int incx, cuDoubleComplex[] y, int offsety, int incy) {
        ByteBuffer byteBuffery = ByteBuffer.allocateDirect(y.length * 8 * 2);
        byteBuffery.order(ByteOrder.nativeOrder());
        DoubleBuffer doubleBuffery = byteBuffery.asDoubleBuffer();
        int status = JCublas.cublasGetVectorNative(n, 16, x, incx, Pointer.to((Buffer)doubleBuffery).withByteOffset((long)(offsety * 8 * 2)), incy);
        if (status == 0) {
            doubleBuffery.rewind();
            int indexy = offsety;
            int i = 0;
            while (i < n) {
                y[indexy].x = doubleBuffery.get(indexy * 2 + 0);
                y[indexy].y = doubleBuffery.get(indexy * 2 + 1);
                ++i;
                indexy += incy;
            }
        }
        return JCublas.checkResult(status);
    }

    public static int cublasSetMatrix(int rows, int cols, cuDoubleComplex[] A, int offsetA, int lda, Pointer B, int ldb) {
        ByteBuffer byteBufferA = ByteBuffer.allocateDirect(A.length * 8 * 2);
        byteBufferA.order(ByteOrder.nativeOrder());
        DoubleBuffer doubleBufferA = byteBufferA.asDoubleBuffer();
        int i = 0;
        while (i < A.length) {
            doubleBufferA.put(A[i].x);
            doubleBufferA.put(A[i].y);
            ++i;
        }
        return JCublas.checkResult(JCublas.cublasSetMatrixNative(rows, cols, 16, Pointer.to((Buffer)doubleBufferA).withByteOffset((long)(offsetA * 8 * 2)), lda, B, ldb));
    }

    public static int cublasGetMatrix(int rows, int cols, Pointer A, int lda, cuDoubleComplex[] B, int offsetB, int ldb) {
        ByteBuffer byteBufferB = ByteBuffer.allocateDirect(B.length * 8 * 2);
        byteBufferB.order(ByteOrder.nativeOrder());
        DoubleBuffer doubleBufferB = byteBufferB.asDoubleBuffer();
        int status = JCublas.cublasGetMatrixNative(rows, cols, 16, A, lda, Pointer.to((Buffer)doubleBufferB).withByteOffset((long)(offsetB * 8 * 2)), ldb);
        if (status == 0) {
            doubleBufferB.rewind();
            int c = 0;
            while (c < cols) {
                int r = 0;
                while (r < rows) {
                    int index = c * ldb + r + offsetB;
                    B[index].x = doubleBufferB.get(index * 2 + 0);
                    B[index].y = doubleBufferB.get(index * 2 + 1);
                    ++r;
                }
                ++c;
            }
        }
        return JCublas.checkResult(status);
    }

    public static int cublasSetKernelStream(cudaStream_t stream) {
        return JCublas.checkResult(JCublas.cublasSetKernelStreamNative(stream));
    }

    private static native int cublasSetKernelStreamNative(cudaStream_t var0);

    public static int cublasSetVectorAsync(int n, int elemSize, Pointer hostPtr, int incx, Pointer devicePtr, int incy, cudaStream_t stream) {
        return JCublas.checkResult(JCublas.cublasSetVectorAsyncNative(n, elemSize, hostPtr, incx, devicePtr, incy, stream));
    }

    public static int cublasGetVectorAsync(int n, int elemSize, Pointer devicePtr, int incx, Pointer hostPtr, int incy, cudaStream_t stream) {
        return JCublas.checkResult(JCublas.cublasGetVectorAsyncNative(n, elemSize, devicePtr, incx, hostPtr, incy, stream));
    }

    public static int cublasSetMatrixAsync(int rows, int cols, int elemSize, Pointer A, int lda, Pointer B, int ldb, cudaStream_t stream) {
        return JCublas.checkResult(JCublas.cublasSetMatrixAsyncNative(rows, cols, elemSize, A, lda, B, ldb, stream));
    }

    public static int cublasGetMatrixAsync(int rows, int cols, int elemSize, Pointer A, int lda, Pointer B, int ldb, cudaStream_t stream) {
        return JCublas.checkResult(JCublas.cublasGetMatrixAsyncNative(rows, cols, elemSize, A, lda, B, ldb, stream));
    }

    public static void cublasSrotm(int n, Pointer x, int incx, Pointer y, int incy, float[] sparam) {
        JCublas.cublasSrotmNative(n, x, incx, y, incy, sparam);
        JCublas.checkResultBLAS();
    }

    private static native void cublasSrotmNative(int var0, Pointer var1, int var2, Pointer var3, int var4, float[] var5);

    public static void cublasSrotmg(float[] sd1, float[] sd2, float[] sx1, float sy1, float[] sparam) {
        JCublas.cublasSrotmgNative(sd1, sd2, sx1, sy1, sparam);
        JCublas.checkResultBLAS();
    }

    private static native void cublasSrotmgNative(float[] var0, float[] var1, float[] var2, float var3, float[] var4);

    public static void cublasDrotm(int n, Pointer x, int incx, Pointer y, int incy, double[] sparam) {
        JCublas.cublasDrotmNative(n, x, incx, y, incy, sparam);
        JCublas.checkResultBLAS();
    }

    private static native void cublasDrotmNative(int var0, Pointer var1, int var2, Pointer var3, int var4, double[] var5);

    public static void cublasDrotmg(double[] sd1, double[] sd2, double[] sx1, double sy1, double[] sparam) {
        JCublas.cublasDrotmgNative(sd1, sd2, sx1, sy1, sparam);
        JCublas.checkResultBLAS();
    }

    private static native void cublasDrotmgNative(double[] var0, double[] var1, double[] var2, double var3, double[] var5);

    public static int cublasIsamax(int n, Pointer x, int incx) {
        int result = JCublas.cublasIsamaxNative(n, x, incx);
        JCublas.checkResultBLAS();
        return result;
    }

    private static native int cublasIsamaxNative(int var0, Pointer var1, int var2);

    public static int cublasIsamin(int n, Pointer x, int incx) {
        int result = JCublas.cublasIsaminNative(n, x, incx);
        JCublas.checkResultBLAS();
        return result;
    }

    private static native int cublasIsaminNative(int var0, Pointer var1, int var2);

    public static float cublasSasum(int n, Pointer x, int incx) {
        float result = JCublas.cublasSasumNative(n, x, incx);
        JCublas.checkResultBLAS();
        return result;
    }

    private static native float cublasSasumNative(int var0, Pointer var1, int var2);

    public static void cublasSaxpy(int n, float alpha, Pointer x, int incx, Pointer y, int incy) {
        JCublas.cublasSaxpyNative(n, alpha, x, incx, y, incy);
        JCublas.checkResultBLAS();
    }

    private static native void cublasSaxpyNative(int var0, float var1, Pointer var2, int var3, Pointer var4, int var5);

    public static void cublasScopy(int n, Pointer x, int incx, Pointer y, int incy) {
        JCublas.cublasScopyNative(n, x, incx, y, incy);
        JCublas.checkResultBLAS();
    }

    private static native void cublasScopyNative(int var0, Pointer var1, int var2, Pointer var3, int var4);

    public static float cublasSdot(int n, Pointer x, int incx, Pointer y, int incy) {
        float result = JCublas.cublasSdotNative(n, x, incx, y, incy);
        JCublas.checkResultBLAS();
        return result;
    }

    private static native float cublasSdotNative(int var0, Pointer var1, int var2, Pointer var3, int var4);

    public static float cublasSnrm2(int n, Pointer x, int incx) {
        float result = JCublas.cublasSnrm2Native(n, x, incx);
        JCublas.checkResultBLAS();
        return result;
    }

    private static native float cublasSnrm2Native(int var0, Pointer var1, int var2);

    public static void cublasSrot(int n, Pointer x, int incx, Pointer y, int incy, float sc, float ss) {
        JCublas.cublasSrotNative(n, x, incx, y, incy, sc, ss);
        JCublas.checkResultBLAS();
    }

    private static native void cublasSrotNative(int var0, Pointer var1, int var2, Pointer var3, int var4, float var5, float var6);

    public static void cublasSrotg(Pointer host_sa, Pointer host_sb, Pointer host_sc, Pointer host_ss) {
        JCublas.cublasSrotgNative(host_sa, host_sb, host_sc, host_ss);
        JCublas.checkResultBLAS();
    }

    private static native void cublasSrotgNative(Pointer var0, Pointer var1, Pointer var2, Pointer var3);

    public static void cublasSscal(int n, float alpha, Pointer x, int incx) {
        JCublas.cublasSscalNative(n, alpha, x, incx);
        JCublas.checkResultBLAS();
    }

    private static native void cublasSscalNative(int var0, float var1, Pointer var2, int var3);

    public static void cublasSswap(int n, Pointer x, int incx, Pointer y, int incy) {
        JCublas.cublasSswapNative(n, x, incx, y, incy);
        JCublas.checkResultBLAS();
    }

    private static native void cublasSswapNative(int var0, Pointer var1, int var2, Pointer var3, int var4);

    public static void cublasCaxpy(int n, cuComplex alpha, Pointer x, int incx, Pointer y, int incy) {
        JCublas.cublasCaxpyNative(n, alpha, x, incx, y, incy);
        JCublas.checkResultBLAS();
    }

    private static native void cublasCaxpyNative(int var0, cuComplex var1, Pointer var2, int var3, Pointer var4, int var5);

    public static void cublasCcopy(int n, Pointer x, int incx, Pointer y, int incy) {
        JCublas.cublasCcopyNative(n, x, incx, y, incy);
        JCublas.checkResultBLAS();
    }

    private static native void cublasCcopyNative(int var0, Pointer var1, int var2, Pointer var3, int var4);

    public static void cublasZcopy(int n, Pointer x, int incx, Pointer y, int incy) {
        JCublas.cublasZcopyNative(n, x, incx, y, incy);
        JCublas.checkResultBLAS();
    }

    private static native void cublasZcopyNative(int var0, Pointer var1, int var2, Pointer var3, int var4);

    public static void cublasCscal(int n, cuComplex alpha, Pointer x, int incx) {
        JCublas.cublasCscalNative(n, alpha, x, incx);
        JCublas.checkResultBLAS();
    }

    private static native void cublasCscalNative(int var0, cuComplex var1, Pointer var2, int var3);

    public static void cublasCrotg(Pointer host_ca, cuComplex cb, Pointer host_sc, Pointer host_cs) {
        JCublas.cublasCrotgNative(host_ca, cb, host_sc, host_cs);
        JCublas.checkResultBLAS();
    }

    private static native void cublasCrotgNative(Pointer var0, cuComplex var1, Pointer var2, Pointer var3);

    public static void cublasCrot(int n, Pointer x, int incx, Pointer y, int incy, float c, cuComplex s) {
        JCublas.cublasCrotNative(n, x, incx, y, incy, c, s);
        JCublas.checkResultBLAS();
    }

    private static native void cublasCrotNative(int var0, Pointer var1, int var2, Pointer var3, int var4, float var5, cuComplex var6);

    public static void cublasCsrot(int n, Pointer x, int incx, Pointer y, int incy, float c, float s) {
        JCublas.cublasCsrotNative(n, x, incx, y, incy, c, s);
        JCublas.checkResultBLAS();
    }

    private static native void cublasCsrotNative(int var0, Pointer var1, int var2, Pointer var3, int var4, float var5, float var6);

    public static void cublasCsscal(int n, float alpha, Pointer x, int incx) {
        JCublas.cublasCsscalNative(n, alpha, x, incx);
        JCublas.checkResultBLAS();
    }

    private static native void cublasCsscalNative(int var0, float var1, Pointer var2, int var3);

    public static void cublasCswap(int n, Pointer x, int incx, Pointer y, int incy) {
        JCublas.cublasCswapNative(n, x, incx, y, incy);
        JCublas.checkResultBLAS();
    }

    private static native void cublasCswapNative(int var0, Pointer var1, int var2, Pointer var3, int var4);

    public static void cublasZswap(int n, Pointer x, int incx, Pointer y, int incy) {
        JCublas.cublasZswapNative(n, x, incx, y, incy);
        JCublas.checkResultBLAS();
    }

    private static native void cublasZswapNative(int var0, Pointer var1, int var2, Pointer var3, int var4);

    public static int cublasIcamax(int n, Pointer x, int incx) {
        int result = JCublas.cublasIcamaxNative(n, x, incx);
        JCublas.checkResultBLAS();
        return result;
    }

    private static native int cublasIcamaxNative(int var0, Pointer var1, int var2);

    public static int cublasIcamin(int n, Pointer x, int incx) {
        int result = JCublas.cublasIcaminNative(n, x, incx);
        JCublas.checkResultBLAS();
        return result;
    }

    private static native int cublasIcaminNative(int var0, Pointer var1, int var2);

    public static float cublasScasum(int n, Pointer x, int incx) {
        float result = JCublas.cublasScasumNative(n, x, incx);
        JCublas.checkResultBLAS();
        return result;
    }

    private static native float cublasScasumNative(int var0, Pointer var1, int var2);

    public static float cublasScnrm2(int n, Pointer x, int incx) {
        float result = JCublas.cublasScnrm2Native(n, x, incx);
        JCublas.checkResultBLAS();
        return result;
    }

    private static native float cublasScnrm2Native(int var0, Pointer var1, int var2);

    public static void cublasZaxpy(int n, cuDoubleComplex alpha, Pointer x, int incx, Pointer y, int incy) {
        JCublas.cublasZaxpyNative(n, alpha, x, incx, y, incy);
        JCublas.checkResultBLAS();
    }

    private static native void cublasZaxpyNative(int var0, cuDoubleComplex var1, Pointer var2, int var3, Pointer var4, int var5);

    public static void cublasZscal(int n, cuDoubleComplex alpha, Pointer x, int incx) {
        JCublas.cublasZscalNative(n, alpha, x, incx);
        JCublas.checkResultBLAS();
    }

    private static native void cublasZscalNative(int var0, cuDoubleComplex var1, Pointer var2, int var3);

    public static void cublasZdscal(int n, double alpha, Pointer x, int incx) {
        JCublas.cublasZdscalNative(n, alpha, x, incx);
        JCublas.checkResultBLAS();
    }

    private static native void cublasZdscalNative(int var0, double var1, Pointer var3, int var4);

    public static double cublasDznrm2(int n, Pointer x, int incx) {
        double result = JCublas.cublasDznrm2Native(n, x, incx);
        JCublas.checkResultBLAS();
        return result;
    }

    private static native double cublasDznrm2Native(int var0, Pointer var1, int var2);

    public static void cublasZrotg(Pointer host_ca, cuDoubleComplex cb, Pointer host_sc, Pointer host_cs) {
        JCublas.cublasZrotgNative(host_ca, cb, host_sc, host_cs);
        JCublas.checkResultBLAS();
    }

    private static native void cublasZrotgNative(Pointer var0, cuDoubleComplex var1, Pointer var2, Pointer var3);

    public static void cublasZrot(int n, Pointer x, int incx, Pointer y, int incy, double sc, cuDoubleComplex cs) {
        JCublas.cublasZrotNative(n, x, incx, y, incy, sc, cs);
        JCublas.checkResultBLAS();
    }

    private static native void cublasZrotNative(int var0, Pointer var1, int var2, Pointer var3, int var4, double var5, cuDoubleComplex var7);

    public static void cublasZdrot(int n, Pointer x, int incx, Pointer y, int incy, double c, double s) {
        JCublas.cublasZdrotNative(n, x, incx, y, incy, c, s);
        JCublas.checkResultBLAS();
    }

    private static native void cublasZdrotNative(int var0, Pointer var1, int var2, Pointer var3, int var4, double var5, double var7);

    public static int cublasIzamax(int n, Pointer x, int incx) {
        int result = JCublas.cublasIzamaxNative(n, x, incx);
        JCublas.checkResultBLAS();
        return result;
    }

    private static native int cublasIzamaxNative(int var0, Pointer var1, int var2);

    public static int cublasIzamin(int n, Pointer x, int incx) {
        int result = JCublas.cublasIzaminNative(n, x, incx);
        JCublas.checkResultBLAS();
        return result;
    }

    private static native int cublasIzaminNative(int var0, Pointer var1, int var2);

    public static double cublasDzasum(int n, Pointer x, int incx) {
        double result = JCublas.cublasDzasumNative(n, x, incx);
        JCublas.checkResultBLAS();
        return result;
    }

    private static native double cublasDzasumNative(int var0, Pointer var1, int var2);

    public static void cublasSgbmv(char trans, int m, int n, int kl, int ku, float alpha, Pointer A, int lda, Pointer x, int incx, float beta, Pointer y, int incy) {
        JCublas.cublasSgbmvNative(trans, m, n, kl, ku, alpha, A, lda, x, incx, beta, y, incy);
        JCublas.checkResultBLAS();
    }

    private static native void cublasSgbmvNative(char var0, int var1, int var2, int var3, int var4, float var5, Pointer var6, int var7, Pointer var8, int var9, float var10, Pointer var11, int var12);

    public static void cublasSgemv(char trans, int m, int n, float alpha, Pointer A, int lda, Pointer x, int incx, float beta, Pointer y, int incy) {
        JCublas.cublasSgemvNative(trans, m, n, alpha, A, lda, x, incx, beta, y, incy);
        JCublas.checkResultBLAS();
    }

    private static native void cublasSgemvNative(char var0, int var1, int var2, float var3, Pointer var4, int var5, Pointer var6, int var7, float var8, Pointer var9, int var10);

    public static void cublasSger(int m, int n, float alpha, Pointer x, int incx, Pointer y, int incy, Pointer A, int lda) {
        JCublas.cublasSgerNative(m, n, alpha, x, incx, y, incy, A, lda);
        JCublas.checkResultBLAS();
    }

    private static native void cublasSgerNative(int var0, int var1, float var2, Pointer var3, int var4, Pointer var5, int var6, Pointer var7, int var8);

    public static void cublasSsbmv(char uplo, int n, int k, float alpha, Pointer A, int lda, Pointer x, int incx, float beta, Pointer y, int incy) {
        JCublas.cublasSsbmvNative(uplo, n, k, alpha, A, lda, x, incx, beta, y, incy);
        JCublas.checkResultBLAS();
    }

    private static native void cublasSsbmvNative(char var0, int var1, int var2, float var3, Pointer var4, int var5, Pointer var6, int var7, float var8, Pointer var9, int var10);

    public static void cublasSspmv(char uplo, int n, float alpha, Pointer AP, Pointer x, int incx, float beta, Pointer y, int incy) {
        JCublas.cublasSspmvNative(uplo, n, alpha, AP, x, incx, beta, y, incy);
        JCublas.checkResultBLAS();
    }

    private static native void cublasSspmvNative(char var0, int var1, float var2, Pointer var3, Pointer var4, int var5, float var6, Pointer var7, int var8);

    public static void cublasSspr(char uplo, int n, float alpha, Pointer x, int incx, Pointer AP) {
        JCublas.cublasSsprNative(uplo, n, alpha, x, incx, AP);
        JCublas.checkResultBLAS();
    }

    private static native void cublasSsprNative(char var0, int var1, float var2, Pointer var3, int var4, Pointer var5);

    public static void cublasSspr2(char uplo, int n, float alpha, Pointer x, int incx, Pointer y, int incy, Pointer AP) {
        JCublas.cublasSspr2Native(uplo, n, alpha, x, incx, y, incy, AP);
        JCublas.checkResultBLAS();
    }

    private static native void cublasSspr2Native(char var0, int var1, float var2, Pointer var3, int var4, Pointer var5, int var6, Pointer var7);

    public static void cublasSsymv(char uplo, int n, float alpha, Pointer A, int lda, Pointer x, int incx, float beta, Pointer y, int incy) {
        JCublas.cublasSsymvNative(uplo, n, alpha, A, lda, x, incx, beta, y, incy);
        JCublas.checkResultBLAS();
    }

    private static native void cublasSsymvNative(char var0, int var1, float var2, Pointer var3, int var4, Pointer var5, int var6, float var7, Pointer var8, int var9);

    public static void cublasSsyr(char uplo, int n, float alpha, Pointer x, int incx, Pointer A, int lda) {
        JCublas.cublasSsyrNative(uplo, n, alpha, x, incx, A, lda);
        JCublas.checkResultBLAS();
    }

    private static native void cublasSsyrNative(char var0, int var1, float var2, Pointer var3, int var4, Pointer var5, int var6);

    public static void cublasSsyr2(char uplo, int n, float alpha, Pointer x, int incx, Pointer y, int incy, Pointer A, int lda) {
        JCublas.cublasSsyr2Native(uplo, n, alpha, x, incx, y, incy, A, lda);
        JCublas.checkResultBLAS();
    }

    private static native void cublasSsyr2Native(char var0, int var1, float var2, Pointer var3, int var4, Pointer var5, int var6, Pointer var7, int var8);

    public static void cublasStbmv(char uplo, char trans, char diag, int n, int k, Pointer A, int lda, Pointer x, int incx) {
        JCublas.cublasStbmvNative(uplo, trans, diag, n, k, A, lda, x, incx);
        JCublas.checkResultBLAS();
    }

    private static native void cublasStbmvNative(char var0, char var1, char var2, int var3, int var4, Pointer var5, int var6, Pointer var7, int var8);

    public static void cublasStbsv(char uplo, char trans, char diag, int n, int k, Pointer A, int lda, Pointer x, int incx) {
        JCublas.cublasStbsvNative(uplo, trans, diag, n, k, A, lda, x, incx);
        JCublas.checkResultBLAS();
    }

    private static native void cublasStbsvNative(char var0, char var1, char var2, int var3, int var4, Pointer var5, int var6, Pointer var7, int var8);

    public static void cublasStpmv(char uplo, char trans, char diag, int n, Pointer AP, Pointer x, int incx) {
        JCublas.cublasStpmvNative(uplo, trans, diag, n, AP, x, incx);
        JCublas.checkResultBLAS();
    }

    private static native void cublasStpmvNative(char var0, char var1, char var2, int var3, Pointer var4, Pointer var5, int var6);

    public static void cublasStpsv(char uplo, char trans, char diag, int n, Pointer AP, Pointer x, int incx) {
        JCublas.cublasStpsvNative(uplo, trans, diag, n, AP, x, incx);
        JCublas.checkResultBLAS();
    }

    private static native void cublasStpsvNative(char var0, char var1, char var2, int var3, Pointer var4, Pointer var5, int var6);

    public static void cublasStrmv(char uplo, char trans, char diag, int n, Pointer A, int lda, Pointer x, int incx) {
        JCublas.cublasStrmvNative(uplo, trans, diag, n, A, lda, x, incx);
        JCublas.checkResultBLAS();
    }

    private static native void cublasStrmvNative(char var0, char var1, char var2, int var3, Pointer var4, int var5, Pointer var6, int var7);

    public static void cublasStrsv(char uplo, char trans, char diag, int n, Pointer A, int lda, Pointer x, int incx) {
        JCublas.cublasStrsvNative(uplo, trans, diag, n, A, lda, x, incx);
        JCublas.checkResultBLAS();
    }

    private static native void cublasStrsvNative(char var0, char var1, char var2, int var3, Pointer var4, int var5, Pointer var6, int var7);

    public static void cublasZtrmv(char uplo, char trans, char diag, int n, Pointer A, int lda, Pointer x, int incx) {
        JCublas.cublasZtrmvNative(uplo, trans, diag, n, A, lda, x, incx);
        JCublas.checkResultBLAS();
    }

    private static native void cublasZtrmvNative(char var0, char var1, char var2, int var3, Pointer var4, int var5, Pointer var6, int var7);

    public static void cublasZgbmv(char trans, int m, int n, int kl, int ku, cuDoubleComplex alpha, Pointer A, int lda, Pointer x, int incx, cuDoubleComplex beta, Pointer y, int incy) {
        JCublas.cublasZgbmvNative(trans, m, n, kl, ku, alpha, A, lda, x, incx, beta, y, incy);
        JCublas.checkResultBLAS();
    }

    private static native void cublasZgbmvNative(char var0, int var1, int var2, int var3, int var4, cuDoubleComplex var5, Pointer var6, int var7, Pointer var8, int var9, cuDoubleComplex var10, Pointer var11, int var12);

    public static void cublasZtbmv(char uplo, char trans, char diag, int n, int k, Pointer A, int lda, Pointer x, int incx) {
        JCublas.cublasZtbmvNative(uplo, trans, diag, n, k, A, lda, x, incx);
        JCublas.checkResultBLAS();
    }

    private static native void cublasZtbmvNative(char var0, char var1, char var2, int var3, int var4, Pointer var5, int var6, Pointer var7, int var8);

    public static void cublasZtbsv(char uplo, char trans, char diag, int n, int k, Pointer A, int lda, Pointer x, int incx) {
        JCublas.cublasZtbsvNative(uplo, trans, diag, n, k, A, lda, x, incx);
        JCublas.checkResultBLAS();
    }

    private static native void cublasZtbsvNative(char var0, char var1, char var2, int var3, int var4, Pointer var5, int var6, Pointer var7, int var8);

    public static void cublasZhemv(char uplo, int n, cuDoubleComplex alpha, Pointer A, int lda, Pointer x, int incx, cuDoubleComplex beta, Pointer y, int incy) {
        JCublas.cublasZhemvNative(uplo, n, alpha, A, lda, x, incx, beta, y, incy);
        JCublas.checkResultBLAS();
    }

    private static native void cublasZhemvNative(char var0, int var1, cuDoubleComplex var2, Pointer var3, int var4, Pointer var5, int var6, cuDoubleComplex var7, Pointer var8, int var9);

    public static void cublasZhpmv(char uplo, int n, cuDoubleComplex alpha, Pointer AP, Pointer x, int incx, cuDoubleComplex beta, Pointer y, int incy) {
        JCublas.cublasZhpmvNative(uplo, n, alpha, AP, x, incx, beta, y, incy);
        JCublas.checkResultBLAS();
    }

    private static native void cublasZhpmvNative(char var0, int var1, cuDoubleComplex var2, Pointer var3, Pointer var4, int var5, cuDoubleComplex var6, Pointer var7, int var8);

    public static void cublasZgemv(char trans, int m, int n, cuDoubleComplex alpha, Pointer A, int lda, Pointer x, int incx, cuDoubleComplex beta, Pointer y, int incy) {
        JCublas.cublasZgemvNative(trans, m, n, alpha, A, lda, x, incx, beta, y, incy);
        JCublas.checkResultBLAS();
    }

    private static native void cublasZgemvNative(char var0, int var1, int var2, cuDoubleComplex var3, Pointer var4, int var5, Pointer var6, int var7, cuDoubleComplex var8, Pointer var9, int var10);

    public static void cublasZtpmv(char uplo, char trans, char diag, int n, Pointer AP, Pointer x, int incx) {
        JCublas.cublasZtpmvNative(uplo, trans, diag, n, AP, x, incx);
        JCublas.checkResultBLAS();
    }

    private static native void cublasZtpmvNative(char var0, char var1, char var2, int var3, Pointer var4, Pointer var5, int var6);

    public static void cublasZtpsv(char uplo, char trans, char diag, int n, Pointer AP, Pointer x, int incx) {
        JCublas.cublasZtpsvNative(uplo, trans, diag, n, AP, x, incx);
        JCublas.checkResultBLAS();
    }

    private static native void cublasZtpsvNative(char var0, char var1, char var2, int var3, Pointer var4, Pointer var5, int var6);

    public static void cublasCgemv(char trans, int m, int n, cuComplex alpha, Pointer A, int lda, Pointer x, int incx, cuComplex beta, Pointer y, int incy) {
        JCublas.cublasCgemvNative(trans, m, n, alpha, A, lda, x, incx, beta, y, incy);
        JCublas.checkResultBLAS();
    }

    private static native void cublasCgemvNative(char var0, int var1, int var2, cuComplex var3, Pointer var4, int var5, Pointer var6, int var7, cuComplex var8, Pointer var9, int var10);

    public static void cublasCgbmv(char trans, int m, int n, int kl, int ku, cuComplex alpha, Pointer A, int lda, Pointer x, int incx, cuComplex beta, Pointer y, int incy) {
        JCublas.cublasCgbmvNative(trans, m, n, kl, ku, alpha, A, lda, x, incx, beta, y, incy);
        JCublas.checkResultBLAS();
    }

    private static native void cublasCgbmvNative(char var0, int var1, int var2, int var3, int var4, cuComplex var5, Pointer var6, int var7, Pointer var8, int var9, cuComplex var10, Pointer var11, int var12);

    public static void cublasChemv(char uplo, int n, cuComplex alpha, Pointer A, int lda, Pointer x, int incx, cuComplex beta, Pointer y, int incy) {
        JCublas.cublasChemvNative(uplo, n, alpha, A, lda, x, incx, beta, y, incy);
        JCublas.checkResultBLAS();
    }

    private static native void cublasChemvNative(char var0, int var1, cuComplex var2, Pointer var3, int var4, Pointer var5, int var6, cuComplex var7, Pointer var8, int var9);

    public static void cublasChbmv(char uplo, int n, int k, cuComplex alpha, Pointer A, int lda, Pointer x, int incx, cuComplex beta, Pointer y, int incy) {
        JCublas.cublasChbmvNative(uplo, n, k, alpha, A, lda, x, incx, beta, y, incy);
        JCublas.checkResultBLAS();
    }

    private static native void cublasChbmvNative(char var0, int var1, int var2, cuComplex var3, Pointer var4, int var5, Pointer var6, int var7, cuComplex var8, Pointer var9, int var10);

    public static void cublasCtrmv(char uplo, char trans, char diag, int n, Pointer A, int lda, Pointer x, int incx) {
        JCublas.cublasCtrmvNative(uplo, trans, diag, n, A, lda, x, incx);
        JCublas.checkResultBLAS();
    }

    private static native void cublasCtrmvNative(char var0, char var1, char var2, int var3, Pointer var4, int var5, Pointer var6, int var7);

    public static void cublasCtbmv(char uplo, char trans, char diag, int n, int k, Pointer A, int lda, Pointer x, int incx) {
        JCublas.cublasCtbmvNative(uplo, trans, diag, n, k, A, lda, x, incx);
        JCublas.checkResultBLAS();
    }

    private static native void cublasCtbmvNative(char var0, char var1, char var2, int var3, int var4, Pointer var5, int var6, Pointer var7, int var8);

    public static void cublasCtpmv(char uplo, char trans, char diag, int n, Pointer AP, Pointer x, int incx) {
        JCublas.cublasCtpmvNative(uplo, trans, diag, n, AP, x, incx);
        JCublas.checkResultBLAS();
    }

    private static native void cublasCtpmvNative(char var0, char var1, char var2, int var3, Pointer var4, Pointer var5, int var6);

    public static void cublasCtrsv(char uplo, char trans, char diag, int n, Pointer A, int lda, Pointer x, int incx) {
        JCublas.cublasCtrsvNative(uplo, trans, diag, n, A, lda, x, incx);
        JCublas.checkResultBLAS();
    }

    private static native void cublasCtrsvNative(char var0, char var1, char var2, int var3, Pointer var4, int var5, Pointer var6, int var7);

    public static void cublasCtbsv(char uplo, char trans, char diag, int n, int k, Pointer A, int lda, Pointer x, int incx) {
        JCublas.cublasCtbsvNative(uplo, trans, diag, n, k, A, lda, x, incx);
        JCublas.checkResultBLAS();
    }

    private static native void cublasCtbsvNative(char var0, char var1, char var2, int var3, int var4, Pointer var5, int var6, Pointer var7, int var8);

    public static void cublasCtpsv(char uplo, char trans, char diag, int n, Pointer AP, Pointer x, int incx) {
        JCublas.cublasCtpsvNative(uplo, trans, diag, n, AP, x, incx);
        JCublas.checkResultBLAS();
    }

    private static native void cublasCtpsvNative(char var0, char var1, char var2, int var3, Pointer var4, Pointer var5, int var6);

    public static void cublasCgeru(int m, int n, cuComplex alpha, Pointer x, int incx, Pointer y, int incy, Pointer A, int lda) {
        JCublas.cublasCgeruNative(m, n, alpha, x, incx, y, incy, A, lda);
        JCublas.checkResultBLAS();
    }

    private static native void cublasCgeruNative(int var0, int var1, cuComplex var2, Pointer var3, int var4, Pointer var5, int var6, Pointer var7, int var8);

    public static void cublasCgerc(int m, int n, cuComplex alpha, Pointer x, int incx, Pointer y, int incy, Pointer A, int lda) {
        JCublas.cublasCgercNative(m, n, alpha, x, incx, y, incy, A, lda);
        JCublas.checkResultBLAS();
    }

    private static native void cublasCgercNative(int var0, int var1, cuComplex var2, Pointer var3, int var4, Pointer var5, int var6, Pointer var7, int var8);

    public static void cublasCher(char uplo, int n, float alpha, Pointer x, int incx, Pointer A, int lda) {
        JCublas.cublasCherNative(uplo, n, alpha, x, incx, A, lda);
        JCublas.checkResultBLAS();
    }

    private static native void cublasCherNative(char var0, int var1, float var2, Pointer var3, int var4, Pointer var5, int var6);

    public static void cublasChpr(char uplo, int n, float alpha, Pointer x, int incx, Pointer AP) {
        JCublas.cublasChprNative(uplo, n, alpha, x, incx, AP);
        JCublas.checkResultBLAS();
    }

    private static native void cublasChprNative(char var0, int var1, float var2, Pointer var3, int var4, Pointer var5);

    public static void cublasChpr2(char uplo, int n, cuComplex alpha, Pointer x, int incx, Pointer y, int incy, Pointer AP) {
        JCublas.cublasChpr2Native(uplo, n, alpha, x, incx, y, incy, AP);
        JCublas.checkResultBLAS();
    }

    private static native void cublasChpr2Native(char var0, int var1, cuComplex var2, Pointer var3, int var4, Pointer var5, int var6, Pointer var7);

    public static void cublasCher2(char uplo, int n, cuComplex alpha, Pointer x, int incx, Pointer y, int incy, Pointer A, int lda) {
        JCublas.cublasCher2Native(uplo, n, alpha, x, incx, y, incy, A, lda);
        JCublas.checkResultBLAS();
    }

    private static native void cublasCher2Native(char var0, int var1, cuComplex var2, Pointer var3, int var4, Pointer var5, int var6, Pointer var7, int var8);

    public static void cublasSgemm(char transa, char transb, int m, int n, int k, float alpha, Pointer A, int lda, Pointer B, int ldb, float beta, Pointer C, int ldc) {
        JCublas.cublasSgemmNative(transa, transb, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc);
        JCublas.checkResultBLAS();
    }

    private static native void cublasSgemmNative(char var0, char var1, int var2, int var3, int var4, float var5, Pointer var6, int var7, Pointer var8, int var9, float var10, Pointer var11, int var12);

    public static void cublasSsymm(char side, char uplo, int m, int n, float alpha, Pointer A, int lda, Pointer B, int ldb, float beta, Pointer C, int ldc) {
        JCublas.cublasSsymmNative(side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc);
        JCublas.checkResultBLAS();
    }

    private static native void cublasSsymmNative(char var0, char var1, int var2, int var3, float var4, Pointer var5, int var6, Pointer var7, int var8, float var9, Pointer var10, int var11);

    public static void cublasSsyrk(char uplo, char trans, int n, int k, float alpha, Pointer A, int lda, float beta, Pointer C, int ldc) {
        JCublas.cublasSsyrkNative(uplo, trans, n, k, alpha, A, lda, beta, C, ldc);
        JCublas.checkResultBLAS();
    }

    private static native void cublasSsyrkNative(char var0, char var1, int var2, int var3, float var4, Pointer var5, int var6, float var7, Pointer var8, int var9);

    public static void cublasSsyr2k(char uplo, char trans, int n, int k, float alpha, Pointer A, int lda, Pointer B, int ldb, float beta, Pointer C, int ldc) {
        JCublas.cublasSsyr2kNative(uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc);
        JCublas.checkResultBLAS();
    }

    private static native void cublasSsyr2kNative(char var0, char var1, int var2, int var3, float var4, Pointer var5, int var6, Pointer var7, int var8, float var9, Pointer var10, int var11);

    public static void cublasStrmm(char side, char uplo, char transa, char diag, int m, int n, float alpha, Pointer A, int lda, Pointer B, int ldb) {
        JCublas.cublasStrmmNative(side, uplo, transa, diag, m, n, alpha, A, lda, B, ldb);
        JCublas.checkResultBLAS();
    }

    private static native void cublasStrmmNative(char var0, char var1, char var2, char var3, int var4, int var5, float var6, Pointer var7, int var8, Pointer var9, int var10);

    public static void cublasStrsm(char side, char uplo, char transa, char diag, int m, int n, float alpha, Pointer A, int lda, Pointer B, int ldb) {
        JCublas.cublasStrsmNative(side, uplo, transa, diag, m, n, alpha, A, lda, B, ldb);
        JCublas.checkResultBLAS();
    }

    private static native void cublasStrsmNative(char var0, char var1, char var2, char var3, int var4, int var5, float var6, Pointer var7, int var8, Pointer var9, int var10);

    public static void cublasCgemm(char transa, char transb, int m, int n, int k, cuComplex alpha, Pointer A, int lda, Pointer B, int ldb, cuComplex beta, Pointer C, int ldc) {
        JCublas.cublasCgemmNative(transa, transb, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc);
        JCublas.checkResultBLAS();
    }

    private static native void cublasCgemmNative(char var0, char var1, int var2, int var3, int var4, cuComplex var5, Pointer var6, int var7, Pointer var8, int var9, cuComplex var10, Pointer var11, int var12);

    public static void cublasCsymm(char side, char uplo, int m, int n, cuComplex alpha, Pointer A, int lda, Pointer B, int ldb, cuComplex beta, Pointer C, int ldc) {
        JCublas.cublasCsymmNative(side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc);
        JCublas.checkResultBLAS();
    }

    private static native void cublasCsymmNative(char var0, char var1, int var2, int var3, cuComplex var4, Pointer var5, int var6, Pointer var7, int var8, cuComplex var9, Pointer var10, int var11);

    public static void cublasChemm(char side, char uplo, int m, int n, cuComplex alpha, Pointer A, int lda, Pointer B, int ldb, cuComplex beta, Pointer C, int ldc) {
        JCublas.cublasChemmNative(side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc);
        JCublas.checkResultBLAS();
    }

    private static native void cublasChemmNative(char var0, char var1, int var2, int var3, cuComplex var4, Pointer var5, int var6, Pointer var7, int var8, cuComplex var9, Pointer var10, int var11);

    public static void cublasCsyrk(char uplo, char trans, int n, int k, cuComplex alpha, Pointer A, int lda, cuComplex beta, Pointer C, int ldc) {
        JCublas.cublasCsyrkNative(uplo, trans, n, k, alpha, A, lda, beta, C, ldc);
        JCublas.checkResultBLAS();
    }

    private static native void cublasCsyrkNative(char var0, char var1, int var2, int var3, cuComplex var4, Pointer var5, int var6, cuComplex var7, Pointer var8, int var9);

    public static void cublasCherk(char uplo, char trans, int n, int k, float alpha, Pointer A, int lda, float beta, Pointer C, int ldc) {
        JCublas.cublasCherkNative(uplo, trans, n, k, alpha, A, lda, beta, C, ldc);
        JCublas.checkResultBLAS();
    }

    private static native void cublasCherkNative(char var0, char var1, int var2, int var3, float var4, Pointer var5, int var6, float var7, Pointer var8, int var9);

    public static void cublasCsyr2k(char uplo, char trans, int n, int k, cuComplex alpha, Pointer A, int lda, Pointer B, int ldb, cuComplex beta, Pointer C, int ldc) {
        JCublas.cublasCsyr2kNative(uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc);
        JCublas.checkResultBLAS();
    }

    private static native void cublasCsyr2kNative(char var0, char var1, int var2, int var3, cuComplex var4, Pointer var5, int var6, Pointer var7, int var8, cuComplex var9, Pointer var10, int var11);

    public static void cublasCher2k(char uplo, char trans, int n, int k, cuComplex alpha, Pointer A, int lda, Pointer B, int ldb, float beta, Pointer C, int ldc) {
        JCublas.cublasCher2kNative(uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc);
        JCublas.checkResultBLAS();
    }

    private static native void cublasCher2kNative(char var0, char var1, int var2, int var3, cuComplex var4, Pointer var5, int var6, Pointer var7, int var8, float var9, Pointer var10, int var11);

    public static void cublasCtrmm(char side, char uplo, char transa, char diag, int m, int n, cuComplex alpha, Pointer A, int lda, Pointer B, int ldb) {
        JCublas.cublasCtrmmNative(side, uplo, transa, diag, m, n, alpha, A, lda, B, ldb);
        JCublas.checkResultBLAS();
    }

    private static native void cublasCtrmmNative(char var0, char var1, char var2, char var3, int var4, int var5, cuComplex var6, Pointer var7, int var8, Pointer var9, int var10);

    public static void cublasCtrsm(char side, char uplo, char transa, char diag, int m, int n, cuComplex alpha, Pointer A, int lda, Pointer B, int ldb) {
        JCublas.cublasCtrsmNative(side, uplo, transa, diag, m, n, alpha, A, lda, B, ldb);
        JCublas.checkResultBLAS();
    }

    private static native void cublasCtrsmNative(char var0, char var1, char var2, char var3, int var4, int var5, cuComplex var6, Pointer var7, int var8, Pointer var9, int var10);

    public static double cublasDasum(int n, Pointer x, int incx) {
        double result = JCublas.cublasDasumNative(n, x, incx);
        JCublas.checkResultBLAS();
        return result;
    }

    private static native double cublasDasumNative(int var0, Pointer var1, int var2);

    public static void cublasDaxpy(int n, double alpha, Pointer x, int incx, Pointer y, int incy) {
        JCublas.cublasDaxpyNative(n, alpha, x, incx, y, incy);
        JCublas.checkResultBLAS();
    }

    private static native void cublasDaxpyNative(int var0, double var1, Pointer var3, int var4, Pointer var5, int var6);

    public static void cublasDcopy(int n, Pointer x, int incx, Pointer y, int incy) {
        JCublas.cublasDcopyNative(n, x, incx, y, incy);
        JCublas.checkResultBLAS();
    }

    private static native void cublasDcopyNative(int var0, Pointer var1, int var2, Pointer var3, int var4);

    public static double cublasDdot(int n, Pointer x, int incx, Pointer y, int incy) {
        double result = JCublas.cublasDdotNative(n, x, incx, y, incy);
        JCublas.checkResultBLAS();
        return result;
    }

    private static native double cublasDdotNative(int var0, Pointer var1, int var2, Pointer var3, int var4);

    public static double cublasDnrm2(int n, Pointer x, int incx) {
        double result = JCublas.cublasDnrm2Native(n, x, incx);
        JCublas.checkResultBLAS();
        return result;
    }

    private static native double cublasDnrm2Native(int var0, Pointer var1, int var2);

    public static void cublasDrot(int n, Pointer x, int incx, Pointer y, int incy, double sc, double ss) {
        JCublas.cublasDrotNative(n, x, incx, y, incy, sc, ss);
        JCublas.checkResultBLAS();
    }

    private static native void cublasDrotNative(int var0, Pointer var1, int var2, Pointer var3, int var4, double var5, double var7);

    public static void cublasDrotg(Pointer host_sa, Pointer host_sb, Pointer host_sc, Pointer host_ss) {
        JCublas.cublasDrotgNative(host_sa, host_sb, host_sc, host_ss);
        JCublas.checkResultBLAS();
    }

    private static native void cublasDrotgNative(Pointer var0, Pointer var1, Pointer var2, Pointer var3);

    public static void cublasDscal(int n, double alpha, Pointer x, int incx) {
        JCublas.cublasDscalNative(n, alpha, x, incx);
        JCublas.checkResultBLAS();
    }

    private static native void cublasDscalNative(int var0, double var1, Pointer var3, int var4);

    public static void cublasDswap(int n, Pointer x, int incx, Pointer y, int incy) {
        JCublas.cublasDswapNative(n, x, incx, y, incy);
        JCublas.checkResultBLAS();
    }

    private static native void cublasDswapNative(int var0, Pointer var1, int var2, Pointer var3, int var4);

    public static int cublasIdamax(int n, Pointer x, int incx) {
        int result = JCublas.cublasIdamaxNative(n, x, incx);
        JCublas.checkResultBLAS();
        return result;
    }

    private static native int cublasIdamaxNative(int var0, Pointer var1, int var2);

    public static int cublasIdamin(int n, Pointer x, int incx) {
        int result = JCublas.cublasIdaminNative(n, x, incx);
        JCublas.checkResultBLAS();
        return result;
    }

    private static native int cublasIdaminNative(int var0, Pointer var1, int var2);

    public static void cublasDgemv(char trans, int m, int n, double alpha, Pointer A, int lda, Pointer x, int incx, double beta, Pointer y, int incy) {
        JCublas.cublasDgemvNative(trans, m, n, alpha, A, lda, x, incx, beta, y, incy);
        JCublas.checkResultBLAS();
    }

    private static native void cublasDgemvNative(char var0, int var1, int var2, double var3, Pointer var5, int var6, Pointer var7, int var8, double var9, Pointer var11, int var12);

    public static void cublasDger(int m, int n, double alpha, Pointer x, int incx, Pointer y, int incy, Pointer A, int lda) {
        JCublas.cublasDgerNative(m, n, alpha, x, incx, y, incy, A, lda);
        JCublas.checkResultBLAS();
    }

    private static native void cublasDgerNative(int var0, int var1, double var2, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static void cublasDsyr(char uplo, int n, double alpha, Pointer x, int incx, Pointer A, int lda) {
        JCublas.cublasDsyrNative(uplo, n, alpha, x, incx, A, lda);
        JCublas.checkResultBLAS();
    }

    private static native void cublasDsyrNative(char var0, int var1, double var2, Pointer var4, int var5, Pointer var6, int var7);

    public static void cublasDsyr2(char uplo, int n, double alpha, Pointer x, int incx, Pointer y, int incy, Pointer A, int lda) {
        JCublas.cublasDsyr2Native(uplo, n, alpha, x, incx, y, incy, A, lda);
        JCublas.checkResultBLAS();
    }

    private static native void cublasDsyr2Native(char var0, int var1, double var2, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static void cublasDspr(char uplo, int n, double alpha, Pointer x, int incx, Pointer AP) {
        JCublas.cublasDsprNative(uplo, n, alpha, x, incx, AP);
        JCublas.checkResultBLAS();
    }

    private static native void cublasDsprNative(char var0, int var1, double var2, Pointer var4, int var5, Pointer var6);

    public static void cublasDspr2(char uplo, int n, double alpha, Pointer x, int incx, Pointer y, int incy, Pointer AP) {
        JCublas.cublasDspr2Native(uplo, n, alpha, x, incx, y, incy, AP);
        JCublas.checkResultBLAS();
    }

    private static native void cublasDspr2Native(char var0, int var1, double var2, Pointer var4, int var5, Pointer var6, int var7, Pointer var8);

    public static void cublasDtrsv(char uplo, char trans, char diag, int n, Pointer A, int lda, Pointer x, int incx) {
        JCublas.cublasDtrsvNative(uplo, trans, diag, n, A, lda, x, incx);
        JCublas.checkResultBLAS();
    }

    private static native void cublasDtrsvNative(char var0, char var1, char var2, int var3, Pointer var4, int var5, Pointer var6, int var7);

    public static void cublasDtrmv(char uplo, char trans, char diag, int n, Pointer A, int lda, Pointer x, int incx) {
        JCublas.cublasDtrmvNative(uplo, trans, diag, n, A, lda, x, incx);
        JCublas.checkResultBLAS();
    }

    private static native void cublasDtrmvNative(char var0, char var1, char var2, int var3, Pointer var4, int var5, Pointer var6, int var7);

    public static void cublasDgbmv(char trans, int m, int n, int kl, int ku, double alpha, Pointer A, int lda, Pointer x, int incx, double beta, Pointer y, int incy) {
        JCublas.cublasDgbmvNative(trans, m, n, kl, ku, alpha, A, lda, x, incx, beta, y, incy);
        JCublas.checkResultBLAS();
    }

    private static native void cublasDgbmvNative(char var0, int var1, int var2, int var3, int var4, double var5, Pointer var7, int var8, Pointer var9, int var10, double var11, Pointer var13, int var14);

    public static void cublasDtbmv(char uplo, char trans, char diag, int n, int k, Pointer A, int lda, Pointer x, int incx) {
        JCublas.cublasDtbmvNative(uplo, trans, diag, n, k, A, lda, x, incx);
        JCublas.checkResultBLAS();
    }

    private static native void cublasDtbmvNative(char var0, char var1, char var2, int var3, int var4, Pointer var5, int var6, Pointer var7, int var8);

    public static void cublasDtpmv(char uplo, char trans, char diag, int n, Pointer AP, Pointer x, int incx) {
        JCublas.cublasDtpmvNative(uplo, trans, diag, n, AP, x, incx);
        JCublas.checkResultBLAS();
    }

    private static native void cublasDtpmvNative(char var0, char var1, char var2, int var3, Pointer var4, Pointer var5, int var6);

    public static void cublasDtpsv(char uplo, char trans, char diag, int n, Pointer AP, Pointer x, int incx) {
        JCublas.cublasDtpsvNative(uplo, trans, diag, n, AP, x, incx);
        JCublas.checkResultBLAS();
    }

    private static native void cublasDtpsvNative(char var0, char var1, char var2, int var3, Pointer var4, Pointer var5, int var6);

    public static void cublasDtbsv(char uplo, char trans, char diag, int n, int k, Pointer A, int lda, Pointer x, int incx) {
        JCublas.cublasDtbsvNative(uplo, trans, diag, n, k, A, lda, x, incx);
        JCublas.checkResultBLAS();
    }

    private static native void cublasDtbsvNative(char var0, char var1, char var2, int var3, int var4, Pointer var5, int var6, Pointer var7, int var8);

    public static void cublasDsymv(char uplo, int n, double alpha, Pointer A, int lda, Pointer x, int incx, double beta, Pointer y, int incy) {
        JCublas.cublasDsymvNative(uplo, n, alpha, A, lda, x, incx, beta, y, incy);
        JCublas.checkResultBLAS();
    }

    private static native void cublasDsymvNative(char var0, int var1, double var2, Pointer var4, int var5, Pointer var6, int var7, double var8, Pointer var10, int var11);

    public static void cublasDsbmv(char uplo, int n, int k, double alpha, Pointer A, int lda, Pointer x, int incx, double beta, Pointer y, int incy) {
        JCublas.cublasDsbmvNative(uplo, n, k, alpha, A, lda, x, incx, beta, y, incy);
        JCublas.checkResultBLAS();
    }

    private static native void cublasDsbmvNative(char var0, int var1, int var2, double var3, Pointer var5, int var6, Pointer var7, int var8, double var9, Pointer var11, int var12);

    public static void cublasDspmv(char uplo, int n, double alpha, Pointer AP, Pointer x, int incx, double beta, Pointer y, int incy) {
        JCublas.cublasDspmvNative(uplo, n, alpha, AP, x, incx, beta, y, incy);
        JCublas.checkResultBLAS();
    }

    private static native void cublasDspmvNative(char var0, int var1, double var2, Pointer var4, Pointer var5, int var6, double var7, Pointer var9, int var10);

    public static void cublasDgemm(char transa, char transb, int m, int n, int k, double alpha, Pointer A, int lda, Pointer B, int ldb, double beta, Pointer C, int ldc) {
        JCublas.cublasDgemmNative(transa, transb, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc);
        JCublas.checkResultBLAS();
    }

    private static native void cublasDgemmNative(char var0, char var1, int var2, int var3, int var4, double var5, Pointer var7, int var8, Pointer var9, int var10, double var11, Pointer var13, int var14);

    public static void cublasDtrsm(char side, char uplo, char transa, char diag, int m, int n, double alpha, Pointer A, int lda, Pointer B, int ldb) {
        JCublas.cublasDtrsmNative(side, uplo, transa, diag, m, n, alpha, A, lda, B, ldb);
        JCublas.checkResultBLAS();
    }

    private static native void cublasDtrsmNative(char var0, char var1, char var2, char var3, int var4, int var5, double var6, Pointer var8, int var9, Pointer var10, int var11);

    public static void cublasZtrsm(char side, char uplo, char transa, char diag, int m, int n, cuDoubleComplex alpha, Pointer A, int lda, Pointer B, int ldb) {
        JCublas.cublasZtrsmNative(side, uplo, transa, diag, m, n, alpha, A, lda, B, ldb);
        JCublas.checkResultBLAS();
    }

    private static native void cublasZtrsmNative(char var0, char var1, char var2, char var3, int var4, int var5, cuDoubleComplex var6, Pointer var7, int var8, Pointer var9, int var10);

    public static void cublasDtrmm(char side, char uplo, char transa, char diag, int m, int n, double alpha, Pointer A, int lda, Pointer B, int ldb) {
        JCublas.cublasDtrmmNative(side, uplo, transa, diag, m, n, alpha, A, lda, B, ldb);
        JCublas.checkResultBLAS();
    }

    private static native void cublasDtrmmNative(char var0, char var1, char var2, char var3, int var4, int var5, double var6, Pointer var8, int var9, Pointer var10, int var11);

    public static void cublasDsymm(char side, char uplo, int m, int n, double alpha, Pointer A, int lda, Pointer B, int ldb, double beta, Pointer C, int ldc) {
        JCublas.cublasDsymmNative(side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc);
        JCublas.checkResultBLAS();
    }

    private static native void cublasDsymmNative(char var0, char var1, int var2, int var3, double var4, Pointer var6, int var7, Pointer var8, int var9, double var10, Pointer var12, int var13);

    public static void cublasZsymm(char side, char uplo, int m, int n, cuDoubleComplex alpha, Pointer A, int lda, Pointer B, int ldb, cuDoubleComplex beta, Pointer C, int ldc) {
        JCublas.cublasZsymmNative(side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc);
        JCublas.checkResultBLAS();
    }

    private static native void cublasZsymmNative(char var0, char var1, int var2, int var3, cuDoubleComplex var4, Pointer var5, int var6, Pointer var7, int var8, cuDoubleComplex var9, Pointer var10, int var11);

    public static void cublasDsyrk(char uplo, char trans, int n, int k, double alpha, Pointer A, int lda, double beta, Pointer C, int ldc) {
        JCublas.cublasDsyrkNative(uplo, trans, n, k, alpha, A, lda, beta, C, ldc);
        JCublas.checkResultBLAS();
    }

    private static native void cublasDsyrkNative(char var0, char var1, int var2, int var3, double var4, Pointer var6, int var7, double var8, Pointer var10, int var11);

    public static void cublasZsyrk(char uplo, char trans, int n, int k, cuDoubleComplex alpha, Pointer A, int lda, cuDoubleComplex beta, Pointer C, int ldc) {
        JCublas.cublasZsyrkNative(uplo, trans, n, k, alpha, A, lda, beta, C, ldc);
        JCublas.checkResultBLAS();
    }

    private static native void cublasZsyrkNative(char var0, char var1, int var2, int var3, cuDoubleComplex var4, Pointer var5, int var6, cuDoubleComplex var7, Pointer var8, int var9);

    public static void cublasZsyr2k(char uplo, char trans, int n, int k, cuDoubleComplex alpha, Pointer A, int lda, Pointer B, int ldb, cuDoubleComplex beta, Pointer C, int ldc) {
        JCublas.cublasZsyr2kNative(uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc);
        JCublas.checkResultBLAS();
    }

    private static native void cublasZsyr2kNative(char var0, char var1, int var2, int var3, cuDoubleComplex var4, Pointer var5, int var6, Pointer var7, int var8, cuDoubleComplex var9, Pointer var10, int var11);

    public static void cublasZher2k(char uplo, char trans, int n, int k, cuDoubleComplex alpha, Pointer A, int lda, Pointer B, int ldb, double beta, Pointer C, int ldc) {
        JCublas.cublasZher2kNative(uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc);
        JCublas.checkResultBLAS();
    }

    private static native void cublasZher2kNative(char var0, char var1, int var2, int var3, cuDoubleComplex var4, Pointer var5, int var6, Pointer var7, int var8, double var9, Pointer var11, int var12);

    public static void cublasZher(char uplo, int n, double alpha, Pointer x, int incx, Pointer A, int lda) {
        JCublas.cublasZherNative(uplo, n, alpha, x, incx, A, lda);
        JCublas.checkResultBLAS();
    }

    private static native void cublasZherNative(char var0, int var1, double var2, Pointer var4, int var5, Pointer var6, int var7);

    public static void cublasZhpr(char uplo, int n, double alpha, Pointer x, int incx, Pointer AP) {
        JCublas.cublasZhprNative(uplo, n, alpha, x, incx, AP);
        JCublas.checkResultBLAS();
    }

    private static native void cublasZhprNative(char var0, int var1, double var2, Pointer var4, int var5, Pointer var6);

    public static void cublasZhpr2(char uplo, int n, cuDoubleComplex alpha, Pointer x, int incx, Pointer y, int incy, Pointer AP) {
        JCublas.cublasZhpr2Native(uplo, n, alpha, x, incx, y, incy, AP);
        JCublas.checkResultBLAS();
    }

    private static native void cublasZhpr2Native(char var0, int var1, cuDoubleComplex var2, Pointer var3, int var4, Pointer var5, int var6, Pointer var7);

    public static void cublasZher2(char uplo, int n, cuDoubleComplex alpha, Pointer x, int incx, Pointer y, int incy, Pointer A, int lda) {
        JCublas.cublasZher2Native(uplo, n, alpha, x, incx, y, incy, A, lda);
        JCublas.checkResultBLAS();
    }

    private static native void cublasZher2Native(char var0, int var1, cuDoubleComplex var2, Pointer var3, int var4, Pointer var5, int var6, Pointer var7, int var8);

    public static void cublasDsyr2k(char uplo, char trans, int n, int k, double alpha, Pointer A, int lda, Pointer B, int ldb, double beta, Pointer C, int ldc) {
        JCublas.cublasDsyr2kNative(uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc);
        JCublas.checkResultBLAS();
    }

    private static native void cublasDsyr2kNative(char var0, char var1, int var2, int var3, double var4, Pointer var6, int var7, Pointer var8, int var9, double var10, Pointer var12, int var13);

    public static void cublasZgemm(char transa, char transb, int m, int n, int k, cuDoubleComplex alpha, Pointer A, int lda, Pointer B, int ldb, cuDoubleComplex beta, Pointer C, int ldc) {
        JCublas.cublasZgemmNative(transa, transb, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc);
        JCublas.checkResultBLAS();
    }

    private static native void cublasZgemmNative(char var0, char var1, int var2, int var3, int var4, cuDoubleComplex var5, Pointer var6, int var7, Pointer var8, int var9, cuDoubleComplex var10, Pointer var11, int var12);

    public static void cublasZtrmm(char side, char uplo, char transa, char diag, int m, int n, cuDoubleComplex alpha, Pointer A, int lda, Pointer B, int ldb) {
        JCublas.cublasZtrmmNative(side, uplo, transa, diag, m, n, alpha, A, lda, B, ldb);
        JCublas.checkResultBLAS();
    }

    private static native void cublasZtrmmNative(char var0, char var1, char var2, char var3, int var4, int var5, cuDoubleComplex var6, Pointer var7, int var8, Pointer var9, int var10);

    public static void cublasZgeru(int m, int n, cuDoubleComplex alpha, Pointer x, int incx, Pointer y, int incy, Pointer A, int lda) {
        JCublas.cublasZgeruNative(m, n, alpha, x, incx, y, incy, A, lda);
        JCublas.checkResultBLAS();
    }

    private static native void cublasZgeruNative(int var0, int var1, cuDoubleComplex var2, Pointer var3, int var4, Pointer var5, int var6, Pointer var7, int var8);

    public static void cublasZgerc(int m, int n, cuDoubleComplex alpha, Pointer x, int incx, Pointer y, int incy, Pointer A, int lda) {
        JCublas.cublasZgercNative(m, n, alpha, x, incx, y, incy, A, lda);
        JCublas.checkResultBLAS();
    }

    private static native void cublasZgercNative(int var0, int var1, cuDoubleComplex var2, Pointer var3, int var4, Pointer var5, int var6, Pointer var7, int var8);

    public static void cublasZherk(char uplo, char trans, int n, int k, double alpha, Pointer A, int lda, double beta, Pointer C, int ldc) {
        JCublas.cublasZherkNative(uplo, trans, n, k, alpha, A, lda, beta, C, ldc);
        JCublas.checkResultBLAS();
    }

    private static native void cublasZherkNative(char var0, char var1, int var2, int var3, double var4, Pointer var6, int var7, double var8, Pointer var10, int var11);

    public static void cublasZhemm(char side, char uplo, int m, int n, cuDoubleComplex alpha, Pointer A, int lda, Pointer B, int ldb, cuDoubleComplex beta, Pointer C, int ldc) {
        JCublas.cublasZhemmNative(side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc);
        JCublas.checkResultBLAS();
    }

    private static native void cublasZhemmNative(char var0, char var1, int var2, int var3, cuDoubleComplex var4, Pointer var5, int var6, Pointer var7, int var8, cuDoubleComplex var9, Pointer var10, int var11);

    public static void cublasZtrsv(char uplo, char trans, char diag, int n, Pointer A, int lda, Pointer x, int incx) {
        JCublas.cublasZtrsvNative(uplo, trans, diag, n, A, lda, x, incx);
        JCublas.checkResultBLAS();
    }

    private static native void cublasZtrsvNative(char var0, char var1, char var2, int var3, Pointer var4, int var5, Pointer var6, int var7);

    public static void cublasZhbmv(char uplo, int n, int k, cuDoubleComplex alpha, Pointer A, int lda, Pointer x, int incx, cuDoubleComplex beta, Pointer y, int incy) {
        JCublas.cublasZhbmvNative(uplo, n, k, alpha, A, lda, x, incx, beta, y, incy);
        JCublas.checkResultBLAS();
    }

    private static native void cublasZhbmvNative(char var0, int var1, int var2, cuDoubleComplex var3, Pointer var4, int var5, Pointer var6, int var7, cuDoubleComplex var8, Pointer var9, int var10);
}

