/*
 * Decompiled with CFR 0.152.
 */
package jcuda.jcufft;

import jcuda.CudaException;
import jcuda.LibUtils;
import jcuda.LogLevel;
import jcuda.Pointer;
import jcuda.jcufft.cufftHandle;
import jcuda.jcufft.cufftResult;
import jcuda.runtime.JCuda;
import jcuda.runtime.cudaError;
import jcuda.runtime.cudaStream_t;

public class JCufft {
    public static final int CUFFT_FORWARD = -1;
    public static final int CUFFT_INVERSE = 1;
    private static boolean initialized = false;
    private static boolean exceptionsEnabled = false;

    static {
        JCufft.initialize();
    }

    private JCufft() {
    }

    public static void initialize() {
        if (!initialized) {
            LibUtils.loadLibrary((String)"JCufft");
            initialized = true;
        }
    }

    public static void setLogLevel(LogLevel logLevel) {
        JCufft.setLogLevel(logLevel.ordinal());
    }

    private static native void setLogLevel(int var0);

    public static void setExceptionsEnabled(boolean enabled) {
        exceptionsEnabled = enabled;
    }

    private static int checkResult(int result) {
        if (exceptionsEnabled && result != 0) {
            throw new CudaException(cufftResult.stringFor(result));
        }
        return result;
    }

    public static int cufftGetVersion(int[] version) {
        return JCufft.cufftGetVersionNative(version);
    }

    private static native int cufftGetVersionNative(int[] var0);

    public static int cufftPlan1d(cufftHandle plan, int nx, int type, int batch) {
        plan.setDimension(1);
        plan.setType(type);
        plan.setSize(nx, 0, 0);
        plan.setBatchSize(batch);
        return JCufft.checkResult(JCufft.cufftPlan1dNative(plan, nx, type, batch));
    }

    private static native int cufftPlan1dNative(cufftHandle var0, int var1, int var2, int var3);

    public static int cufftPlan2d(cufftHandle plan, int nx, int ny, int type) {
        plan.setDimension(2);
        plan.setType(type);
        plan.setSize(nx, ny, 0);
        return JCufft.checkResult(JCufft.cufftPlan2dNative(plan, nx, ny, type));
    }

    private static native int cufftPlan2dNative(cufftHandle var0, int var1, int var2, int var3);

    public static int cufftPlan3d(cufftHandle plan, int nx, int ny, int nz, int type) {
        plan.setDimension(3);
        plan.setType(type);
        plan.setSize(nx, ny, nz);
        return JCufft.checkResult(JCufft.cufftPlan3dNative(plan, nx, ny, nz, type));
    }

    private static native int cufftPlan3dNative(cufftHandle var0, int var1, int var2, int var3, int var4);

    public static int cufftPlanMany(cufftHandle plan, int rank, int[] n, int[] inembed, int istride, int idist, int[] onembed, int ostride, int odist, int type, int batch) {
        return JCufft.checkResult(JCufft.cufftPlanManyNative(plan, rank, n, inembed, istride, idist, onembed, ostride, odist, type, batch));
    }

    private static native int cufftPlanManyNative(cufftHandle var0, int var1, int[] var2, int[] var3, int var4, int var5, int[] var6, int var7, int var8, int var9, int var10);

    public static int cufftDestroy(cufftHandle plan) {
        return JCufft.checkResult(JCufft.cufftDestroyNative(plan));
    }

    private static native int cufftDestroyNative(cufftHandle var0);

    public static int cufftSetStream(cufftHandle plan, cudaStream_t stream) {
        return JCufft.checkResult(JCufft.cufftSetStreamNative(plan, stream));
    }

    private static native int cufftSetStreamNative(cufftHandle var0, cudaStream_t var1);

    public static int cufftSetCompatibilityMode(cufftHandle plan, int mode) {
        return JCufft.checkResult(JCufft.cufftSetCompatibilityModeNative(plan, mode));
    }

    private static native int cufftSetCompatibilityModeNative(cufftHandle var0, int var1);

    public static int cufftExecC2C(cufftHandle plan, Pointer cIdata, Pointer cOdata, int direction) {
        return JCufft.checkResult(JCufft.cufftExecC2CNative(plan, cIdata, cOdata, direction));
    }

    private static native int cufftExecC2CNative(cufftHandle var0, Pointer var1, Pointer var2, int var3);

    public static int cufftExecC2C(cufftHandle plan, float[] cIdata, float[] cOdata, int direction) {
        int cudaResult = 0;
        boolean inPlace = cIdata == cOdata;
        Pointer hostCIdata = Pointer.to((float[])cIdata);
        Pointer deviceCIdata = new Pointer();
        cudaResult = JCuda.cudaMalloc((Pointer)deviceCIdata, (long)(cIdata.length * 4));
        if (cudaResult != 0) {
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 10;
        }
        Pointer hostCOdata = null;
        Pointer deviceCOdata = null;
        if (inPlace) {
            hostCOdata = hostCIdata;
            deviceCOdata = deviceCIdata;
        } else {
            hostCOdata = Pointer.to((float[])cOdata);
            deviceCOdata = new Pointer();
            cudaResult = JCuda.cudaMalloc((Pointer)deviceCOdata, (long)(cOdata.length * 4));
            if (cudaResult != 0) {
                JCuda.cudaFree((Pointer)deviceCIdata);
                if (exceptionsEnabled) {
                    throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
                }
                return 10;
            }
        }
        cudaResult = JCuda.cudaMemcpy((Pointer)deviceCIdata, (Pointer)hostCIdata, (long)(cIdata.length * 4), (int)1);
        if (cudaResult != 0) {
            JCuda.cudaFree((Pointer)deviceCIdata);
            if (!inPlace) {
                JCuda.cudaFree((Pointer)deviceCOdata);
            }
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 10;
        }
        int result = 0;
        try {
            result = JCufft.cufftExecC2C(plan, deviceCIdata, deviceCOdata, direction);
        }
        catch (CudaException e) {
            JCuda.cudaFree((Pointer)deviceCIdata);
            if (!inPlace) {
                JCuda.cudaFree((Pointer)deviceCOdata);
            }
            result = 10;
        }
        if (result != 0) {
            if (exceptionsEnabled) {
                throw new CudaException(cufftResult.stringFor(result));
            }
            return result;
        }
        cudaResult = JCuda.cudaMemcpy((Pointer)hostCOdata, (Pointer)deviceCOdata, (long)(cOdata.length * 4), (int)2);
        if (cudaResult != 0) {
            JCuda.cudaFree((Pointer)deviceCIdata);
            if (!inPlace) {
                JCuda.cudaFree((Pointer)deviceCOdata);
            }
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 10;
        }
        cudaResult = JCuda.cudaFree((Pointer)deviceCIdata);
        if (cudaResult != 0) {
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 10;
        }
        if (!inPlace && (cudaResult = JCuda.cudaFree((Pointer)deviceCOdata)) != 0) {
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 10;
        }
        return result;
    }

    public static int cufftExecR2C(cufftHandle plan, Pointer rIdata, Pointer cOdata) {
        return JCufft.checkResult(JCufft.cufftExecR2CNative(plan, rIdata, cOdata));
    }

    private static native int cufftExecR2CNative(cufftHandle var0, Pointer var1, Pointer var2);

    public static int cufftExecR2C(cufftHandle plan, float[] rIdata, float[] cOdata) {
        int cudaResult = 0;
        Pointer hostRIdata = Pointer.to((float[])rIdata);
        Pointer deviceRIdata = new Pointer();
        cudaResult = JCuda.cudaMalloc((Pointer)deviceRIdata, (long)(rIdata.length * 4));
        if (cudaResult != 0) {
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 10;
        }
        Pointer hostCOdata = Pointer.to((float[])cOdata);
        Pointer deviceCOdata = new Pointer();
        cudaResult = JCuda.cudaMalloc((Pointer)deviceCOdata, (long)(cOdata.length * 4));
        if (cudaResult != 0) {
            JCuda.cudaFree((Pointer)deviceCOdata);
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 10;
        }
        cudaResult = JCuda.cudaMemcpy((Pointer)deviceRIdata, (Pointer)hostRIdata, (long)(rIdata.length * 4), (int)1);
        if (cudaResult != 0) {
            JCuda.cudaFree((Pointer)deviceRIdata);
            JCuda.cudaFree((Pointer)deviceCOdata);
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 10;
        }
        int result = 0;
        try {
            result = JCufft.cufftExecR2C(plan, deviceRIdata, deviceCOdata);
        }
        catch (CudaException e) {
            JCuda.cudaFree((Pointer)deviceRIdata);
            JCuda.cudaFree((Pointer)deviceCOdata);
            result = 10;
        }
        if (result != 0) {
            if (exceptionsEnabled) {
                throw new CudaException(cufftResult.stringFor(cudaResult));
            }
            return result;
        }
        cudaResult = JCuda.cudaMemcpy((Pointer)hostCOdata, (Pointer)deviceCOdata, (long)(cOdata.length * 4), (int)2);
        if (cudaResult != 0) {
            JCuda.cudaFree((Pointer)deviceRIdata);
            JCuda.cudaFree((Pointer)deviceCOdata);
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 10;
        }
        cudaResult = JCuda.cudaFree((Pointer)deviceRIdata);
        if (cudaResult != 0) {
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 10;
        }
        cudaResult = JCuda.cudaFree((Pointer)deviceCOdata);
        if (cudaResult != 0) {
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 10;
        }
        return result;
    }

    public static int cufftExecC2R(cufftHandle plan, Pointer cIdata, Pointer rOdata) {
        return JCufft.checkResult(JCufft.cufftExecC2RNative(plan, cIdata, rOdata));
    }

    private static native int cufftExecC2RNative(cufftHandle var0, Pointer var1, Pointer var2);

    public static int cufftExecC2R(cufftHandle plan, float[] cIdata, float[] rOdata) {
        int cudaResult = 0;
        Pointer hostCIdata = Pointer.to((float[])cIdata);
        Pointer deviceCIdata = new Pointer();
        cudaResult = JCuda.cudaMalloc((Pointer)deviceCIdata, (long)(cIdata.length * 4));
        if (cudaResult != 0) {
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 10;
        }
        Pointer hostROdata = Pointer.to((float[])rOdata);
        Pointer deviceROdata = new Pointer();
        cudaResult = JCuda.cudaMalloc((Pointer)deviceROdata, (long)(rOdata.length * 4));
        if (cudaResult != 0) {
            JCuda.cudaFree((Pointer)deviceCIdata);
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 10;
        }
        cudaResult = JCuda.cudaMemcpy((Pointer)deviceCIdata, (Pointer)hostCIdata, (long)(cIdata.length * 4), (int)1);
        if (cudaResult != 0) {
            JCuda.cudaFree((Pointer)deviceCIdata);
            JCuda.cudaFree((Pointer)deviceROdata);
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 10;
        }
        int result = 0;
        try {
            result = JCufft.cufftExecC2R(plan, deviceCIdata, deviceROdata);
        }
        catch (CudaException e) {
            JCuda.cudaFree((Pointer)deviceCIdata);
            JCuda.cudaFree((Pointer)deviceROdata);
            result = 10;
        }
        if (result != 0) {
            if (exceptionsEnabled) {
                throw new CudaException(cufftResult.stringFor(cudaResult));
            }
            return result;
        }
        cudaResult = JCuda.cudaMemcpy((Pointer)hostROdata, (Pointer)deviceROdata, (long)(rOdata.length * 4), (int)2);
        if (cudaResult != 0) {
            JCuda.cudaFree((Pointer)deviceCIdata);
            JCuda.cudaFree((Pointer)deviceROdata);
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 10;
        }
        cudaResult = JCuda.cudaFree((Pointer)deviceCIdata);
        if (cudaResult != 0) {
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 10;
        }
        cudaResult = JCuda.cudaFree((Pointer)deviceROdata);
        if (cudaResult != 0) {
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 10;
        }
        return result;
    }

    public static int cufftExecZ2Z(cufftHandle plan, Pointer cIdata, Pointer cOdata, int direction) {
        return JCufft.checkResult(JCufft.cufftExecZ2ZNative(plan, cIdata, cOdata, direction));
    }

    private static native int cufftExecZ2ZNative(cufftHandle var0, Pointer var1, Pointer var2, int var3);

    public static int cufftExecZ2Z(cufftHandle plan, double[] cIdata, double[] cOdata, int direction) {
        int cudaResult = 0;
        boolean inPlace = cIdata == cOdata;
        Pointer hostCIdata = Pointer.to((double[])cIdata);
        Pointer deviceCIdata = new Pointer();
        cudaResult = JCuda.cudaMalloc((Pointer)deviceCIdata, (long)(cIdata.length * 8));
        if (cudaResult != 0) {
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 10;
        }
        Pointer hostCOdata = null;
        Pointer deviceCOdata = null;
        if (inPlace) {
            hostCOdata = hostCIdata;
            deviceCOdata = deviceCIdata;
        } else {
            hostCOdata = Pointer.to((double[])cOdata);
            deviceCOdata = new Pointer();
            cudaResult = JCuda.cudaMalloc((Pointer)deviceCOdata, (long)(cOdata.length * 8));
            if (cudaResult != 0) {
                JCuda.cudaFree((Pointer)deviceCIdata);
                if (exceptionsEnabled) {
                    throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
                }
                return 10;
            }
        }
        cudaResult = JCuda.cudaMemcpy((Pointer)deviceCIdata, (Pointer)hostCIdata, (long)(cIdata.length * 8), (int)1);
        if (cudaResult != 0) {
            JCuda.cudaFree((Pointer)deviceCIdata);
            if (!inPlace) {
                JCuda.cudaFree((Pointer)deviceCOdata);
            }
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 10;
        }
        int result = 0;
        try {
            result = JCufft.cufftExecZ2Z(plan, deviceCIdata, deviceCOdata, direction);
        }
        catch (CudaException e) {
            JCuda.cudaFree((Pointer)deviceCIdata);
            if (!inPlace) {
                JCuda.cudaFree((Pointer)deviceCOdata);
            }
            result = 10;
        }
        if (result != 0) {
            if (exceptionsEnabled) {
                throw new CudaException(cufftResult.stringFor(cudaResult));
            }
            return result;
        }
        cudaResult = JCuda.cudaMemcpy((Pointer)hostCOdata, (Pointer)deviceCOdata, (long)(cOdata.length * 8), (int)2);
        if (cudaResult != 0) {
            JCuda.cudaFree((Pointer)deviceCIdata);
            if (!inPlace) {
                JCuda.cudaFree((Pointer)deviceCOdata);
            }
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 10;
        }
        cudaResult = JCuda.cudaFree((Pointer)deviceCIdata);
        if (cudaResult != 0) {
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 10;
        }
        if (!inPlace && (cudaResult = JCuda.cudaFree((Pointer)deviceCOdata)) != 0) {
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 10;
        }
        return result;
    }

    public static int cufftExecD2Z(cufftHandle plan, Pointer rIdata, Pointer cOdata) {
        return JCufft.checkResult(JCufft.cufftExecD2ZNative(plan, rIdata, cOdata));
    }

    private static native int cufftExecD2ZNative(cufftHandle var0, Pointer var1, Pointer var2);

    public static int cufftExecR2C(cufftHandle plan, double[] rIdata, double[] cOdata) {
        int cudaResult = 0;
        Pointer hostRIdata = Pointer.to((double[])rIdata);
        Pointer deviceRIdata = new Pointer();
        cudaResult = JCuda.cudaMalloc((Pointer)deviceRIdata, (long)(rIdata.length * 8));
        if (cudaResult != 0) {
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 10;
        }
        Pointer hostCOdata = Pointer.to((double[])cOdata);
        Pointer deviceCOdata = new Pointer();
        cudaResult = JCuda.cudaMalloc((Pointer)deviceCOdata, (long)(cOdata.length * 8));
        if (cudaResult != 0) {
            JCuda.cudaFree((Pointer)deviceCOdata);
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 10;
        }
        cudaResult = JCuda.cudaMemcpy((Pointer)deviceRIdata, (Pointer)hostRIdata, (long)(rIdata.length * 8), (int)1);
        if (cudaResult != 0) {
            JCuda.cudaFree((Pointer)deviceRIdata);
            JCuda.cudaFree((Pointer)deviceCOdata);
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 10;
        }
        int result = 0;
        try {
            result = JCufft.cufftExecD2Z(plan, deviceRIdata, deviceCOdata);
        }
        catch (CudaException e) {
            JCuda.cudaFree((Pointer)deviceRIdata);
            JCuda.cudaFree((Pointer)deviceCOdata);
            result = 10;
        }
        if (result != 0) {
            if (exceptionsEnabled) {
                throw new CudaException(cufftResult.stringFor(cudaResult));
            }
            return result;
        }
        cudaResult = JCuda.cudaMemcpy((Pointer)hostCOdata, (Pointer)deviceCOdata, (long)(cOdata.length * 8), (int)2);
        if (cudaResult != 0) {
            JCuda.cudaFree((Pointer)deviceRIdata);
            JCuda.cudaFree((Pointer)deviceCOdata);
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 10;
        }
        cudaResult = JCuda.cudaFree((Pointer)deviceRIdata);
        if (cudaResult != 0) {
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 10;
        }
        cudaResult = JCuda.cudaFree((Pointer)deviceCOdata);
        if (cudaResult != 0) {
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 10;
        }
        return result;
    }

    public static int cufftExecZ2D(cufftHandle plan, Pointer cIdata, Pointer rOdata) {
        return JCufft.checkResult(JCufft.cufftExecZ2DNative(plan, cIdata, rOdata));
    }

    private static native int cufftExecZ2DNative(cufftHandle var0, Pointer var1, Pointer var2);

    public static int cufftExecZ2D(cufftHandle plan, double[] cIdata, double[] rOdata) {
        int cudaResult = 0;
        Pointer hostCIdata = Pointer.to((double[])cIdata);
        Pointer deviceCIdata = new Pointer();
        cudaResult = JCuda.cudaMalloc((Pointer)deviceCIdata, (long)(cIdata.length * 8));
        if (cudaResult != 0) {
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 10;
        }
        Pointer hostROdata = Pointer.to((double[])rOdata);
        Pointer deviceROdata = new Pointer();
        cudaResult = JCuda.cudaMalloc((Pointer)deviceROdata, (long)(rOdata.length * 8));
        if (cudaResult != 0) {
            JCuda.cudaFree((Pointer)deviceCIdata);
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 10;
        }
        cudaResult = JCuda.cudaMemcpy((Pointer)deviceCIdata, (Pointer)hostCIdata, (long)(cIdata.length * 8), (int)1);
        if (cudaResult != 0) {
            JCuda.cudaFree((Pointer)deviceCIdata);
            JCuda.cudaFree((Pointer)deviceROdata);
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 10;
        }
        int result = 0;
        try {
            result = JCufft.cufftExecZ2D(plan, deviceCIdata, deviceROdata);
        }
        catch (CudaException e) {
            JCuda.cudaFree((Pointer)deviceCIdata);
            JCuda.cudaFree((Pointer)deviceROdata);
            result = 10;
        }
        if (result != 0) {
            if (exceptionsEnabled) {
                throw new CudaException(cufftResult.stringFor(cudaResult));
            }
            return result;
        }
        cudaResult = JCuda.cudaMemcpy((Pointer)hostROdata, (Pointer)deviceROdata, (long)(rOdata.length * 8), (int)2);
        if (cudaResult != 0) {
            JCuda.cudaFree((Pointer)deviceCIdata);
            JCuda.cudaFree((Pointer)deviceROdata);
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 10;
        }
        cudaResult = JCuda.cudaFree((Pointer)deviceCIdata);
        if (cudaResult != 0) {
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 10;
        }
        cudaResult = JCuda.cudaFree((Pointer)deviceROdata);
        if (cudaResult != 0) {
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 10;
        }
        return result;
    }
}

