/*
 * Decompiled with CFR 0.152.
 */
package jcuda.jcudpp;

import jcuda.CudaException;
import jcuda.LibUtils;
import jcuda.LogLevel;
import jcuda.Pointer;
import jcuda.jcudpp.CUDPPConfiguration;
import jcuda.jcudpp.CUDPPHandle;
import jcuda.jcudpp.CUDPPHashTableConfig;
import jcuda.jcudpp.CUDPPResult;

public class JCudpp {
    public static final int CUDPP_HASH_KEY_NOT_FOUND = -1;
    private static boolean initialized = false;
    private static boolean exceptionsEnabled = false;

    static {
        JCudpp.initialize();
    }

    private JCudpp() {
    }

    public static void setLogLevel(LogLevel logLevel) {
        JCudpp.setLogLevel(logLevel.ordinal());
    }

    private static native void setLogLevel(int var0);

    public static void setExceptionsEnabled(boolean enabled) {
        exceptionsEnabled = enabled;
    }

    private static int checkResult(int result) {
        if (exceptionsEnabled && result != 0) {
            throw new CudaException(CUDPPResult.stringFor(result));
        }
        return result;
    }

    public static void initialize() {
        JCudpp.assertInit();
    }

    private static void assertInit() {
        if (!initialized) {
            LibUtils.loadLibrary((String)"JCudpp");
            initialized = true;
        }
    }

    public static int cudppCreate(CUDPPHandle theCudpp) {
        return JCudpp.checkResult(JCudpp.cudppCreateNative(theCudpp));
    }

    private static native int cudppCreateNative(CUDPPHandle var0);

    public static int cudppDestroy(CUDPPHandle theCudpp) {
        return JCudpp.checkResult(JCudpp.cudppDestroyNative(theCudpp));
    }

    private static native int cudppDestroyNative(CUDPPHandle var0);

    public static int cudppPlan(CUDPPHandle cudppHandle, CUDPPHandle planHandle, CUDPPConfiguration config, long n, long rows, long rowPitch) {
        return JCudpp.checkResult(JCudpp.cudppPlanNative(cudppHandle, planHandle, config, n, rows, rowPitch));
    }

    private static native int cudppPlanNative(CUDPPHandle var0, CUDPPHandle var1, CUDPPConfiguration var2, long var3, long var5, long var7);

    public static int cudppDestroyPlan(CUDPPHandle plan) {
        return JCudpp.checkResult(JCudpp.cudppDestroyPlanNative(plan));
    }

    private static native int cudppDestroyPlanNative(CUDPPHandle var0);

    public static int cudppScan(CUDPPHandle planHandle, Pointer d_out, Pointer d_in, long numElements) {
        return JCudpp.checkResult(JCudpp.cudppScanNative(planHandle, d_out, d_in, numElements));
    }

    private static native int cudppScanNative(CUDPPHandle var0, Pointer var1, Pointer var2, long var3);

    public static int cudppMultiScan(CUDPPHandle planHandle, Pointer d_out, Pointer d_in, long numElements, long numRows) {
        return JCudpp.checkResult(JCudpp.cudppMultiScanNative(planHandle, d_out, d_in, numElements, numRows));
    }

    private static native int cudppMultiScanNative(CUDPPHandle var0, Pointer var1, Pointer var2, long var3, long var5);

    public static int cudppSegmentedScan(CUDPPHandle planHandle, Pointer d_out, Pointer d_idata, Pointer d_iflags, long numElements) {
        return JCudpp.checkResult(JCudpp.cudppSegmentedScanNative(planHandle, d_out, d_idata, d_iflags, numElements));
    }

    private static native int cudppSegmentedScanNative(CUDPPHandle var0, Pointer var1, Pointer var2, Pointer var3, long var4);

    public static int cudppCompact(CUDPPHandle planHandle, Pointer d_out, Pointer d_numValidElements, Pointer d_in, Pointer d_isValid, long numElements) {
        return JCudpp.checkResult(JCudpp.cudppCompactNative(planHandle, d_out, d_numValidElements, d_in, d_isValid, numElements));
    }

    private static native int cudppCompactNative(CUDPPHandle var0, Pointer var1, Pointer var2, Pointer var3, Pointer var4, long var5);

    public static int cudppReduce(CUDPPHandle planHandle, Pointer d_out, Pointer d_in, long numElements) {
        return JCudpp.checkResult(JCudpp.cudppReduceNative(planHandle, d_out, d_in, numElements));
    }

    private static native int cudppReduceNative(CUDPPHandle var0, Pointer var1, Pointer var2, long var3);

    public static int cudppSort(CUDPPHandle planHandle, Pointer d_keys, Pointer d_values, long numElements) {
        return JCudpp.checkResult(JCudpp.cudppSortNative(planHandle, d_keys, d_values, numElements));
    }

    private static native int cudppSortNative(CUDPPHandle var0, Pointer var1, Pointer var2, long var3);

    public static int cudppSparseMatrix(CUDPPHandle cudppHandle, CUDPPHandle sparseMatrixHandle, CUDPPConfiguration config, long numNonZeroElements, long numRows, Pointer A, Pointer h_rowIndices, Pointer h_indices) {
        return JCudpp.checkResult(JCudpp.cudppSparseMatrixNative(cudppHandle, sparseMatrixHandle, config, numNonZeroElements, numRows, A, h_rowIndices, h_indices));
    }

    private static native int cudppSparseMatrixNative(CUDPPHandle var0, CUDPPHandle var1, CUDPPConfiguration var2, long var3, long var5, Pointer var7, Pointer var8, Pointer var9);

    public static int cudppDestroySparseMatrix(CUDPPHandle sparseMatrixHandle) {
        return JCudpp.checkResult(JCudpp.cudppDestroySparseMatrixNative(sparseMatrixHandle));
    }

    private static native int cudppDestroySparseMatrixNative(CUDPPHandle var0);

    public static int cudppSparseMatrixVectorMultiply(CUDPPHandle sparseMatrixHandle, Pointer d_y, Pointer d_x) {
        return JCudpp.checkResult(JCudpp.cudppSparseMatrixVectorMultiplyNative(sparseMatrixHandle, d_y, d_x));
    }

    private static native int cudppSparseMatrixVectorMultiplyNative(CUDPPHandle var0, Pointer var1, Pointer var2);

    public static int cudppRand(CUDPPHandle planHandle, Pointer d_out, long numElements) {
        return JCudpp.checkResult(JCudpp.cudppRandNative(planHandle, d_out, numElements));
    }

    private static native int cudppRandNative(CUDPPHandle var0, Pointer var1, long var2);

    public static int cudppRandSeed(CUDPPHandle planHandle, int seed) {
        return JCudpp.checkResult(JCudpp.cudppRandSeedNative(planHandle, seed));
    }

    private static native int cudppRandSeedNative(CUDPPHandle var0, int var1);

    public static int cudppTridiagonal(CUDPPHandle planHandle, Pointer a, Pointer b, Pointer c, Pointer d, Pointer x, int systemSize, int numSystems) {
        return JCudpp.checkResult(JCudpp.cudppTridiagonalNative(planHandle, a, b, c, d, x, systemSize, numSystems));
    }

    private static native int cudppTridiagonalNative(CUDPPHandle var0, Pointer var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, int var6, int var7);

    public static int cudppHashTable(CUDPPHandle cudppHandle, CUDPPHandle plan, CUDPPHashTableConfig config) {
        return JCudpp.checkResult(JCudpp.cudppHashTableNative(cudppHandle, plan, config));
    }

    private static native int cudppHashTableNative(CUDPPHandle var0, CUDPPHandle var1, CUDPPHashTableConfig var2);

    public static int cudppDestroyHashTable(CUDPPHandle cudppHandle, CUDPPHandle plan) {
        return JCudpp.checkResult(JCudpp.cudppDestroyHashTableNative(cudppHandle, plan));
    }

    private static native int cudppDestroyHashTableNative(CUDPPHandle var0, CUDPPHandle var1);

    public static int cudppHashInsert(CUDPPHandle plan, Pointer d_keys, Pointer d_vals, long num) {
        return JCudpp.checkResult(JCudpp.cudppHashInsertNative(plan, d_keys, d_vals, num));
    }

    private static native int cudppHashInsertNative(CUDPPHandle var0, Pointer var1, Pointer var2, long var3);

    public static int cudppHashRetrieve(CUDPPHandle plan, Pointer d_keys, Pointer d_vals, long num) {
        return JCudpp.checkResult(JCudpp.cudppHashRetrieveNative(plan, d_keys, d_vals, num));
    }

    private static native int cudppHashRetrieveNative(CUDPPHandle var0, Pointer var1, Pointer var2, long var3);

    public static int cudppMultivalueHashGetValuesSize(CUDPPHandle plan, int[] size) {
        return JCudpp.checkResult(JCudpp.cudppMultivalueHashGetValuesSizeNative(plan, size));
    }

    private static native int cudppMultivalueHashGetValuesSizeNative(CUDPPHandle var0, int[] var1);

    public static int cudppMultivalueHashGetAllValues(CUDPPHandle plan, Pointer d_vals) {
        return JCudpp.checkResult(JCudpp.cudppMultivalueHashGetAllValuesNative(plan, d_vals));
    }

    private static native int cudppMultivalueHashGetAllValuesNative(CUDPPHandle var0, Pointer var1);
}

