/*
 * Decompiled with CFR 0.152.
 */
package jcuda.jcusparse;

import jcuda.CudaException;
import jcuda.LibUtils;
import jcuda.LogLevel;
import jcuda.Pointer;
import jcuda.jcusparse.cusparseHandle;
import jcuda.jcusparse.cusparseHybMat;
import jcuda.jcusparse.cusparseMatDescr;
import jcuda.jcusparse.cusparseSolveAnalysisInfo;
import jcuda.jcusparse.cusparseStatus;
import jcuda.runtime.cudaStream_t;

public class JCusparse2 {
    private static boolean initialized = false;
    private static boolean exceptionsEnabled = false;

    static {
        JCusparse2.initialize();
    }

    private JCusparse2() {
    }

    public static void initialize() {
        if (!initialized) {
            LibUtils.loadLibrary((String)"JCusparse2");
            initialized = true;
        }
    }

    public static void setLogLevel(LogLevel logLevel) {
        JCusparse2.setLogLevelNative(logLevel.ordinal());
    }

    private static native void setLogLevelNative(int var0);

    public static void setExceptionsEnabled(boolean enabled) {
        exceptionsEnabled = enabled;
    }

    private static int checkResult(int result) {
        if (exceptionsEnabled && result != 0) {
            throw new CudaException(cusparseStatus.stringFor(result));
        }
        return result;
    }

    private static int checkForError(int result) {
        if (exceptionsEnabled && result == -1) {
            throw new CudaException(cusparseStatus.stringFor(result));
        }
        return result;
    }

    public static int cusparseCreate(cusparseHandle handle) {
        return JCusparse2.checkResult(JCusparse2.cusparseCreateNative(handle));
    }

    private static native int cusparseCreateNative(cusparseHandle var0);

    public static int cusparseDestroy(cusparseHandle handle) {
        return JCusparse2.checkResult(JCusparse2.cusparseDestroyNative(handle));
    }

    private static native int cusparseDestroyNative(cusparseHandle var0);

    public static int cusparseGetVersion(cusparseHandle handle, int[] version) {
        return JCusparse2.checkResult(JCusparse2.cusparseGetVersionNative(handle, version));
    }

    private static native int cusparseGetVersionNative(cusparseHandle var0, int[] var1);

    public static int cusparseSetStream(cusparseHandle handle, cudaStream_t streamId) {
        return JCusparse2.checkResult(JCusparse2.cusparseSetStreamNative(handle, streamId));
    }

    private static native int cusparseSetStreamNative(cusparseHandle var0, cudaStream_t var1);

    public static int cusparseGetPointerMode(cusparseHandle handle, int[] mode) {
        return JCusparse2.checkResult(JCusparse2.cusparseGetPointerModeNative(handle, mode));
    }

    private static native int cusparseGetPointerModeNative(cusparseHandle var0, int[] var1);

    public static int cusparseSetPointerMode(cusparseHandle handle, int mode) {
        return JCusparse2.checkResult(JCusparse2.cusparseSetPointerModeNative(handle, mode));
    }

    private static native int cusparseSetPointerModeNative(cusparseHandle var0, int var1);

    public static int cusparseCreateMatDescr(cusparseMatDescr descrA) {
        return JCusparse2.checkResult(JCusparse2.cusparseCreateMatDescrNative(descrA));
    }

    private static native int cusparseCreateMatDescrNative(cusparseMatDescr var0);

    public static int cusparseDestroyMatDescr(cusparseMatDescr descrA) {
        return JCusparse2.checkResult(JCusparse2.cusparseDestroyMatDescrNative(descrA));
    }

    private static native int cusparseDestroyMatDescrNative(cusparseMatDescr var0);

    public static int cusparseSetMatType(cusparseMatDescr descrA, int type) {
        return JCusparse2.checkResult(JCusparse2.cusparseSetMatTypeNative(descrA, type));
    }

    private static native int cusparseSetMatTypeNative(cusparseMatDescr var0, int var1);

    public static int cusparseGetMatType(cusparseMatDescr descrA) {
        return JCusparse2.cusparseGetMatTypeNative(descrA);
    }

    private static native int cusparseGetMatTypeNative(cusparseMatDescr var0);

    public static int cusparseSetMatFillMode(cusparseMatDescr descrA, int fillMode) {
        return JCusparse2.checkResult(JCusparse2.cusparseSetMatFillModeNative(descrA, fillMode));
    }

    private static native int cusparseSetMatFillModeNative(cusparseMatDescr var0, int var1);

    public static int cusparseGetMatFillMode(cusparseMatDescr descrA) {
        return JCusparse2.cusparseGetMatFillModeNative(descrA);
    }

    private static native int cusparseGetMatFillModeNative(cusparseMatDescr var0);

    public static int cusparseSetMatDiagType(cusparseMatDescr descrA, int diagType) {
        return JCusparse2.checkResult(JCusparse2.cusparseSetMatDiagTypeNative(descrA, diagType));
    }

    private static native int cusparseSetMatDiagTypeNative(cusparseMatDescr var0, int var1);

    public static int cusparseGetMatDiagType(cusparseMatDescr descrA) {
        return JCusparse2.cusparseGetMatDiagTypeNative(descrA);
    }

    private static native int cusparseGetMatDiagTypeNative(cusparseMatDescr var0);

    public static int cusparseSetMatIndexBase(cusparseMatDescr descrA, int base) {
        return JCusparse2.checkResult(JCusparse2.cusparseSetMatIndexBaseNative(descrA, base));
    }

    private static native int cusparseSetMatIndexBaseNative(cusparseMatDescr var0, int var1);

    public static int cusparseGetMatIndexBase(cusparseMatDescr descrA) {
        return JCusparse2.cusparseGetMatIndexBaseNative(descrA);
    }

    private static native int cusparseGetMatIndexBaseNative(cusparseMatDescr var0);

    public static int cusparseCreateSolveAnalysisInfo(cusparseSolveAnalysisInfo info) {
        return JCusparse2.checkResult(JCusparse2.cusparseCreateSolveAnalysisInfoNative(info));
    }

    private static native int cusparseCreateSolveAnalysisInfoNative(cusparseSolveAnalysisInfo var0);

    public static int cusparseDestroySolveAnalysisInfo(cusparseSolveAnalysisInfo info) {
        return JCusparse2.checkResult(JCusparse2.cusparseDestroySolveAnalysisInfoNative(info));
    }

    private static native int cusparseDestroySolveAnalysisInfoNative(cusparseSolveAnalysisInfo var0);

    public static int cusparseGetLevelInfo(cusparseHandle handle, cusparseSolveAnalysisInfo info, int[] nlevels, Pointer levelPtr, Pointer levelInd) {
        return JCusparse2.checkResult(JCusparse2.cusparseGetLevelInfoNative(handle, info, nlevels, levelPtr, levelInd));
    }

    private static native int cusparseGetLevelInfoNative(cusparseHandle var0, cusparseSolveAnalysisInfo var1, int[] var2, Pointer var3, Pointer var4);

    public static int cusparseCreateHybMat(cusparseHybMat hybA) {
        return JCusparse2.checkResult(JCusparse2.cusparseCreateHybMatNative(hybA));
    }

    private static native int cusparseCreateHybMatNative(cusparseHybMat var0);

    public static int cusparseDestroyHybMat(cusparseHybMat hybA) {
        return JCusparse2.checkResult(JCusparse2.cusparseDestroyHybMatNative(hybA));
    }

    private static native int cusparseDestroyHybMatNative(cusparseHybMat var0);

    public static int cusparseSaxpyi(cusparseHandle handle, int nnz, Pointer alpha, Pointer xVal, Pointer xInd, Pointer y, int idxBase) {
        return JCusparse2.checkResult(JCusparse2.cusparseSaxpyiNative(handle, nnz, alpha, xVal, xInd, y, idxBase));
    }

    private static native int cusparseSaxpyiNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, int var6);

    public static int cusparseDaxpyi(cusparseHandle handle, int nnz, Pointer alpha, Pointer xVal, Pointer xInd, Pointer y, int idxBase) {
        return JCusparse2.checkResult(JCusparse2.cusparseDaxpyiNative(handle, nnz, alpha, xVal, xInd, y, idxBase));
    }

    private static native int cusparseDaxpyiNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, int var6);

    public static int cusparseCaxpyi(cusparseHandle handle, int nnz, Pointer alpha, Pointer xVal, Pointer xInd, Pointer y, int idxBase) {
        return JCusparse2.checkResult(JCusparse2.cusparseCaxpyiNative(handle, nnz, alpha, xVal, xInd, y, idxBase));
    }

    private static native int cusparseCaxpyiNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, int var6);

    public static int cusparseZaxpyi(cusparseHandle handle, int nnz, Pointer alpha, Pointer xVal, Pointer xInd, Pointer y, int idxBase) {
        return JCusparse2.checkResult(JCusparse2.cusparseZaxpyiNative(handle, nnz, alpha, xVal, xInd, y, idxBase));
    }

    private static native int cusparseZaxpyiNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, int var6);

    public static int cusparseSdoti(cusparseHandle handle, int nnz, Pointer xVal, Pointer xInd, Pointer y, Pointer resultDevHostPtr, int idxBase) {
        return JCusparse2.checkResult(JCusparse2.cusparseSdotiNative(handle, nnz, xVal, xInd, y, resultDevHostPtr, idxBase));
    }

    private static native int cusparseSdotiNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, int var6);

    public static int cusparseDdoti(cusparseHandle handle, int nnz, Pointer xVal, Pointer xInd, Pointer y, Pointer resultDevHostPtr, int idxBase) {
        return JCusparse2.checkResult(JCusparse2.cusparseDdotiNative(handle, nnz, xVal, xInd, y, resultDevHostPtr, idxBase));
    }

    private static native int cusparseDdotiNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, int var6);

    public static int cusparseCdoti(cusparseHandle handle, int nnz, Pointer xVal, Pointer xInd, Pointer y, Pointer resultDevHostPtr, int idxBase) {
        return JCusparse2.checkResult(JCusparse2.cusparseCdotiNative(handle, nnz, xVal, xInd, y, resultDevHostPtr, idxBase));
    }

    private static native int cusparseCdotiNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, int var6);

    public static int cusparseZdoti(cusparseHandle handle, int nnz, Pointer xVal, Pointer xInd, Pointer y, Pointer resultDevHostPtr, int idxBase) {
        return JCusparse2.checkResult(JCusparse2.cusparseZdotiNative(handle, nnz, xVal, xInd, y, resultDevHostPtr, idxBase));
    }

    private static native int cusparseZdotiNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, int var6);

    public static int cusparseCdotci(cusparseHandle handle, int nnz, Pointer xVal, Pointer xInd, Pointer y, Pointer resultDevHostPtr, int idxBase) {
        return JCusparse2.checkResult(JCusparse2.cusparseCdotciNative(handle, nnz, xVal, xInd, y, resultDevHostPtr, idxBase));
    }

    private static native int cusparseCdotciNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, int var6);

    public static int cusparseZdotci(cusparseHandle handle, int nnz, Pointer xVal, Pointer xInd, Pointer y, Pointer resultDevHostPtr, int idxBase) {
        return JCusparse2.checkResult(JCusparse2.cusparseZdotciNative(handle, nnz, xVal, xInd, y, resultDevHostPtr, idxBase));
    }

    private static native int cusparseZdotciNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, int var6);

    public static int cusparseSgthr(cusparseHandle handle, int nnz, Pointer y, Pointer xVal, Pointer xInd, int idxBase) {
        return JCusparse2.checkResult(JCusparse2.cusparseSgthrNative(handle, nnz, y, xVal, xInd, idxBase));
    }

    private static native int cusparseSgthrNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    public static int cusparseDgthr(cusparseHandle handle, int nnz, Pointer y, Pointer xVal, Pointer xInd, int idxBase) {
        return JCusparse2.checkResult(JCusparse2.cusparseDgthrNative(handle, nnz, y, xVal, xInd, idxBase));
    }

    private static native int cusparseDgthrNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    public static int cusparseCgthr(cusparseHandle handle, int nnz, Pointer y, Pointer xVal, Pointer xInd, int idxBase) {
        return JCusparse2.checkResult(JCusparse2.cusparseCgthrNative(handle, nnz, y, xVal, xInd, idxBase));
    }

    private static native int cusparseCgthrNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    public static int cusparseZgthr(cusparseHandle handle, int nnz, Pointer y, Pointer xVal, Pointer xInd, int idxBase) {
        return JCusparse2.checkResult(JCusparse2.cusparseZgthrNative(handle, nnz, y, xVal, xInd, idxBase));
    }

    private static native int cusparseZgthrNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    public static int cusparseSgthrz(cusparseHandle handle, int nnz, Pointer y, Pointer xVal, Pointer xInd, int idxBase) {
        return JCusparse2.checkResult(JCusparse2.cusparseSgthrzNative(handle, nnz, y, xVal, xInd, idxBase));
    }

    private static native int cusparseSgthrzNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    public static int cusparseDgthrz(cusparseHandle handle, int nnz, Pointer y, Pointer xVal, Pointer xInd, int idxBase) {
        return JCusparse2.checkResult(JCusparse2.cusparseDgthrzNative(handle, nnz, y, xVal, xInd, idxBase));
    }

    private static native int cusparseDgthrzNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    public static int cusparseCgthrz(cusparseHandle handle, int nnz, Pointer y, Pointer xVal, Pointer xInd, int idxBase) {
        return JCusparse2.checkResult(JCusparse2.cusparseCgthrzNative(handle, nnz, y, xVal, xInd, idxBase));
    }

    private static native int cusparseCgthrzNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    public static int cusparseZgthrz(cusparseHandle handle, int nnz, Pointer y, Pointer xVal, Pointer xInd, int idxBase) {
        return JCusparse2.checkResult(JCusparse2.cusparseZgthrzNative(handle, nnz, y, xVal, xInd, idxBase));
    }

    private static native int cusparseZgthrzNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    public static int cusparseSsctr(cusparseHandle handle, int nnz, Pointer xVal, Pointer xInd, Pointer y, int idxBase) {
        return JCusparse2.checkResult(JCusparse2.cusparseSsctrNative(handle, nnz, xVal, xInd, y, idxBase));
    }

    private static native int cusparseSsctrNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    public static int cusparseDsctr(cusparseHandle handle, int nnz, Pointer xVal, Pointer xInd, Pointer y, int idxBase) {
        return JCusparse2.checkResult(JCusparse2.cusparseDsctrNative(handle, nnz, xVal, xInd, y, idxBase));
    }

    private static native int cusparseDsctrNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    public static int cusparseCsctr(cusparseHandle handle, int nnz, Pointer xVal, Pointer xInd, Pointer y, int idxBase) {
        return JCusparse2.checkResult(JCusparse2.cusparseCsctrNative(handle, nnz, xVal, xInd, y, idxBase));
    }

    private static native int cusparseCsctrNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    public static int cusparseZsctr(cusparseHandle handle, int nnz, Pointer xVal, Pointer xInd, Pointer y, int idxBase) {
        return JCusparse2.checkResult(JCusparse2.cusparseZsctrNative(handle, nnz, xVal, xInd, y, idxBase));
    }

    private static native int cusparseZsctrNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    public static int cusparseSroti(cusparseHandle handle, int nnz, Pointer xVal, Pointer xInd, Pointer y, Pointer c, Pointer s, int idxBase) {
        return JCusparse2.checkResult(JCusparse2.cusparseSrotiNative(handle, nnz, xVal, xInd, y, c, s, idxBase));
    }

    private static native int cusparseSrotiNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7);

    public static int cusparseDroti(cusparseHandle handle, int nnz, Pointer xVal, Pointer xInd, Pointer y, Pointer c, Pointer s, int idxBase) {
        return JCusparse2.checkResult(JCusparse2.cusparseDrotiNative(handle, nnz, xVal, xInd, y, c, s, idxBase));
    }

    private static native int cusparseDrotiNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7);

    public static int cusparseScsrmv(cusparseHandle handle, int transA, int m, int n, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer x, Pointer beta, Pointer y) {
        return JCusparse2.checkResult(JCusparse2.cusparseScsrmvNative(handle, transA, m, n, nnz, alpha, descrA, csrValA, csrRowPtrA, csrColIndA, x, beta, y));
    }

    private static native int cusparseScsrmvNative(cusparseHandle var0, int var1, int var2, int var3, int var4, Pointer var5, cusparseMatDescr var6, Pointer var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12);

    public static int cusparseDcsrmv(cusparseHandle handle, int transA, int m, int n, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer x, Pointer beta, Pointer y) {
        return JCusparse2.checkResult(JCusparse2.cusparseDcsrmvNative(handle, transA, m, n, nnz, alpha, descrA, csrValA, csrRowPtrA, csrColIndA, x, beta, y));
    }

    private static native int cusparseDcsrmvNative(cusparseHandle var0, int var1, int var2, int var3, int var4, Pointer var5, cusparseMatDescr var6, Pointer var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12);

    public static int cusparseCcsrmv(cusparseHandle handle, int transA, int m, int n, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer x, Pointer beta, Pointer y) {
        return JCusparse2.checkResult(JCusparse2.cusparseCcsrmvNative(handle, transA, m, n, nnz, alpha, descrA, csrValA, csrRowPtrA, csrColIndA, x, beta, y));
    }

    private static native int cusparseCcsrmvNative(cusparseHandle var0, int var1, int var2, int var3, int var4, Pointer var5, cusparseMatDescr var6, Pointer var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12);

    public static int cusparseZcsrmv(cusparseHandle handle, int transA, int m, int n, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer x, Pointer beta, Pointer y) {
        return JCusparse2.checkResult(JCusparse2.cusparseZcsrmvNative(handle, transA, m, n, nnz, alpha, descrA, csrValA, csrRowPtrA, csrColIndA, x, beta, y));
    }

    private static native int cusparseZcsrmvNative(cusparseHandle var0, int var1, int var2, int var3, int var4, Pointer var5, cusparseMatDescr var6, Pointer var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12);

    public static int cusparseShybmv(cusparseHandle handle, int transA, Pointer alpha, cusparseMatDescr descrA, cusparseHybMat hybA, Pointer x, Pointer beta, Pointer y) {
        return JCusparse2.checkResult(JCusparse2.cusparseShybmvNative(handle, transA, alpha, descrA, hybA, x, beta, y));
    }

    private static native int cusparseShybmvNative(cusparseHandle var0, int var1, Pointer var2, cusparseMatDescr var3, cusparseHybMat var4, Pointer var5, Pointer var6, Pointer var7);

    public static int cusparseDhybmv(cusparseHandle handle, int transA, Pointer alpha, cusparseMatDescr descrA, cusparseHybMat hybA, Pointer x, Pointer beta, Pointer y) {
        return JCusparse2.checkResult(JCusparse2.cusparseDhybmvNative(handle, transA, alpha, descrA, hybA, x, beta, y));
    }

    private static native int cusparseDhybmvNative(cusparseHandle var0, int var1, Pointer var2, cusparseMatDescr var3, cusparseHybMat var4, Pointer var5, Pointer var6, Pointer var7);

    public static int cusparseChybmv(cusparseHandle handle, int transA, Pointer alpha, cusparseMatDescr descrA, cusparseHybMat hybA, Pointer x, Pointer beta, Pointer y) {
        return JCusparse2.checkResult(JCusparse2.cusparseChybmvNative(handle, transA, alpha, descrA, hybA, x, beta, y));
    }

    private static native int cusparseChybmvNative(cusparseHandle var0, int var1, Pointer var2, cusparseMatDescr var3, cusparseHybMat var4, Pointer var5, Pointer var6, Pointer var7);

    public static int cusparseZhybmv(cusparseHandle handle, int transA, Pointer alpha, cusparseMatDescr descrA, cusparseHybMat hybA, Pointer x, Pointer beta, Pointer y) {
        return JCusparse2.checkResult(JCusparse2.cusparseZhybmvNative(handle, transA, alpha, descrA, hybA, x, beta, y));
    }

    private static native int cusparseZhybmvNative(cusparseHandle var0, int var1, Pointer var2, cusparseMatDescr var3, cusparseHybMat var4, Pointer var5, Pointer var6, Pointer var7);

    public static int cusparseSbsrmv(cusparseHandle handle, int dirA, int transA, int mb, int nb, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrValA, Pointer bsrRowPtrA, Pointer bsrColIndA, int blockDim, Pointer x, Pointer beta, Pointer y) {
        return JCusparse2.checkResult(JCusparse2.cusparseSbsrmvNative(handle, dirA, transA, mb, nb, nnzb, alpha, descrA, bsrValA, bsrRowPtrA, bsrColIndA, blockDim, x, beta, y));
    }

    private static native int cusparseSbsrmvNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, cusparseMatDescr var7, Pointer var8, Pointer var9, Pointer var10, int var11, Pointer var12, Pointer var13, Pointer var14);

    public static int cusparseDbsrmv(cusparseHandle handle, int dirA, int transA, int mb, int nb, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrValA, Pointer bsrRowPtrA, Pointer bsrColIndA, int blockDim, Pointer x, Pointer beta, Pointer y) {
        return JCusparse2.checkResult(JCusparse2.cusparseDbsrmvNative(handle, dirA, transA, mb, nb, nnzb, alpha, descrA, bsrValA, bsrRowPtrA, bsrColIndA, blockDim, x, beta, y));
    }

    private static native int cusparseDbsrmvNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, cusparseMatDescr var7, Pointer var8, Pointer var9, Pointer var10, int var11, Pointer var12, Pointer var13, Pointer var14);

    public static int cusparseCbsrmv(cusparseHandle handle, int dirA, int transA, int mb, int nb, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrValA, Pointer bsrRowPtrA, Pointer bsrColIndA, int blockDim, Pointer x, Pointer beta, Pointer y) {
        return JCusparse2.checkResult(JCusparse2.cusparseCbsrmvNative(handle, dirA, transA, mb, nb, nnzb, alpha, descrA, bsrValA, bsrRowPtrA, bsrColIndA, blockDim, x, beta, y));
    }

    private static native int cusparseCbsrmvNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, cusparseMatDescr var7, Pointer var8, Pointer var9, Pointer var10, int var11, Pointer var12, Pointer var13, Pointer var14);

    public static int cusparseZbsrmv(cusparseHandle handle, int dirA, int transA, int mb, int nb, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrValA, Pointer bsrRowPtrA, Pointer bsrColIndA, int blockDim, Pointer x, Pointer beta, Pointer y) {
        return JCusparse2.checkResult(JCusparse2.cusparseZbsrmvNative(handle, dirA, transA, mb, nb, nnzb, alpha, descrA, bsrValA, bsrRowPtrA, bsrColIndA, blockDim, x, beta, y));
    }

    private static native int cusparseZbsrmvNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, cusparseMatDescr var7, Pointer var8, Pointer var9, Pointer var10, int var11, Pointer var12, Pointer var13, Pointer var14);

    public static int cusparseSbsrxmv(cusparseHandle handle, int dirA, int transA, int sizeOfMask, int mb, int nb, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrValA, Pointer bsrMaskPtrA, Pointer bsrRowPtrA, Pointer bsrEndPtrA, Pointer bsrColIndA, int blockDim, Pointer x, Pointer beta, Pointer y) {
        return JCusparse2.checkResult(JCusparse2.cusparseSbsrxmvNative(handle, dirA, transA, sizeOfMask, mb, nb, nnzb, alpha, descrA, bsrValA, bsrMaskPtrA, bsrRowPtrA, bsrEndPtrA, bsrColIndA, blockDim, x, beta, y));
    }

    private static native int cusparseSbsrxmvNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12, Pointer var13, int var14, Pointer var15, Pointer var16, Pointer var17);

    public static int cusparseDbsrxmv(cusparseHandle handle, int dirA, int transA, int sizeOfMask, int mb, int nb, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrValA, Pointer bsrMaskPtrA, Pointer bsrRowPtrA, Pointer bsrEndPtrA, Pointer bsrColIndA, int blockDim, Pointer x, Pointer beta, Pointer y) {
        return JCusparse2.checkResult(JCusparse2.cusparseDbsrxmvNative(handle, dirA, transA, sizeOfMask, mb, nb, nnzb, alpha, descrA, bsrValA, bsrMaskPtrA, bsrRowPtrA, bsrEndPtrA, bsrColIndA, blockDim, x, beta, y));
    }

    private static native int cusparseDbsrxmvNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12, Pointer var13, int var14, Pointer var15, Pointer var16, Pointer var17);

    public static int cusparseCbsrxmv(cusparseHandle handle, int dirA, int transA, int sizeOfMask, int mb, int nb, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrValA, Pointer bsrMaskPtrA, Pointer bsrRowPtrA, Pointer bsrEndPtrA, Pointer bsrColIndA, int blockDim, Pointer x, Pointer beta, Pointer y) {
        return JCusparse2.checkResult(JCusparse2.cusparseCbsrxmvNative(handle, dirA, transA, sizeOfMask, mb, nb, nnzb, alpha, descrA, bsrValA, bsrMaskPtrA, bsrRowPtrA, bsrEndPtrA, bsrColIndA, blockDim, x, beta, y));
    }

    private static native int cusparseCbsrxmvNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12, Pointer var13, int var14, Pointer var15, Pointer var16, Pointer var17);

    public static int cusparseZbsrxmv(cusparseHandle handle, int dirA, int transA, int sizeOfMask, int mb, int nb, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrValA, Pointer bsrMaskPtrA, Pointer bsrRowPtrA, Pointer bsrEndPtrA, Pointer bsrColIndA, int blockDim, Pointer x, Pointer beta, Pointer y) {
        return JCusparse2.checkResult(JCusparse2.cusparseZbsrxmvNative(handle, dirA, transA, sizeOfMask, mb, nb, nnzb, alpha, descrA, bsrValA, bsrMaskPtrA, bsrRowPtrA, bsrEndPtrA, bsrColIndA, blockDim, x, beta, y));
    }

    private static native int cusparseZbsrxmvNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12, Pointer var13, int var14, Pointer var15, Pointer var16, Pointer var17);

    public static int cusparseScsrsv_analysis(cusparseHandle handle, int transA, int m, int nnz, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, cusparseSolveAnalysisInfo info) {
        return JCusparse2.checkResult(JCusparse2.cusparseScsrsv_analysisNative(handle, transA, m, nnz, descrA, csrValA, csrRowPtrA, csrColIndA, info));
    }

    private static native int cusparseScsrsv_analysisNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, cusparseSolveAnalysisInfo var8);

    public static int cusparseDcsrsv_analysis(cusparseHandle handle, int transA, int m, int nnz, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, cusparseSolveAnalysisInfo info) {
        return JCusparse2.checkResult(JCusparse2.cusparseDcsrsv_analysisNative(handle, transA, m, nnz, descrA, csrValA, csrRowPtrA, csrColIndA, info));
    }

    private static native int cusparseDcsrsv_analysisNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, cusparseSolveAnalysisInfo var8);

    public static int cusparseCcsrsv_analysis(cusparseHandle handle, int transA, int m, int nnz, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, cusparseSolveAnalysisInfo info) {
        return JCusparse2.checkResult(JCusparse2.cusparseCcsrsv_analysisNative(handle, transA, m, nnz, descrA, csrValA, csrRowPtrA, csrColIndA, info));
    }

    private static native int cusparseCcsrsv_analysisNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, cusparseSolveAnalysisInfo var8);

    public static int cusparseZcsrsv_analysis(cusparseHandle handle, int transA, int m, int nnz, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, cusparseSolveAnalysisInfo info) {
        return JCusparse2.checkResult(JCusparse2.cusparseZcsrsv_analysisNative(handle, transA, m, nnz, descrA, csrValA, csrRowPtrA, csrColIndA, info));
    }

    private static native int cusparseZcsrsv_analysisNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, cusparseSolveAnalysisInfo var8);

    public static int cusparseScsrsv_solve(cusparseHandle handle, int transA, int m, Pointer alpha, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, cusparseSolveAnalysisInfo info, Pointer x, Pointer y) {
        return JCusparse2.checkResult(JCusparse2.cusparseScsrsv_solveNative(handle, transA, m, alpha, descrA, csrValA, csrRowPtrA, csrColIndA, info, x, y));
    }

    private static native int cusparseScsrsv_solveNative(cusparseHandle var0, int var1, int var2, Pointer var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, cusparseSolveAnalysisInfo var8, Pointer var9, Pointer var10);

    public static int cusparseDcsrsv_solve(cusparseHandle handle, int transA, int m, Pointer alpha, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, cusparseSolveAnalysisInfo info, Pointer x, Pointer y) {
        return JCusparse2.checkResult(JCusparse2.cusparseDcsrsv_solveNative(handle, transA, m, alpha, descrA, csrValA, csrRowPtrA, csrColIndA, info, x, y));
    }

    private static native int cusparseDcsrsv_solveNative(cusparseHandle var0, int var1, int var2, Pointer var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, cusparseSolveAnalysisInfo var8, Pointer var9, Pointer var10);

    public static int cusparseCcsrsv_solve(cusparseHandle handle, int transA, int m, Pointer alpha, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, cusparseSolveAnalysisInfo info, Pointer x, Pointer y) {
        return JCusparse2.checkResult(JCusparse2.cusparseCcsrsv_solveNative(handle, transA, m, alpha, descrA, csrValA, csrRowPtrA, csrColIndA, info, x, y));
    }

    private static native int cusparseCcsrsv_solveNative(cusparseHandle var0, int var1, int var2, Pointer var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, cusparseSolveAnalysisInfo var8, Pointer var9, Pointer var10);

    public static int cusparseZcsrsv_solve(cusparseHandle handle, int transA, int m, Pointer alpha, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, cusparseSolveAnalysisInfo info, Pointer x, Pointer y) {
        return JCusparse2.checkResult(JCusparse2.cusparseZcsrsv_solveNative(handle, transA, m, alpha, descrA, csrValA, csrRowPtrA, csrColIndA, info, x, y));
    }

    private static native int cusparseZcsrsv_solveNative(cusparseHandle var0, int var1, int var2, Pointer var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, cusparseSolveAnalysisInfo var8, Pointer var9, Pointer var10);

    public static int cusparseShybsv_analysis(cusparseHandle handle, int transA, cusparseMatDescr descrA, cusparseHybMat hybA, cusparseSolveAnalysisInfo info) {
        return JCusparse2.checkResult(JCusparse2.cusparseShybsv_analysisNative(handle, transA, descrA, hybA, info));
    }

    private static native int cusparseShybsv_analysisNative(cusparseHandle var0, int var1, cusparseMatDescr var2, cusparseHybMat var3, cusparseSolveAnalysisInfo var4);

    public static int cusparseDhybsv_analysis(cusparseHandle handle, int transA, cusparseMatDescr descrA, cusparseHybMat hybA, cusparseSolveAnalysisInfo info) {
        return JCusparse2.checkResult(JCusparse2.cusparseDhybsv_analysisNative(handle, transA, descrA, hybA, info));
    }

    private static native int cusparseDhybsv_analysisNative(cusparseHandle var0, int var1, cusparseMatDescr var2, cusparseHybMat var3, cusparseSolveAnalysisInfo var4);

    public static int cusparseChybsv_analysis(cusparseHandle handle, int transA, cusparseMatDescr descrA, cusparseHybMat hybA, cusparseSolveAnalysisInfo info) {
        return JCusparse2.checkResult(JCusparse2.cusparseChybsv_analysisNative(handle, transA, descrA, hybA, info));
    }

    private static native int cusparseChybsv_analysisNative(cusparseHandle var0, int var1, cusparseMatDescr var2, cusparseHybMat var3, cusparseSolveAnalysisInfo var4);

    public static int cusparseZhybsv_analysis(cusparseHandle handle, int transA, cusparseMatDescr descrA, cusparseHybMat hybA, cusparseSolveAnalysisInfo info) {
        return JCusparse2.checkResult(JCusparse2.cusparseZhybsv_analysisNative(handle, transA, descrA, hybA, info));
    }

    private static native int cusparseZhybsv_analysisNative(cusparseHandle var0, int var1, cusparseMatDescr var2, cusparseHybMat var3, cusparseSolveAnalysisInfo var4);

    public static int cusparseShybsv_solve(cusparseHandle handle, int trans, Pointer alpha, cusparseMatDescr descra, cusparseHybMat hybA, cusparseSolveAnalysisInfo info, Pointer x, Pointer y) {
        return JCusparse2.checkResult(JCusparse2.cusparseShybsv_solveNative(handle, trans, alpha, descra, hybA, info, x, y));
    }

    private static native int cusparseShybsv_solveNative(cusparseHandle var0, int var1, Pointer var2, cusparseMatDescr var3, cusparseHybMat var4, cusparseSolveAnalysisInfo var5, Pointer var6, Pointer var7);

    public static int cusparseChybsv_solve(cusparseHandle handle, int trans, Pointer alpha, cusparseMatDescr descra, cusparseHybMat hybA, cusparseSolveAnalysisInfo info, Pointer x, Pointer y) {
        return JCusparse2.checkResult(JCusparse2.cusparseChybsv_solveNative(handle, trans, alpha, descra, hybA, info, x, y));
    }

    private static native int cusparseChybsv_solveNative(cusparseHandle var0, int var1, Pointer var2, cusparseMatDescr var3, cusparseHybMat var4, cusparseSolveAnalysisInfo var5, Pointer var6, Pointer var7);

    public static int cusparseDhybsv_solve(cusparseHandle handle, int trans, Pointer alpha, cusparseMatDescr descra, cusparseHybMat hybA, cusparseSolveAnalysisInfo info, Pointer x, Pointer y) {
        return JCusparse2.checkResult(JCusparse2.cusparseDhybsv_solveNative(handle, trans, alpha, descra, hybA, info, x, y));
    }

    private static native int cusparseDhybsv_solveNative(cusparseHandle var0, int var1, Pointer var2, cusparseMatDescr var3, cusparseHybMat var4, cusparseSolveAnalysisInfo var5, Pointer var6, Pointer var7);

    public static int cusparseZhybsv_solve(cusparseHandle handle, int trans, Pointer alpha, cusparseMatDescr descra, cusparseHybMat hybA, cusparseSolveAnalysisInfo info, Pointer x, Pointer y) {
        return JCusparse2.checkResult(JCusparse2.cusparseZhybsv_solveNative(handle, trans, alpha, descra, hybA, info, x, y));
    }

    private static native int cusparseZhybsv_solveNative(cusparseHandle var0, int var1, Pointer var2, cusparseMatDescr var3, cusparseHybMat var4, cusparseSolveAnalysisInfo var5, Pointer var6, Pointer var7);

    public static int cusparseScsrmm(cusparseHandle handle, int transA, int m, int n, int k, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCusparse2.checkResult(JCusparse2.cusparseScsrmmNative(handle, transA, m, n, k, nnz, alpha, descrA, csrValA, csrRowPtrA, csrColIndA, B, ldb, beta, C, ldc));
    }

    private static native int cusparseScsrmmNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, cusparseMatDescr var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, int var12, Pointer var13, Pointer var14, int var15);

    public static int cusparseDcsrmm(cusparseHandle handle, int transA, int m, int n, int k, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCusparse2.checkResult(JCusparse2.cusparseDcsrmmNative(handle, transA, m, n, k, nnz, alpha, descrA, csrValA, csrRowPtrA, csrColIndA, B, ldb, beta, C, ldc));
    }

    private static native int cusparseDcsrmmNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, cusparseMatDescr var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, int var12, Pointer var13, Pointer var14, int var15);

    public static int cusparseCcsrmm(cusparseHandle handle, int transA, int m, int n, int k, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCusparse2.checkResult(JCusparse2.cusparseCcsrmmNative(handle, transA, m, n, k, nnz, alpha, descrA, csrValA, csrRowPtrA, csrColIndA, B, ldb, beta, C, ldc));
    }

    private static native int cusparseCcsrmmNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, cusparseMatDescr var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, int var12, Pointer var13, Pointer var14, int var15);

    public static int cusparseZcsrmm(cusparseHandle handle, int transA, int m, int n, int k, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCusparse2.checkResult(JCusparse2.cusparseZcsrmmNative(handle, transA, m, n, k, nnz, alpha, descrA, csrValA, csrRowPtrA, csrColIndA, B, ldb, beta, C, ldc));
    }

    private static native int cusparseZcsrmmNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, cusparseMatDescr var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, int var12, Pointer var13, Pointer var14, int var15);

    public static int cusparseScsrmm2(cusparseHandle handle, int transa, int transb, int m, int n, int k, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCusparse2.checkResult(JCusparse2.cusparseScsrmm2Native(handle, transa, transb, m, n, k, nnz, alpha, descrA, csrValA, csrRowPtrA, csrColIndA, B, ldb, beta, C, ldc));
    }

    private static native int cusparseScsrmm2Native(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12, int var13, Pointer var14, Pointer var15, int var16);

    public static int cusparseDcsrmm2(cusparseHandle handle, int transa, int transb, int m, int n, int k, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCusparse2.checkResult(JCusparse2.cusparseDcsrmm2Native(handle, transa, transb, m, n, k, nnz, alpha, descrA, csrValA, csrRowPtrA, csrColIndA, B, ldb, beta, C, ldc));
    }

    private static native int cusparseDcsrmm2Native(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12, int var13, Pointer var14, Pointer var15, int var16);

    public static int cusparseCcsrmm2(cusparseHandle handle, int transa, int transb, int m, int n, int k, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCusparse2.checkResult(JCusparse2.cusparseCcsrmm2Native(handle, transa, transb, m, n, k, nnz, alpha, descrA, csrValA, csrRowPtrA, csrColIndA, B, ldb, beta, C, ldc));
    }

    private static native int cusparseCcsrmm2Native(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12, int var13, Pointer var14, Pointer var15, int var16);

    public static int cusparseZcsrmm2(cusparseHandle handle, int transa, int transb, int m, int n, int k, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCusparse2.checkResult(JCusparse2.cusparseZcsrmm2Native(handle, transa, transb, m, n, k, nnz, alpha, descrA, csrValA, csrRowPtrA, csrColIndA, B, ldb, beta, C, ldc));
    }

    private static native int cusparseZcsrmm2Native(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12, int var13, Pointer var14, Pointer var15, int var16);

    public static int cusparseScsrsm_analysis(cusparseHandle handle, int transA, int m, int nnz, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, cusparseSolveAnalysisInfo info) {
        return JCusparse2.checkResult(JCusparse2.cusparseScsrsm_analysisNative(handle, transA, m, nnz, descrA, csrValA, csrRowPtrA, csrColIndA, info));
    }

    private static native int cusparseScsrsm_analysisNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, cusparseSolveAnalysisInfo var8);

    public static int cusparseDcsrsm_analysis(cusparseHandle handle, int transA, int m, int nnz, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, cusparseSolveAnalysisInfo info) {
        return JCusparse2.checkResult(JCusparse2.cusparseDcsrsm_analysisNative(handle, transA, m, nnz, descrA, csrValA, csrRowPtrA, csrColIndA, info));
    }

    private static native int cusparseDcsrsm_analysisNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, cusparseSolveAnalysisInfo var8);

    public static int cusparseCcsrsm_analysis(cusparseHandle handle, int transA, int m, int nnz, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, cusparseSolveAnalysisInfo info) {
        return JCusparse2.checkResult(JCusparse2.cusparseCcsrsm_analysisNative(handle, transA, m, nnz, descrA, csrValA, csrRowPtrA, csrColIndA, info));
    }

    private static native int cusparseCcsrsm_analysisNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, cusparseSolveAnalysisInfo var8);

    public static int cusparseZcsrsm_analysis(cusparseHandle handle, int transA, int m, int nnz, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, cusparseSolveAnalysisInfo info) {
        return JCusparse2.checkResult(JCusparse2.cusparseZcsrsm_analysisNative(handle, transA, m, nnz, descrA, csrValA, csrRowPtrA, csrColIndA, info));
    }

    private static native int cusparseZcsrsm_analysisNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, cusparseSolveAnalysisInfo var8);

    public static int cusparseScsrsm_solve(cusparseHandle handle, int transA, int m, int n, Pointer alpha, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, cusparseSolveAnalysisInfo info, Pointer x, int ldx, Pointer y, int ldy) {
        return JCusparse2.checkResult(JCusparse2.cusparseScsrsm_solveNative(handle, transA, m, n, alpha, descrA, csrValA, csrRowPtrA, csrColIndA, info, x, ldx, y, ldy));
    }

    private static native int cusparseScsrsm_solveNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, cusparseSolveAnalysisInfo var9, Pointer var10, int var11, Pointer var12, int var13);

    public static int cusparseDcsrsm_solve(cusparseHandle handle, int transA, int m, int n, Pointer alpha, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, cusparseSolveAnalysisInfo info, Pointer x, int ldx, Pointer y, int ldy) {
        return JCusparse2.checkResult(JCusparse2.cusparseDcsrsm_solveNative(handle, transA, m, n, alpha, descrA, csrValA, csrRowPtrA, csrColIndA, info, x, ldx, y, ldy));
    }

    private static native int cusparseDcsrsm_solveNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, cusparseSolveAnalysisInfo var9, Pointer var10, int var11, Pointer var12, int var13);

    public static int cusparseCcsrsm_solve(cusparseHandle handle, int transA, int m, int n, Pointer alpha, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, cusparseSolveAnalysisInfo info, Pointer x, int ldx, Pointer y, int ldy) {
        return JCusparse2.checkResult(JCusparse2.cusparseCcsrsm_solveNative(handle, transA, m, n, alpha, descrA, csrValA, csrRowPtrA, csrColIndA, info, x, ldx, y, ldy));
    }

    private static native int cusparseCcsrsm_solveNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, cusparseSolveAnalysisInfo var9, Pointer var10, int var11, Pointer var12, int var13);

    public static int cusparseZcsrsm_solve(cusparseHandle handle, int transA, int m, int n, Pointer alpha, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, cusparseSolveAnalysisInfo info, Pointer x, int ldx, Pointer y, int ldy) {
        return JCusparse2.checkResult(JCusparse2.cusparseZcsrsm_solveNative(handle, transA, m, n, alpha, descrA, csrValA, csrRowPtrA, csrColIndA, info, x, ldx, y, ldy));
    }

    private static native int cusparseZcsrsm_solveNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, cusparseSolveAnalysisInfo var9, Pointer var10, int var11, Pointer var12, int var13);

    public static int cusparseScsrilu0(cusparseHandle handle, int trans, int m, cusparseMatDescr descrA, Pointer csrValA_ValM, Pointer csrRowPtrA, Pointer csrColIndA, cusparseSolveAnalysisInfo info) {
        return JCusparse2.checkResult(JCusparse2.cusparseScsrilu0Native(handle, trans, m, descrA, csrValA_ValM, csrRowPtrA, csrColIndA, info));
    }

    private static native int cusparseScsrilu0Native(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, cusparseSolveAnalysisInfo var7);

    public static int cusparseDcsrilu0(cusparseHandle handle, int trans, int m, cusparseMatDescr descrA, Pointer csrValA_ValM, Pointer csrRowPtrA, Pointer csrColIndA, cusparseSolveAnalysisInfo info) {
        return JCusparse2.checkResult(JCusparse2.cusparseDcsrilu0Native(handle, trans, m, descrA, csrValA_ValM, csrRowPtrA, csrColIndA, info));
    }

    private static native int cusparseDcsrilu0Native(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, cusparseSolveAnalysisInfo var7);

    public static int cusparseCcsrilu0(cusparseHandle handle, int trans, int m, cusparseMatDescr descrA, Pointer csrValA_ValM, Pointer csrRowPtrA, Pointer csrColIndA, cusparseSolveAnalysisInfo info) {
        return JCusparse2.checkResult(JCusparse2.cusparseCcsrilu0Native(handle, trans, m, descrA, csrValA_ValM, csrRowPtrA, csrColIndA, info));
    }

    private static native int cusparseCcsrilu0Native(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, cusparseSolveAnalysisInfo var7);

    public static int cusparseZcsrilu0(cusparseHandle handle, int trans, int m, cusparseMatDescr descrA, Pointer csrValA_ValM, Pointer csrRowPtrA, Pointer csrColIndA, cusparseSolveAnalysisInfo info) {
        return JCusparse2.checkResult(JCusparse2.cusparseZcsrilu0Native(handle, trans, m, descrA, csrValA_ValM, csrRowPtrA, csrColIndA, info));
    }

    private static native int cusparseZcsrilu0Native(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, cusparseSolveAnalysisInfo var7);

    public static int cusparseScsric0(cusparseHandle handle, int trans, int m, cusparseMatDescr descrA, Pointer csrValA_ValM, Pointer csrRowPtrA, Pointer csrColIndA, cusparseSolveAnalysisInfo info) {
        return JCusparse2.checkResult(JCusparse2.cusparseScsric0Native(handle, trans, m, descrA, csrValA_ValM, csrRowPtrA, csrColIndA, info));
    }

    private static native int cusparseScsric0Native(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, cusparseSolveAnalysisInfo var7);

    public static int cusparseDcsric0(cusparseHandle handle, int trans, int m, cusparseMatDescr descrA, Pointer csrValA_ValM, Pointer csrRowPtrA, Pointer csrColIndA, cusparseSolveAnalysisInfo info) {
        return JCusparse2.checkResult(JCusparse2.cusparseDcsric0Native(handle, trans, m, descrA, csrValA_ValM, csrRowPtrA, csrColIndA, info));
    }

    private static native int cusparseDcsric0Native(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, cusparseSolveAnalysisInfo var7);

    public static int cusparseCcsric0(cusparseHandle handle, int trans, int m, cusparseMatDescr descrA, Pointer csrValA_ValM, Pointer csrRowPtrA, Pointer csrColIndA, cusparseSolveAnalysisInfo info) {
        return JCusparse2.checkResult(JCusparse2.cusparseCcsric0Native(handle, trans, m, descrA, csrValA_ValM, csrRowPtrA, csrColIndA, info));
    }

    private static native int cusparseCcsric0Native(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, cusparseSolveAnalysisInfo var7);

    public static int cusparseZcsric0(cusparseHandle handle, int trans, int m, cusparseMatDescr descrA, Pointer csrValA_ValM, Pointer csrRowPtrA, Pointer csrColIndA, cusparseSolveAnalysisInfo info) {
        return JCusparse2.checkResult(JCusparse2.cusparseZcsric0Native(handle, trans, m, descrA, csrValA_ValM, csrRowPtrA, csrColIndA, info));
    }

    private static native int cusparseZcsric0Native(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, cusparseSolveAnalysisInfo var7);

    public static int cusparseSgtsv(cusparseHandle handle, int m, int n, Pointer dl, Pointer d, Pointer du, Pointer B, int ldb) {
        return JCusparse2.checkResult(JCusparse2.cusparseSgtsvNative(handle, m, n, dl, d, du, B, ldb));
    }

    private static native int cusparseSgtsvNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7);

    public static int cusparseDgtsv(cusparseHandle handle, int m, int n, Pointer dl, Pointer d, Pointer du, Pointer B, int ldb) {
        return JCusparse2.checkResult(JCusparse2.cusparseDgtsvNative(handle, m, n, dl, d, du, B, ldb));
    }

    private static native int cusparseDgtsvNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7);

    public static int cusparseCgtsv(cusparseHandle handle, int m, int n, Pointer dl, Pointer d, Pointer du, Pointer B, int ldb) {
        return JCusparse2.checkResult(JCusparse2.cusparseCgtsvNative(handle, m, n, dl, d, du, B, ldb));
    }

    private static native int cusparseCgtsvNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7);

    public static int cusparseZgtsv(cusparseHandle handle, int m, int n, Pointer dl, Pointer d, Pointer du, Pointer B, int ldb) {
        return JCusparse2.checkResult(JCusparse2.cusparseZgtsvNative(handle, m, n, dl, d, du, B, ldb));
    }

    private static native int cusparseZgtsvNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7);

    public static int cusparseSgtsv_nopivot(cusparseHandle handle, int m, int n, Pointer dl, Pointer d, Pointer du, Pointer B, int ldb) {
        return JCusparse2.checkResult(JCusparse2.cusparseSgtsv_nopivotNative(handle, m, n, dl, d, du, B, ldb));
    }

    private static native int cusparseSgtsv_nopivotNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7);

    public static int cusparseDgtsv_nopivot(cusparseHandle handle, int m, int n, Pointer dl, Pointer d, Pointer du, Pointer B, int ldb) {
        return JCusparse2.checkResult(JCusparse2.cusparseDgtsv_nopivotNative(handle, m, n, dl, d, du, B, ldb));
    }

    private static native int cusparseDgtsv_nopivotNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7);

    public static int cusparseCgtsv_nopivot(cusparseHandle handle, int m, int n, Pointer dl, Pointer d, Pointer du, Pointer B, int ldb) {
        return JCusparse2.checkResult(JCusparse2.cusparseCgtsv_nopivotNative(handle, m, n, dl, d, du, B, ldb));
    }

    private static native int cusparseCgtsv_nopivotNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7);

    public static int cusparseZgtsv_nopivot(cusparseHandle handle, int m, int n, Pointer dl, Pointer d, Pointer du, Pointer B, int ldb) {
        return JCusparse2.checkResult(JCusparse2.cusparseZgtsv_nopivotNative(handle, m, n, dl, d, du, B, ldb));
    }

    private static native int cusparseZgtsv_nopivotNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7);

    public static int cusparseSgtsvStridedBatch(cusparseHandle handle, int m, Pointer dl, Pointer d, Pointer du, Pointer x, int batchCount, int batchStride) {
        return JCusparse2.checkResult(JCusparse2.cusparseSgtsvStridedBatchNative(handle, m, dl, d, du, x, batchCount, batchStride));
    }

    private static native int cusparseSgtsvStridedBatchNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, int var6, int var7);

    public static int cusparseDgtsvStridedBatch(cusparseHandle handle, int m, Pointer dl, Pointer d, Pointer du, Pointer x, int batchCount, int batchStride) {
        return JCusparse2.checkResult(JCusparse2.cusparseDgtsvStridedBatchNative(handle, m, dl, d, du, x, batchCount, batchStride));
    }

    private static native int cusparseDgtsvStridedBatchNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, int var6, int var7);

    public static int cusparseCgtsvStridedBatch(cusparseHandle handle, int m, Pointer dl, Pointer d, Pointer du, Pointer x, int batchCount, int batchStride) {
        return JCusparse2.checkResult(JCusparse2.cusparseCgtsvStridedBatchNative(handle, m, dl, d, du, x, batchCount, batchStride));
    }

    private static native int cusparseCgtsvStridedBatchNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, int var6, int var7);

    public static int cusparseZgtsvStridedBatch(cusparseHandle handle, int m, Pointer dl, Pointer d, Pointer du, Pointer x, int batchCount, int batchStride) {
        return JCusparse2.checkResult(JCusparse2.cusparseZgtsvStridedBatchNative(handle, m, dl, d, du, x, batchCount, batchStride));
    }

    private static native int cusparseZgtsvStridedBatchNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, int var6, int var7);

    public static int cusparseXcsrgemmNnz(cusparseHandle handle, int transA, int transB, int m, int n, int k, cusparseMatDescr descrA, int nnzA, Pointer csrRowPtrA, Pointer csrColIndA, cusparseMatDescr descrB, int nnzB, Pointer csrRowPtrB, Pointer csrColIndB, cusparseMatDescr descrC, Pointer csrRowPtrC, Pointer nnzTotalDevHostPtr) {
        return JCusparse2.checkResult(JCusparse2.cusparseXcsrgemmNnzNative(handle, transA, transB, m, n, k, descrA, nnzA, csrRowPtrA, csrColIndA, descrB, nnzB, csrRowPtrB, csrColIndB, descrC, csrRowPtrC, nnzTotalDevHostPtr));
    }

    private static native int cusparseXcsrgemmNnzNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, cusparseMatDescr var6, int var7, Pointer var8, Pointer var9, cusparseMatDescr var10, int var11, Pointer var12, Pointer var13, cusparseMatDescr var14, Pointer var15, Pointer var16);

    public static int cusparseScsrgemm(cusparseHandle handle, int transA, int transB, int m, int n, int k, cusparseMatDescr descrA, int nnzA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, cusparseMatDescr descrB, int nnzB, Pointer csrValB, Pointer csrRowPtrB, Pointer csrColIndB, cusparseMatDescr descrC, Pointer csrValC, Pointer csrRowPtrC, Pointer csrColIndC) {
        return JCusparse2.checkResult(JCusparse2.cusparseScsrgemmNative(handle, transA, transB, m, n, k, descrA, nnzA, csrValA, csrRowPtrA, csrColIndA, descrB, nnzB, csrValB, csrRowPtrB, csrColIndB, descrC, csrValC, csrRowPtrC, csrColIndC));
    }

    private static native int cusparseScsrgemmNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, cusparseMatDescr var6, int var7, Pointer var8, Pointer var9, Pointer var10, cusparseMatDescr var11, int var12, Pointer var13, Pointer var14, Pointer var15, cusparseMatDescr var16, Pointer var17, Pointer var18, Pointer var19);

    public static int cusparseDcsrgemm(cusparseHandle handle, int transA, int transB, int m, int n, int k, cusparseMatDescr descrA, int nnzA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, cusparseMatDescr descrB, int nnzB, Pointer csrValB, Pointer csrRowPtrB, Pointer csrColIndB, cusparseMatDescr descrC, Pointer csrValC, Pointer csrRowPtrC, Pointer csrColIndC) {
        return JCusparse2.checkResult(JCusparse2.cusparseDcsrgemmNative(handle, transA, transB, m, n, k, descrA, nnzA, csrValA, csrRowPtrA, csrColIndA, descrB, nnzB, csrValB, csrRowPtrB, csrColIndB, descrC, csrValC, csrRowPtrC, csrColIndC));
    }

    private static native int cusparseDcsrgemmNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, cusparseMatDescr var6, int var7, Pointer var8, Pointer var9, Pointer var10, cusparseMatDescr var11, int var12, Pointer var13, Pointer var14, Pointer var15, cusparseMatDescr var16, Pointer var17, Pointer var18, Pointer var19);

    public static int cusparseCcsrgemm(cusparseHandle handle, int transA, int transB, int m, int n, int k, cusparseMatDescr descrA, int nnzA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, cusparseMatDescr descrB, int nnzB, Pointer csrValB, Pointer csrRowPtrB, Pointer csrColIndB, cusparseMatDescr descrC, Pointer csrValC, Pointer csrRowPtrC, Pointer csrColIndC) {
        return JCusparse2.checkResult(JCusparse2.cusparseCcsrgemmNative(handle, transA, transB, m, n, k, descrA, nnzA, csrValA, csrRowPtrA, csrColIndA, descrB, nnzB, csrValB, csrRowPtrB, csrColIndB, descrC, csrValC, csrRowPtrC, csrColIndC));
    }

    private static native int cusparseCcsrgemmNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, cusparseMatDescr var6, int var7, Pointer var8, Pointer var9, Pointer var10, cusparseMatDescr var11, int var12, Pointer var13, Pointer var14, Pointer var15, cusparseMatDescr var16, Pointer var17, Pointer var18, Pointer var19);

    public static int cusparseZcsrgemm(cusparseHandle handle, int transA, int transB, int m, int n, int k, cusparseMatDescr descrA, int nnzA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, cusparseMatDescr descrB, int nnzB, Pointer csrValB, Pointer csrRowPtrB, Pointer csrColIndB, cusparseMatDescr descrC, Pointer csrValC, Pointer csrRowPtrC, Pointer csrColIndC) {
        return JCusparse2.checkResult(JCusparse2.cusparseZcsrgemmNative(handle, transA, transB, m, n, k, descrA, nnzA, csrValA, csrRowPtrA, csrColIndA, descrB, nnzB, csrValB, csrRowPtrB, csrColIndB, descrC, csrValC, csrRowPtrC, csrColIndC));
    }

    private static native int cusparseZcsrgemmNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, cusparseMatDescr var6, int var7, Pointer var8, Pointer var9, Pointer var10, cusparseMatDescr var11, int var12, Pointer var13, Pointer var14, Pointer var15, cusparseMatDescr var16, Pointer var17, Pointer var18, Pointer var19);

    public static int cusparseXcsrgeamNnz(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, int nnzA, Pointer csrRowPtrA, Pointer csrColIndA, cusparseMatDescr descrB, int nnzB, Pointer csrRowPtrB, Pointer csrColIndB, cusparseMatDescr descrC, Pointer csrRowPtrC, Pointer nnzTotalDevHostPtr) {
        return JCusparse2.checkResult(JCusparse2.cusparseXcsrgeamNnzNative(handle, m, n, descrA, nnzA, csrRowPtrA, csrColIndA, descrB, nnzB, csrRowPtrB, csrColIndB, descrC, csrRowPtrC, nnzTotalDevHostPtr));
    }

    private static native int cusparseXcsrgeamNnzNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, int var4, Pointer var5, Pointer var6, cusparseMatDescr var7, int var8, Pointer var9, Pointer var10, cusparseMatDescr var11, Pointer var12, Pointer var13);

    public static int cusparseScsrgeam(cusparseHandle handle, int m, int n, Pointer alpha, cusparseMatDescr descrA, int nnzA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer beta, cusparseMatDescr descrB, int nnzB, Pointer csrValB, Pointer csrRowPtrB, Pointer csrColIndB, cusparseMatDescr descrC, Pointer csrValC, Pointer csrRowPtrC, Pointer csrColIndC) {
        return JCusparse2.checkResult(JCusparse2.cusparseScsrgeamNative(handle, m, n, alpha, descrA, nnzA, csrValA, csrRowPtrA, csrColIndA, beta, descrB, nnzB, csrValB, csrRowPtrB, csrColIndB, descrC, csrValC, csrRowPtrC, csrColIndC));
    }

    private static native int cusparseScsrgeamNative(cusparseHandle var0, int var1, int var2, Pointer var3, cusparseMatDescr var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, cusparseMatDescr var10, int var11, Pointer var12, Pointer var13, Pointer var14, cusparseMatDescr var15, Pointer var16, Pointer var17, Pointer var18);

    public static int cusparseDcsrgeam(cusparseHandle handle, int m, int n, Pointer alpha, cusparseMatDescr descrA, int nnzA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer beta, cusparseMatDescr descrB, int nnzB, Pointer csrValB, Pointer csrRowPtrB, Pointer csrColIndB, cusparseMatDescr descrC, Pointer csrValC, Pointer csrRowPtrC, Pointer csrColIndC) {
        return JCusparse2.checkResult(JCusparse2.cusparseDcsrgeamNative(handle, m, n, alpha, descrA, nnzA, csrValA, csrRowPtrA, csrColIndA, beta, descrB, nnzB, csrValB, csrRowPtrB, csrColIndB, descrC, csrValC, csrRowPtrC, csrColIndC));
    }

    private static native int cusparseDcsrgeamNative(cusparseHandle var0, int var1, int var2, Pointer var3, cusparseMatDescr var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, cusparseMatDescr var10, int var11, Pointer var12, Pointer var13, Pointer var14, cusparseMatDescr var15, Pointer var16, Pointer var17, Pointer var18);

    public static int cusparseCcsrgeam(cusparseHandle handle, int m, int n, Pointer alpha, cusparseMatDescr descrA, int nnzA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer beta, cusparseMatDescr descrB, int nnzB, Pointer csrValB, Pointer csrRowPtrB, Pointer csrColIndB, cusparseMatDescr descrC, Pointer csrValC, Pointer csrRowPtrC, Pointer csrColIndC) {
        return JCusparse2.checkResult(JCusparse2.cusparseCcsrgeamNative(handle, m, n, alpha, descrA, nnzA, csrValA, csrRowPtrA, csrColIndA, beta, descrB, nnzB, csrValB, csrRowPtrB, csrColIndB, descrC, csrValC, csrRowPtrC, csrColIndC));
    }

    private static native int cusparseCcsrgeamNative(cusparseHandle var0, int var1, int var2, Pointer var3, cusparseMatDescr var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, cusparseMatDescr var10, int var11, Pointer var12, Pointer var13, Pointer var14, cusparseMatDescr var15, Pointer var16, Pointer var17, Pointer var18);

    public static int cusparseZcsrgeam(cusparseHandle handle, int m, int n, Pointer alpha, cusparseMatDescr descrA, int nnzA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer beta, cusparseMatDescr descrB, int nnzB, Pointer csrValB, Pointer csrRowPtrB, Pointer csrColIndB, cusparseMatDescr descrC, Pointer csrValC, Pointer csrRowPtrC, Pointer csrColIndC) {
        return JCusparse2.checkResult(JCusparse2.cusparseZcsrgeamNative(handle, m, n, alpha, descrA, nnzA, csrValA, csrRowPtrA, csrColIndA, beta, descrB, nnzB, csrValB, csrRowPtrB, csrColIndB, descrC, csrValC, csrRowPtrC, csrColIndC));
    }

    private static native int cusparseZcsrgeamNative(cusparseHandle var0, int var1, int var2, Pointer var3, cusparseMatDescr var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, cusparseMatDescr var10, int var11, Pointer var12, Pointer var13, Pointer var14, cusparseMatDescr var15, Pointer var16, Pointer var17, Pointer var18);

    public static int cusparseSnnz(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerRowCol, Pointer nnzTotalDevHostPtr) {
        return JCusparse2.checkResult(JCusparse2.cusparseSnnzNative(handle, dirA, m, n, descrA, A, lda, nnzPerRowCol, nnzTotalDevHostPtr));
    }

    private static native int cusparseSnnzNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, int var6, Pointer var7, Pointer var8);

    public static int cusparseDnnz(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerRowCol, Pointer nnzTotalDevHostPtr) {
        return JCusparse2.checkResult(JCusparse2.cusparseDnnzNative(handle, dirA, m, n, descrA, A, lda, nnzPerRowCol, nnzTotalDevHostPtr));
    }

    private static native int cusparseDnnzNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, int var6, Pointer var7, Pointer var8);

    public static int cusparseCnnz(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerRowCol, Pointer nnzTotalDevHostPtr) {
        return JCusparse2.checkResult(JCusparse2.cusparseCnnzNative(handle, dirA, m, n, descrA, A, lda, nnzPerRowCol, nnzTotalDevHostPtr));
    }

    private static native int cusparseCnnzNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, int var6, Pointer var7, Pointer var8);

    public static int cusparseZnnz(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerRowCol, Pointer nnzTotalDevHostPtr) {
        return JCusparse2.checkResult(JCusparse2.cusparseZnnzNative(handle, dirA, m, n, descrA, A, lda, nnzPerRowCol, nnzTotalDevHostPtr));
    }

    private static native int cusparseZnnzNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, int var6, Pointer var7, Pointer var8);

    public static int cusparseSdense2csr(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerRow, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA) {
        return JCusparse2.checkResult(JCusparse2.cusparseSdense2csrNative(handle, m, n, descrA, A, lda, nnzPerRow, csrValA, csrRowPtrA, csrColIndA));
    }

    private static native int cusparseSdense2csrNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9);

    public static int cusparseDdense2csr(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerRow, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA) {
        return JCusparse2.checkResult(JCusparse2.cusparseDdense2csrNative(handle, m, n, descrA, A, lda, nnzPerRow, csrValA, csrRowPtrA, csrColIndA));
    }

    private static native int cusparseDdense2csrNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9);

    public static int cusparseCdense2csr(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerRow, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA) {
        return JCusparse2.checkResult(JCusparse2.cusparseCdense2csrNative(handle, m, n, descrA, A, lda, nnzPerRow, csrValA, csrRowPtrA, csrColIndA));
    }

    private static native int cusparseCdense2csrNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9);

    public static int cusparseZdense2csr(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerRow, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA) {
        return JCusparse2.checkResult(JCusparse2.cusparseZdense2csrNative(handle, m, n, descrA, A, lda, nnzPerRow, csrValA, csrRowPtrA, csrColIndA));
    }

    private static native int cusparseZdense2csrNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9);

    public static int cusparseScsr2dense(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer A, int lda) {
        return JCusparse2.checkResult(JCusparse2.cusparseScsr2denseNative(handle, m, n, descrA, csrValA, csrRowPtrA, csrColIndA, A, lda));
    }

    private static native int cusparseScsr2denseNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, int var8);

    public static int cusparseDcsr2dense(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer A, int lda) {
        return JCusparse2.checkResult(JCusparse2.cusparseDcsr2denseNative(handle, m, n, descrA, csrValA, csrRowPtrA, csrColIndA, A, lda));
    }

    private static native int cusparseDcsr2denseNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, int var8);

    public static int cusparseCcsr2dense(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer A, int lda) {
        return JCusparse2.checkResult(JCusparse2.cusparseCcsr2denseNative(handle, m, n, descrA, csrValA, csrRowPtrA, csrColIndA, A, lda));
    }

    private static native int cusparseCcsr2denseNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, int var8);

    public static int cusparseZcsr2dense(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer A, int lda) {
        return JCusparse2.checkResult(JCusparse2.cusparseZcsr2denseNative(handle, m, n, descrA, csrValA, csrRowPtrA, csrColIndA, A, lda));
    }

    private static native int cusparseZcsr2denseNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, int var8);

    public static int cusparseSdense2csc(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerCol, Pointer cscValA, Pointer cscRowIndA, Pointer cscColPtrA) {
        return JCusparse2.checkResult(JCusparse2.cusparseSdense2cscNative(handle, m, n, descrA, A, lda, nnzPerCol, cscValA, cscRowIndA, cscColPtrA));
    }

    private static native int cusparseSdense2cscNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9);

    public static int cusparseDdense2csc(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerCol, Pointer cscValA, Pointer cscRowIndA, Pointer cscColPtrA) {
        return JCusparse2.checkResult(JCusparse2.cusparseDdense2cscNative(handle, m, n, descrA, A, lda, nnzPerCol, cscValA, cscRowIndA, cscColPtrA));
    }

    private static native int cusparseDdense2cscNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9);

    public static int cusparseCdense2csc(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerCol, Pointer cscValA, Pointer cscRowIndA, Pointer cscColPtrA) {
        return JCusparse2.checkResult(JCusparse2.cusparseCdense2cscNative(handle, m, n, descrA, A, lda, nnzPerCol, cscValA, cscRowIndA, cscColPtrA));
    }

    private static native int cusparseCdense2cscNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9);

    public static int cusparseZdense2csc(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerCol, Pointer cscValA, Pointer cscRowIndA, Pointer cscColPtrA) {
        return JCusparse2.checkResult(JCusparse2.cusparseZdense2cscNative(handle, m, n, descrA, A, lda, nnzPerCol, cscValA, cscRowIndA, cscColPtrA));
    }

    private static native int cusparseZdense2cscNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9);

    public static int cusparseScsc2dense(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer cscValA, Pointer cscRowIndA, Pointer cscColPtrA, Pointer A, int lda) {
        return JCusparse2.checkResult(JCusparse2.cusparseScsc2denseNative(handle, m, n, descrA, cscValA, cscRowIndA, cscColPtrA, A, lda));
    }

    private static native int cusparseScsc2denseNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, int var8);

    public static int cusparseDcsc2dense(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer cscValA, Pointer cscRowIndA, Pointer cscColPtrA, Pointer A, int lda) {
        return JCusparse2.checkResult(JCusparse2.cusparseDcsc2denseNative(handle, m, n, descrA, cscValA, cscRowIndA, cscColPtrA, A, lda));
    }

    private static native int cusparseDcsc2denseNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, int var8);

    public static int cusparseCcsc2dense(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer cscValA, Pointer cscRowIndA, Pointer cscColPtrA, Pointer A, int lda) {
        return JCusparse2.checkResult(JCusparse2.cusparseCcsc2denseNative(handle, m, n, descrA, cscValA, cscRowIndA, cscColPtrA, A, lda));
    }

    private static native int cusparseCcsc2denseNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, int var8);

    public static int cusparseZcsc2dense(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer cscValA, Pointer cscRowIndA, Pointer cscColPtrA, Pointer A, int lda) {
        return JCusparse2.checkResult(JCusparse2.cusparseZcsc2denseNative(handle, m, n, descrA, cscValA, cscRowIndA, cscColPtrA, A, lda));
    }

    private static native int cusparseZcsc2denseNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, int var8);

    public static int cusparseXcoo2csr(cusparseHandle handle, Pointer cooRowInd, int nnz, int m, Pointer csrRowPtr, int idxBase) {
        return JCusparse2.checkResult(JCusparse2.cusparseXcoo2csrNative(handle, cooRowInd, nnz, m, csrRowPtr, idxBase));
    }

    private static native int cusparseXcoo2csrNative(cusparseHandle var0, Pointer var1, int var2, int var3, Pointer var4, int var5);

    public static int cusparseXcsr2coo(cusparseHandle handle, Pointer csrRowPtr, int nnz, int m, Pointer cooRowInd, int idxBase) {
        return JCusparse2.checkResult(JCusparse2.cusparseXcsr2cooNative(handle, csrRowPtr, nnz, m, cooRowInd, idxBase));
    }

    private static native int cusparseXcsr2cooNative(cusparseHandle var0, Pointer var1, int var2, int var3, Pointer var4, int var5);

    public static int cusparseScsr2csc(cusparseHandle handle, int m, int n, int nnz, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, Pointer cscVal, Pointer cscRowInd, Pointer cscColPtr, int copyValues, int idxBase) {
        return JCusparse2.checkResult(JCusparse2.cusparseScsr2cscNative(handle, m, n, nnz, csrVal, csrRowPtr, csrColInd, cscVal, cscRowInd, cscColPtr, copyValues, idxBase));
    }

    private static native int cusparseScsr2cscNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, int var10, int var11);

    public static int cusparseDcsr2csc(cusparseHandle handle, int m, int n, int nnz, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, Pointer cscVal, Pointer cscRowInd, Pointer cscColPtr, int copyValues, int idxBase) {
        return JCusparse2.checkResult(JCusparse2.cusparseDcsr2cscNative(handle, m, n, nnz, csrVal, csrRowPtr, csrColInd, cscVal, cscRowInd, cscColPtr, copyValues, idxBase));
    }

    private static native int cusparseDcsr2cscNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, int var10, int var11);

    public static int cusparseCcsr2csc(cusparseHandle handle, int m, int n, int nnz, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, Pointer cscVal, Pointer cscRowInd, Pointer cscColPtr, int copyValues, int idxBase) {
        return JCusparse2.checkResult(JCusparse2.cusparseCcsr2cscNative(handle, m, n, nnz, csrVal, csrRowPtr, csrColInd, cscVal, cscRowInd, cscColPtr, copyValues, idxBase));
    }

    private static native int cusparseCcsr2cscNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, int var10, int var11);

    public static int cusparseZcsr2csc(cusparseHandle handle, int m, int n, int nnz, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, Pointer cscVal, Pointer cscRowInd, Pointer cscColPtr, int copyValues, int idxBase) {
        return JCusparse2.checkResult(JCusparse2.cusparseZcsr2cscNative(handle, m, n, nnz, csrVal, csrRowPtr, csrColInd, cscVal, cscRowInd, cscColPtr, copyValues, idxBase));
    }

    private static native int cusparseZcsr2cscNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, int var10, int var11);

    public static int cusparseSdense2hyb(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerRow, cusparseHybMat hybA, int userEllWidth, int partitionType) {
        return JCusparse2.checkResult(JCusparse2.cusparseSdense2hybNative(handle, m, n, descrA, A, lda, nnzPerRow, hybA, userEllWidth, partitionType));
    }

    private static native int cusparseSdense2hybNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, int var5, Pointer var6, cusparseHybMat var7, int var8, int var9);

    public static int cusparseDdense2hyb(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerRow, cusparseHybMat hybA, int userEllWidth, int partitionType) {
        return JCusparse2.checkResult(JCusparse2.cusparseDdense2hybNative(handle, m, n, descrA, A, lda, nnzPerRow, hybA, userEllWidth, partitionType));
    }

    private static native int cusparseDdense2hybNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, int var5, Pointer var6, cusparseHybMat var7, int var8, int var9);

    public static int cusparseCdense2hyb(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerRow, cusparseHybMat hybA, int userEllWidth, int partitionType) {
        return JCusparse2.checkResult(JCusparse2.cusparseCdense2hybNative(handle, m, n, descrA, A, lda, nnzPerRow, hybA, userEllWidth, partitionType));
    }

    private static native int cusparseCdense2hybNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, int var5, Pointer var6, cusparseHybMat var7, int var8, int var9);

    public static int cusparseZdense2hyb(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerRow, cusparseHybMat hybA, int userEllWidth, int partitionType) {
        return JCusparse2.checkResult(JCusparse2.cusparseZdense2hybNative(handle, m, n, descrA, A, lda, nnzPerRow, hybA, userEllWidth, partitionType));
    }

    private static native int cusparseZdense2hybNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, int var5, Pointer var6, cusparseHybMat var7, int var8, int var9);

    public static int cusparseShyb2dense(cusparseHandle handle, cusparseMatDescr descrA, cusparseHybMat hybA, Pointer A, int lda) {
        return JCusparse2.checkResult(JCusparse2.cusparseShyb2denseNative(handle, descrA, hybA, A, lda));
    }

    private static native int cusparseShyb2denseNative(cusparseHandle var0, cusparseMatDescr var1, cusparseHybMat var2, Pointer var3, int var4);

    public static int cusparseDhyb2dense(cusparseHandle handle, cusparseMatDescr descrA, cusparseHybMat hybA, Pointer A, int lda) {
        return JCusparse2.checkResult(JCusparse2.cusparseDhyb2denseNative(handle, descrA, hybA, A, lda));
    }

    private static native int cusparseDhyb2denseNative(cusparseHandle var0, cusparseMatDescr var1, cusparseHybMat var2, Pointer var3, int var4);

    public static int cusparseChyb2dense(cusparseHandle handle, cusparseMatDescr descrA, cusparseHybMat hybA, Pointer A, int lda) {
        return JCusparse2.checkResult(JCusparse2.cusparseChyb2denseNative(handle, descrA, hybA, A, lda));
    }

    private static native int cusparseChyb2denseNative(cusparseHandle var0, cusparseMatDescr var1, cusparseHybMat var2, Pointer var3, int var4);

    public static int cusparseZhyb2dense(cusparseHandle handle, cusparseMatDescr descrA, cusparseHybMat hybA, Pointer A, int lda) {
        return JCusparse2.checkResult(JCusparse2.cusparseZhyb2denseNative(handle, descrA, hybA, A, lda));
    }

    private static native int cusparseZhyb2denseNative(cusparseHandle var0, cusparseMatDescr var1, cusparseHybMat var2, Pointer var3, int var4);

    public static int cusparseScsr2hyb(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, cusparseHybMat hybA, int userEllWidth, int partitionType) {
        return JCusparse2.checkResult(JCusparse2.cusparseScsr2hybNative(handle, m, n, descrA, csrValA, csrRowPtrA, csrColIndA, hybA, userEllWidth, partitionType));
    }

    private static native int cusparseScsr2hybNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, cusparseHybMat var7, int var8, int var9);

    public static int cusparseDcsr2hyb(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, cusparseHybMat hybA, int userEllWidth, int partitionType) {
        return JCusparse2.checkResult(JCusparse2.cusparseDcsr2hybNative(handle, m, n, descrA, csrValA, csrRowPtrA, csrColIndA, hybA, userEllWidth, partitionType));
    }

    private static native int cusparseDcsr2hybNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, cusparseHybMat var7, int var8, int var9);

    public static int cusparseCcsr2hyb(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, cusparseHybMat hybA, int userEllWidth, int partitionType) {
        return JCusparse2.checkResult(JCusparse2.cusparseCcsr2hybNative(handle, m, n, descrA, csrValA, csrRowPtrA, csrColIndA, hybA, userEllWidth, partitionType));
    }

    private static native int cusparseCcsr2hybNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, cusparseHybMat var7, int var8, int var9);

    public static int cusparseZcsr2hyb(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, cusparseHybMat hybA, int userEllWidth, int partitionType) {
        return JCusparse2.checkResult(JCusparse2.cusparseZcsr2hybNative(handle, m, n, descrA, csrValA, csrRowPtrA, csrColIndA, hybA, userEllWidth, partitionType));
    }

    private static native int cusparseZcsr2hybNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, cusparseHybMat var7, int var8, int var9);

    public static int cusparseShyb2csr(cusparseHandle handle, cusparseMatDescr descrA, cusparseHybMat hybA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA) {
        return JCusparse2.checkResult(JCusparse2.cusparseShyb2csrNative(handle, descrA, hybA, csrValA, csrRowPtrA, csrColIndA));
    }

    private static native int cusparseShyb2csrNative(cusparseHandle var0, cusparseMatDescr var1, cusparseHybMat var2, Pointer var3, Pointer var4, Pointer var5);

    public static int cusparseDhyb2csr(cusparseHandle handle, cusparseMatDescr descrA, cusparseHybMat hybA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA) {
        return JCusparse2.checkResult(JCusparse2.cusparseDhyb2csrNative(handle, descrA, hybA, csrValA, csrRowPtrA, csrColIndA));
    }

    private static native int cusparseDhyb2csrNative(cusparseHandle var0, cusparseMatDescr var1, cusparseHybMat var2, Pointer var3, Pointer var4, Pointer var5);

    public static int cusparseChyb2csr(cusparseHandle handle, cusparseMatDescr descrA, cusparseHybMat hybA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA) {
        return JCusparse2.checkResult(JCusparse2.cusparseChyb2csrNative(handle, descrA, hybA, csrValA, csrRowPtrA, csrColIndA));
    }

    private static native int cusparseChyb2csrNative(cusparseHandle var0, cusparseMatDescr var1, cusparseHybMat var2, Pointer var3, Pointer var4, Pointer var5);

    public static int cusparseZhyb2csr(cusparseHandle handle, cusparseMatDescr descrA, cusparseHybMat hybA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA) {
        return JCusparse2.checkResult(JCusparse2.cusparseZhyb2csrNative(handle, descrA, hybA, csrValA, csrRowPtrA, csrColIndA));
    }

    private static native int cusparseZhyb2csrNative(cusparseHandle var0, cusparseMatDescr var1, cusparseHybMat var2, Pointer var3, Pointer var4, Pointer var5);

    public static int cusparseScsc2hyb(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer cscValA, Pointer cscRowIndA, Pointer cscColPtrA, cusparseHybMat hybA, int userEllWidth, int partitionType) {
        return JCusparse2.checkResult(JCusparse2.cusparseScsc2hybNative(handle, m, n, descrA, cscValA, cscRowIndA, cscColPtrA, hybA, userEllWidth, partitionType));
    }

    private static native int cusparseScsc2hybNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, cusparseHybMat var7, int var8, int var9);

    public static int cusparseDcsc2hyb(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer cscValA, Pointer cscRowIndA, Pointer cscColPtrA, cusparseHybMat hybA, int userEllWidth, int partitionType) {
        return JCusparse2.checkResult(JCusparse2.cusparseDcsc2hybNative(handle, m, n, descrA, cscValA, cscRowIndA, cscColPtrA, hybA, userEllWidth, partitionType));
    }

    private static native int cusparseDcsc2hybNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, cusparseHybMat var7, int var8, int var9);

    public static int cusparseCcsc2hyb(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer cscValA, Pointer cscRowIndA, Pointer cscColPtrA, cusparseHybMat hybA, int userEllWidth, int partitionType) {
        return JCusparse2.checkResult(JCusparse2.cusparseCcsc2hybNative(handle, m, n, descrA, cscValA, cscRowIndA, cscColPtrA, hybA, userEllWidth, partitionType));
    }

    private static native int cusparseCcsc2hybNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, cusparseHybMat var7, int var8, int var9);

    public static int cusparseZcsc2hyb(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer cscValA, Pointer cscRowIndA, Pointer cscColPtrA, cusparseHybMat hybA, int userEllWidth, int partitionType) {
        return JCusparse2.checkResult(JCusparse2.cusparseZcsc2hybNative(handle, m, n, descrA, cscValA, cscRowIndA, cscColPtrA, hybA, userEllWidth, partitionType));
    }

    private static native int cusparseZcsc2hybNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, cusparseHybMat var7, int var8, int var9);

    public static int cusparseShyb2csc(cusparseHandle handle, cusparseMatDescr descrA, cusparseHybMat hybA, Pointer cscVal, Pointer cscRowInd, Pointer cscColPtr) {
        return JCusparse2.checkResult(JCusparse2.cusparseShyb2cscNative(handle, descrA, hybA, cscVal, cscRowInd, cscColPtr));
    }

    private static native int cusparseShyb2cscNative(cusparseHandle var0, cusparseMatDescr var1, cusparseHybMat var2, Pointer var3, Pointer var4, Pointer var5);

    public static int cusparseDhyb2csc(cusparseHandle handle, cusparseMatDescr descrA, cusparseHybMat hybA, Pointer cscVal, Pointer cscRowInd, Pointer cscColPtr) {
        return JCusparse2.checkResult(JCusparse2.cusparseDhyb2cscNative(handle, descrA, hybA, cscVal, cscRowInd, cscColPtr));
    }

    private static native int cusparseDhyb2cscNative(cusparseHandle var0, cusparseMatDescr var1, cusparseHybMat var2, Pointer var3, Pointer var4, Pointer var5);

    public static int cusparseChyb2csc(cusparseHandle handle, cusparseMatDescr descrA, cusparseHybMat hybA, Pointer cscVal, Pointer cscRowInd, Pointer cscColPtr) {
        return JCusparse2.checkResult(JCusparse2.cusparseChyb2cscNative(handle, descrA, hybA, cscVal, cscRowInd, cscColPtr));
    }

    private static native int cusparseChyb2cscNative(cusparseHandle var0, cusparseMatDescr var1, cusparseHybMat var2, Pointer var3, Pointer var4, Pointer var5);

    public static int cusparseZhyb2csc(cusparseHandle handle, cusparseMatDescr descrA, cusparseHybMat hybA, Pointer cscVal, Pointer cscRowInd, Pointer cscColPtr) {
        return JCusparse2.checkResult(JCusparse2.cusparseZhyb2cscNative(handle, descrA, hybA, cscVal, cscRowInd, cscColPtr));
    }

    private static native int cusparseZhyb2cscNative(cusparseHandle var0, cusparseMatDescr var1, cusparseHybMat var2, Pointer var3, Pointer var4, Pointer var5);

    public static int cusparseXcsr2bsrNnz(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer csrRowPtrA, Pointer csrColIndA, int blockDim, cusparseMatDescr descrC, Pointer bsrRowPtrC, Pointer nnzTotalDevHostPtr) {
        return JCusparse2.checkResult(JCusparse2.cusparseXcsr2bsrNnzNative(handle, dirA, m, n, descrA, csrRowPtrA, csrColIndA, blockDim, descrC, bsrRowPtrC, nnzTotalDevHostPtr));
    }

    private static native int cusparseXcsr2bsrNnzNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, int var7, cusparseMatDescr var8, Pointer var9, Pointer var10);

    public static int cusparseScsr2bsr(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, int blockDim, cusparseMatDescr descrC, Pointer bsrValC, Pointer bsrRowPtrC, Pointer bsrColIndC) {
        return JCusparse2.checkResult(JCusparse2.cusparseScsr2bsrNative(handle, dirA, m, n, descrA, csrValA, csrRowPtrA, csrColIndA, blockDim, descrC, bsrValC, bsrRowPtrC, bsrColIndC));
    }

    private static native int cusparseScsr2bsrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, cusparseMatDescr var9, Pointer var10, Pointer var11, Pointer var12);

    public static int cusparseDcsr2bsr(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, int blockDim, cusparseMatDescr descrC, Pointer bsrValC, Pointer bsrRowPtrC, Pointer bsrColIndC) {
        return JCusparse2.checkResult(JCusparse2.cusparseDcsr2bsrNative(handle, dirA, m, n, descrA, csrValA, csrRowPtrA, csrColIndA, blockDim, descrC, bsrValC, bsrRowPtrC, bsrColIndC));
    }

    private static native int cusparseDcsr2bsrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, cusparseMatDescr var9, Pointer var10, Pointer var11, Pointer var12);

    public static int cusparseCcsr2bsr(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, int blockDim, cusparseMatDescr descrC, Pointer bsrValC, Pointer bsrRowPtrC, Pointer bsrColIndC) {
        return JCusparse2.checkResult(JCusparse2.cusparseCcsr2bsrNative(handle, dirA, m, n, descrA, csrValA, csrRowPtrA, csrColIndA, blockDim, descrC, bsrValC, bsrRowPtrC, bsrColIndC));
    }

    private static native int cusparseCcsr2bsrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, cusparseMatDescr var9, Pointer var10, Pointer var11, Pointer var12);

    public static int cusparseZcsr2bsr(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, int blockDim, cusparseMatDescr descrC, Pointer bsrValC, Pointer bsrRowPtrC, Pointer bsrColIndC) {
        return JCusparse2.checkResult(JCusparse2.cusparseZcsr2bsrNative(handle, dirA, m, n, descrA, csrValA, csrRowPtrA, csrColIndA, blockDim, descrC, bsrValC, bsrRowPtrC, bsrColIndC));
    }

    private static native int cusparseZcsr2bsrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, cusparseMatDescr var9, Pointer var10, Pointer var11, Pointer var12);

    public static int cusparseSbsr2csr(cusparseHandle handle, int dirA, int mb, int nb, cusparseMatDescr descrA, Pointer bsrValA, Pointer bsrRowPtrA, Pointer bsrColIndA, int blockDim, cusparseMatDescr descrC, Pointer csrValC, Pointer csrRowPtrC, Pointer csrColIndC) {
        return JCusparse2.checkResult(JCusparse2.cusparseSbsr2csrNative(handle, dirA, mb, nb, descrA, bsrValA, bsrRowPtrA, bsrColIndA, blockDim, descrC, csrValC, csrRowPtrC, csrColIndC));
    }

    private static native int cusparseSbsr2csrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, cusparseMatDescr var9, Pointer var10, Pointer var11, Pointer var12);

    public static int cusparseDbsr2csr(cusparseHandle handle, int dirA, int mb, int nb, cusparseMatDescr descrA, Pointer bsrValA, Pointer bsrRowPtrA, Pointer bsrColIndA, int blockDim, cusparseMatDescr descrC, Pointer csrValC, Pointer csrRowPtrC, Pointer csrColIndC) {
        return JCusparse2.checkResult(JCusparse2.cusparseDbsr2csrNative(handle, dirA, mb, nb, descrA, bsrValA, bsrRowPtrA, bsrColIndA, blockDim, descrC, csrValC, csrRowPtrC, csrColIndC));
    }

    private static native int cusparseDbsr2csrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, cusparseMatDescr var9, Pointer var10, Pointer var11, Pointer var12);

    public static int cusparseCbsr2csr(cusparseHandle handle, int dirA, int mb, int nb, cusparseMatDescr descrA, Pointer bsrValA, Pointer bsrRowPtrA, Pointer bsrColIndA, int blockDim, cusparseMatDescr descrC, Pointer csrValC, Pointer csrRowPtrC, Pointer csrColIndC) {
        return JCusparse2.checkResult(JCusparse2.cusparseCbsr2csrNative(handle, dirA, mb, nb, descrA, bsrValA, bsrRowPtrA, bsrColIndA, blockDim, descrC, csrValC, csrRowPtrC, csrColIndC));
    }

    private static native int cusparseCbsr2csrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, cusparseMatDescr var9, Pointer var10, Pointer var11, Pointer var12);

    public static int cusparseZbsr2csr(cusparseHandle handle, int dirA, int mb, int nb, cusparseMatDescr descrA, Pointer bsrValA, Pointer bsrRowPtrA, Pointer bsrColIndA, int blockDim, cusparseMatDescr descrC, Pointer csrValC, Pointer csrRowPtrC, Pointer csrColIndC) {
        return JCusparse2.checkResult(JCusparse2.cusparseZbsr2csrNative(handle, dirA, mb, nb, descrA, bsrValA, bsrRowPtrA, bsrColIndA, blockDim, descrC, csrValC, csrRowPtrC, csrColIndC));
    }

    private static native int cusparseZbsr2csrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, cusparseMatDescr var9, Pointer var10, Pointer var11, Pointer var12);
}

