/*
 * Decompiled with CFR 0.152.
 */
package jcuda;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;

public final class LibUtils {
    public static void loadLibrary(String baseName) {
        String libName = LibUtils.createLibName(baseName);
        Throwable throwable = null;
        boolean tryResource = true;
        try {
            LibUtils.loadLibraryResource(libName);
            return;
        }
        catch (Throwable t) {
            throwable = t;
            try {
                System.loadLibrary(libName);
                return;
            }
            catch (Throwable t2) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                pw.println("Error while loading native library \"" + libName + "\" with base name \"" + baseName + "\"");
                pw.println("Operating system name: " + System.getProperty("os.name"));
                pw.println("Architecture         : " + System.getProperty("os.arch"));
                pw.println("Architecture bit size: " + System.getProperty("sun.arch.data.model"));
                if (throwable != null) {
                    pw.println("Stack trace from the attempt to load the library as a resource:");
                    throwable.printStackTrace(pw);
                }
                pw.println("Stack trace from the attempt to load the library as a file:");
                t2.printStackTrace(pw);
                pw.flush();
                pw.close();
                throw new UnsatisfiedLinkError("Could not load the native library.\n" + sw.toString());
            }
        }
    }

    private static void loadLibraryResource(String libName) throws Throwable {
        String libPrefix = LibUtils.createLibPrefix();
        String libExtension = LibUtils.createLibExtension();
        String fullName = String.valueOf(libPrefix) + libName;
        String resourceName = "/lib/" + fullName + "." + libExtension;
        InputStream inputStream = LibUtils.class.getResourceAsStream(resourceName);
        if (inputStream == null) {
            throw new NullPointerException("No resource found with name '" + resourceName + "'");
        }
        File tempFile = File.createTempFile(fullName, "." + libExtension);
        tempFile.deleteOnExit();
        FileOutputStream outputStream = null;
        try {
            int read;
            outputStream = new FileOutputStream(tempFile);
            byte[] buffer = new byte[8192];
            while ((read = inputStream.read(buffer)) >= 0) {
                ((OutputStream)outputStream).write(buffer, 0, read);
            }
            outputStream.flush();
            ((OutputStream)outputStream).close();
            outputStream = null;
            System.load(tempFile.toString());
        }
        finally {
            if (outputStream != null) {
                ((OutputStream)outputStream).close();
            }
        }
    }

    private static String createLibExtension() {
        OSType osType = LibUtils.calculateOS();
        switch (osType) {
            case APPLE: {
                return "jnilib";
            }
            case LINUX: {
                return "so";
            }
            case SUN: {
                return "so";
            }
            case WINDOWS: {
                return "dll";
            }
        }
        return "";
    }

    private static String createLibPrefix() {
        OSType osType = LibUtils.calculateOS();
        switch (osType) {
            case APPLE: 
            case LINUX: 
            case SUN: {
                return "lib";
            }
            case WINDOWS: {
                return "";
            }
        }
        return "";
    }

    public static String createLibName(String baseName) {
        OSType osType = LibUtils.calculateOS();
        ARCHType archType = LibUtils.calculateArch();
        String libName = baseName;
        libName = String.valueOf(libName) + "-" + osType.toString().toLowerCase(Locale.ENGLISH);
        libName = String.valueOf(libName) + "-" + archType.toString().toLowerCase(Locale.ENGLISH);
        return libName;
    }

    public static OSType calculateOS() {
        String osName = System.getProperty("os.name");
        if ((osName = osName.toLowerCase(Locale.ENGLISH)).startsWith("mac os")) {
            return OSType.APPLE;
        }
        if (osName.startsWith("windows")) {
            return OSType.WINDOWS;
        }
        if (osName.startsWith("linux")) {
            return OSType.LINUX;
        }
        if (osName.startsWith("sun")) {
            return OSType.SUN;
        }
        return OSType.UNKNOWN;
    }

    public static ARCHType calculateArch() {
        String osArch = System.getProperty("os.arch");
        if ((osArch = osArch.toLowerCase(Locale.ENGLISH)).equals("i386") || osArch.equals("x86") || osArch.equals("i686")) {
            return ARCHType.X86;
        }
        if (osArch.startsWith("amd64") || osArch.startsWith("x86_64")) {
            return ARCHType.X86_64;
        }
        if (osArch.equals("ppc") || osArch.equals("powerpc")) {
            return ARCHType.PPC;
        }
        if (osArch.startsWith("ppc")) {
            return ARCHType.PPC_64;
        }
        if (osArch.startsWith("sparc")) {
            return ARCHType.SPARC;
        }
        if (osArch.startsWith("arm")) {
            return ARCHType.ARM;
        }
        if (osArch.startsWith("mips")) {
            return ARCHType.MIPS;
        }
        if (osArch.contains("risc")) {
            return ARCHType.RISC;
        }
        return ARCHType.UNKNOWN;
    }

    private LibUtils() {
    }

    public static enum ARCHType {
        PPC,
        PPC_64,
        SPARC,
        X86,
        X86_64,
        ARM,
        MIPS,
        RISC,
        UNKNOWN;

    }

    public static enum OSType {
        APPLE,
        LINUX,
        SUN,
        WINDOWS,
        UNKNOWN;

    }
}

