/*
 * JCufft - Java bindings for CUFFT, the NVIDIA CUDA FFT library,
 * to be used with JCuda
 *
 * Copyright (c) 2008-2013 Marco Hutter - http://www.jcuda.org
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

/* DO NOT EDIT THIS FILE - it is machine generated */
#include <jni.h>
/* Header for class jcuda_jcufft_JCufft */

#ifndef _Included_jcuda_jcufft_JCufft
#define _Included_jcuda_jcufft_JCufft
#ifdef __cplusplus
extern "C" {
#endif
#undef jcuda_jcufft_JCufft_CUFFT_FORWARD
#define jcuda_jcufft_JCufft_CUFFT_FORWARD -1L
#undef jcuda_jcufft_JCufft_CUFFT_INVERSE
#define jcuda_jcufft_JCufft_CUFFT_INVERSE 1L
/*
 * Class:     jcuda_jcufft_JCufft
 * Method:    setLogLevel
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcufft_JCufft_setLogLevel
  (JNIEnv *, jclass, jint);

/*
 * Class:     jcuda_jcufft_JCufft
 * Method:    cufftGetVersionNative
 * Signature: ([I)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcufft_JCufft_cufftGetVersionNative
  (JNIEnv *, jclass, jintArray);

/*
 * Class:     jcuda_jcufft_JCufft
 * Method:    cufftPlan1dNative
 * Signature: (Ljcuda/jcufft/cufftHandle;III)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcufft_JCufft_cufftPlan1dNative
  (JNIEnv *, jclass, jobject, jint, jint, jint);

/*
 * Class:     jcuda_jcufft_JCufft
 * Method:    cufftPlan2dNative
 * Signature: (Ljcuda/jcufft/cufftHandle;III)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcufft_JCufft_cufftPlan2dNative
  (JNIEnv *, jclass, jobject, jint, jint, jint);

/*
 * Class:     jcuda_jcufft_JCufft
 * Method:    cufftPlan3dNative
 * Signature: (Ljcuda/jcufft/cufftHandle;IIII)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcufft_JCufft_cufftPlan3dNative
  (JNIEnv *, jclass, jobject, jint, jint, jint, jint);

/*
 * Class:     jcuda_jcufft_JCufft
 * Method:    cufftPlanManyNative
 * Signature: (Ljcuda/jcufft/cufftHandle;I[I[III[IIIII)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcufft_JCufft_cufftPlanManyNative
  (JNIEnv *, jclass, jobject, jint, jintArray, jintArray, jint, jint, jintArray, jint, jint, jint, jint);

/*
 * Class:     jcuda_jcufft_JCufft
 * Method:    cufftMakePlan1dNative
 * Signature: (Ljcuda/jcufft/cufftHandle;III[J)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcufft_JCufft_cufftMakePlan1dNative
  (JNIEnv *, jclass, jobject, jint, jint, jint, jlongArray);

/*
 * Class:     jcuda_jcufft_JCufft
 * Method:    cufftMakePlan2dNative
 * Signature: (Ljcuda/jcufft/cufftHandle;III[J)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcufft_JCufft_cufftMakePlan2dNative
  (JNIEnv *, jclass, jobject, jint, jint, jint, jlongArray);

/*
 * Class:     jcuda_jcufft_JCufft
 * Method:    cufftMakePlan3dNative
 * Signature: (Ljcuda/jcufft/cufftHandle;IIII[J)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcufft_JCufft_cufftMakePlan3dNative
  (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jlongArray);

/*
 * Class:     jcuda_jcufft_JCufft
 * Method:    cufftMakePlanManyNative
 * Signature: (Ljcuda/jcufft/cufftHandle;I[I[III[IIIII[J)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcufft_JCufft_cufftMakePlanManyNative
  (JNIEnv *, jclass, jobject, jint, jintArray, jintArray, jint, jint, jintArray, jint, jint, jint, jint, jlongArray);

/*
 * Class:     jcuda_jcufft_JCufft
 * Method:    cufftEstimate1dNative
 * Signature: (III[J)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcufft_JCufft_cufftEstimate1dNative
  (JNIEnv *, jclass, jint, jint, jint, jlongArray);

/*
 * Class:     jcuda_jcufft_JCufft
 * Method:    cufftEstimate2dNative
 * Signature: (III[J)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcufft_JCufft_cufftEstimate2dNative
  (JNIEnv *, jclass, jint, jint, jint, jlongArray);

/*
 * Class:     jcuda_jcufft_JCufft
 * Method:    cufftEstimate3dNative
 * Signature: (IIII[J)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcufft_JCufft_cufftEstimate3dNative
  (JNIEnv *, jclass, jint, jint, jint, jint, jlongArray);

/*
 * Class:     jcuda_jcufft_JCufft
 * Method:    cufftEstimateManyNative
 * Signature: (I[I[III[IIIII[J)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcufft_JCufft_cufftEstimateManyNative
  (JNIEnv *, jclass, jint, jintArray, jintArray, jint, jint, jintArray, jint, jint, jint, jint, jlongArray);

/*
 * Class:     jcuda_jcufft_JCufft
 * Method:    cufftCreateNative
 * Signature: (Ljcuda/jcufft/cufftHandle;)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcufft_JCufft_cufftCreateNative
  (JNIEnv *, jclass, jobject);

/*
 * Class:     jcuda_jcufft_JCufft
 * Method:    cufftGetSize1dNative
 * Signature: (Ljcuda/jcufft/cufftHandle;III[J)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcufft_JCufft_cufftGetSize1dNative
  (JNIEnv *, jclass, jobject, jint, jint, jint, jlongArray);

/*
 * Class:     jcuda_jcufft_JCufft
 * Method:    cufftGetSize2dNative
 * Signature: (Ljcuda/jcufft/cufftHandle;III[J)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcufft_JCufft_cufftGetSize2dNative
  (JNIEnv *, jclass, jobject, jint, jint, jint, jlongArray);

/*
 * Class:     jcuda_jcufft_JCufft
 * Method:    cufftGetSize3dNative
 * Signature: (Ljcuda/jcufft/cufftHandle;IIII[J)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcufft_JCufft_cufftGetSize3dNative
  (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jlongArray);

/*
 * Class:     jcuda_jcufft_JCufft
 * Method:    cufftGetSizeManyNative
 * Signature: (Ljcuda/jcufft/cufftHandle;I[I[III[IIIII[J)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcufft_JCufft_cufftGetSizeManyNative
  (JNIEnv *, jclass, jobject, jint, jintArray, jintArray, jint, jint, jintArray, jint, jint, jint, jint, jlongArray);

/*
 * Class:     jcuda_jcufft_JCufft
 * Method:    cufftGetSizeNative
 * Signature: (Ljcuda/jcufft/cufftHandle;[J)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcufft_JCufft_cufftGetSizeNative
  (JNIEnv *, jclass, jobject, jlongArray);

/*
 * Class:     jcuda_jcufft_JCufft
 * Method:    cufftSetWorkAreaNative
 * Signature: (Ljcuda/jcufft/cufftHandle;Ljcuda/Pointer;)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcufft_JCufft_cufftSetWorkAreaNative
  (JNIEnv *, jclass, jobject, jobject);

/*
 * Class:     jcuda_jcufft_JCufft
 * Method:    cufftSetAutoAllocationNative
 * Signature: (Ljcuda/jcufft/cufftHandle;I)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcufft_JCufft_cufftSetAutoAllocationNative
  (JNIEnv *, jclass, jobject, jint);

/*
 * Class:     jcuda_jcufft_JCufft
 * Method:    cufftDestroyNative
 * Signature: (Ljcuda/jcufft/cufftHandle;)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcufft_JCufft_cufftDestroyNative
  (JNIEnv *, jclass, jobject);

/*
 * Class:     jcuda_jcufft_JCufft
 * Method:    cufftSetStreamNative
 * Signature: (Ljcuda/jcufft/cufftHandle;Ljcuda/runtime/cudaStream_t;)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcufft_JCufft_cufftSetStreamNative
  (JNIEnv *, jclass, jobject, jobject);

/*
 * Class:     jcuda_jcufft_JCufft
 * Method:    cufftSetCompatibilityModeNative
 * Signature: (Ljcuda/jcufft/cufftHandle;I)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcufft_JCufft_cufftSetCompatibilityModeNative
  (JNIEnv *, jclass, jobject, jint);

/*
 * Class:     jcuda_jcufft_JCufft
 * Method:    cufftExecC2CNative
 * Signature: (Ljcuda/jcufft/cufftHandle;Ljcuda/Pointer;Ljcuda/Pointer;I)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcufft_JCufft_cufftExecC2CNative
  (JNIEnv *, jclass, jobject, jobject, jobject, jint);

/*
 * Class:     jcuda_jcufft_JCufft
 * Method:    cufftExecR2CNative
 * Signature: (Ljcuda/jcufft/cufftHandle;Ljcuda/Pointer;Ljcuda/Pointer;)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcufft_JCufft_cufftExecR2CNative
  (JNIEnv *, jclass, jobject, jobject, jobject);

/*
 * Class:     jcuda_jcufft_JCufft
 * Method:    cufftExecC2RNative
 * Signature: (Ljcuda/jcufft/cufftHandle;Ljcuda/Pointer;Ljcuda/Pointer;)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcufft_JCufft_cufftExecC2RNative
  (JNIEnv *, jclass, jobject, jobject, jobject);

/*
 * Class:     jcuda_jcufft_JCufft
 * Method:    cufftExecZ2ZNative
 * Signature: (Ljcuda/jcufft/cufftHandle;Ljcuda/Pointer;Ljcuda/Pointer;I)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcufft_JCufft_cufftExecZ2ZNative
  (JNIEnv *, jclass, jobject, jobject, jobject, jint);

/*
 * Class:     jcuda_jcufft_JCufft
 * Method:    cufftExecD2ZNative
 * Signature: (Ljcuda/jcufft/cufftHandle;Ljcuda/Pointer;Ljcuda/Pointer;)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcufft_JCufft_cufftExecD2ZNative
  (JNIEnv *, jclass, jobject, jobject, jobject);

/*
 * Class:     jcuda_jcufft_JCufft
 * Method:    cufftExecZ2DNative
 * Signature: (Ljcuda/jcufft/cufftHandle;Ljcuda/Pointer;Ljcuda/Pointer;)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcufft_JCufft_cufftExecZ2DNative
  (JNIEnv *, jclass, jobject, jobject, jobject);

#ifdef __cplusplus
}
#endif
#endif
