/*
 * Decompiled with CFR 0.152.
 */
package jcuda.jcusolver;

import jcuda.CudaException;
import jcuda.LibUtils;
import jcuda.LogLevel;
import jcuda.jcusolver.cusolverStatus;

public class JCusolver {
    private static boolean initialized = false;
    private static boolean exceptionsEnabled = false;

    static {
        JCusolver.initialize();
    }

    private JCusolver() {
    }

    public static void initialize() {
        if (!initialized) {
            LibUtils.loadLibrary((String)"JCusolver");
            initialized = true;
        }
    }

    public static void setLogLevel(LogLevel logLevel) {
        JCusolver.setLogLevelNative(logLevel.ordinal());
    }

    private static native void setLogLevelNative(int var0);

    public static void setExceptionsEnabled(boolean enabled) {
        exceptionsEnabled = enabled;
    }

    static int checkResult(int result) {
        if (exceptionsEnabled && result != 0) {
            throw new CudaException(cusolverStatus.stringFor(result));
        }
        return result;
    }
}

