/*
 * JCublas - Java bindings for CUBLAS, the NVIDIA CUDA BLAS library,
 * to be used with JCuda
 *
 * Copyright (c) 2008-2012 Marco Hutter - http://www.jcuda.org
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

/* DO NOT EDIT THIS FILE - it is machine generated */
#include <jni.h>
/* Header for class jcuda_jcublas_JCublas */

#ifndef _Included_jcuda_jcublas_JCublas
#define _Included_jcuda_jcublas_JCublas
#ifdef __cplusplus
extern "C" {
#endif
/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    setLogLevelNative
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_setLogLevelNative
  (JNIEnv *, jclass, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasInitNative
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas_cublasInitNative
  (JNIEnv *, jclass);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasShutdownNative
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas_cublasShutdownNative
  (JNIEnv *, jclass);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasGetErrorNative
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas_cublasGetErrorNative
  (JNIEnv *, jclass);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasAllocNative
 * Signature: (IILjcuda/Pointer;)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas_cublasAllocNative
  (JNIEnv *, jclass, jint, jint, jobject);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasFreeNative
 * Signature: (Ljcuda/Pointer;)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas_cublasFreeNative
  (JNIEnv *, jclass, jobject);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    printVector
 * Signature: (ILjcuda/Pointer;)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_printVector
  (JNIEnv *, jclass, jint, jobject);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    printMatrix
 * Signature: (ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_printMatrix
  (JNIEnv *, jclass, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasSetVectorNative
 * Signature: (IILjcuda/Pointer;ILjcuda/Pointer;I)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas_cublasSetVectorNative
  (JNIEnv *, jclass, jint, jint, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasGetVectorNative
 * Signature: (IILjcuda/Pointer;ILjcuda/Pointer;I)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas_cublasGetVectorNative
  (JNIEnv *, jclass, jint, jint, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasSetMatrixNative
 * Signature: (IIILjcuda/Pointer;ILjcuda/Pointer;I)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas_cublasSetMatrixNative
  (JNIEnv *, jclass, jint, jint, jint, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasGetMatrixNative
 * Signature: (IIILjcuda/Pointer;ILjcuda/Pointer;I)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas_cublasGetMatrixNative
  (JNIEnv *, jclass, jint, jint, jint, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasSetVectorAsyncNative
 * Signature: (IILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/runtime/cudaStream_t;)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas_cublasSetVectorAsyncNative
  (JNIEnv *, jclass, jint, jint, jobject, jint, jobject, jint, jobject);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasGetVectorAsyncNative
 * Signature: (IILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/runtime/cudaStream_t;)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas_cublasGetVectorAsyncNative
  (JNIEnv *, jclass, jint, jint, jobject, jint, jobject, jint, jobject);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasSetMatrixAsyncNative
 * Signature: (IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/runtime/cudaStream_t;)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas_cublasSetMatrixAsyncNative
  (JNIEnv *, jclass, jint, jint, jint, jobject, jint, jobject, jint, jobject);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasGetMatrixAsyncNative
 * Signature: (IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/runtime/cudaStream_t;)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas_cublasGetMatrixAsyncNative
  (JNIEnv *, jclass, jint, jint, jint, jobject, jint, jobject, jint, jobject);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasSetKernelStreamNative
 * Signature: (Ljcuda/runtime/cudaStream_t;)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas_cublasSetKernelStreamNative
  (JNIEnv *, jclass, jobject);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasSrotmNative
 * Signature: (ILjcuda/Pointer;ILjcuda/Pointer;I[F)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasSrotmNative
  (JNIEnv *, jclass, jint, jobject, jint, jobject, jint, jfloatArray);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasSrotmgNative
 * Signature: ([F[F[FF[F)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasSrotmgNative
  (JNIEnv *, jclass, jfloatArray, jfloatArray, jfloatArray, jfloat, jfloatArray);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasDrotmNative
 * Signature: (ILjcuda/Pointer;ILjcuda/Pointer;I[D)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasDrotmNative
  (JNIEnv *, jclass, jint, jobject, jint, jobject, jint, jdoubleArray);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasDrotmgNative
 * Signature: ([D[D[DD[D)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasDrotmgNative
  (JNIEnv *, jclass, jdoubleArray, jdoubleArray, jdoubleArray, jdouble, jdoubleArray);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasIsamaxNative
 * Signature: (ILjcuda/Pointer;I)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas_cublasIsamaxNative
  (JNIEnv *, jclass, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasIsaminNative
 * Signature: (ILjcuda/Pointer;I)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas_cublasIsaminNative
  (JNIEnv *, jclass, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasSasumNative
 * Signature: (ILjcuda/Pointer;I)F
 */
JNIEXPORT jfloat JNICALL Java_jcuda_jcublas_JCublas_cublasSasumNative
  (JNIEnv *, jclass, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasSaxpyNative
 * Signature: (IFLjcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasSaxpyNative
  (JNIEnv *, jclass, jint, jfloat, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasScopyNative
 * Signature: (ILjcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasScopyNative
  (JNIEnv *, jclass, jint, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasSdotNative
 * Signature: (ILjcuda/Pointer;ILjcuda/Pointer;I)F
 */
JNIEXPORT jfloat JNICALL Java_jcuda_jcublas_JCublas_cublasSdotNative
  (JNIEnv *, jclass, jint, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasSnrm2Native
 * Signature: (ILjcuda/Pointer;I)F
 */
JNIEXPORT jfloat JNICALL Java_jcuda_jcublas_JCublas_cublasSnrm2Native
  (JNIEnv *, jclass, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasSrotNative
 * Signature: (ILjcuda/Pointer;ILjcuda/Pointer;IFF)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasSrotNative
  (JNIEnv *, jclass, jint, jobject, jint, jobject, jint, jfloat, jfloat);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasSrotgNative
 * Signature: (Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasSrotgNative
  (JNIEnv *, jclass, jobject, jobject, jobject, jobject);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasSscalNative
 * Signature: (IFLjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasSscalNative
  (JNIEnv *, jclass, jint, jfloat, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasSswapNative
 * Signature: (ILjcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasSswapNative
  (JNIEnv *, jclass, jint, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasCaxpyNative
 * Signature: (ILjcuda/cuComplex;Ljcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasCaxpyNative
  (JNIEnv *, jclass, jint, jobject, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasCcopyNative
 * Signature: (ILjcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasCcopyNative
  (JNIEnv *, jclass, jint, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasZcopyNative
 * Signature: (ILjcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasZcopyNative
  (JNIEnv *, jclass, jint, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasCscalNative
 * Signature: (ILjcuda/cuComplex;Ljcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasCscalNative
  (JNIEnv *, jclass, jint, jobject, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasCrotgNative
 * Signature: (Ljcuda/Pointer;Ljcuda/cuComplex;Ljcuda/Pointer;Ljcuda/Pointer;)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasCrotgNative
  (JNIEnv *, jclass, jobject, jobject, jobject, jobject);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasCrotNative
 * Signature: (ILjcuda/Pointer;ILjcuda/Pointer;IFLjcuda/cuComplex;)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasCrotNative
  (JNIEnv *, jclass, jint, jobject, jint, jobject, jint, jfloat, jobject);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasCsrotNative
 * Signature: (ILjcuda/Pointer;ILjcuda/Pointer;IFF)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasCsrotNative
  (JNIEnv *, jclass, jint, jobject, jint, jobject, jint, jfloat, jfloat);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasCsscalNative
 * Signature: (IFLjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasCsscalNative
  (JNIEnv *, jclass, jint, jfloat, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasCswapNative
 * Signature: (ILjcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasCswapNative
  (JNIEnv *, jclass, jint, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasZswapNative
 * Signature: (ILjcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasZswapNative
  (JNIEnv *, jclass, jint, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasCdotuNative
 * Signature: (ILjcuda/Pointer;ILjcuda/Pointer;I)Ljcuda/cuComplex;
 */
JNIEXPORT jobject JNICALL Java_jcuda_jcublas_JCublas_cublasCdotuNative
  (JNIEnv *, jclass, jint, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasCdotcNative
 * Signature: (ILjcuda/Pointer;ILjcuda/Pointer;I)Ljcuda/cuComplex;
 */
JNIEXPORT jobject JNICALL Java_jcuda_jcublas_JCublas_cublasCdotcNative
  (JNIEnv *, jclass, jint, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasIcamaxNative
 * Signature: (ILjcuda/Pointer;I)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas_cublasIcamaxNative
  (JNIEnv *, jclass, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasIcaminNative
 * Signature: (ILjcuda/Pointer;I)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas_cublasIcaminNative
  (JNIEnv *, jclass, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasScasumNative
 * Signature: (ILjcuda/Pointer;I)F
 */
JNIEXPORT jfloat JNICALL Java_jcuda_jcublas_JCublas_cublasScasumNative
  (JNIEnv *, jclass, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasScnrm2Native
 * Signature: (ILjcuda/Pointer;I)F
 */
JNIEXPORT jfloat JNICALL Java_jcuda_jcublas_JCublas_cublasScnrm2Native
  (JNIEnv *, jclass, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasZaxpyNative
 * Signature: (ILjcuda/cuDoubleComplex;Ljcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasZaxpyNative
  (JNIEnv *, jclass, jint, jobject, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasZdotuNative
 * Signature: (ILjcuda/Pointer;ILjcuda/Pointer;I)Ljcuda/cuDoubleComplex;
 */
JNIEXPORT jobject JNICALL Java_jcuda_jcublas_JCublas_cublasZdotuNative
  (JNIEnv *, jclass, jint, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasZdotcNative
 * Signature: (ILjcuda/Pointer;ILjcuda/Pointer;I)Ljcuda/cuDoubleComplex;
 */
JNIEXPORT jobject JNICALL Java_jcuda_jcublas_JCublas_cublasZdotcNative
  (JNIEnv *, jclass, jint, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasZscalNative
 * Signature: (ILjcuda/cuDoubleComplex;Ljcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasZscalNative
  (JNIEnv *, jclass, jint, jobject, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasZdscalNative
 * Signature: (IDLjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasZdscalNative
  (JNIEnv *, jclass, jint, jdouble, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasDznrm2Native
 * Signature: (ILjcuda/Pointer;I)D
 */
JNIEXPORT jdouble JNICALL Java_jcuda_jcublas_JCublas_cublasDznrm2Native
  (JNIEnv *, jclass, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasZrotgNative
 * Signature: (Ljcuda/Pointer;Ljcuda/cuDoubleComplex;Ljcuda/Pointer;Ljcuda/Pointer;)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasZrotgNative
  (JNIEnv *, jclass, jobject, jobject, jobject, jobject);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasZrotNative
 * Signature: (ILjcuda/Pointer;ILjcuda/Pointer;IDLjcuda/cuDoubleComplex;)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasZrotNative
  (JNIEnv *, jclass, jint, jobject, jint, jobject, jint, jdouble, jobject);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasZdrotNative
 * Signature: (ILjcuda/Pointer;ILjcuda/Pointer;IDD)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasZdrotNative
  (JNIEnv *, jclass, jint, jobject, jint, jobject, jint, jdouble, jdouble);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasIzamaxNative
 * Signature: (ILjcuda/Pointer;I)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas_cublasIzamaxNative
  (JNIEnv *, jclass, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasIzaminNative
 * Signature: (ILjcuda/Pointer;I)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas_cublasIzaminNative
  (JNIEnv *, jclass, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasDzasumNative
 * Signature: (ILjcuda/Pointer;I)D
 */
JNIEXPORT jdouble JNICALL Java_jcuda_jcublas_JCublas_cublasDzasumNative
  (JNIEnv *, jclass, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasSgbmvNative
 * Signature: (CIIIIFLjcuda/Pointer;ILjcuda/Pointer;IFLjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasSgbmvNative
  (JNIEnv *, jclass, jchar, jint, jint, jint, jint, jfloat, jobject, jint, jobject, jint, jfloat, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasSgemvNative
 * Signature: (CIIFLjcuda/Pointer;ILjcuda/Pointer;IFLjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasSgemvNative
  (JNIEnv *, jclass, jchar, jint, jint, jfloat, jobject, jint, jobject, jint, jfloat, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasSgerNative
 * Signature: (IIFLjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasSgerNative
  (JNIEnv *, jclass, jint, jint, jfloat, jobject, jint, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasSsbmvNative
 * Signature: (CIIFLjcuda/Pointer;ILjcuda/Pointer;IFLjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasSsbmvNative
  (JNIEnv *, jclass, jchar, jint, jint, jfloat, jobject, jint, jobject, jint, jfloat, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasSspmvNative
 * Signature: (CIFLjcuda/Pointer;Ljcuda/Pointer;IFLjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasSspmvNative
  (JNIEnv *, jclass, jchar, jint, jfloat, jobject, jobject, jint, jfloat, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasSsprNative
 * Signature: (CIFLjcuda/Pointer;ILjcuda/Pointer;)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasSsprNative
  (JNIEnv *, jclass, jchar, jint, jfloat, jobject, jint, jobject);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasSspr2Native
 * Signature: (CIFLjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasSspr2Native
  (JNIEnv *, jclass, jchar, jint, jfloat, jobject, jint, jobject, jint, jobject);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasSsymvNative
 * Signature: (CIFLjcuda/Pointer;ILjcuda/Pointer;IFLjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasSsymvNative
  (JNIEnv *, jclass, jchar, jint, jfloat, jobject, jint, jobject, jint, jfloat, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasSsyrNative
 * Signature: (CIFLjcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasSsyrNative
  (JNIEnv *, jclass, jchar, jint, jfloat, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasSsyr2Native
 * Signature: (CIFLjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasSsyr2Native
  (JNIEnv *, jclass, jchar, jint, jfloat, jobject, jint, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasStbmvNative
 * Signature: (CCCIILjcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasStbmvNative
  (JNIEnv *, jclass, jchar, jchar, jchar, jint, jint, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasStbsvNative
 * Signature: (CCCIILjcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasStbsvNative
  (JNIEnv *, jclass, jchar, jchar, jchar, jint, jint, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasStpmvNative
 * Signature: (CCCILjcuda/Pointer;Ljcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasStpmvNative
  (JNIEnv *, jclass, jchar, jchar, jchar, jint, jobject, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasStpsvNative
 * Signature: (CCCILjcuda/Pointer;Ljcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasStpsvNative
  (JNIEnv *, jclass, jchar, jchar, jchar, jint, jobject, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasStrmvNative
 * Signature: (CCCILjcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasStrmvNative
  (JNIEnv *, jclass, jchar, jchar, jchar, jint, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasStrsvNative
 * Signature: (CCCILjcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasStrsvNative
  (JNIEnv *, jclass, jchar, jchar, jchar, jint, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasZtrmvNative
 * Signature: (CCCILjcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasZtrmvNative
  (JNIEnv *, jclass, jchar, jchar, jchar, jint, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasZgbmvNative
 * Signature: (CIIIILjcuda/cuDoubleComplex;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/cuDoubleComplex;Ljcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasZgbmvNative
  (JNIEnv *, jclass, jchar, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasZtbmvNative
 * Signature: (CCCIILjcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasZtbmvNative
  (JNIEnv *, jclass, jchar, jchar, jchar, jint, jint, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasZtbsvNative
 * Signature: (CCCIILjcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasZtbsvNative
  (JNIEnv *, jclass, jchar, jchar, jchar, jint, jint, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasZhemvNative
 * Signature: (CILjcuda/cuDoubleComplex;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/cuDoubleComplex;Ljcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasZhemvNative
  (JNIEnv *, jclass, jchar, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasZhpmvNative
 * Signature: (CILjcuda/cuDoubleComplex;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/cuDoubleComplex;Ljcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasZhpmvNative
  (JNIEnv *, jclass, jchar, jint, jobject, jobject, jobject, jint, jobject, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasZgemvNative
 * Signature: (CIILjcuda/cuDoubleComplex;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/cuDoubleComplex;Ljcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasZgemvNative
  (JNIEnv *, jclass, jchar, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasZtpmvNative
 * Signature: (CCCILjcuda/Pointer;Ljcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasZtpmvNative
  (JNIEnv *, jclass, jchar, jchar, jchar, jint, jobject, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasZtpsvNative
 * Signature: (CCCILjcuda/Pointer;Ljcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasZtpsvNative
  (JNIEnv *, jclass, jchar, jchar, jchar, jint, jobject, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasCgemvNative
 * Signature: (CIILjcuda/cuComplex;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/cuComplex;Ljcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasCgemvNative
  (JNIEnv *, jclass, jchar, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasCgbmvNative
 * Signature: (CIIIILjcuda/cuComplex;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/cuComplex;Ljcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasCgbmvNative
  (JNIEnv *, jclass, jchar, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasChemvNative
 * Signature: (CILjcuda/cuComplex;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/cuComplex;Ljcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasChemvNative
  (JNIEnv *, jclass, jchar, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasChbmvNative
 * Signature: (CIILjcuda/cuComplex;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/cuComplex;Ljcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasChbmvNative
  (JNIEnv *, jclass, jchar, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasCtrmvNative
 * Signature: (CCCILjcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasCtrmvNative
  (JNIEnv *, jclass, jchar, jchar, jchar, jint, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasCtbmvNative
 * Signature: (CCCIILjcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasCtbmvNative
  (JNIEnv *, jclass, jchar, jchar, jchar, jint, jint, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasCtpmvNative
 * Signature: (CCCILjcuda/Pointer;Ljcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasCtpmvNative
  (JNIEnv *, jclass, jchar, jchar, jchar, jint, jobject, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasCtrsvNative
 * Signature: (CCCILjcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasCtrsvNative
  (JNIEnv *, jclass, jchar, jchar, jchar, jint, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasCtbsvNative
 * Signature: (CCCIILjcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasCtbsvNative
  (JNIEnv *, jclass, jchar, jchar, jchar, jint, jint, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasCtpsvNative
 * Signature: (CCCILjcuda/Pointer;Ljcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasCtpsvNative
  (JNIEnv *, jclass, jchar, jchar, jchar, jint, jobject, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasCgeruNative
 * Signature: (IILjcuda/cuComplex;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasCgeruNative
  (JNIEnv *, jclass, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasCgercNative
 * Signature: (IILjcuda/cuComplex;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasCgercNative
  (JNIEnv *, jclass, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasCherNative
 * Signature: (CIFLjcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasCherNative
  (JNIEnv *, jclass, jchar, jint, jfloat, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasChprNative
 * Signature: (CIFLjcuda/Pointer;ILjcuda/Pointer;)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasChprNative
  (JNIEnv *, jclass, jchar, jint, jfloat, jobject, jint, jobject);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasChpr2Native
 * Signature: (CILjcuda/cuComplex;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasChpr2Native
  (JNIEnv *, jclass, jchar, jint, jobject, jobject, jint, jobject, jint, jobject);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasCher2Native
 * Signature: (CILjcuda/cuComplex;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasCher2Native
  (JNIEnv *, jclass, jchar, jint, jobject, jobject, jint, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasSgemmNative
 * Signature: (CCIIIFLjcuda/Pointer;ILjcuda/Pointer;IFLjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasSgemmNative
  (JNIEnv *, jclass, jchar, jchar, jint, jint, jint, jfloat, jobject, jint, jobject, jint, jfloat, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasSsymmNative
 * Signature: (CCIIFLjcuda/Pointer;ILjcuda/Pointer;IFLjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasSsymmNative
  (JNIEnv *, jclass, jchar, jchar, jint, jint, jfloat, jobject, jint, jobject, jint, jfloat, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasSsyrkNative
 * Signature: (CCIIFLjcuda/Pointer;IFLjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasSsyrkNative
  (JNIEnv *, jclass, jchar, jchar, jint, jint, jfloat, jobject, jint, jfloat, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasSsyr2kNative
 * Signature: (CCIIFLjcuda/Pointer;ILjcuda/Pointer;IFLjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasSsyr2kNative
  (JNIEnv *, jclass, jchar, jchar, jint, jint, jfloat, jobject, jint, jobject, jint, jfloat, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasStrmmNative
 * Signature: (CCCCIIFLjcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasStrmmNative
  (JNIEnv *, jclass, jchar, jchar, jchar, jchar, jint, jint, jfloat, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasStrsmNative
 * Signature: (CCCCIIFLjcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasStrsmNative
  (JNIEnv *, jclass, jchar, jchar, jchar, jchar, jint, jint, jfloat, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasCgemmNative
 * Signature: (CCIIILjcuda/cuComplex;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/cuComplex;Ljcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasCgemmNative
  (JNIEnv *, jclass, jchar, jchar, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasCsymmNative
 * Signature: (CCIILjcuda/cuComplex;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/cuComplex;Ljcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasCsymmNative
  (JNIEnv *, jclass, jchar, jchar, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasChemmNative
 * Signature: (CCIILjcuda/cuComplex;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/cuComplex;Ljcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasChemmNative
  (JNIEnv *, jclass, jchar, jchar, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasCsyrkNative
 * Signature: (CCIILjcuda/cuComplex;Ljcuda/Pointer;ILjcuda/cuComplex;Ljcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasCsyrkNative
  (JNIEnv *, jclass, jchar, jchar, jint, jint, jobject, jobject, jint, jobject, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasCherkNative
 * Signature: (CCIIFLjcuda/Pointer;IFLjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasCherkNative
  (JNIEnv *, jclass, jchar, jchar, jint, jint, jfloat, jobject, jint, jfloat, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasCsyr2kNative
 * Signature: (CCIILjcuda/cuComplex;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/cuComplex;Ljcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasCsyr2kNative
  (JNIEnv *, jclass, jchar, jchar, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasCher2kNative
 * Signature: (CCIILjcuda/cuComplex;Ljcuda/Pointer;ILjcuda/Pointer;IFLjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasCher2kNative
  (JNIEnv *, jclass, jchar, jchar, jint, jint, jobject, jobject, jint, jobject, jint, jfloat, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasCtrmmNative
 * Signature: (CCCCIILjcuda/cuComplex;Ljcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasCtrmmNative
  (JNIEnv *, jclass, jchar, jchar, jchar, jchar, jint, jint, jobject, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasCtrsmNative
 * Signature: (CCCCIILjcuda/cuComplex;Ljcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasCtrsmNative
  (JNIEnv *, jclass, jchar, jchar, jchar, jchar, jint, jint, jobject, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasDasumNative
 * Signature: (ILjcuda/Pointer;I)D
 */
JNIEXPORT jdouble JNICALL Java_jcuda_jcublas_JCublas_cublasDasumNative
  (JNIEnv *, jclass, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasDaxpyNative
 * Signature: (IDLjcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasDaxpyNative
  (JNIEnv *, jclass, jint, jdouble, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasDcopyNative
 * Signature: (ILjcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasDcopyNative
  (JNIEnv *, jclass, jint, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasDdotNative
 * Signature: (ILjcuda/Pointer;ILjcuda/Pointer;I)D
 */
JNIEXPORT jdouble JNICALL Java_jcuda_jcublas_JCublas_cublasDdotNative
  (JNIEnv *, jclass, jint, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasDnrm2Native
 * Signature: (ILjcuda/Pointer;I)D
 */
JNIEXPORT jdouble JNICALL Java_jcuda_jcublas_JCublas_cublasDnrm2Native
  (JNIEnv *, jclass, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasDrotNative
 * Signature: (ILjcuda/Pointer;ILjcuda/Pointer;IDD)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasDrotNative
  (JNIEnv *, jclass, jint, jobject, jint, jobject, jint, jdouble, jdouble);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasDrotgNative
 * Signature: (Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasDrotgNative
  (JNIEnv *, jclass, jobject, jobject, jobject, jobject);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasDscalNative
 * Signature: (IDLjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasDscalNative
  (JNIEnv *, jclass, jint, jdouble, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasDswapNative
 * Signature: (ILjcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasDswapNative
  (JNIEnv *, jclass, jint, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasIdamaxNative
 * Signature: (ILjcuda/Pointer;I)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas_cublasIdamaxNative
  (JNIEnv *, jclass, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasIdaminNative
 * Signature: (ILjcuda/Pointer;I)I
 */
JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas_cublasIdaminNative
  (JNIEnv *, jclass, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasDgemvNative
 * Signature: (CIIDLjcuda/Pointer;ILjcuda/Pointer;IDLjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasDgemvNative
  (JNIEnv *, jclass, jchar, jint, jint, jdouble, jobject, jint, jobject, jint, jdouble, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasDgerNative
 * Signature: (IIDLjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasDgerNative
  (JNIEnv *, jclass, jint, jint, jdouble, jobject, jint, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasDsyrNative
 * Signature: (CIDLjcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasDsyrNative
  (JNIEnv *, jclass, jchar, jint, jdouble, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasDsyr2Native
 * Signature: (CIDLjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasDsyr2Native
  (JNIEnv *, jclass, jchar, jint, jdouble, jobject, jint, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasDsprNative
 * Signature: (CIDLjcuda/Pointer;ILjcuda/Pointer;)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasDsprNative
  (JNIEnv *, jclass, jchar, jint, jdouble, jobject, jint, jobject);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasDspr2Native
 * Signature: (CIDLjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasDspr2Native
  (JNIEnv *, jclass, jchar, jint, jdouble, jobject, jint, jobject, jint, jobject);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasDtrsvNative
 * Signature: (CCCILjcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasDtrsvNative
  (JNIEnv *, jclass, jchar, jchar, jchar, jint, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasDtrmvNative
 * Signature: (CCCILjcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasDtrmvNative
  (JNIEnv *, jclass, jchar, jchar, jchar, jint, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasDgbmvNative
 * Signature: (CIIIIDLjcuda/Pointer;ILjcuda/Pointer;IDLjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasDgbmvNative
  (JNIEnv *, jclass, jchar, jint, jint, jint, jint, jdouble, jobject, jint, jobject, jint, jdouble, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasDtbmvNative
 * Signature: (CCCIILjcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasDtbmvNative
  (JNIEnv *, jclass, jchar, jchar, jchar, jint, jint, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasDtpmvNative
 * Signature: (CCCILjcuda/Pointer;Ljcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasDtpmvNative
  (JNIEnv *, jclass, jchar, jchar, jchar, jint, jobject, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasDtpsvNative
 * Signature: (CCCILjcuda/Pointer;Ljcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasDtpsvNative
  (JNIEnv *, jclass, jchar, jchar, jchar, jint, jobject, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasDtbsvNative
 * Signature: (CCCIILjcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasDtbsvNative
  (JNIEnv *, jclass, jchar, jchar, jchar, jint, jint, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasDsymvNative
 * Signature: (CIDLjcuda/Pointer;ILjcuda/Pointer;IDLjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasDsymvNative
  (JNIEnv *, jclass, jchar, jint, jdouble, jobject, jint, jobject, jint, jdouble, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasDsbmvNative
 * Signature: (CIIDLjcuda/Pointer;ILjcuda/Pointer;IDLjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasDsbmvNative
  (JNIEnv *, jclass, jchar, jint, jint, jdouble, jobject, jint, jobject, jint, jdouble, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasDspmvNative
 * Signature: (CIDLjcuda/Pointer;Ljcuda/Pointer;IDLjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasDspmvNative
  (JNIEnv *, jclass, jchar, jint, jdouble, jobject, jobject, jint, jdouble, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasDgemmNative
 * Signature: (CCIIIDLjcuda/Pointer;ILjcuda/Pointer;IDLjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasDgemmNative
  (JNIEnv *, jclass, jchar, jchar, jint, jint, jint, jdouble, jobject, jint, jobject, jint, jdouble, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasDtrsmNative
 * Signature: (CCCCIIDLjcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasDtrsmNative
  (JNIEnv *, jclass, jchar, jchar, jchar, jchar, jint, jint, jdouble, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasZtrsmNative
 * Signature: (CCCCIILjcuda/cuDoubleComplex;Ljcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasZtrsmNative
  (JNIEnv *, jclass, jchar, jchar, jchar, jchar, jint, jint, jobject, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasDtrmmNative
 * Signature: (CCCCIIDLjcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasDtrmmNative
  (JNIEnv *, jclass, jchar, jchar, jchar, jchar, jint, jint, jdouble, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasDsymmNative
 * Signature: (CCIIDLjcuda/Pointer;ILjcuda/Pointer;IDLjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasDsymmNative
  (JNIEnv *, jclass, jchar, jchar, jint, jint, jdouble, jobject, jint, jobject, jint, jdouble, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasZsymmNative
 * Signature: (CCIILjcuda/cuDoubleComplex;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/cuDoubleComplex;Ljcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasZsymmNative
  (JNIEnv *, jclass, jchar, jchar, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasDsyrkNative
 * Signature: (CCIIDLjcuda/Pointer;IDLjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasDsyrkNative
  (JNIEnv *, jclass, jchar, jchar, jint, jint, jdouble, jobject, jint, jdouble, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasZsyrkNative
 * Signature: (CCIILjcuda/cuDoubleComplex;Ljcuda/Pointer;ILjcuda/cuDoubleComplex;Ljcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasZsyrkNative
  (JNIEnv *, jclass, jchar, jchar, jint, jint, jobject, jobject, jint, jobject, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasZsyr2kNative
 * Signature: (CCIILjcuda/cuDoubleComplex;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/cuDoubleComplex;Ljcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasZsyr2kNative
  (JNIEnv *, jclass, jchar, jchar, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasZher2kNative
 * Signature: (CCIILjcuda/cuDoubleComplex;Ljcuda/Pointer;ILjcuda/Pointer;IDLjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasZher2kNative
  (JNIEnv *, jclass, jchar, jchar, jint, jint, jobject, jobject, jint, jobject, jint, jdouble, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasZherNative
 * Signature: (CIDLjcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasZherNative
  (JNIEnv *, jclass, jchar, jint, jdouble, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasZhprNative
 * Signature: (CIDLjcuda/Pointer;ILjcuda/Pointer;)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasZhprNative
  (JNIEnv *, jclass, jchar, jint, jdouble, jobject, jint, jobject);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasZhpr2Native
 * Signature: (CILjcuda/cuDoubleComplex;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasZhpr2Native
  (JNIEnv *, jclass, jchar, jint, jobject, jobject, jint, jobject, jint, jobject);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasZher2Native
 * Signature: (CILjcuda/cuDoubleComplex;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasZher2Native
  (JNIEnv *, jclass, jchar, jint, jobject, jobject, jint, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasDsyr2kNative
 * Signature: (CCIIDLjcuda/Pointer;ILjcuda/Pointer;IDLjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasDsyr2kNative
  (JNIEnv *, jclass, jchar, jchar, jint, jint, jdouble, jobject, jint, jobject, jint, jdouble, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasZgemmNative
 * Signature: (CCIIILjcuda/cuDoubleComplex;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/cuDoubleComplex;Ljcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasZgemmNative
  (JNIEnv *, jclass, jchar, jchar, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasZtrmmNative
 * Signature: (CCCCIILjcuda/cuDoubleComplex;Ljcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasZtrmmNative
  (JNIEnv *, jclass, jchar, jchar, jchar, jchar, jint, jint, jobject, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasZgeruNative
 * Signature: (IILjcuda/cuDoubleComplex;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasZgeruNative
  (JNIEnv *, jclass, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasZgercNative
 * Signature: (IILjcuda/cuDoubleComplex;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasZgercNative
  (JNIEnv *, jclass, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasZherkNative
 * Signature: (CCIIDLjcuda/Pointer;IDLjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasZherkNative
  (JNIEnv *, jclass, jchar, jchar, jint, jint, jdouble, jobject, jint, jdouble, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasZhemmNative
 * Signature: (CCIILjcuda/cuDoubleComplex;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/cuDoubleComplex;Ljcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasZhemmNative
  (JNIEnv *, jclass, jchar, jchar, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasZtrsvNative
 * Signature: (CCCILjcuda/Pointer;ILjcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasZtrsvNative
  (JNIEnv *, jclass, jchar, jchar, jchar, jint, jobject, jint, jobject, jint);

/*
 * Class:     jcuda_jcublas_JCublas
 * Method:    cublasZhbmvNative
 * Signature: (CIILjcuda/cuDoubleComplex;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/cuDoubleComplex;Ljcuda/Pointer;I)V
 */
JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas_cublasZhbmvNative
  (JNIEnv *, jclass, jchar, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

#ifdef __cplusplus
}
#endif
#endif
