/*
 * Decompiled with CFR 0.152.
 */
package jcuda.jnpp;

import jcuda.CudaException;
import jcuda.LibUtils;
import jcuda.LogLevel;
import jcuda.Pointer;
import jcuda.jnpp.NppStatus;
import jcuda.jnpp.NppiGraphcutState;
import jcuda.jnpp.NppiPoint;
import jcuda.jnpp.NppiRect;
import jcuda.jnpp.NppiSize;
import jcuda.jnpp.TypedPointer;
import jcuda.jnpp.types.Npp16s;
import jcuda.jnpp.types.Npp16sc;
import jcuda.jnpp.types.Npp16u;
import jcuda.jnpp.types.Npp32f;
import jcuda.jnpp.types.Npp32fc;
import jcuda.jnpp.types.Npp32s;
import jcuda.jnpp.types.Npp32sc;
import jcuda.jnpp.types.Npp32u;
import jcuda.jnpp.types.Npp64f;
import jcuda.jnpp.types.Npp8s;
import jcuda.jnpp.types.Npp8u;

public class JNppi {
    private static boolean initialized = false;
    private static boolean exceptionsEnabled = false;

    static {
        JNppi.initialize();
    }

    private JNppi() {
    }

    public static void initialize() {
        if (!initialized) {
            LibUtils.loadLibrary((String)"Jnppi");
            initialized = true;
        }
    }

    public static void setLogLevel(LogLevel logLevel) {
        JNppi.setLogLevelNative(logLevel.ordinal());
    }

    private static native void setLogLevelNative(int var0);

    public static void setExceptionsEnabled(boolean enabled) {
        exceptionsEnabled = enabled;
    }

    private static int checkResult(int result) {
        if (exceptionsEnabled && result < 0) {
            throw new CudaException(NppStatus.stringFor(result));
        }
        return result;
    }

    private static <T extends TypedPointer<?>> T checkResult(T result) {
        if (exceptionsEnabled && result == null) {
            throw new CudaException("Failed to allocate memory");
        }
        return result;
    }

    public static TypedPointer<Npp8u> nppiMalloc_8u_C1(int nWidthPixels, int nHeightPixels, int[] pStepBytes) {
        return JNppi.checkResult(JNppi.nppiMalloc_8u_C1Native(nWidthPixels, nHeightPixels, pStepBytes));
    }

    private static native TypedPointer<Npp8u> nppiMalloc_8u_C1Native(int var0, int var1, int[] var2);

    public static TypedPointer<Npp8u> nppiMalloc_8u_C2(int nWidthPixels, int nHeightPixels, int[] pStepBytes) {
        return JNppi.checkResult(JNppi.nppiMalloc_8u_C2Native(nWidthPixels, nHeightPixels, pStepBytes));
    }

    private static native TypedPointer<Npp8u> nppiMalloc_8u_C2Native(int var0, int var1, int[] var2);

    public static TypedPointer<Npp8u> nppiMalloc_8u_C3(int nWidthPixels, int nHeightPixels, int[] pStepBytes) {
        return JNppi.checkResult(JNppi.nppiMalloc_8u_C3Native(nWidthPixels, nHeightPixels, pStepBytes));
    }

    private static native TypedPointer<Npp8u> nppiMalloc_8u_C3Native(int var0, int var1, int[] var2);

    public static TypedPointer<Npp8u> nppiMalloc_8u_C4(int nWidthPixels, int nHeightPixels, int[] pStepBytes) {
        return JNppi.checkResult(JNppi.nppiMalloc_8u_C4Native(nWidthPixels, nHeightPixels, pStepBytes));
    }

    private static native TypedPointer<Npp8u> nppiMalloc_8u_C4Native(int var0, int var1, int[] var2);

    public static TypedPointer<Npp16u> nppiMalloc_16u_C1(int nWidthPixels, int nHeightPixels, int[] pStepBytes) {
        return JNppi.checkResult(JNppi.nppiMalloc_16u_C1Native(nWidthPixels, nHeightPixels, pStepBytes));
    }

    private static native TypedPointer<Npp16u> nppiMalloc_16u_C1Native(int var0, int var1, int[] var2);

    public static TypedPointer<Npp16u> nppiMalloc_16u_C2(int nWidthPixels, int nHeightPixels, int[] pStepBytes) {
        return JNppi.checkResult(JNppi.nppiMalloc_16u_C2Native(nWidthPixels, nHeightPixels, pStepBytes));
    }

    private static native TypedPointer<Npp16u> nppiMalloc_16u_C2Native(int var0, int var1, int[] var2);

    public static TypedPointer<Npp16u> nppiMalloc_16u_C3(int nWidthPixels, int nHeightPixels, int[] pStepBytes) {
        return JNppi.checkResult(JNppi.nppiMalloc_16u_C3Native(nWidthPixels, nHeightPixels, pStepBytes));
    }

    private static native TypedPointer<Npp16u> nppiMalloc_16u_C3Native(int var0, int var1, int[] var2);

    public static TypedPointer<Npp16u> nppiMalloc_16u_C4(int nWidthPixels, int nHeightPixels, int[] pStepBytes) {
        return JNppi.checkResult(JNppi.nppiMalloc_16u_C4Native(nWidthPixels, nHeightPixels, pStepBytes));
    }

    private static native TypedPointer<Npp16u> nppiMalloc_16u_C4Native(int var0, int var1, int[] var2);

    public static TypedPointer<Npp16s> nppiMalloc_16s_C1(int nWidthPixels, int nHeightPixels, int[] pStepBytes) {
        return JNppi.checkResult(JNppi.nppiMalloc_16s_C1Native(nWidthPixels, nHeightPixels, pStepBytes));
    }

    private static native TypedPointer<Npp16s> nppiMalloc_16s_C1Native(int var0, int var1, int[] var2);

    public static TypedPointer<Npp16s> nppiMalloc_16s_C2(int nWidthPixels, int nHeightPixels, int[] pStepBytes) {
        return JNppi.checkResult(JNppi.nppiMalloc_16s_C2Native(nWidthPixels, nHeightPixels, pStepBytes));
    }

    private static native TypedPointer<Npp16s> nppiMalloc_16s_C2Native(int var0, int var1, int[] var2);

    public static TypedPointer<Npp16s> nppiMalloc_16s_C4(int nWidthPixels, int nHeightPixels, int[] pStepBytes) {
        return JNppi.checkResult(JNppi.nppiMalloc_16s_C4Native(nWidthPixels, nHeightPixels, pStepBytes));
    }

    private static native TypedPointer<Npp16s> nppiMalloc_16s_C4Native(int var0, int var1, int[] var2);

    public static TypedPointer<Npp16s> nppiMalloc_16sc_C1(int nWidthPixels, int nHeightPixels, int[] pStepBytes) {
        return JNppi.checkResult(JNppi.nppiMalloc_16sc_C1Native(nWidthPixels, nHeightPixels, pStepBytes));
    }

    private static native TypedPointer<Npp16s> nppiMalloc_16sc_C1Native(int var0, int var1, int[] var2);

    public static TypedPointer<Npp16s> nppiMalloc_16sc_C2(int nWidthPixels, int nHeightPixels, int[] pStepBytes) {
        return JNppi.checkResult(JNppi.nppiMalloc_16sc_C2Native(nWidthPixels, nHeightPixels, pStepBytes));
    }

    private static native TypedPointer<Npp16s> nppiMalloc_16sc_C2Native(int var0, int var1, int[] var2);

    public static TypedPointer<Npp16s> nppiMalloc_16sc_C3(int nWidthPixels, int nHeightPixels, int[] pStepBytes) {
        return JNppi.checkResult(JNppi.nppiMalloc_16sc_C3Native(nWidthPixels, nHeightPixels, pStepBytes));
    }

    private static native TypedPointer<Npp16s> nppiMalloc_16sc_C3Native(int var0, int var1, int[] var2);

    public static TypedPointer<Npp16s> nppiMalloc_16sc_C4(int nWidthPixels, int nHeightPixels, int[] pStepBytes) {
        return JNppi.checkResult(JNppi.nppiMalloc_16sc_C4Native(nWidthPixels, nHeightPixels, pStepBytes));
    }

    private static native TypedPointer<Npp16s> nppiMalloc_16sc_C4Native(int var0, int var1, int[] var2);

    public static TypedPointer<Npp32s> nppiMalloc_32s_C1(int nWidthPixels, int nHeightPixels, int[] pStepBytes) {
        return JNppi.checkResult(JNppi.nppiMalloc_32s_C1Native(nWidthPixels, nHeightPixels, pStepBytes));
    }

    private static native TypedPointer<Npp32s> nppiMalloc_32s_C1Native(int var0, int var1, int[] var2);

    public static TypedPointer<Npp32s> nppiMalloc_32s_C3(int nWidthPixels, int nHeightPixels, int[] pStepBytes) {
        return JNppi.checkResult(JNppi.nppiMalloc_32s_C3Native(nWidthPixels, nHeightPixels, pStepBytes));
    }

    private static native TypedPointer<Npp32s> nppiMalloc_32s_C3Native(int var0, int var1, int[] var2);

    public static TypedPointer<Npp32s> nppiMalloc_32s_C4(int nWidthPixels, int nHeightPixels, int[] pStepBytes) {
        return JNppi.checkResult(JNppi.nppiMalloc_32s_C4Native(nWidthPixels, nHeightPixels, pStepBytes));
    }

    private static native TypedPointer<Npp32s> nppiMalloc_32s_C4Native(int var0, int var1, int[] var2);

    public static TypedPointer<Npp32s> nppiMalloc_32sc_C1(int nWidthPixels, int nHeightPixels, int[] pStepBytes) {
        return JNppi.checkResult(JNppi.nppiMalloc_32sc_C1Native(nWidthPixels, nHeightPixels, pStepBytes));
    }

    private static native TypedPointer<Npp32s> nppiMalloc_32sc_C1Native(int var0, int var1, int[] var2);

    public static TypedPointer<Npp32s> nppiMalloc_32sc_C2(int nWidthPixels, int nHeightPixels, int[] pStepBytes) {
        return JNppi.checkResult(JNppi.nppiMalloc_32sc_C2Native(nWidthPixels, nHeightPixels, pStepBytes));
    }

    private static native TypedPointer<Npp32s> nppiMalloc_32sc_C2Native(int var0, int var1, int[] var2);

    public static TypedPointer<Npp32s> nppiMalloc_32sc_C3(int nWidthPixels, int nHeightPixels, int[] pStepBytes) {
        return JNppi.checkResult(JNppi.nppiMalloc_32sc_C3Native(nWidthPixels, nHeightPixels, pStepBytes));
    }

    private static native TypedPointer<Npp32s> nppiMalloc_32sc_C3Native(int var0, int var1, int[] var2);

    public static TypedPointer<Npp32s> nppiMalloc_32sc_C4(int nWidthPixels, int nHeightPixels, int[] pStepBytes) {
        return JNppi.checkResult(JNppi.nppiMalloc_32sc_C4Native(nWidthPixels, nHeightPixels, pStepBytes));
    }

    private static native TypedPointer<Npp32s> nppiMalloc_32sc_C4Native(int var0, int var1, int[] var2);

    public static TypedPointer<Npp32f> nppiMalloc_32f_C1(int nWidthPixels, int nHeightPixels, int[] pStepBytes) {
        return JNppi.checkResult(JNppi.nppiMalloc_32f_C1Native(nWidthPixels, nHeightPixels, pStepBytes));
    }

    private static native TypedPointer<Npp32f> nppiMalloc_32f_C1Native(int var0, int var1, int[] var2);

    public static TypedPointer<Npp32f> nppiMalloc_32f_C2(int nWidthPixels, int nHeightPixels, int[] pStepBytes) {
        return JNppi.checkResult(JNppi.nppiMalloc_32f_C2Native(nWidthPixels, nHeightPixels, pStepBytes));
    }

    private static native TypedPointer<Npp32f> nppiMalloc_32f_C2Native(int var0, int var1, int[] var2);

    public static TypedPointer<Npp32f> nppiMalloc_32f_C3(int nWidthPixels, int nHeightPixels, int[] pStepBytes) {
        return JNppi.checkResult(JNppi.nppiMalloc_32f_C3Native(nWidthPixels, nHeightPixels, pStepBytes));
    }

    private static native TypedPointer<Npp32f> nppiMalloc_32f_C3Native(int var0, int var1, int[] var2);

    public static TypedPointer<Npp32f> nppiMalloc_32f_C4(int nWidthPixels, int nHeightPixels, int[] pStepBytes) {
        return JNppi.checkResult(JNppi.nppiMalloc_32f_C4Native(nWidthPixels, nHeightPixels, pStepBytes));
    }

    private static native TypedPointer<Npp32f> nppiMalloc_32f_C4Native(int var0, int var1, int[] var2);

    public static TypedPointer<Npp32f> nppiMalloc_32fc_C1(int nWidthPixels, int nHeightPixels, int[] pStepBytes) {
        return JNppi.checkResult(JNppi.nppiMalloc_32fc_C1Native(nWidthPixels, nHeightPixels, pStepBytes));
    }

    private static native TypedPointer<Npp32f> nppiMalloc_32fc_C1Native(int var0, int var1, int[] var2);

    public static TypedPointer<Npp32f> nppiMalloc_32fc_C2(int nWidthPixels, int nHeightPixels, int[] pStepBytes) {
        return JNppi.checkResult(JNppi.nppiMalloc_32fc_C2Native(nWidthPixels, nHeightPixels, pStepBytes));
    }

    private static native TypedPointer<Npp32f> nppiMalloc_32fc_C2Native(int var0, int var1, int[] var2);

    public static TypedPointer<Npp32f> nppiMalloc_32fc_C3(int nWidthPixels, int nHeightPixels, int[] pStepBytes) {
        return JNppi.checkResult(JNppi.nppiMalloc_32fc_C3Native(nWidthPixels, nHeightPixels, pStepBytes));
    }

    private static native TypedPointer<Npp32f> nppiMalloc_32fc_C3Native(int var0, int var1, int[] var2);

    public static TypedPointer<Npp32f> nppiMalloc_32fc_C4(int nWidthPixels, int nHeightPixels, int[] pStepBytes) {
        return JNppi.checkResult(JNppi.nppiMalloc_32fc_C4Native(nWidthPixels, nHeightPixels, pStepBytes));
    }

    private static native TypedPointer<Npp32f> nppiMalloc_32fc_C4Native(int var0, int var1, int[] var2);

    public static void nppiFree(Pointer pData) {
        JNppi.nppiFreeNative(pData);
    }

    private static native void nppiFreeNative(Pointer var0);

    public static int nppiSet_8s_C1R(byte nValue, TypedPointer<Npp8s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSet_8s_C1RNative(nValue, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSet_8s_C1RNative(byte var0, TypedPointer<Npp8s> var1, int var2, NppiSize var3);

    public static int nppiSet_8s_C2R(byte[] aValue, TypedPointer<Npp8s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSet_8s_C2RNative(aValue, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSet_8s_C2RNative(byte[] var0, TypedPointer<Npp8s> var1, int var2, NppiSize var3);

    public static int nppiSet_8s_C3R(byte[] aValue, TypedPointer<Npp8s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSet_8s_C3RNative(aValue, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSet_8s_C3RNative(byte[] var0, TypedPointer<Npp8s> var1, int var2, NppiSize var3);

    public static int nppiSet_8s_C4R(byte[] aValue, TypedPointer<Npp8s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSet_8s_C4RNative(aValue, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSet_8s_C4RNative(byte[] var0, TypedPointer<Npp8s> var1, int var2, NppiSize var3);

    public static int nppiSet_8s_AC4R(byte[] aValue, TypedPointer<Npp8s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSet_8s_AC4RNative(aValue, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSet_8s_AC4RNative(byte[] var0, TypedPointer<Npp8s> var1, int var2, NppiSize var3);

    public static int nppiSet_8u_C1R(byte nValue, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSet_8u_C1RNative(nValue, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSet_8u_C1RNative(byte var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3);

    public static int nppiSet_8u_C1MR(byte nValue, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, TypedPointer<Npp8u> pMask, int nMaskStep) {
        return JNppi.checkResult(JNppi.nppiSet_8u_C1MRNative(nValue, pDst, nDstStep, oSizeROI, pMask, nMaskStep));
    }

    private static native int nppiSet_8u_C1MRNative(byte var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3, TypedPointer<Npp8u> var4, int var5);

    public static int nppiSet_8u_C4R(byte[] aValues, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSet_8u_C4RNative(aValues, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSet_8u_C4RNative(byte[] var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3);

    public static int nppiSet_8u_C4MR(byte[] aValues, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, TypedPointer<Npp8u> pMask, int nMaskStep) {
        return JNppi.checkResult(JNppi.nppiSet_8u_C4MRNative(aValues, pDst, nDstStep, oSizeROI, pMask, nMaskStep));
    }

    private static native int nppiSet_8u_C4MRNative(byte[] var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3, TypedPointer<Npp8u> var4, int var5);

    public static int nppiSet_8u_AC4R(byte[] aValues, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSet_8u_AC4RNative(aValues, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSet_8u_AC4RNative(byte[] var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3);

    public static int nppiSet_8u_AC4MR(byte[] aValues, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, TypedPointer<Npp8u> pMask, int nMaskStep) {
        return JNppi.checkResult(JNppi.nppiSet_8u_AC4MRNative(aValues, pDst, nDstStep, oSizeROI, pMask, nMaskStep));
    }

    private static native int nppiSet_8u_AC4MRNative(byte[] var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3, TypedPointer<Npp8u> var4, int var5);

    public static int nppiSet_8u_C4CR(byte nValue, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSet_8u_C4CRNative(nValue, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSet_8u_C4CRNative(byte var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3);

    public static int nppiSet_16u_C1R(short nValue, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSet_16u_C1RNative(nValue, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSet_16u_C1RNative(short var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3);

    public static int nppiSet_16u_C1MR(short nValue, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, TypedPointer<Npp8u> pMask, int nMaskStep) {
        return JNppi.checkResult(JNppi.nppiSet_16u_C1MRNative(nValue, pDst, nDstStep, oSizeROI, pMask, nMaskStep));
    }

    private static native int nppiSet_16u_C1MRNative(short var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3, TypedPointer<Npp8u> var4, int var5);

    public static int nppiSet_16u_C2R(short[] aValues, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSet_16u_C2RNative(aValues, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSet_16u_C2RNative(short[] var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3);

    public static int nppiSet_16u_C4R(short[] aValues, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSet_16u_C4RNative(aValues, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSet_16u_C4RNative(short[] var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3);

    public static int nppiSet_16u_C4MR(short[] aValues, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, TypedPointer<Npp8u> pMask, int nMaskStep) {
        return JNppi.checkResult(JNppi.nppiSet_16u_C4MRNative(aValues, pDst, nDstStep, oSizeROI, pMask, nMaskStep));
    }

    private static native int nppiSet_16u_C4MRNative(short[] var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3, TypedPointer<Npp8u> var4, int var5);

    public static int nppiSet_16u_AC4R(short[] aValues, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSet_16u_AC4RNative(aValues, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSet_16u_AC4RNative(short[] var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3);

    public static int nppiSet_16u_AC4MR(short[] aValues, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, TypedPointer<Npp8u> pMask, int nMaskStep) {
        return JNppi.checkResult(JNppi.nppiSet_16u_AC4MRNative(aValues, pDst, nDstStep, oSizeROI, pMask, nMaskStep));
    }

    private static native int nppiSet_16u_AC4MRNative(short[] var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3, TypedPointer<Npp8u> var4, int var5);

    public static int nppiSet_16u_C4CR(short nValue, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSet_16u_C4CRNative(nValue, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSet_16u_C4CRNative(short var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3);

    public static int nppiSet_16s_C1R(short nValue, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSet_16s_C1RNative(nValue, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSet_16s_C1RNative(short var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3);

    public static int nppiSet_16s_C1MR(short nValue, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, TypedPointer<Npp8u> pMask, int nMaskStep) {
        return JNppi.checkResult(JNppi.nppiSet_16s_C1MRNative(nValue, pDst, nDstStep, oSizeROI, pMask, nMaskStep));
    }

    private static native int nppiSet_16s_C1MRNative(short var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3, TypedPointer<Npp8u> var4, int var5);

    public static int nppiSet_16s_C2R(short[] aValues, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSet_16s_C2RNative(aValues, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSet_16s_C2RNative(short[] var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3);

    public static int nppiSet_16s_C4R(short[] aValues, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSet_16s_C4RNative(aValues, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSet_16s_C4RNative(short[] var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3);

    public static int nppiSet_16s_C4MR(short[] aValues, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, TypedPointer<Npp8u> pMask, int nMaskStep) {
        return JNppi.checkResult(JNppi.nppiSet_16s_C4MRNative(aValues, pDst, nDstStep, oSizeROI, pMask, nMaskStep));
    }

    private static native int nppiSet_16s_C4MRNative(short[] var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3, TypedPointer<Npp8u> var4, int var5);

    public static int nppiSet_16s_AC4R(short[] aValues, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSet_16s_AC4RNative(aValues, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSet_16s_AC4RNative(short[] var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3);

    public static int nppiSet_16s_AC4MR(short[] aValues, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, TypedPointer<Npp8u> pMask, int nMaskStep) {
        return JNppi.checkResult(JNppi.nppiSet_16s_AC4MRNative(aValues, pDst, nDstStep, oSizeROI, pMask, nMaskStep));
    }

    private static native int nppiSet_16s_AC4MRNative(short[] var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3, TypedPointer<Npp8u> var4, int var5);

    public static int nppiSet_16s_C4CR(short nValue, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSet_16s_C4CRNative(nValue, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSet_16s_C4CRNative(short var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3);

    public static int nppiSet_16sc_C1R(Npp16sc oValue, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSet_16sc_C1RNative(oValue, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSet_16sc_C1RNative(Npp16sc var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3);

    public static int nppiSet_16sc_C2R(Npp16sc[] aValue, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSet_16sc_C2RNative(aValue, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSet_16sc_C2RNative(Npp16sc[] var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3);

    public static int nppiSet_16sc_C3R(Npp16sc[] aValue, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSet_16sc_C3RNative(aValue, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSet_16sc_C3RNative(Npp16sc[] var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3);

    public static int nppiSet_16sc_AC4R(Npp16sc[] aValue, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSet_16sc_AC4RNative(aValue, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSet_16sc_AC4RNative(Npp16sc[] var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3);

    public static int nppiSet_16sc_C4R(Npp16sc[] aValue, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSet_16sc_C4RNative(aValue, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSet_16sc_C4RNative(Npp16sc[] var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3);

    public static int nppiSet_32s_C1R(int nValue, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSet_32s_C1RNative(nValue, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSet_32s_C1RNative(int var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3);

    public static int nppiSet_32s_C1MR(int nValue, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, TypedPointer<Npp8u> pMask, int nMaskStep) {
        return JNppi.checkResult(JNppi.nppiSet_32s_C1MRNative(nValue, pDst, nDstStep, oSizeROI, pMask, nMaskStep));
    }

    private static native int nppiSet_32s_C1MRNative(int var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3, TypedPointer<Npp8u> var4, int var5);

    public static int nppiSet_32s_C4R(int[] aValues, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSet_32s_C4RNative(aValues, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSet_32s_C4RNative(int[] var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3);

    public static int nppiSet_32s_C4MR(int[] aValues, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, TypedPointer<Npp8u> pMask, int nMaskStep) {
        return JNppi.checkResult(JNppi.nppiSet_32s_C4MRNative(aValues, pDst, nDstStep, oSizeROI, pMask, nMaskStep));
    }

    private static native int nppiSet_32s_C4MRNative(int[] var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3, TypedPointer<Npp8u> var4, int var5);

    public static int nppiSet_32s_AC4R(int[] aValues, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSet_32s_AC4RNative(aValues, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSet_32s_AC4RNative(int[] var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3);

    public static int nppiSet_32s_AC4MR(int[] aValues, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, TypedPointer<Npp8u> pMask, int nMaskStep) {
        return JNppi.checkResult(JNppi.nppiSet_32s_AC4MRNative(aValues, pDst, nDstStep, oSizeROI, pMask, nMaskStep));
    }

    private static native int nppiSet_32s_AC4MRNative(int[] var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3, TypedPointer<Npp8u> var4, int var5);

    public static int nppiSet_32s_C4CR(int nValue, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSet_32s_C4CRNative(nValue, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSet_32s_C4CRNative(int var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3);

    public static int nppiSet_32sc_C1R(Npp32sc oValue, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSet_32sc_C1RNative(oValue, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSet_32sc_C1RNative(Npp32sc var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3);

    public static int nppiSet_32sc_C2R(Npp32sc[] aValue, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSet_32sc_C2RNative(aValue, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSet_32sc_C2RNative(Npp32sc[] var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3);

    public static int nppiSet_32sc_C3R(Npp32sc[] aValue, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSet_32sc_C3RNative(aValue, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSet_32sc_C3RNative(Npp32sc[] var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3);

    public static int nppiSet_32sc_C4R(Npp32sc[] aValue, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSet_32sc_C4RNative(aValue, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSet_32sc_C4RNative(Npp32sc[] var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3);

    public static int nppiSet_32sc_AC4R(Npp32sc[] aValue, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSet_32sc_AC4RNative(aValue, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSet_32sc_AC4RNative(Npp32sc[] var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3);

    public static int nppiSet_32f_C1R(float nValue, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSet_32f_C1RNative(nValue, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSet_32f_C1RNative(float var0, TypedPointer<Npp32f> var1, int var2, NppiSize var3);

    public static int nppiSet_32f_C1MR(float nValue, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI, TypedPointer<Npp8u> pMask, int nMaskStep) {
        return JNppi.checkResult(JNppi.nppiSet_32f_C1MRNative(nValue, pDst, nDstStep, oSizeROI, pMask, nMaskStep));
    }

    private static native int nppiSet_32f_C1MRNative(float var0, TypedPointer<Npp32f> var1, int var2, NppiSize var3, TypedPointer<Npp8u> var4, int var5);

    public static int nppiSet_32f_C4R(float[] aValues, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSet_32f_C4RNative(aValues, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSet_32f_C4RNative(float[] var0, TypedPointer<Npp32f> var1, int var2, NppiSize var3);

    public static int nppiSet_32f_C4MR(float[] aValues, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI, TypedPointer<Npp8u> pMask, int nMaskStep) {
        return JNppi.checkResult(JNppi.nppiSet_32f_C4MRNative(aValues, pDst, nDstStep, oSizeROI, pMask, nMaskStep));
    }

    private static native int nppiSet_32f_C4MRNative(float[] var0, TypedPointer<Npp32f> var1, int var2, NppiSize var3, TypedPointer<Npp8u> var4, int var5);

    public static int nppiSet_32f_AC4R(float[] aValues, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSet_32f_AC4RNative(aValues, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSet_32f_AC4RNative(float[] var0, TypedPointer<Npp32f> var1, int var2, NppiSize var3);

    public static int nppiSet_32f_AC4MR(float[] aValues, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI, TypedPointer<Npp8u> pMask, int nMaskStep) {
        return JNppi.checkResult(JNppi.nppiSet_32f_AC4MRNative(aValues, pDst, nDstStep, oSizeROI, pMask, nMaskStep));
    }

    private static native int nppiSet_32f_AC4MRNative(float[] var0, TypedPointer<Npp32f> var1, int var2, NppiSize var3, TypedPointer<Npp8u> var4, int var5);

    public static int nppiSet_32f_C4CR(float nValue, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSet_32f_C4CRNative(nValue, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSet_32f_C4CRNative(float var0, TypedPointer<Npp32f> var1, int var2, NppiSize var3);

    public static int nppiSet_32fc_C1R(Npp32fc oValue, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSet_32fc_C1RNative(oValue, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSet_32fc_C1RNative(Npp32fc var0, TypedPointer<Npp32f> var1, int var2, NppiSize var3);

    public static int nppiSet_32fc_C2R(Npp32fc[] aValue, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSet_32fc_C2RNative(aValue, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSet_32fc_C2RNative(Npp32fc[] var0, TypedPointer<Npp32f> var1, int var2, NppiSize var3);

    public static int nppiSet_32fc_C3R(Npp32fc[] aValue, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSet_32fc_C3RNative(aValue, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSet_32fc_C3RNative(Npp32fc[] var0, TypedPointer<Npp32f> var1, int var2, NppiSize var3);

    public static int nppiSet_32fc_C4R(Npp32fc[] aValue, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSet_32fc_C4RNative(aValue, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSet_32fc_C4RNative(Npp32fc[] var0, TypedPointer<Npp32f> var1, int var2, NppiSize var3);

    public static int nppiSet_32fc_AC4R(Npp32fc[] aValue, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSet_32fc_AC4RNative(aValue, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSet_32fc_AC4RNative(Npp32fc[] var0, TypedPointer<Npp32f> var1, int var2, NppiSize var3);

    public static int nppiCopy_8s_C1R(TypedPointer<Npp8s> pSrc, int nSrcStep, TypedPointer<Npp8s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_8s_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_8s_C1RNative(TypedPointer<Npp8s> var0, int var1, TypedPointer<Npp8s> var2, int var3, NppiSize var4);

    public static int nppiCopy_8s_C2R(TypedPointer<Npp8s> pSrc, int nSrcStep, TypedPointer<Npp8s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_8s_C2RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_8s_C2RNative(TypedPointer<Npp8s> var0, int var1, TypedPointer<Npp8s> var2, int var3, NppiSize var4);

    public static int nppiCopy_8s_C3R(TypedPointer<Npp8s> pSrc, int nSrcStep, TypedPointer<Npp8s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_8s_C3RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_8s_C3RNative(TypedPointer<Npp8s> var0, int var1, TypedPointer<Npp8s> var2, int var3, NppiSize var4);

    public static int nppiCopy_8s_C4R(TypedPointer<Npp8s> pSrc, int nSrcStep, TypedPointer<Npp8s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_8s_C4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_8s_C4RNative(TypedPointer<Npp8s> var0, int var1, TypedPointer<Npp8s> var2, int var3, NppiSize var4);

    public static int nppiCopy_8s_AC4R(TypedPointer<Npp8s> pSrc, int nSrcStep, TypedPointer<Npp8s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_8s_AC4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_8s_AC4RNative(TypedPointer<Npp8s> var0, int var1, TypedPointer<Npp8s> var2, int var3, NppiSize var4);

    public static int nppiCopy_8u_C1R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_8u_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_8u_C1RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiCopy_8u_C4R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_8u_C4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_8u_C4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiCopy_8u_AC4R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_8u_AC4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_8u_AC4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiCopy_16u_C1R(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_16u_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_16u_C1RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4);

    public static int nppiCopy_16u_C4R(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_16u_C4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_16u_C4RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4);

    public static int nppiCopy_16u_AC4R(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_16u_AC4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_16u_AC4RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4);

    public static int nppiCopy_16s_C1R(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_16s_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_16s_C1RNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4);

    public static int nppiCopy_16s_C4R(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_16s_C4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_16s_C4RNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4);

    public static int nppiCopy_16s_AC4R(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_16s_AC4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_16s_AC4RNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4);

    public static int nppiCopy_16sc_C1R(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_16sc_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_16sc_C1RNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4);

    public static int nppiCopy_16sc_C2R(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_16sc_C2RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_16sc_C2RNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4);

    public static int nppiCopy_16sc_C3R(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_16sc_C3RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_16sc_C3RNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4);

    public static int nppiCopy_16sc_C4R(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_16sc_C4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_16sc_C4RNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4);

    public static int nppiCopy_16sc_AC4R(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_16sc_AC4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_16sc_AC4RNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4);

    public static int nppiCopy_32s_C1R(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_32s_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_32s_C1RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4);

    public static int nppiCopy_32s_C4R(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_32s_C4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_32s_C4RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4);

    public static int nppiCopy_32s_AC4R(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_32s_AC4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_32s_AC4RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4);

    public static int nppiCopy_32sc_C1R(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_32sc_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_32sc_C1RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4);

    public static int nppiCopy_32sc_C2R(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_32sc_C2RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_32sc_C2RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4);

    public static int nppiCopy_32sc_C3R(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_32sc_C3RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_32sc_C3RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4);

    public static int nppiCopy_32sc_C4R(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_32sc_C4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_32sc_C4RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4);

    public static int nppiCopy_32sc_AC4R(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_32sc_AC4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_32sc_AC4RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4);

    public static int nppiCopy_32f_C1R(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_32f_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_32f_C1RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiCopy_32f_C4R(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_32f_C4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_32f_C4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiCopy_32f_AC4R(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_32f_AC4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_32f_AC4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiCopy_32fc_C1R(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_32fc_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_32fc_C1RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiCopy_32fc_C2R(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_32fc_C2RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_32fc_C2RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiCopy_32fc_C3R(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_32fc_C3RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_32fc_C3RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiCopy_32fc_C4R(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_32fc_C4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_32fc_C4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiCopy_32fc_AC4R(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_32fc_AC4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_32fc_AC4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiCopy_8u_C1MR(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, TypedPointer<Npp8u> pMask, int nMaskStep) {
        return JNppi.checkResult(JNppi.nppiCopy_8u_C1MRNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, pMask, nMaskStep));
    }

    private static native int nppiCopy_8u_C1MRNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, TypedPointer<Npp8u> var5, int var6);

    public static int nppiCopy_8u_C3MR(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, TypedPointer<Npp8u> pMask, int nMaskStep) {
        return JNppi.checkResult(JNppi.nppiCopy_8u_C3MRNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, pMask, nMaskStep));
    }

    private static native int nppiCopy_8u_C3MRNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, TypedPointer<Npp8u> var5, int var6);

    public static int nppiCopy_8u_C4MR(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, TypedPointer<Npp8u> pMask, int nMaskStep) {
        return JNppi.checkResult(JNppi.nppiCopy_8u_C4MRNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, pMask, nMaskStep));
    }

    private static native int nppiCopy_8u_C4MRNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, TypedPointer<Npp8u> var5, int var6);

    public static int nppiCopy_8u_AC4MR(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, TypedPointer<Npp8u> pMask, int nMaskStep) {
        return JNppi.checkResult(JNppi.nppiCopy_8u_AC4MRNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, pMask, nMaskStep));
    }

    private static native int nppiCopy_8u_AC4MRNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, TypedPointer<Npp8u> var5, int var6);

    public static int nppiCopy_16u_C1MR(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, TypedPointer<Npp8u> pMask, int nMaskStep) {
        return JNppi.checkResult(JNppi.nppiCopy_16u_C1MRNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, pMask, nMaskStep));
    }

    private static native int nppiCopy_16u_C1MRNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4, TypedPointer<Npp8u> var5, int var6);

    public static int nppiCopy_16u_C3MR(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, TypedPointer<Npp8u> pMask, int nMaskStep) {
        return JNppi.checkResult(JNppi.nppiCopy_16u_C3MRNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, pMask, nMaskStep));
    }

    private static native int nppiCopy_16u_C3MRNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4, TypedPointer<Npp8u> var5, int var6);

    public static int nppiCopy_16u_C4MR(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, TypedPointer<Npp8u> pMask, int nMaskStep) {
        return JNppi.checkResult(JNppi.nppiCopy_16u_C4MRNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, pMask, nMaskStep));
    }

    private static native int nppiCopy_16u_C4MRNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4, TypedPointer<Npp8u> var5, int var6);

    public static int nppiCopy_16u_AC4MR(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, TypedPointer<Npp8u> pMask, int nMaskStep) {
        return JNppi.checkResult(JNppi.nppiCopy_16u_AC4MRNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, pMask, nMaskStep));
    }

    private static native int nppiCopy_16u_AC4MRNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4, TypedPointer<Npp8u> var5, int var6);

    public static int nppiCopy_16s_C1MR(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, TypedPointer<Npp8u> pMask, int nMaskStep) {
        return JNppi.checkResult(JNppi.nppiCopy_16s_C1MRNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, pMask, nMaskStep));
    }

    private static native int nppiCopy_16s_C1MRNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, TypedPointer<Npp8u> var5, int var6);

    public static int nppiCopy_16s_C3MR(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, TypedPointer<Npp8u> pMask, int nMaskStep) {
        return JNppi.checkResult(JNppi.nppiCopy_16s_C3MRNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, pMask, nMaskStep));
    }

    private static native int nppiCopy_16s_C3MRNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, TypedPointer<Npp8u> var5, int var6);

    public static int nppiCopy_16s_C4MR(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, TypedPointer<Npp8u> pMask, int nMaskStep) {
        return JNppi.checkResult(JNppi.nppiCopy_16s_C4MRNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, pMask, nMaskStep));
    }

    private static native int nppiCopy_16s_C4MRNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, TypedPointer<Npp8u> var5, int var6);

    public static int nppiCopy_16s_AC4MR(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, TypedPointer<Npp8u> pMask, int nMaskStep) {
        return JNppi.checkResult(JNppi.nppiCopy_16s_AC4MRNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, pMask, nMaskStep));
    }

    private static native int nppiCopy_16s_AC4MRNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, TypedPointer<Npp8u> var5, int var6);

    public static int nppiCopy_32s_C1MR(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, TypedPointer<Npp8u> pMask, int nMaskStep) {
        return JNppi.checkResult(JNppi.nppiCopy_32s_C1MRNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, pMask, nMaskStep));
    }

    private static native int nppiCopy_32s_C1MRNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4, TypedPointer<Npp8u> var5, int var6);

    public static int nppiCopy_32s_C3MR(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, TypedPointer<Npp8u> pMask, int nMaskStep) {
        return JNppi.checkResult(JNppi.nppiCopy_32s_C3MRNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, pMask, nMaskStep));
    }

    private static native int nppiCopy_32s_C3MRNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4, TypedPointer<Npp8u> var5, int var6);

    public static int nppiCopy_32s_C4MR(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, TypedPointer<Npp8u> pMask, int nMaskStep) {
        return JNppi.checkResult(JNppi.nppiCopy_32s_C4MRNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, pMask, nMaskStep));
    }

    private static native int nppiCopy_32s_C4MRNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4, TypedPointer<Npp8u> var5, int var6);

    public static int nppiCopy_32s_AC4MR(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, TypedPointer<Npp8u> pMask, int nMaskStep) {
        return JNppi.checkResult(JNppi.nppiCopy_32s_AC4MRNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, pMask, nMaskStep));
    }

    private static native int nppiCopy_32s_AC4MRNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4, TypedPointer<Npp8u> var5, int var6);

    public static int nppiCopy_32f_C1MR(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI, TypedPointer<Npp8u> pMask, int nMaskStep) {
        return JNppi.checkResult(JNppi.nppiCopy_32f_C1MRNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, pMask, nMaskStep));
    }

    private static native int nppiCopy_32f_C1MRNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4, TypedPointer<Npp8u> var5, int var6);

    public static int nppiCopy_32f_C3MR(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI, TypedPointer<Npp8u> pMask, int nMaskStep) {
        return JNppi.checkResult(JNppi.nppiCopy_32f_C3MRNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, pMask, nMaskStep));
    }

    private static native int nppiCopy_32f_C3MRNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4, TypedPointer<Npp8u> var5, int var6);

    public static int nppiCopy_32f_C4MR(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI, TypedPointer<Npp8u> pMask, int nMaskStep) {
        return JNppi.checkResult(JNppi.nppiCopy_32f_C4MRNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, pMask, nMaskStep));
    }

    private static native int nppiCopy_32f_C4MRNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4, TypedPointer<Npp8u> var5, int var6);

    public static int nppiCopy_32f_AC4MR(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI, TypedPointer<Npp8u> pMask, int nMaskStep) {
        return JNppi.checkResult(JNppi.nppiCopy_32f_AC4MRNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, pMask, nMaskStep));
    }

    private static native int nppiCopy_32f_AC4MRNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4, TypedPointer<Npp8u> var5, int var6);

    public static int nppiCopy_8u_C3CR(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_8u_C3CRNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_8u_C3CRNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiCopy_8u_C4CR(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_8u_C4CRNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_8u_C4CRNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiCopy_16s_C3CR(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_16s_C3CRNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_16s_C3CRNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4);

    public static int nppiCopy_16s_C4CR(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_16s_C4CRNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_16s_C4CRNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4);

    public static int nppiCopy_16u_C3CR(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_16u_C3CRNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_16u_C3CRNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4);

    public static int nppiCopy_16u_C4CR(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_16u_C4CRNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_16u_C4CRNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4);

    public static int nppiCopy_32s_C3CR(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_32s_C3CRNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_32s_C3CRNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4);

    public static int nppiCopy_32s_C4CR(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_32s_C4CRNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_32s_C4CRNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4);

    public static int nppiCopy_32f_C3CR(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_32f_C3CRNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_32f_C3CRNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiCopy_32f_C4CR(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_32f_C4CRNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_32f_C4CRNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiCopy_8u_C3C1R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_8u_C3C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_8u_C3C1RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiCopy_8u_C4C1R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_8u_C4C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_8u_C4C1RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiCopy_16s_C3C1R(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_16s_C3C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_16s_C3C1RNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4);

    public static int nppiCopy_16s_C4C1R(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_16s_C4C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_16s_C4C1RNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4);

    public static int nppiCopy_16u_C3C1R(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_16u_C3C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_16u_C3C1RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4);

    public static int nppiCopy_16u_C4C1R(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_16u_C4C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_16u_C4C1RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4);

    public static int nppiCopy_32s_C3C1R(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_32s_C3C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_32s_C3C1RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4);

    public static int nppiCopy_32s_C4C1R(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_32s_C4C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_32s_C4C1RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4);

    public static int nppiCopy_32f_C3C1R(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_32f_C3C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_32f_C3C1RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiCopy_32f_C4C1R(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_32f_C4C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_32f_C4C1RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiCopy_8u_C1C3R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_8u_C1C3RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_8u_C1C3RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiCopy_8u_C1C4R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_8u_C1C4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_8u_C1C4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiCopy_16s_C1C3R(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_16s_C1C3RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_16s_C1C3RNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4);

    public static int nppiCopy_16s_C1C4R(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_16s_C1C4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_16s_C1C4RNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4);

    public static int nppiCopy_16u_C1C3R(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_16u_C1C3RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_16u_C1C3RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4);

    public static int nppiCopy_16u_C1C4R(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_16u_C1C4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_16u_C1C4RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4);

    public static int nppiCopy_32s_C1C3R(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_32s_C1C3RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_32s_C1C3RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4);

    public static int nppiCopy_32s_C1C4R(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_32s_C1C4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_32s_C1C4RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4);

    public static int nppiCopy_32f_C1C3R(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_32f_C1C3RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_32f_C1C3RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiCopy_32f_C1C4R(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_32f_C1C4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_32f_C1C4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiCopy_8u_C3P3R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u>[] aDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_8u_C3P3RNative(pSrc, nSrcStep, aDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_8u_C3P3RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u>[] var2, int var3, NppiSize var4);

    public static int nppiCopy_8u_C4P4R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u>[] aDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_8u_C4P4RNative(pSrc, nSrcStep, aDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_8u_C4P4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u>[] var2, int var3, NppiSize var4);

    public static int nppiCopy_16s_C3P3R(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s>[] aDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_16s_C3P3RNative(pSrc, nSrcStep, aDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_16s_C3P3RNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s>[] var2, int var3, NppiSize var4);

    public static int nppiCopy_16s_C4P4R(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s>[] aDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_16s_C4P4RNative(pSrc, nSrcStep, aDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_16s_C4P4RNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s>[] var2, int var3, NppiSize var4);

    public static int nppiCopy_16u_C3P3R(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u>[] aDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_16u_C3P3RNative(pSrc, nSrcStep, aDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_16u_C3P3RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u>[] var2, int var3, NppiSize var4);

    public static int nppiCopy_16u_C4P4R(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u>[] aDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_16u_C4P4RNative(pSrc, nSrcStep, aDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_16u_C4P4RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u>[] var2, int var3, NppiSize var4);

    public static int nppiCopy_32s_C3P3R(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s>[] aDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_32s_C3P3RNative(pSrc, nSrcStep, aDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_32s_C3P3RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s>[] var2, int var3, NppiSize var4);

    public static int nppiCopy_32s_C4P4R(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s>[] aDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_32s_C4P4RNative(pSrc, nSrcStep, aDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_32s_C4P4RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s>[] var2, int var3, NppiSize var4);

    public static int nppiCopy_32f_C3P3R(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f>[] aDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_32f_C3P3RNative(pSrc, nSrcStep, aDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_32f_C3P3RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f>[] var2, int var3, NppiSize var4);

    public static int nppiCopy_32f_C4P4R(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f>[] aDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_32f_C4P4RNative(pSrc, nSrcStep, aDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_32f_C4P4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f>[] var2, int var3, NppiSize var4);

    public static int nppiCopy_8u_P3C3R(TypedPointer<Npp8u>[] aSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_8u_P3C3RNative(aSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_8u_P3C3RNative(TypedPointer<Npp8u>[] var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiCopy_8u_P4C4R(TypedPointer<Npp8u>[] aSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_8u_P4C4RNative(aSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_8u_P4C4RNative(TypedPointer<Npp8u>[] var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiCopy_16u_P3C3R(TypedPointer<Npp16u>[] aSrc, int nSrcStep, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_16u_P3C3RNative(aSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_16u_P3C3RNative(TypedPointer<Npp16u>[] var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4);

    public static int nppiCopy_16u_P4C4R(TypedPointer<Npp16u>[] aSrc, int nSrcStep, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_16u_P4C4RNative(aSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_16u_P4C4RNative(TypedPointer<Npp16u>[] var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4);

    public static int nppiCopy_16s_P3C3R(TypedPointer<Npp16s>[] aSrc, int nSrcStep, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_16s_P3C3RNative(aSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_16s_P3C3RNative(TypedPointer<Npp16s>[] var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4);

    public static int nppiCopy_16s_P4C4R(TypedPointer<Npp16s>[] aSrc, int nSrcStep, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_16s_P4C4RNative(aSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_16s_P4C4RNative(TypedPointer<Npp16s>[] var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4);

    public static int nppiCopy_32s_P3C3R(TypedPointer<Npp32s>[] aSrc, int nSrcStep, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_32s_P3C3RNative(aSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_32s_P3C3RNative(TypedPointer<Npp32s>[] var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4);

    public static int nppiCopy_32s_P4C4R(TypedPointer<Npp32s>[] aSrc, int nSrcStep, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_32s_P4C4RNative(aSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_32s_P4C4RNative(TypedPointer<Npp32s>[] var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4);

    public static int nppiCopy_32f_P3C3R(TypedPointer<Npp32f>[] aSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_32f_P3C3RNative(aSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_32f_P3C3RNative(TypedPointer<Npp32f>[] var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiCopy_32f_P4C4R(TypedPointer<Npp32f>[] aSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiCopy_32f_P4C4RNative(aSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiCopy_32f_P4C4RNative(TypedPointer<Npp32f>[] var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiConvert_8u16u_C1R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiConvert_8u16u_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiConvert_8u16u_C1RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4);

    public static int nppiConvert_16u8u_C1R(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiConvert_16u8u_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiConvert_16u8u_C1RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiConvert_8u16u_C4R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiConvert_8u16u_C4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiConvert_8u16u_C4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4);

    public static int nppiConvert_16u8u_C4R(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiConvert_16u8u_C4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiConvert_16u8u_C4RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiConvert_8u16u_AC4R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiConvert_8u16u_AC4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiConvert_8u16u_AC4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4);

    public static int nppiConvert_16u8u_AC4R(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiConvert_16u8u_AC4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiConvert_16u8u_AC4RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiConvert_8u16s_C1R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiConvert_8u16s_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiConvert_8u16s_C1RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4);

    public static int nppiConvert_16s8u_C1R(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiConvert_16s8u_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiConvert_16s8u_C1RNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiConvert_8u16s_C4R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiConvert_8u16s_C4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiConvert_8u16s_C4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4);

    public static int nppiConvert_16s8u_C4R(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiConvert_16s8u_C4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiConvert_16s8u_C4RNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiConvert_8u16s_AC4R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiConvert_8u16s_AC4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiConvert_8u16s_AC4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4);

    public static int nppiConvert_16s8u_AC4R(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiConvert_16s8u_AC4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiConvert_16s8u_AC4RNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiConvert_16s32f_C1R(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiConvert_16s32f_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiConvert_16s32f_C1RNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiConvert_32f16s_C1R(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int eRoundMode) {
        return JNppi.checkResult(JNppi.nppiConvert_32f16s_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, eRoundMode));
    }

    private static native int nppiConvert_32f16s_C1RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, int var5);

    public static int nppiConvert_8u32f_C1R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiConvert_8u32f_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiConvert_8u32f_C1RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiConvert_16u32f_C1R(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiConvert_16u32f_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiConvert_16u32f_C1RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiConvert_32f16u_C1R(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int eRoundMode) {
        return JNppi.checkResult(JNppi.nppiConvert_32f16u_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, eRoundMode));
    }

    private static native int nppiConvert_32f16u_C1RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4, int var5);

    public static int nppiConvert_32f8u_C1R(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int eRoundMode) {
        return JNppi.checkResult(JNppi.nppiConvert_32f8u_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, eRoundMode));
    }

    private static native int nppiConvert_32f8u_C1RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, int var5);

    public static int nppiConvert_16u32s_C1R(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiConvert_16u32s_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiConvert_16u32s_C1RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4);

    public static int nppiConvert_16s32s_C1R(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiConvert_16s32s_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiConvert_16s32s_C1RNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4);

    public static int nppiCopyConstBorder_8u_C1R(TypedPointer<Npp8u> pSrc, int nSrcStep, NppiSize oSrcSizeROI, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oDstSizeROI, int nTopBorderHeight, int nLeftBorderWidth, byte nValue) {
        return JNppi.checkResult(JNppi.nppiCopyConstBorder_8u_C1RNative(pSrc, nSrcStep, oSrcSizeROI, pDst, nDstStep, oDstSizeROI, nTopBorderHeight, nLeftBorderWidth, nValue));
    }

    private static native int nppiCopyConstBorder_8u_C1RNative(TypedPointer<Npp8u> var0, int var1, NppiSize var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5, int var6, int var7, byte var8);

    public static int nppiCopyConstBorder_8u_C4R(TypedPointer<Npp8u> pSrc, int nSrcStep, NppiSize oSrcSizeROI, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oDstSizeROI, int nTopBorderHeight, int nLeftBorderWidth, byte[] aValue) {
        return JNppi.checkResult(JNppi.nppiCopyConstBorder_8u_C4RNative(pSrc, nSrcStep, oSrcSizeROI, pDst, nDstStep, oDstSizeROI, nTopBorderHeight, nLeftBorderWidth, aValue));
    }

    private static native int nppiCopyConstBorder_8u_C4RNative(TypedPointer<Npp8u> var0, int var1, NppiSize var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5, int var6, int var7, byte[] var8);

    public static int nppiCopyConstBorder_8u_AC4R(TypedPointer<Npp8u> pSrc, int nSrcStep, NppiSize oSrcSizeROI, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oDstSizeROI, int nTopBorderHeight, int nLeftBorderWidth, byte[] aValue) {
        return JNppi.checkResult(JNppi.nppiCopyConstBorder_8u_AC4RNative(pSrc, nSrcStep, oSrcSizeROI, pDst, nDstStep, oDstSizeROI, nTopBorderHeight, nLeftBorderWidth, aValue));
    }

    private static native int nppiCopyConstBorder_8u_AC4RNative(TypedPointer<Npp8u> var0, int var1, NppiSize var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5, int var6, int var7, byte[] var8);

    public static int nppiCopyConstBorder_32s_C1R(TypedPointer<Npp32s> pSrc, int nSrcStep, NppiSize oSrcSizeROI, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oDstSizeROI, int nTopBorderHeight, int nLeftBorderWidth, int nValue) {
        return JNppi.checkResult(JNppi.nppiCopyConstBorder_32s_C1RNative(pSrc, nSrcStep, oSrcSizeROI, pDst, nDstStep, oDstSizeROI, nTopBorderHeight, nLeftBorderWidth, nValue));
    }

    private static native int nppiCopyConstBorder_32s_C1RNative(TypedPointer<Npp32s> var0, int var1, NppiSize var2, TypedPointer<Npp32s> var3, int var4, NppiSize var5, int var6, int var7, int var8);

    public static int nppiTranspose_8u_C1R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oROI) {
        return JNppi.checkResult(JNppi.nppiTranspose_8u_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oROI));
    }

    private static native int nppiTranspose_8u_C1RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiSwapChannels_8u_C4IR(TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int[] aDstOrder) {
        return JNppi.checkResult(JNppi.nppiSwapChannels_8u_C4IRNative(pSrcDst, nSrcDstStep, oSizeROI, aDstOrder));
    }

    private static native int nppiSwapChannels_8u_C4IRNative(TypedPointer<Npp8u> var0, int var1, NppiSize var2, int[] var3);

    public static int nppiAddC_8u_C1RSfs(TypedPointer<Npp8u> pSrc1, int nSrc1Step, byte nConstant, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAddC_8u_C1RSfsNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAddC_8u_C1RSfsNative(TypedPointer<Npp8u> var0, int var1, byte var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5, int var6);

    public static int nppiAddC_8u_C1IRSfs(byte nConstant, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAddC_8u_C1IRSfsNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAddC_8u_C1IRSfsNative(byte var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3, int var4);

    public static int nppiAddC_8u_C3RSfs(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAddC_8u_C3RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAddC_8u_C3RSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5, int var6);

    public static int nppiAddC_8u_C3IRSfs(TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAddC_8u_C3IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAddC_8u_C3IRSfsNative(TypedPointer<Npp8u> var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3, int var4);

    public static int nppiAddC_8u_AC4RSfs(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAddC_8u_AC4RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAddC_8u_AC4RSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5, int var6);

    public static int nppiAddC_8u_AC4IRSfs(TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAddC_8u_AC4IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAddC_8u_AC4IRSfsNative(TypedPointer<Npp8u> var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3, int var4);

    public static int nppiAddC_8u_C4RSfs(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAddC_8u_C4RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAddC_8u_C4RSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5, int var6);

    public static int nppiAddC_8u_C4IRSfs(TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAddC_8u_C4IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAddC_8u_C4IRSfsNative(TypedPointer<Npp8u> var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3, int var4);

    public static int nppiAddC_16u_C1RSfs(TypedPointer<Npp16u> pSrc1, int nSrc1Step, short nConstant, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAddC_16u_C1RSfsNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAddC_16u_C1RSfsNative(TypedPointer<Npp16u> var0, int var1, short var2, TypedPointer<Npp16u> var3, int var4, NppiSize var5, int var6);

    public static int nppiAddC_16u_C1IRSfs(short nConstant, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAddC_16u_C1IRSfsNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAddC_16u_C1IRSfsNative(short var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3, int var4);

    public static int nppiAddC_16u_C3RSfs(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAddC_16u_C3RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAddC_16u_C3RSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, TypedPointer<Npp16u> var3, int var4, NppiSize var5, int var6);

    public static int nppiAddC_16u_C3IRSfs(TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAddC_16u_C3IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAddC_16u_C3IRSfsNative(TypedPointer<Npp16u> var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3, int var4);

    public static int nppiAddC_16u_AC4RSfs(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAddC_16u_AC4RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAddC_16u_AC4RSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, TypedPointer<Npp16u> var3, int var4, NppiSize var5, int var6);

    public static int nppiAddC_16u_AC4IRSfs(TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAddC_16u_AC4IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAddC_16u_AC4IRSfsNative(TypedPointer<Npp16u> var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3, int var4);

    public static int nppiAddC_16u_C4RSfs(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAddC_16u_C4RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAddC_16u_C4RSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, TypedPointer<Npp16u> var3, int var4, NppiSize var5, int var6);

    public static int nppiAddC_16u_C4IRSfs(TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAddC_16u_C4IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAddC_16u_C4IRSfsNative(TypedPointer<Npp16u> var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3, int var4);

    public static int nppiAddC_16s_C1RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, short nConstant, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAddC_16s_C1RSfsNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAddC_16s_C1RSfsNative(TypedPointer<Npp16s> var0, int var1, short var2, TypedPointer<Npp16s> var3, int var4, NppiSize var5, int var6);

    public static int nppiAddC_16s_C1IRSfs(short nConstant, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAddC_16s_C1IRSfsNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAddC_16s_C1IRSfsNative(short var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3, int var4);

    public static int nppiAddC_16s_C3RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pConstants, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAddC_16s_C3RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAddC_16s_C3RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, TypedPointer<Npp16s> var3, int var4, NppiSize var5, int var6);

    public static int nppiAddC_16s_C3IRSfs(TypedPointer<Npp16s> pConstants, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAddC_16s_C3IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAddC_16s_C3IRSfsNative(TypedPointer<Npp16s> var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3, int var4);

    public static int nppiAddC_16s_AC4RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pConstants, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAddC_16s_AC4RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAddC_16s_AC4RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, TypedPointer<Npp16s> var3, int var4, NppiSize var5, int var6);

    public static int nppiAddC_16s_AC4IRSfs(TypedPointer<Npp16s> pConstants, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAddC_16s_AC4IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAddC_16s_AC4IRSfsNative(TypedPointer<Npp16s> var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3, int var4);

    public static int nppiAddC_16s_C4RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pConstants, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAddC_16s_C4RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAddC_16s_C4RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, TypedPointer<Npp16s> var3, int var4, NppiSize var5, int var6);

    public static int nppiAddC_16s_C4IRSfs(TypedPointer<Npp16s> pConstants, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAddC_16s_C4IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAddC_16s_C4IRSfsNative(TypedPointer<Npp16s> var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3, int var4);

    public static int nppiAddC_16sc_C1RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, Npp16sc nConstant, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAddC_16sc_C1RSfsNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAddC_16sc_C1RSfsNative(TypedPointer<Npp16s> var0, int var1, Npp16sc var2, TypedPointer<Npp16s> var3, int var4, NppiSize var5, int var6);

    public static int nppiAddC_16sc_C1IRSfs(Npp16sc nConstant, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAddC_16sc_C1IRSfsNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAddC_16sc_C1IRSfsNative(Npp16sc var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3, int var4);

    public static int nppiAddC_16sc_C3RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pConstants, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAddC_16sc_C3RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAddC_16sc_C3RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, TypedPointer<Npp16s> var3, int var4, NppiSize var5, int var6);

    public static int nppiAddC_16sc_C3IRSfs(TypedPointer<Npp16s> pConstants, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAddC_16sc_C3IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAddC_16sc_C3IRSfsNative(TypedPointer<Npp16s> var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3, int var4);

    public static int nppiAddC_16sc_AC4RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pConstants, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAddC_16sc_AC4RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAddC_16sc_AC4RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, TypedPointer<Npp16s> var3, int var4, NppiSize var5, int var6);

    public static int nppiAddC_16sc_AC4IRSfs(TypedPointer<Npp16s> pConstants, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAddC_16sc_AC4IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAddC_16sc_AC4IRSfsNative(TypedPointer<Npp16s> var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3, int var4);

    public static int nppiAddC_32s_C1RSfs(TypedPointer<Npp32s> pSrc1, int nSrc1Step, int nConstant, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAddC_32s_C1RSfsNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAddC_32s_C1RSfsNative(TypedPointer<Npp32s> var0, int var1, int var2, TypedPointer<Npp32s> var3, int var4, NppiSize var5, int var6);

    public static int nppiAddC_32s_C1IRSfs(int nConstant, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAddC_32s_C1IRSfsNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAddC_32s_C1IRSfsNative(int var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3, int var4);

    public static int nppiAddC_32s_C3RSfs(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pConstants, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAddC_32s_C3RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAddC_32s_C3RSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, TypedPointer<Npp32s> var3, int var4, NppiSize var5, int var6);

    public static int nppiAddC_32s_C3IRSfs(TypedPointer<Npp32s> pConstants, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAddC_32s_C3IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAddC_32s_C3IRSfsNative(TypedPointer<Npp32s> var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3, int var4);

    public static int nppiAddC_32sc_C1RSfs(TypedPointer<Npp32s> pSrc1, int nSrc1Step, Npp32sc nConstant, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAddC_32sc_C1RSfsNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAddC_32sc_C1RSfsNative(TypedPointer<Npp32s> var0, int var1, Npp32sc var2, TypedPointer<Npp32s> var3, int var4, NppiSize var5, int var6);

    public static int nppiAddC_32sc_C1IRSfs(Npp32sc nConstant, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAddC_32sc_C1IRSfsNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAddC_32sc_C1IRSfsNative(Npp32sc var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3, int var4);

    public static int nppiAddC_32sc_C3RSfs(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pConstants, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAddC_32sc_C3RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAddC_32sc_C3RSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, TypedPointer<Npp32s> var3, int var4, NppiSize var5, int var6);

    public static int nppiAddC_32sc_C3IRSfs(TypedPointer<Npp32s> pConstants, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAddC_32sc_C3IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAddC_32sc_C3IRSfsNative(TypedPointer<Npp32s> var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3, int var4);

    public static int nppiAddC_32sc_AC4RSfs(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pConstants, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAddC_32sc_AC4RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAddC_32sc_AC4RSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, TypedPointer<Npp32s> var3, int var4, NppiSize var5, int var6);

    public static int nppiAddC_32sc_AC4IRSfs(TypedPointer<Npp32s> pConstants, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAddC_32sc_AC4IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAddC_32sc_AC4IRSfsNative(TypedPointer<Npp32s> var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3, int var4);

    public static int nppiAddC_32f_C1R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, float nConstant, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAddC_32f_C1RNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAddC_32f_C1RNative(TypedPointer<Npp32f> var0, int var1, float var2, TypedPointer<Npp32f> var3, int var4, NppiSize var5);

    public static int nppiAddC_32f_C1IR(float nConstant, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAddC_32f_C1IRNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAddC_32f_C1IRNative(float var0, TypedPointer<Npp32f> var1, int var2, NppiSize var3);

    public static int nppiAddC_32f_C3R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAddC_32f_C3RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAddC_32f_C3RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, TypedPointer<Npp32f> var3, int var4, NppiSize var5);

    public static int nppiAddC_32f_C3IR(TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAddC_32f_C3IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAddC_32f_C3IRNative(TypedPointer<Npp32f> var0, TypedPointer<Npp32f> var1, int var2, NppiSize var3);

    public static int nppiAddC_32f_AC4R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAddC_32f_AC4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAddC_32f_AC4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, TypedPointer<Npp32f> var3, int var4, NppiSize var5);

    public static int nppiAddC_32f_AC4IR(TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAddC_32f_AC4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAddC_32f_AC4IRNative(TypedPointer<Npp32f> var0, TypedPointer<Npp32f> var1, int var2, NppiSize var3);

    public static int nppiAddC_32f_C4R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAddC_32f_C4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAddC_32f_C4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, TypedPointer<Npp32f> var3, int var4, NppiSize var5);

    public static int nppiAddC_32f_C4IR(TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAddC_32f_C4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAddC_32f_C4IRNative(TypedPointer<Npp32f> var0, TypedPointer<Npp32f> var1, int var2, NppiSize var3);

    public static int nppiAddC_32fc_C1R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, Npp32fc nConstant, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAddC_32fc_C1RNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAddC_32fc_C1RNative(TypedPointer<Npp32f> var0, int var1, Npp32fc var2, TypedPointer<Npp32f> var3, int var4, NppiSize var5);

    public static int nppiAddC_32fc_C1IR(Npp32fc nConstant, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAddC_32fc_C1IRNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAddC_32fc_C1IRNative(Npp32fc var0, TypedPointer<Npp32f> var1, int var2, NppiSize var3);

    public static int nppiAddC_32fc_C3R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAddC_32fc_C3RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAddC_32fc_C3RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, TypedPointer<Npp32f> var3, int var4, NppiSize var5);

    public static int nppiAddC_32fc_C3IR(TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAddC_32fc_C3IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAddC_32fc_C3IRNative(TypedPointer<Npp32f> var0, TypedPointer<Npp32f> var1, int var2, NppiSize var3);

    public static int nppiAddC_32fc_AC4R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAddC_32fc_AC4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAddC_32fc_AC4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, TypedPointer<Npp32f> var3, int var4, NppiSize var5);

    public static int nppiAddC_32fc_AC4IR(TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAddC_32fc_AC4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAddC_32fc_AC4IRNative(TypedPointer<Npp32f> var0, TypedPointer<Npp32f> var1, int var2, NppiSize var3);

    public static int nppiAddC_32fc_C4R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAddC_32fc_C4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAddC_32fc_C4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, TypedPointer<Npp32f> var3, int var4, NppiSize var5);

    public static int nppiAddC_32fc_C4IR(TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAddC_32fc_C4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAddC_32fc_C4IRNative(TypedPointer<Npp32f> var0, TypedPointer<Npp32f> var1, int var2, NppiSize var3);

    public static int nppiMulC_8u_C1RSfs(TypedPointer<Npp8u> pSrc1, int nSrc1Step, byte nConstant, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMulC_8u_C1RSfsNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMulC_8u_C1RSfsNative(TypedPointer<Npp8u> var0, int var1, byte var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5, int var6);

    public static int nppiMulC_8u_C1IRSfs(byte nConstant, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMulC_8u_C1IRSfsNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMulC_8u_C1IRSfsNative(byte var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3, int var4);

    public static int nppiMulC_8u_C3RSfs(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMulC_8u_C3RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMulC_8u_C3RSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5, int var6);

    public static int nppiMulC_8u_C3IRSfs(TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMulC_8u_C3IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMulC_8u_C3IRSfsNative(TypedPointer<Npp8u> var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3, int var4);

    public static int nppiMulC_8u_AC4RSfs(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMulC_8u_AC4RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMulC_8u_AC4RSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5, int var6);

    public static int nppiMulC_8u_AC4IRSfs(TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMulC_8u_AC4IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMulC_8u_AC4IRSfsNative(TypedPointer<Npp8u> var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3, int var4);

    public static int nppiMulC_8u_C4RSfs(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMulC_8u_C4RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMulC_8u_C4RSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5, int var6);

    public static int nppiMulC_8u_C4IRSfs(TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMulC_8u_C4IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMulC_8u_C4IRSfsNative(TypedPointer<Npp8u> var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3, int var4);

    public static int nppiMulC_16u_C1RSfs(TypedPointer<Npp16u> pSrc1, int nSrc1Step, short nConstant, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMulC_16u_C1RSfsNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMulC_16u_C1RSfsNative(TypedPointer<Npp16u> var0, int var1, short var2, TypedPointer<Npp16u> var3, int var4, NppiSize var5, int var6);

    public static int nppiMulC_16u_C1IRSfs(short nConstant, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMulC_16u_C1IRSfsNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMulC_16u_C1IRSfsNative(short var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3, int var4);

    public static int nppiMulC_16u_C3RSfs(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMulC_16u_C3RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMulC_16u_C3RSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, TypedPointer<Npp16u> var3, int var4, NppiSize var5, int var6);

    public static int nppiMulC_16u_C3IRSfs(TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMulC_16u_C3IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMulC_16u_C3IRSfsNative(TypedPointer<Npp16u> var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3, int var4);

    public static int nppiMulC_16u_AC4RSfs(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMulC_16u_AC4RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMulC_16u_AC4RSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, TypedPointer<Npp16u> var3, int var4, NppiSize var5, int var6);

    public static int nppiMulC_16u_AC4IRSfs(TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMulC_16u_AC4IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMulC_16u_AC4IRSfsNative(TypedPointer<Npp16u> var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3, int var4);

    public static int nppiMulC_16u_C4RSfs(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMulC_16u_C4RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMulC_16u_C4RSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, TypedPointer<Npp16u> var3, int var4, NppiSize var5, int var6);

    public static int nppiMulC_16u_C4IRSfs(TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMulC_16u_C4IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMulC_16u_C4IRSfsNative(TypedPointer<Npp16u> var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3, int var4);

    public static int nppiMulC_16s_C1RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, short nConstant, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMulC_16s_C1RSfsNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMulC_16s_C1RSfsNative(TypedPointer<Npp16s> var0, int var1, short var2, TypedPointer<Npp16s> var3, int var4, NppiSize var5, int var6);

    public static int nppiMulC_16s_C1IRSfs(short nConstant, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMulC_16s_C1IRSfsNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMulC_16s_C1IRSfsNative(short var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3, int var4);

    public static int nppiMulC_16s_C3RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pConstants, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMulC_16s_C3RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMulC_16s_C3RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, TypedPointer<Npp16s> var3, int var4, NppiSize var5, int var6);

    public static int nppiMulC_16s_C3IRSfs(TypedPointer<Npp16s> pConstants, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMulC_16s_C3IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMulC_16s_C3IRSfsNative(TypedPointer<Npp16s> var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3, int var4);

    public static int nppiMulC_16s_AC4RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pConstants, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMulC_16s_AC4RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMulC_16s_AC4RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, TypedPointer<Npp16s> var3, int var4, NppiSize var5, int var6);

    public static int nppiMulC_16s_AC4IRSfs(TypedPointer<Npp16s> pConstants, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMulC_16s_AC4IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMulC_16s_AC4IRSfsNative(TypedPointer<Npp16s> var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3, int var4);

    public static int nppiMulC_16s_C4RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pConstants, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMulC_16s_C4RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMulC_16s_C4RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, TypedPointer<Npp16s> var3, int var4, NppiSize var5, int var6);

    public static int nppiMulC_16s_C4IRSfs(TypedPointer<Npp16s> pConstants, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMulC_16s_C4IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMulC_16s_C4IRSfsNative(TypedPointer<Npp16s> var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3, int var4);

    public static int nppiMulC_16sc_C1RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, Npp16sc nConstant, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMulC_16sc_C1RSfsNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMulC_16sc_C1RSfsNative(TypedPointer<Npp16s> var0, int var1, Npp16sc var2, TypedPointer<Npp16s> var3, int var4, NppiSize var5, int var6);

    public static int nppiMulC_16sc_C1IRSfs(Npp16sc nConstant, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMulC_16sc_C1IRSfsNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMulC_16sc_C1IRSfsNative(Npp16sc var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3, int var4);

    public static int nppiMulC_16sc_C3RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pConstants, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMulC_16sc_C3RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMulC_16sc_C3RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, TypedPointer<Npp16s> var3, int var4, NppiSize var5, int var6);

    public static int nppiMulC_16sc_C3IRSfs(TypedPointer<Npp16s> pConstants, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMulC_16sc_C3IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMulC_16sc_C3IRSfsNative(TypedPointer<Npp16s> var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3, int var4);

    public static int nppiMulC_16sc_AC4RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pConstants, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMulC_16sc_AC4RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMulC_16sc_AC4RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, TypedPointer<Npp16s> var3, int var4, NppiSize var5, int var6);

    public static int nppiMulC_16sc_AC4IRSfs(TypedPointer<Npp16s> pConstants, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMulC_16sc_AC4IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMulC_16sc_AC4IRSfsNative(TypedPointer<Npp16s> var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3, int var4);

    public static int nppiMulC_32s_C1RSfs(TypedPointer<Npp32s> pSrc1, int nSrc1Step, int nConstant, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMulC_32s_C1RSfsNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMulC_32s_C1RSfsNative(TypedPointer<Npp32s> var0, int var1, int var2, TypedPointer<Npp32s> var3, int var4, NppiSize var5, int var6);

    public static int nppiMulC_32s_C1IRSfs(int nConstant, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMulC_32s_C1IRSfsNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMulC_32s_C1IRSfsNative(int var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3, int var4);

    public static int nppiMulC_32s_C3RSfs(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pConstants, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMulC_32s_C3RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMulC_32s_C3RSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, TypedPointer<Npp32s> var3, int var4, NppiSize var5, int var6);

    public static int nppiMulC_32s_C3IRSfs(TypedPointer<Npp32s> pConstants, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMulC_32s_C3IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMulC_32s_C3IRSfsNative(TypedPointer<Npp32s> var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3, int var4);

    public static int nppiMulC_32sc_C1RSfs(TypedPointer<Npp32s> pSrc1, int nSrc1Step, Npp32sc nConstant, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMulC_32sc_C1RSfsNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMulC_32sc_C1RSfsNative(TypedPointer<Npp32s> var0, int var1, Npp32sc var2, TypedPointer<Npp32s> var3, int var4, NppiSize var5, int var6);

    public static int nppiMulC_32sc_C1IRSfs(Npp32sc nConstant, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMulC_32sc_C1IRSfsNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMulC_32sc_C1IRSfsNative(Npp32sc var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3, int var4);

    public static int nppiMulC_32sc_C3RSfs(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pConstants, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMulC_32sc_C3RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMulC_32sc_C3RSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, TypedPointer<Npp32s> var3, int var4, NppiSize var5, int var6);

    public static int nppiMulC_32sc_C3IRSfs(TypedPointer<Npp32s> pConstants, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMulC_32sc_C3IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMulC_32sc_C3IRSfsNative(TypedPointer<Npp32s> var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3, int var4);

    public static int nppiMulC_32sc_AC4RSfs(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pConstants, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMulC_32sc_AC4RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMulC_32sc_AC4RSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, TypedPointer<Npp32s> var3, int var4, NppiSize var5, int var6);

    public static int nppiMulC_32sc_AC4IRSfs(TypedPointer<Npp32s> pConstants, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMulC_32sc_AC4IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMulC_32sc_AC4IRSfsNative(TypedPointer<Npp32s> var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3, int var4);

    public static int nppiMulC_32f_C1R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, float nConstant, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulC_32f_C1RNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiMulC_32f_C1RNative(TypedPointer<Npp32f> var0, int var1, float var2, TypedPointer<Npp32f> var3, int var4, NppiSize var5);

    public static int nppiMulC_32f_C1IR(float nConstant, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulC_32f_C1IRNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiMulC_32f_C1IRNative(float var0, TypedPointer<Npp32f> var1, int var2, NppiSize var3);

    public static int nppiMulC_32f_C3R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulC_32f_C3RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiMulC_32f_C3RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, TypedPointer<Npp32f> var3, int var4, NppiSize var5);

    public static int nppiMulC_32f_C3IR(TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulC_32f_C3IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiMulC_32f_C3IRNative(TypedPointer<Npp32f> var0, TypedPointer<Npp32f> var1, int var2, NppiSize var3);

    public static int nppiMulC_32f_AC4R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulC_32f_AC4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiMulC_32f_AC4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, TypedPointer<Npp32f> var3, int var4, NppiSize var5);

    public static int nppiMulC_32f_AC4IR(TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulC_32f_AC4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiMulC_32f_AC4IRNative(TypedPointer<Npp32f> var0, TypedPointer<Npp32f> var1, int var2, NppiSize var3);

    public static int nppiMulC_32f_C4R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulC_32f_C4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiMulC_32f_C4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, TypedPointer<Npp32f> var3, int var4, NppiSize var5);

    public static int nppiMulC_32f_C4IR(TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulC_32f_C4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiMulC_32f_C4IRNative(TypedPointer<Npp32f> var0, TypedPointer<Npp32f> var1, int var2, NppiSize var3);

    public static int nppiMulC_32fc_C1R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, Npp32fc nConstant, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulC_32fc_C1RNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiMulC_32fc_C1RNative(TypedPointer<Npp32f> var0, int var1, Npp32fc var2, TypedPointer<Npp32f> var3, int var4, NppiSize var5);

    public static int nppiMulC_32fc_C1IR(Npp32fc nConstant, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulC_32fc_C1IRNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiMulC_32fc_C1IRNative(Npp32fc var0, TypedPointer<Npp32f> var1, int var2, NppiSize var3);

    public static int nppiMulC_32fc_C3R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulC_32fc_C3RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiMulC_32fc_C3RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, TypedPointer<Npp32f> var3, int var4, NppiSize var5);

    public static int nppiMulC_32fc_C3IR(TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulC_32fc_C3IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiMulC_32fc_C3IRNative(TypedPointer<Npp32f> var0, TypedPointer<Npp32f> var1, int var2, NppiSize var3);

    public static int nppiMulC_32fc_AC4R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulC_32fc_AC4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiMulC_32fc_AC4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, TypedPointer<Npp32f> var3, int var4, NppiSize var5);

    public static int nppiMulC_32fc_AC4IR(TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulC_32fc_AC4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiMulC_32fc_AC4IRNative(TypedPointer<Npp32f> var0, TypedPointer<Npp32f> var1, int var2, NppiSize var3);

    public static int nppiMulC_32fc_C4R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulC_32fc_C4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiMulC_32fc_C4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, TypedPointer<Npp32f> var3, int var4, NppiSize var5);

    public static int nppiMulC_32fc_C4IR(TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulC_32fc_C4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiMulC_32fc_C4IRNative(TypedPointer<Npp32f> var0, TypedPointer<Npp32f> var1, int var2, NppiSize var3);

    public static int nppiMulCScale_8u_C1R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, byte nConstant, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulCScale_8u_C1RNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiMulCScale_8u_C1RNative(TypedPointer<Npp8u> var0, int var1, byte var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5);

    public static int nppiMulCScale_8u_C1IR(byte nConstant, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulCScale_8u_C1IRNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiMulCScale_8u_C1IRNative(byte var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3);

    public static int nppiMulCScale_8u_C3R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulCScale_8u_C3RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiMulCScale_8u_C3RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5);

    public static int nppiMulCScale_8u_C3IR(TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulCScale_8u_C3IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiMulCScale_8u_C3IRNative(TypedPointer<Npp8u> var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3);

    public static int nppiMulCScale_8u_AC4R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulCScale_8u_AC4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiMulCScale_8u_AC4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5);

    public static int nppiMulCScale_8u_AC4IR(TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulCScale_8u_AC4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiMulCScale_8u_AC4IRNative(TypedPointer<Npp8u> var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3);

    public static int nppiMulCScale_8u_C4R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulCScale_8u_C4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiMulCScale_8u_C4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5);

    public static int nppiMulCScale_8u_C4IR(TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulCScale_8u_C4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiMulCScale_8u_C4IRNative(TypedPointer<Npp8u> var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3);

    public static int nppiMulCScale_16u_C1R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, short nConstant, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulCScale_16u_C1RNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiMulCScale_16u_C1RNative(TypedPointer<Npp16u> var0, int var1, short var2, TypedPointer<Npp16u> var3, int var4, NppiSize var5);

    public static int nppiMulCScale_16u_C1IR(short nConstant, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulCScale_16u_C1IRNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiMulCScale_16u_C1IRNative(short var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3);

    public static int nppiMulCScale_16u_C3R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulCScale_16u_C3RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiMulCScale_16u_C3RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, TypedPointer<Npp16u> var3, int var4, NppiSize var5);

    public static int nppiMulCScale_16u_C3IR(TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulCScale_16u_C3IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiMulCScale_16u_C3IRNative(TypedPointer<Npp16u> var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3);

    public static int nppiMulCScale_16u_AC4R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulCScale_16u_AC4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiMulCScale_16u_AC4RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, TypedPointer<Npp16u> var3, int var4, NppiSize var5);

    public static int nppiMulCScale_16u_AC4IR(TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulCScale_16u_AC4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiMulCScale_16u_AC4IRNative(TypedPointer<Npp16u> var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3);

    public static int nppiMulCScale_16u_C4R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulCScale_16u_C4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiMulCScale_16u_C4RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, TypedPointer<Npp16u> var3, int var4, NppiSize var5);

    public static int nppiMulCScale_16u_C4IR(TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulCScale_16u_C4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiMulCScale_16u_C4IRNative(TypedPointer<Npp16u> var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3);

    public static int nppiSubC_8u_C1RSfs(TypedPointer<Npp8u> pSrc1, int nSrc1Step, byte nConstant, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSubC_8u_C1RSfsNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSubC_8u_C1RSfsNative(TypedPointer<Npp8u> var0, int var1, byte var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5, int var6);

    public static int nppiSubC_8u_C1IRSfs(byte nConstant, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSubC_8u_C1IRSfsNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSubC_8u_C1IRSfsNative(byte var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3, int var4);

    public static int nppiSubC_8u_C3RSfs(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSubC_8u_C3RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSubC_8u_C3RSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5, int var6);

    public static int nppiSubC_8u_C3IRSfs(TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSubC_8u_C3IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSubC_8u_C3IRSfsNative(TypedPointer<Npp8u> var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3, int var4);

    public static int nppiSubC_8u_AC4RSfs(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSubC_8u_AC4RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSubC_8u_AC4RSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5, int var6);

    public static int nppiSubC_8u_AC4IRSfs(TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSubC_8u_AC4IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSubC_8u_AC4IRSfsNative(TypedPointer<Npp8u> var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3, int var4);

    public static int nppiSubC_8u_C4RSfs(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSubC_8u_C4RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSubC_8u_C4RSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5, int var6);

    public static int nppiSubC_8u_C4IRSfs(TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSubC_8u_C4IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSubC_8u_C4IRSfsNative(TypedPointer<Npp8u> var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3, int var4);

    public static int nppiSubC_16u_C1RSfs(TypedPointer<Npp16u> pSrc1, int nSrc1Step, short nConstant, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSubC_16u_C1RSfsNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSubC_16u_C1RSfsNative(TypedPointer<Npp16u> var0, int var1, short var2, TypedPointer<Npp16u> var3, int var4, NppiSize var5, int var6);

    public static int nppiSubC_16u_C1IRSfs(short nConstant, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSubC_16u_C1IRSfsNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSubC_16u_C1IRSfsNative(short var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3, int var4);

    public static int nppiSubC_16u_C3RSfs(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSubC_16u_C3RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSubC_16u_C3RSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, TypedPointer<Npp16u> var3, int var4, NppiSize var5, int var6);

    public static int nppiSubC_16u_C3IRSfs(TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSubC_16u_C3IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSubC_16u_C3IRSfsNative(TypedPointer<Npp16u> var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3, int var4);

    public static int nppiSubC_16u_AC4RSfs(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSubC_16u_AC4RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSubC_16u_AC4RSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, TypedPointer<Npp16u> var3, int var4, NppiSize var5, int var6);

    public static int nppiSubC_16u_AC4IRSfs(TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSubC_16u_AC4IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSubC_16u_AC4IRSfsNative(TypedPointer<Npp16u> var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3, int var4);

    public static int nppiSubC_16u_C4RSfs(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSubC_16u_C4RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSubC_16u_C4RSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, TypedPointer<Npp16u> var3, int var4, NppiSize var5, int var6);

    public static int nppiSubC_16u_C4IRSfs(TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSubC_16u_C4IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSubC_16u_C4IRSfsNative(TypedPointer<Npp16u> var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3, int var4);

    public static int nppiSubC_16s_C1RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, short nConstant, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSubC_16s_C1RSfsNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSubC_16s_C1RSfsNative(TypedPointer<Npp16s> var0, int var1, short var2, TypedPointer<Npp16s> var3, int var4, NppiSize var5, int var6);

    public static int nppiSubC_16s_C1IRSfs(short nConstant, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSubC_16s_C1IRSfsNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSubC_16s_C1IRSfsNative(short var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3, int var4);

    public static int nppiSubC_16s_C3RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pConstants, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSubC_16s_C3RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSubC_16s_C3RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, TypedPointer<Npp16s> var3, int var4, NppiSize var5, int var6);

    public static int nppiSubC_16s_C3IRSfs(TypedPointer<Npp16s> pConstants, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSubC_16s_C3IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSubC_16s_C3IRSfsNative(TypedPointer<Npp16s> var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3, int var4);

    public static int nppiSubC_16s_AC4RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pConstants, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSubC_16s_AC4RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSubC_16s_AC4RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, TypedPointer<Npp16s> var3, int var4, NppiSize var5, int var6);

    public static int nppiSubC_16s_AC4IRSfs(TypedPointer<Npp16s> pConstants, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSubC_16s_AC4IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSubC_16s_AC4IRSfsNative(TypedPointer<Npp16s> var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3, int var4);

    public static int nppiSubC_16s_C4RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pConstants, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSubC_16s_C4RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSubC_16s_C4RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, TypedPointer<Npp16s> var3, int var4, NppiSize var5, int var6);

    public static int nppiSubC_16s_C4IRSfs(TypedPointer<Npp16s> pConstants, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSubC_16s_C4IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSubC_16s_C4IRSfsNative(TypedPointer<Npp16s> var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3, int var4);

    public static int nppiSubC_16sc_C1RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, Npp16sc nConstant, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSubC_16sc_C1RSfsNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSubC_16sc_C1RSfsNative(TypedPointer<Npp16s> var0, int var1, Npp16sc var2, TypedPointer<Npp16s> var3, int var4, NppiSize var5, int var6);

    public static int nppiSubC_16sc_C1IRSfs(Npp16sc nConstant, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSubC_16sc_C1IRSfsNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSubC_16sc_C1IRSfsNative(Npp16sc var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3, int var4);

    public static int nppiSubC_16sc_C3RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pConstants, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSubC_16sc_C3RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSubC_16sc_C3RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, TypedPointer<Npp16s> var3, int var4, NppiSize var5, int var6);

    public static int nppiSubC_16sc_C3IRSfs(TypedPointer<Npp16s> pConstants, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSubC_16sc_C3IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSubC_16sc_C3IRSfsNative(TypedPointer<Npp16s> var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3, int var4);

    public static int nppiSubC_16sc_AC4RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pConstants, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSubC_16sc_AC4RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSubC_16sc_AC4RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, TypedPointer<Npp16s> var3, int var4, NppiSize var5, int var6);

    public static int nppiSubC_16sc_AC4IRSfs(TypedPointer<Npp16s> pConstants, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSubC_16sc_AC4IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSubC_16sc_AC4IRSfsNative(TypedPointer<Npp16s> var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3, int var4);

    public static int nppiSubC_32s_C1RSfs(TypedPointer<Npp32s> pSrc1, int nSrc1Step, int nConstant, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSubC_32s_C1RSfsNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSubC_32s_C1RSfsNative(TypedPointer<Npp32s> var0, int var1, int var2, TypedPointer<Npp32s> var3, int var4, NppiSize var5, int var6);

    public static int nppiSubC_32s_C1IRSfs(int nConstant, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSubC_32s_C1IRSfsNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSubC_32s_C1IRSfsNative(int var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3, int var4);

    public static int nppiSubC_32s_C3RSfs(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pConstants, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSubC_32s_C3RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSubC_32s_C3RSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, TypedPointer<Npp32s> var3, int var4, NppiSize var5, int var6);

    public static int nppiSubC_32s_C3IRSfs(TypedPointer<Npp32s> pConstants, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSubC_32s_C3IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSubC_32s_C3IRSfsNative(TypedPointer<Npp32s> var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3, int var4);

    public static int nppiSubC_32sc_C1RSfs(TypedPointer<Npp32s> pSrc1, int nSrc1Step, Npp32sc nConstant, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSubC_32sc_C1RSfsNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSubC_32sc_C1RSfsNative(TypedPointer<Npp32s> var0, int var1, Npp32sc var2, TypedPointer<Npp32s> var3, int var4, NppiSize var5, int var6);

    public static int nppiSubC_32sc_C1IRSfs(Npp32sc nConstant, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSubC_32sc_C1IRSfsNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSubC_32sc_C1IRSfsNative(Npp32sc var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3, int var4);

    public static int nppiSubC_32sc_C3RSfs(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pConstants, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSubC_32sc_C3RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSubC_32sc_C3RSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, TypedPointer<Npp32s> var3, int var4, NppiSize var5, int var6);

    public static int nppiSubC_32sc_C3IRSfs(TypedPointer<Npp32s> pConstants, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSubC_32sc_C3IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSubC_32sc_C3IRSfsNative(TypedPointer<Npp32s> var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3, int var4);

    public static int nppiSubC_32sc_AC4RSfs(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pConstants, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSubC_32sc_AC4RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSubC_32sc_AC4RSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, TypedPointer<Npp32s> var3, int var4, NppiSize var5, int var6);

    public static int nppiSubC_32sc_AC4IRSfs(TypedPointer<Npp32s> pConstants, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSubC_32sc_AC4IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSubC_32sc_AC4IRSfsNative(TypedPointer<Npp32s> var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3, int var4);

    public static int nppiSubC_32f_C1R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, float nConstant, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSubC_32f_C1RNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSubC_32f_C1RNative(TypedPointer<Npp32f> var0, int var1, float var2, TypedPointer<Npp32f> var3, int var4, NppiSize var5);

    public static int nppiSubC_32f_C1IR(float nConstant, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSubC_32f_C1IRNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiSubC_32f_C1IRNative(float var0, TypedPointer<Npp32f> var1, int var2, NppiSize var3);

    public static int nppiSubC_32f_C3R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSubC_32f_C3RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSubC_32f_C3RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, TypedPointer<Npp32f> var3, int var4, NppiSize var5);

    public static int nppiSubC_32f_C3IR(TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSubC_32f_C3IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiSubC_32f_C3IRNative(TypedPointer<Npp32f> var0, TypedPointer<Npp32f> var1, int var2, NppiSize var3);

    public static int nppiSubC_32f_AC4R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSubC_32f_AC4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSubC_32f_AC4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, TypedPointer<Npp32f> var3, int var4, NppiSize var5);

    public static int nppiSubC_32f_AC4IR(TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSubC_32f_AC4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiSubC_32f_AC4IRNative(TypedPointer<Npp32f> var0, TypedPointer<Npp32f> var1, int var2, NppiSize var3);

    public static int nppiSubC_32f_C4R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSubC_32f_C4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSubC_32f_C4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, TypedPointer<Npp32f> var3, int var4, NppiSize var5);

    public static int nppiSubC_32f_C4IR(TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSubC_32f_C4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiSubC_32f_C4IRNative(TypedPointer<Npp32f> var0, TypedPointer<Npp32f> var1, int var2, NppiSize var3);

    public static int nppiSubC_32fc_C1R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, Npp32fc nConstant, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSubC_32fc_C1RNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSubC_32fc_C1RNative(TypedPointer<Npp32f> var0, int var1, Npp32fc var2, TypedPointer<Npp32f> var3, int var4, NppiSize var5);

    public static int nppiSubC_32fc_C1IR(Npp32fc nConstant, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSubC_32fc_C1IRNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiSubC_32fc_C1IRNative(Npp32fc var0, TypedPointer<Npp32f> var1, int var2, NppiSize var3);

    public static int nppiSubC_32fc_C3R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSubC_32fc_C3RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSubC_32fc_C3RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, TypedPointer<Npp32f> var3, int var4, NppiSize var5);

    public static int nppiSubC_32fc_C3IR(TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSubC_32fc_C3IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiSubC_32fc_C3IRNative(TypedPointer<Npp32f> var0, TypedPointer<Npp32f> var1, int var2, NppiSize var3);

    public static int nppiSubC_32fc_AC4R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSubC_32fc_AC4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSubC_32fc_AC4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, TypedPointer<Npp32f> var3, int var4, NppiSize var5);

    public static int nppiSubC_32fc_AC4IR(TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSubC_32fc_AC4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiSubC_32fc_AC4IRNative(TypedPointer<Npp32f> var0, TypedPointer<Npp32f> var1, int var2, NppiSize var3);

    public static int nppiSubC_32fc_C4R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSubC_32fc_C4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSubC_32fc_C4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, TypedPointer<Npp32f> var3, int var4, NppiSize var5);

    public static int nppiSubC_32fc_C4IR(TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSubC_32fc_C4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiSubC_32fc_C4IRNative(TypedPointer<Npp32f> var0, TypedPointer<Npp32f> var1, int var2, NppiSize var3);

    public static int nppiDivC_8u_C1RSfs(TypedPointer<Npp8u> pSrc1, int nSrc1Step, byte nConstant, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDivC_8u_C1RSfsNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDivC_8u_C1RSfsNative(TypedPointer<Npp8u> var0, int var1, byte var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5, int var6);

    public static int nppiDivC_8u_C1IRSfs(byte nConstant, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDivC_8u_C1IRSfsNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDivC_8u_C1IRSfsNative(byte var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3, int var4);

    public static int nppiDivC_8u_C3RSfs(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDivC_8u_C3RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDivC_8u_C3RSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5, int var6);

    public static int nppiDivC_8u_C3IRSfs(TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDivC_8u_C3IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDivC_8u_C3IRSfsNative(TypedPointer<Npp8u> var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3, int var4);

    public static int nppiDivC_8u_AC4RSfs(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDivC_8u_AC4RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDivC_8u_AC4RSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5, int var6);

    public static int nppiDivC_8u_AC4IRSfs(TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDivC_8u_AC4IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDivC_8u_AC4IRSfsNative(TypedPointer<Npp8u> var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3, int var4);

    public static int nppiDivC_8u_C4RSfs(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDivC_8u_C4RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDivC_8u_C4RSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5, int var6);

    public static int nppiDivC_8u_C4IRSfs(TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDivC_8u_C4IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDivC_8u_C4IRSfsNative(TypedPointer<Npp8u> var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3, int var4);

    public static int nppiDivC_16u_C1RSfs(TypedPointer<Npp16u> pSrc1, int nSrc1Step, short nConstant, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDivC_16u_C1RSfsNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDivC_16u_C1RSfsNative(TypedPointer<Npp16u> var0, int var1, short var2, TypedPointer<Npp16u> var3, int var4, NppiSize var5, int var6);

    public static int nppiDivC_16u_C1IRSfs(short nConstant, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDivC_16u_C1IRSfsNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDivC_16u_C1IRSfsNative(short var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3, int var4);

    public static int nppiDivC_16u_C3RSfs(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDivC_16u_C3RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDivC_16u_C3RSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, TypedPointer<Npp16u> var3, int var4, NppiSize var5, int var6);

    public static int nppiDivC_16u_C3IRSfs(TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDivC_16u_C3IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDivC_16u_C3IRSfsNative(TypedPointer<Npp16u> var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3, int var4);

    public static int nppiDivC_16u_AC4RSfs(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDivC_16u_AC4RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDivC_16u_AC4RSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, TypedPointer<Npp16u> var3, int var4, NppiSize var5, int var6);

    public static int nppiDivC_16u_AC4IRSfs(TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDivC_16u_AC4IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDivC_16u_AC4IRSfsNative(TypedPointer<Npp16u> var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3, int var4);

    public static int nppiDivC_16u_C4RSfs(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDivC_16u_C4RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDivC_16u_C4RSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, TypedPointer<Npp16u> var3, int var4, NppiSize var5, int var6);

    public static int nppiDivC_16u_C4IRSfs(TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDivC_16u_C4IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDivC_16u_C4IRSfsNative(TypedPointer<Npp16u> var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3, int var4);

    public static int nppiDivC_16s_C1RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, short nConstant, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDivC_16s_C1RSfsNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDivC_16s_C1RSfsNative(TypedPointer<Npp16s> var0, int var1, short var2, TypedPointer<Npp16s> var3, int var4, NppiSize var5, int var6);

    public static int nppiDivC_16s_C1IRSfs(short nConstant, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDivC_16s_C1IRSfsNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDivC_16s_C1IRSfsNative(short var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3, int var4);

    public static int nppiDivC_16s_C3RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pConstants, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDivC_16s_C3RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDivC_16s_C3RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, TypedPointer<Npp16s> var3, int var4, NppiSize var5, int var6);

    public static int nppiDivC_16s_C3IRSfs(TypedPointer<Npp16s> pConstants, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDivC_16s_C3IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDivC_16s_C3IRSfsNative(TypedPointer<Npp16s> var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3, int var4);

    public static int nppiDivC_16s_AC4RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pConstants, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDivC_16s_AC4RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDivC_16s_AC4RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, TypedPointer<Npp16s> var3, int var4, NppiSize var5, int var6);

    public static int nppiDivC_16s_AC4IRSfs(TypedPointer<Npp16s> pConstants, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDivC_16s_AC4IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDivC_16s_AC4IRSfsNative(TypedPointer<Npp16s> var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3, int var4);

    public static int nppiDivC_16s_C4RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pConstants, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDivC_16s_C4RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDivC_16s_C4RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, TypedPointer<Npp16s> var3, int var4, NppiSize var5, int var6);

    public static int nppiDivC_16s_C4IRSfs(TypedPointer<Npp16s> pConstants, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDivC_16s_C4IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDivC_16s_C4IRSfsNative(TypedPointer<Npp16s> var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3, int var4);

    public static int nppiDivC_16sc_C1RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, Npp16sc nConstant, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDivC_16sc_C1RSfsNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDivC_16sc_C1RSfsNative(TypedPointer<Npp16s> var0, int var1, Npp16sc var2, TypedPointer<Npp16s> var3, int var4, NppiSize var5, int var6);

    public static int nppiDivC_16sc_C1IRSfs(Npp16sc nConstant, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDivC_16sc_C1IRSfsNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDivC_16sc_C1IRSfsNative(Npp16sc var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3, int var4);

    public static int nppiDivC_16sc_C3RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pConstants, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDivC_16sc_C3RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDivC_16sc_C3RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, TypedPointer<Npp16s> var3, int var4, NppiSize var5, int var6);

    public static int nppiDivC_16sc_C3IRSfs(TypedPointer<Npp16s> pConstants, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDivC_16sc_C3IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDivC_16sc_C3IRSfsNative(TypedPointer<Npp16s> var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3, int var4);

    public static int nppiDivC_16sc_AC4RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pConstants, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDivC_16sc_AC4RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDivC_16sc_AC4RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, TypedPointer<Npp16s> var3, int var4, NppiSize var5, int var6);

    public static int nppiDivC_16sc_AC4IRSfs(TypedPointer<Npp16s> pConstants, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDivC_16sc_AC4IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDivC_16sc_AC4IRSfsNative(TypedPointer<Npp16s> var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3, int var4);

    public static int nppiDivC_32s_C1RSfs(TypedPointer<Npp32s> pSrc1, int nSrc1Step, int nConstant, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDivC_32s_C1RSfsNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDivC_32s_C1RSfsNative(TypedPointer<Npp32s> var0, int var1, int var2, TypedPointer<Npp32s> var3, int var4, NppiSize var5, int var6);

    public static int nppiDivC_32s_C1IRSfs(int nConstant, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDivC_32s_C1IRSfsNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDivC_32s_C1IRSfsNative(int var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3, int var4);

    public static int nppiDivC_32s_C3RSfs(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pConstants, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDivC_32s_C3RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDivC_32s_C3RSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, TypedPointer<Npp32s> var3, int var4, NppiSize var5, int var6);

    public static int nppiDivC_32s_C3IRSfs(TypedPointer<Npp32s> pConstants, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDivC_32s_C3IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDivC_32s_C3IRSfsNative(TypedPointer<Npp32s> var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3, int var4);

    public static int nppiDivC_32sc_C1RSfs(TypedPointer<Npp32s> pSrc1, int nSrc1Step, Npp32sc nConstant, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDivC_32sc_C1RSfsNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDivC_32sc_C1RSfsNative(TypedPointer<Npp32s> var0, int var1, Npp32sc var2, TypedPointer<Npp32s> var3, int var4, NppiSize var5, int var6);

    public static int nppiDivC_32sc_C1IRSfs(Npp32sc nConstant, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDivC_32sc_C1IRSfsNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDivC_32sc_C1IRSfsNative(Npp32sc var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3, int var4);

    public static int nppiDivC_32sc_C3RSfs(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pConstants, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDivC_32sc_C3RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDivC_32sc_C3RSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, TypedPointer<Npp32s> var3, int var4, NppiSize var5, int var6);

    public static int nppiDivC_32sc_C3IRSfs(TypedPointer<Npp32s> pConstants, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDivC_32sc_C3IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDivC_32sc_C3IRSfsNative(TypedPointer<Npp32s> var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3, int var4);

    public static int nppiDivC_32sc_AC4RSfs(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pConstants, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDivC_32sc_AC4RSfsNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDivC_32sc_AC4RSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, TypedPointer<Npp32s> var3, int var4, NppiSize var5, int var6);

    public static int nppiDivC_32sc_AC4IRSfs(TypedPointer<Npp32s> pConstants, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDivC_32sc_AC4IRSfsNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDivC_32sc_AC4IRSfsNative(TypedPointer<Npp32s> var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3, int var4);

    public static int nppiDivC_32f_C1R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, float nConstant, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiDivC_32f_C1RNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiDivC_32f_C1RNative(TypedPointer<Npp32f> var0, int var1, float var2, TypedPointer<Npp32f> var3, int var4, NppiSize var5);

    public static int nppiDivC_32f_C1IR(float nConstant, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiDivC_32f_C1IRNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiDivC_32f_C1IRNative(float var0, TypedPointer<Npp32f> var1, int var2, NppiSize var3);

    public static int nppiDivC_32f_C3R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiDivC_32f_C3RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiDivC_32f_C3RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, TypedPointer<Npp32f> var3, int var4, NppiSize var5);

    public static int nppiDivC_32f_C3IR(TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiDivC_32f_C3IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiDivC_32f_C3IRNative(TypedPointer<Npp32f> var0, TypedPointer<Npp32f> var1, int var2, NppiSize var3);

    public static int nppiDivC_32f_AC4R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiDivC_32f_AC4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiDivC_32f_AC4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, TypedPointer<Npp32f> var3, int var4, NppiSize var5);

    public static int nppiDivC_32f_AC4IR(TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiDivC_32f_AC4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiDivC_32f_AC4IRNative(TypedPointer<Npp32f> var0, TypedPointer<Npp32f> var1, int var2, NppiSize var3);

    public static int nppiDivC_32f_C4R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiDivC_32f_C4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiDivC_32f_C4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, TypedPointer<Npp32f> var3, int var4, NppiSize var5);

    public static int nppiDivC_32f_C4IR(TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiDivC_32f_C4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiDivC_32f_C4IRNative(TypedPointer<Npp32f> var0, TypedPointer<Npp32f> var1, int var2, NppiSize var3);

    public static int nppiDivC_32fc_C1R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, Npp32fc nConstant, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiDivC_32fc_C1RNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiDivC_32fc_C1RNative(TypedPointer<Npp32f> var0, int var1, Npp32fc var2, TypedPointer<Npp32f> var3, int var4, NppiSize var5);

    public static int nppiDivC_32fc_C1IR(Npp32fc nConstant, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiDivC_32fc_C1IRNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiDivC_32fc_C1IRNative(Npp32fc var0, TypedPointer<Npp32f> var1, int var2, NppiSize var3);

    public static int nppiDivC_32fc_C3R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiDivC_32fc_C3RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiDivC_32fc_C3RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, TypedPointer<Npp32f> var3, int var4, NppiSize var5);

    public static int nppiDivC_32fc_C3IR(TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiDivC_32fc_C3IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiDivC_32fc_C3IRNative(TypedPointer<Npp32f> var0, TypedPointer<Npp32f> var1, int var2, NppiSize var3);

    public static int nppiDivC_32fc_AC4R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiDivC_32fc_AC4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiDivC_32fc_AC4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, TypedPointer<Npp32f> var3, int var4, NppiSize var5);

    public static int nppiDivC_32fc_AC4IR(TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiDivC_32fc_AC4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiDivC_32fc_AC4IRNative(TypedPointer<Npp32f> var0, TypedPointer<Npp32f> var1, int var2, NppiSize var3);

    public static int nppiDivC_32fc_C4R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiDivC_32fc_C4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiDivC_32fc_C4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, TypedPointer<Npp32f> var3, int var4, NppiSize var5);

    public static int nppiDivC_32fc_C4IR(TypedPointer<Npp32f> pConstants, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiDivC_32fc_C4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiDivC_32fc_C4IRNative(TypedPointer<Npp32f> var0, TypedPointer<Npp32f> var1, int var2, NppiSize var3);

    public static int nppiAbsDiffC_8u_C1R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, byte nConstant) {
        return JNppi.checkResult(JNppi.nppiAbsDiffC_8u_C1RNative(pSrc1, nSrc1Step, pDst, nDstStep, oSizeROI, nConstant));
    }

    private static native int nppiAbsDiffC_8u_C1RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, byte var5);

    public static int nppiAbsDiffC_16u_C1R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int nConstant) {
        return JNppi.checkResult(JNppi.nppiAbsDiffC_16u_C1RNative(pSrc1, nSrc1Step, pDst, nDstStep, oSizeROI, nConstant));
    }

    private static native int nppiAbsDiffC_16u_C1RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4, int var5);

    public static int nppiAbsDiffC_32f_C1R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI, float nConstant) {
        return JNppi.checkResult(JNppi.nppiAbsDiffC_32f_C1RNative(pSrc1, nSrc1Step, pDst, nDstStep, oSizeROI, nConstant));
    }

    private static native int nppiAbsDiffC_32f_C1RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4, float var5);

    public static int nppiAdd_8u_C1RSfs(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAdd_8u_C1RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAdd_8u_C1RSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6, int var7);

    public static int nppiAdd_8u_C1IRSfs(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAdd_8u_C1IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAdd_8u_C1IRSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, int var5);

    public static int nppiAdd_8u_C3RSfs(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAdd_8u_C3RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAdd_8u_C3RSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6, int var7);

    public static int nppiAdd_8u_C3IRSfs(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAdd_8u_C3IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAdd_8u_C3IRSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, int var5);

    public static int nppiAdd_8u_AC4RSfs(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAdd_8u_AC4RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAdd_8u_AC4RSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6, int var7);

    public static int nppiAdd_8u_AC4IRSfs(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAdd_8u_AC4IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAdd_8u_AC4IRSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, int var5);

    public static int nppiAdd_8u_C4RSfs(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAdd_8u_C4RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAdd_8u_C4RSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6, int var7);

    public static int nppiAdd_8u_C4IRSfs(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAdd_8u_C4IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAdd_8u_C4IRSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, int var5);

    public static int nppiAdd_16u_C1RSfs(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pSrc2, int nSrc2Step, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAdd_16u_C1RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAdd_16u_C1RSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, TypedPointer<Npp16u> var4, int var5, NppiSize var6, int var7);

    public static int nppiAdd_16u_C1IRSfs(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAdd_16u_C1IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAdd_16u_C1IRSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4, int var5);

    public static int nppiAdd_16u_C3RSfs(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pSrc2, int nSrc2Step, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAdd_16u_C3RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAdd_16u_C3RSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, TypedPointer<Npp16u> var4, int var5, NppiSize var6, int var7);

    public static int nppiAdd_16u_C3IRSfs(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAdd_16u_C3IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAdd_16u_C3IRSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4, int var5);

    public static int nppiAdd_16u_AC4RSfs(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pSrc2, int nSrc2Step, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAdd_16u_AC4RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAdd_16u_AC4RSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, TypedPointer<Npp16u> var4, int var5, NppiSize var6, int var7);

    public static int nppiAdd_16u_AC4IRSfs(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAdd_16u_AC4IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAdd_16u_AC4IRSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4, int var5);

    public static int nppiAdd_16u_C4RSfs(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pSrc2, int nSrc2Step, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAdd_16u_C4RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAdd_16u_C4RSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, TypedPointer<Npp16u> var4, int var5, NppiSize var6, int var7);

    public static int nppiAdd_16u_C4IRSfs(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAdd_16u_C4IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAdd_16u_C4IRSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4, int var5);

    public static int nppiAdd_16s_C1RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pSrc2, int nSrc2Step, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAdd_16s_C1RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAdd_16s_C1RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, TypedPointer<Npp16s> var4, int var5, NppiSize var6, int var7);

    public static int nppiAdd_16s_C1IRSfs(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAdd_16s_C1IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAdd_16s_C1IRSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, int var5);

    public static int nppiAdd_16s_C3RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pSrc2, int nSrc2Step, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAdd_16s_C3RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAdd_16s_C3RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, TypedPointer<Npp16s> var4, int var5, NppiSize var6, int var7);

    public static int nppiAdd_16s_C3IRSfs(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAdd_16s_C3IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAdd_16s_C3IRSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, int var5);

    public static int nppiAdd_16s_AC4RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pSrc2, int nSrc2Step, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAdd_16s_AC4RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAdd_16s_AC4RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, TypedPointer<Npp16s> var4, int var5, NppiSize var6, int var7);

    public static int nppiAdd_16s_AC4IRSfs(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAdd_16s_AC4IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAdd_16s_AC4IRSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, int var5);

    public static int nppiAdd_16s_C4RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pSrc2, int nSrc2Step, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAdd_16s_C4RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAdd_16s_C4RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, TypedPointer<Npp16s> var4, int var5, NppiSize var6, int var7);

    public static int nppiAdd_16s_C4IRSfs(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAdd_16s_C4IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAdd_16s_C4IRSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, int var5);

    public static int nppiAdd_16sc_C1RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pSrc2, int nSrc2Step, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAdd_16sc_C1RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAdd_16sc_C1RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, TypedPointer<Npp16s> var4, int var5, NppiSize var6, int var7);

    public static int nppiAdd_16sc_C1IRSfs(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAdd_16sc_C1IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAdd_16sc_C1IRSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, int var5);

    public static int nppiAdd_16sc_C3RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pSrc2, int nSrc2Step, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAdd_16sc_C3RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAdd_16sc_C3RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, TypedPointer<Npp16s> var4, int var5, NppiSize var6, int var7);

    public static int nppiAdd_16sc_C3IRSfs(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAdd_16sc_C3IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAdd_16sc_C3IRSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, int var5);

    public static int nppiAdd_16sc_AC4RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pSrc2, int nSrc2Step, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAdd_16sc_AC4RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAdd_16sc_AC4RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, TypedPointer<Npp16s> var4, int var5, NppiSize var6, int var7);

    public static int nppiAdd_16sc_AC4IRSfs(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAdd_16sc_AC4IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAdd_16sc_AC4IRSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, int var5);

    public static int nppiAdd_32s_C1RSfs(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pSrc2, int nSrc2Step, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAdd_32s_C1RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAdd_32s_C1RSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, TypedPointer<Npp32s> var4, int var5, NppiSize var6, int var7);

    public static int nppiAdd_32s_C1R(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pSrc2, int nSrc2Step, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAdd_32s_C1RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAdd_32s_C1RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, TypedPointer<Npp32s> var4, int var5, NppiSize var6);

    public static int nppiAdd_32s_C1IRSfs(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAdd_32s_C1IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAdd_32s_C1IRSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4, int var5);

    public static int nppiAdd_32s_C3RSfs(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pSrc2, int nSrc2Step, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAdd_32s_C3RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAdd_32s_C3RSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, TypedPointer<Npp32s> var4, int var5, NppiSize var6, int var7);

    public static int nppiAdd_32s_C3IRSfs(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAdd_32s_C3IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAdd_32s_C3IRSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4, int var5);

    public static int nppiAdd_32sc_C1RSfs(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pSrc2, int nSrc2Step, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAdd_32sc_C1RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAdd_32sc_C1RSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, TypedPointer<Npp32s> var4, int var5, NppiSize var6, int var7);

    public static int nppiAdd_32sc_C1IRSfs(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAdd_32sc_C1IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAdd_32sc_C1IRSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4, int var5);

    public static int nppiAdd_32sc_C3RSfs(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pSrc2, int nSrc2Step, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAdd_32sc_C3RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAdd_32sc_C3RSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, TypedPointer<Npp32s> var4, int var5, NppiSize var6, int var7);

    public static int nppiAdd_32sc_C3IRSfs(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAdd_32sc_C3IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAdd_32sc_C3IRSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4, int var5);

    public static int nppiAdd_32sc_AC4RSfs(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pSrc2, int nSrc2Step, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAdd_32sc_AC4RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAdd_32sc_AC4RSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, TypedPointer<Npp32s> var4, int var5, NppiSize var6, int var7);

    public static int nppiAdd_32sc_AC4IRSfs(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiAdd_32sc_AC4IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiAdd_32sc_AC4IRSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4, int var5);

    public static int nppiAdd_32f_C1R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pSrc2, int nSrc2Step, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAdd_32f_C1RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAdd_32f_C1RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6);

    public static int nppiAdd_32f_C1IR(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAdd_32f_C1IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAdd_32f_C1IRNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiAdd_32f_C3R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pSrc2, int nSrc2Step, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAdd_32f_C3RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAdd_32f_C3RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6);

    public static int nppiAdd_32f_C3IR(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAdd_32f_C3IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAdd_32f_C3IRNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiAdd_32f_AC4R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pSrc2, int nSrc2Step, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAdd_32f_AC4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAdd_32f_AC4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6);

    public static int nppiAdd_32f_AC4IR(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAdd_32f_AC4IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAdd_32f_AC4IRNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiAdd_32f_C4R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pSrc2, int nSrc2Step, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAdd_32f_C4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAdd_32f_C4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6);

    public static int nppiAdd_32f_C4IR(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAdd_32f_C4IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAdd_32f_C4IRNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiAdd_32fc_C1R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pSrc2, int nSrc2Step, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAdd_32fc_C1RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAdd_32fc_C1RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6);

    public static int nppiAdd_32fc_C1IR(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAdd_32fc_C1IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAdd_32fc_C1IRNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiAdd_32fc_C3R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pSrc2, int nSrc2Step, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAdd_32fc_C3RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAdd_32fc_C3RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6);

    public static int nppiAdd_32fc_C3IR(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAdd_32fc_C3IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAdd_32fc_C3IRNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiAdd_32fc_AC4R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pSrc2, int nSrc2Step, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAdd_32fc_AC4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAdd_32fc_AC4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6);

    public static int nppiAdd_32fc_AC4IR(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAdd_32fc_AC4IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAdd_32fc_AC4IRNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiAdd_32fc_C4R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pSrc2, int nSrc2Step, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAdd_32fc_C4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAdd_32fc_C4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6);

    public static int nppiAdd_32fc_C4IR(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAdd_32fc_C4IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAdd_32fc_C4IRNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiAddSquare_8u32f_C1IMR(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pMask, int nMaskStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAddSquare_8u32f_C1IMRNative(pSrc, nSrcStep, pMask, nMaskStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAddSquare_8u32f_C1IMRNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6);

    public static int nppiAddSquare_8u32f_C1IR(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAddSquare_8u32f_C1IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAddSquare_8u32f_C1IRNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiAddSquare_16u32f_C1IMR(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp8u> pMask, int nMaskStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAddSquare_16u32f_C1IMRNative(pSrc, nSrcStep, pMask, nMaskStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAddSquare_16u32f_C1IMRNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6);

    public static int nppiAddSquare_16u32f_C1IR(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAddSquare_16u32f_C1IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAddSquare_16u32f_C1IRNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiAddSquare_32f_C1IMR(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp8u> pMask, int nMaskStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAddSquare_32f_C1IMRNative(pSrc, nSrcStep, pMask, nMaskStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAddSquare_32f_C1IMRNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6);

    public static int nppiAddSquare_32f_C1IR(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAddSquare_32f_C1IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAddSquare_32f_C1IRNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiAddProduct_8u32f_C1IMR(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pMask, int nMaskStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAddProduct_8u32f_C1IMRNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pMask, nMaskStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAddProduct_8u32f_C1IMRNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp8u> var4, int var5, TypedPointer<Npp32f> var6, int var7, NppiSize var8);

    public static int nppiAddProduct_8u32f_C1IR(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pSrc2, int nSrc2Step, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAddProduct_8u32f_C1IRNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAddProduct_8u32f_C1IRNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6);

    public static int nppiAddProduct_16u32f_C1IMR(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pMask, int nMaskStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAddProduct_16u32f_C1IMRNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pMask, nMaskStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAddProduct_16u32f_C1IMRNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, TypedPointer<Npp8u> var4, int var5, TypedPointer<Npp32f> var6, int var7, NppiSize var8);

    public static int nppiAddProduct_16u32f_C1IR(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pSrc2, int nSrc2Step, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAddProduct_16u32f_C1IRNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAddProduct_16u32f_C1IRNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6);

    public static int nppiAddProduct_32f_C1IMR(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pMask, int nMaskStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAddProduct_32f_C1IMRNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pMask, nMaskStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAddProduct_32f_C1IMRNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, TypedPointer<Npp8u> var4, int var5, TypedPointer<Npp32f> var6, int var7, NppiSize var8);

    public static int nppiAddProduct_32f_C1IR(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pSrc2, int nSrc2Step, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAddProduct_32f_C1IRNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAddProduct_32f_C1IRNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6);

    public static int nppiAddWeighted_8u32f_C1IMR(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pMask, int nMaskStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, float nAlpha) {
        return JNppi.checkResult(JNppi.nppiAddWeighted_8u32f_C1IMRNative(pSrc, nSrcStep, pMask, nMaskStep, pSrcDst, nSrcDstStep, oSizeROI, nAlpha));
    }

    private static native int nppiAddWeighted_8u32f_C1IMRNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6, float var7);

    public static int nppiAddWeighted_8u32f_C1IR(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, float nAlpha) {
        return JNppi.checkResult(JNppi.nppiAddWeighted_8u32f_C1IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nAlpha));
    }

    private static native int nppiAddWeighted_8u32f_C1IRNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4, float var5);

    public static int nppiAddWeighted_16u32f_C1IMR(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp8u> pMask, int nMaskStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, float nAlpha) {
        return JNppi.checkResult(JNppi.nppiAddWeighted_16u32f_C1IMRNative(pSrc, nSrcStep, pMask, nMaskStep, pSrcDst, nSrcDstStep, oSizeROI, nAlpha));
    }

    private static native int nppiAddWeighted_16u32f_C1IMRNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6, float var7);

    public static int nppiAddWeighted_16u32f_C1IR(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, float nAlpha) {
        return JNppi.checkResult(JNppi.nppiAddWeighted_16u32f_C1IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nAlpha));
    }

    private static native int nppiAddWeighted_16u32f_C1IRNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4, float var5);

    public static int nppiAddWeighted_32f_C1IMR(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp8u> pMask, int nMaskStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, float nAlpha) {
        return JNppi.checkResult(JNppi.nppiAddWeighted_32f_C1IMRNative(pSrc, nSrcStep, pMask, nMaskStep, pSrcDst, nSrcDstStep, oSizeROI, nAlpha));
    }

    private static native int nppiAddWeighted_32f_C1IMRNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6, float var7);

    public static int nppiAddWeighted_32f_C1IR(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, float nAlpha) {
        return JNppi.checkResult(JNppi.nppiAddWeighted_32f_C1IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nAlpha));
    }

    private static native int nppiAddWeighted_32f_C1IRNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4, float var5);

    public static int nppiMul_8u_C1RSfs(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMul_8u_C1RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMul_8u_C1RSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6, int var7);

    public static int nppiMul_8u_C1IRSfs(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMul_8u_C1IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMul_8u_C1IRSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, int var5);

    public static int nppiMul_8u_C3RSfs(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMul_8u_C3RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMul_8u_C3RSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6, int var7);

    public static int nppiMul_8u_C3IRSfs(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMul_8u_C3IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMul_8u_C3IRSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, int var5);

    public static int nppiMul_8u_AC4RSfs(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMul_8u_AC4RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMul_8u_AC4RSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6, int var7);

    public static int nppiMul_8u_AC4IRSfs(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMul_8u_AC4IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMul_8u_AC4IRSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, int var5);

    public static int nppiMul_8u_C4RSfs(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMul_8u_C4RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMul_8u_C4RSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6, int var7);

    public static int nppiMul_8u_C4IRSfs(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMul_8u_C4IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMul_8u_C4IRSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, int var5);

    public static int nppiMul_16u_C1RSfs(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pSrc2, int nSrc2Step, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMul_16u_C1RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMul_16u_C1RSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, TypedPointer<Npp16u> var4, int var5, NppiSize var6, int var7);

    public static int nppiMul_16u_C1IRSfs(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMul_16u_C1IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMul_16u_C1IRSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4, int var5);

    public static int nppiMul_16u_C3RSfs(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pSrc2, int nSrc2Step, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMul_16u_C3RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMul_16u_C3RSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, TypedPointer<Npp16u> var4, int var5, NppiSize var6, int var7);

    public static int nppiMul_16u_C3IRSfs(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMul_16u_C3IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMul_16u_C3IRSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4, int var5);

    public static int nppiMul_16u_AC4RSfs(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pSrc2, int nSrc2Step, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMul_16u_AC4RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMul_16u_AC4RSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, TypedPointer<Npp16u> var4, int var5, NppiSize var6, int var7);

    public static int nppiMul_16u_AC4IRSfs(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMul_16u_AC4IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMul_16u_AC4IRSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4, int var5);

    public static int nppiMul_16u_C4RSfs(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pSrc2, int nSrc2Step, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMul_16u_C4RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMul_16u_C4RSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, TypedPointer<Npp16u> var4, int var5, NppiSize var6, int var7);

    public static int nppiMul_16u_C4IRSfs(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMul_16u_C4IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMul_16u_C4IRSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4, int var5);

    public static int nppiMul_16s_C1RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pSrc2, int nSrc2Step, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMul_16s_C1RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMul_16s_C1RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, TypedPointer<Npp16s> var4, int var5, NppiSize var6, int var7);

    public static int nppiMul_16s_C1IRSfs(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMul_16s_C1IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMul_16s_C1IRSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, int var5);

    public static int nppiMul_16s_C3RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pSrc2, int nSrc2Step, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMul_16s_C3RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMul_16s_C3RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, TypedPointer<Npp16s> var4, int var5, NppiSize var6, int var7);

    public static int nppiMul_16s_C3IRSfs(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMul_16s_C3IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMul_16s_C3IRSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, int var5);

    public static int nppiMul_16s_AC4RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pSrc2, int nSrc2Step, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMul_16s_AC4RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMul_16s_AC4RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, TypedPointer<Npp16s> var4, int var5, NppiSize var6, int var7);

    public static int nppiMul_16s_AC4IRSfs(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMul_16s_AC4IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMul_16s_AC4IRSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, int var5);

    public static int nppiMul_16s_C4RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pSrc2, int nSrc2Step, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMul_16s_C4RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMul_16s_C4RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, TypedPointer<Npp16s> var4, int var5, NppiSize var6, int var7);

    public static int nppiMul_16s_C4IRSfs(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMul_16s_C4IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMul_16s_C4IRSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, int var5);

    public static int nppiMul_16sc_C1RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pSrc2, int nSrc2Step, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMul_16sc_C1RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMul_16sc_C1RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, TypedPointer<Npp16s> var4, int var5, NppiSize var6, int var7);

    public static int nppiMul_16sc_C1IRSfs(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMul_16sc_C1IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMul_16sc_C1IRSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, int var5);

    public static int nppiMul_16sc_C3RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pSrc2, int nSrc2Step, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMul_16sc_C3RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMul_16sc_C3RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, TypedPointer<Npp16s> var4, int var5, NppiSize var6, int var7);

    public static int nppiMul_16sc_C3IRSfs(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMul_16sc_C3IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMul_16sc_C3IRSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, int var5);

    public static int nppiMul_16sc_AC4RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pSrc2, int nSrc2Step, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMul_16sc_AC4RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMul_16sc_AC4RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, TypedPointer<Npp16s> var4, int var5, NppiSize var6, int var7);

    public static int nppiMul_16sc_AC4IRSfs(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMul_16sc_AC4IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMul_16sc_AC4IRSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, int var5);

    public static int nppiMul_32s_C1RSfs(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pSrc2, int nSrc2Step, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMul_32s_C1RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMul_32s_C1RSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, TypedPointer<Npp32s> var4, int var5, NppiSize var6, int var7);

    public static int nppiMul_32s_C1R(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pSrc2, int nSrc2Step, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMul_32s_C1RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiMul_32s_C1RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, TypedPointer<Npp32s> var4, int var5, NppiSize var6);

    public static int nppiMul_32s_C1IRSfs(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMul_32s_C1IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMul_32s_C1IRSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4, int var5);

    public static int nppiMul_32s_C3RSfs(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pSrc2, int nSrc2Step, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMul_32s_C3RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMul_32s_C3RSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, TypedPointer<Npp32s> var4, int var5, NppiSize var6, int var7);

    public static int nppiMul_32s_C3IRSfs(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMul_32s_C3IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMul_32s_C3IRSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4, int var5);

    public static int nppiMul_32sc_C1RSfs(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pSrc2, int nSrc2Step, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMul_32sc_C1RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMul_32sc_C1RSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, TypedPointer<Npp32s> var4, int var5, NppiSize var6, int var7);

    public static int nppiMul_32sc_C1IRSfs(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMul_32sc_C1IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMul_32sc_C1IRSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4, int var5);

    public static int nppiMul_32sc_C3RSfs(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pSrc2, int nSrc2Step, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMul_32sc_C3RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMul_32sc_C3RSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, TypedPointer<Npp32s> var4, int var5, NppiSize var6, int var7);

    public static int nppiMul_32sc_C3IRSfs(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMul_32sc_C3IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMul_32sc_C3IRSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4, int var5);

    public static int nppiMul_32sc_AC4RSfs(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pSrc2, int nSrc2Step, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMul_32sc_AC4RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMul_32sc_AC4RSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, TypedPointer<Npp32s> var4, int var5, NppiSize var6, int var7);

    public static int nppiMul_32sc_AC4IRSfs(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiMul_32sc_AC4IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiMul_32sc_AC4IRSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4, int var5);

    public static int nppiMul_32f_C1R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pSrc2, int nSrc2Step, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMul_32f_C1RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiMul_32f_C1RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6);

    public static int nppiMul_32f_C1IR(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMul_32f_C1IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiMul_32f_C1IRNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiMul_32f_C3R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pSrc2, int nSrc2Step, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMul_32f_C3RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiMul_32f_C3RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6);

    public static int nppiMul_32f_C3IR(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMul_32f_C3IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiMul_32f_C3IRNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiMul_32f_AC4R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pSrc2, int nSrc2Step, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMul_32f_AC4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiMul_32f_AC4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6);

    public static int nppiMul_32f_AC4IR(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMul_32f_AC4IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiMul_32f_AC4IRNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiMul_32f_C4R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pSrc2, int nSrc2Step, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMul_32f_C4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiMul_32f_C4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6);

    public static int nppiMul_32f_C4IR(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMul_32f_C4IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiMul_32f_C4IRNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiMul_32fc_C1R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pSrc2, int nSrc2Step, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMul_32fc_C1RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiMul_32fc_C1RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6);

    public static int nppiMul_32fc_C1IR(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMul_32fc_C1IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiMul_32fc_C1IRNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiMul_32fc_C3R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pSrc2, int nSrc2Step, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMul_32fc_C3RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiMul_32fc_C3RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6);

    public static int nppiMul_32fc_C3IR(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMul_32fc_C3IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiMul_32fc_C3IRNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiMul_32fc_AC4R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pSrc2, int nSrc2Step, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMul_32fc_AC4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiMul_32fc_AC4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6);

    public static int nppiMul_32fc_AC4IR(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMul_32fc_AC4IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiMul_32fc_AC4IRNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiMul_32fc_C4R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pSrc2, int nSrc2Step, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMul_32fc_C4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiMul_32fc_C4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6);

    public static int nppiMul_32fc_C4IR(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMul_32fc_C4IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiMul_32fc_C4IRNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiMulScale_8u_C1R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulScale_8u_C1RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiMulScale_8u_C1RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6);

    public static int nppiMulScale_8u_C1IR(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulScale_8u_C1IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiMulScale_8u_C1IRNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiMulScale_8u_C3R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulScale_8u_C3RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiMulScale_8u_C3RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6);

    public static int nppiMulScale_8u_C3IR(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulScale_8u_C3IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiMulScale_8u_C3IRNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiMulScale_8u_AC4R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulScale_8u_AC4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiMulScale_8u_AC4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6);

    public static int nppiMulScale_8u_AC4IR(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulScale_8u_AC4IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiMulScale_8u_AC4IRNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiMulScale_8u_C4R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulScale_8u_C4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiMulScale_8u_C4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6);

    public static int nppiMulScale_8u_C4IR(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulScale_8u_C4IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiMulScale_8u_C4IRNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiMulScale_16u_C1R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pSrc2, int nSrc2Step, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulScale_16u_C1RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiMulScale_16u_C1RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, TypedPointer<Npp16u> var4, int var5, NppiSize var6);

    public static int nppiMulScale_16u_C1IR(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulScale_16u_C1IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiMulScale_16u_C1IRNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4);

    public static int nppiMulScale_16u_C3R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pSrc2, int nSrc2Step, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulScale_16u_C3RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiMulScale_16u_C3RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, TypedPointer<Npp16u> var4, int var5, NppiSize var6);

    public static int nppiMulScale_16u_C3IR(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulScale_16u_C3IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiMulScale_16u_C3IRNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4);

    public static int nppiMulScale_16u_AC4R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pSrc2, int nSrc2Step, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulScale_16u_AC4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiMulScale_16u_AC4RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, TypedPointer<Npp16u> var4, int var5, NppiSize var6);

    public static int nppiMulScale_16u_AC4IR(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulScale_16u_AC4IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiMulScale_16u_AC4IRNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4);

    public static int nppiMulScale_16u_C4R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pSrc2, int nSrc2Step, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulScale_16u_C4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiMulScale_16u_C4RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, TypedPointer<Npp16u> var4, int var5, NppiSize var6);

    public static int nppiMulScale_16u_C4IR(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMulScale_16u_C4IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiMulScale_16u_C4IRNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4);

    public static int nppiSub_8u_C1RSfs(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSub_8u_C1RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSub_8u_C1RSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6, int var7);

    public static int nppiSub_8u_C1IRSfs(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSub_8u_C1IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSub_8u_C1IRSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, int var5);

    public static int nppiSub_8u_C3RSfs(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSub_8u_C3RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSub_8u_C3RSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6, int var7);

    public static int nppiSub_8u_C3IRSfs(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSub_8u_C3IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSub_8u_C3IRSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, int var5);

    public static int nppiSub_8u_AC4RSfs(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSub_8u_AC4RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSub_8u_AC4RSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6, int var7);

    public static int nppiSub_8u_AC4IRSfs(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSub_8u_AC4IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSub_8u_AC4IRSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, int var5);

    public static int nppiSub_8u_C4RSfs(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSub_8u_C4RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSub_8u_C4RSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6, int var7);

    public static int nppiSub_8u_C4IRSfs(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSub_8u_C4IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSub_8u_C4IRSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, int var5);

    public static int nppiSub_16u_C1RSfs(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pSrc2, int nSrc2Step, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSub_16u_C1RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSub_16u_C1RSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, TypedPointer<Npp16u> var4, int var5, NppiSize var6, int var7);

    public static int nppiSub_16u_C1IRSfs(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSub_16u_C1IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSub_16u_C1IRSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4, int var5);

    public static int nppiSub_16u_C3RSfs(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pSrc2, int nSrc2Step, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSub_16u_C3RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSub_16u_C3RSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, TypedPointer<Npp16u> var4, int var5, NppiSize var6, int var7);

    public static int nppiSub_16u_C3IRSfs(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSub_16u_C3IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSub_16u_C3IRSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4, int var5);

    public static int nppiSub_16u_AC4RSfs(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pSrc2, int nSrc2Step, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSub_16u_AC4RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSub_16u_AC4RSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, TypedPointer<Npp16u> var4, int var5, NppiSize var6, int var7);

    public static int nppiSub_16u_AC4IRSfs(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSub_16u_AC4IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSub_16u_AC4IRSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4, int var5);

    public static int nppiSub_16u_C4RSfs(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pSrc2, int nSrc2Step, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSub_16u_C4RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSub_16u_C4RSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, TypedPointer<Npp16u> var4, int var5, NppiSize var6, int var7);

    public static int nppiSub_16u_C4IRSfs(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSub_16u_C4IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSub_16u_C4IRSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4, int var5);

    public static int nppiSub_16s_C1RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pSrc2, int nSrc2Step, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSub_16s_C1RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSub_16s_C1RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, TypedPointer<Npp16s> var4, int var5, NppiSize var6, int var7);

    public static int nppiSub_16s_C1IRSfs(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSub_16s_C1IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSub_16s_C1IRSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, int var5);

    public static int nppiSub_16s_C3RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pSrc2, int nSrc2Step, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSub_16s_C3RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSub_16s_C3RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, TypedPointer<Npp16s> var4, int var5, NppiSize var6, int var7);

    public static int nppiSub_16s_C3IRSfs(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSub_16s_C3IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSub_16s_C3IRSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, int var5);

    public static int nppiSub_16s_AC4RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pSrc2, int nSrc2Step, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSub_16s_AC4RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSub_16s_AC4RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, TypedPointer<Npp16s> var4, int var5, NppiSize var6, int var7);

    public static int nppiSub_16s_AC4IRSfs(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSub_16s_AC4IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSub_16s_AC4IRSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, int var5);

    public static int nppiSub_16s_C4RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pSrc2, int nSrc2Step, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSub_16s_C4RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSub_16s_C4RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, TypedPointer<Npp16s> var4, int var5, NppiSize var6, int var7);

    public static int nppiSub_16s_C4IRSfs(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSub_16s_C4IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSub_16s_C4IRSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, int var5);

    public static int nppiSub_16sc_C1RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pSrc2, int nSrc2Step, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSub_16sc_C1RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSub_16sc_C1RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, TypedPointer<Npp16s> var4, int var5, NppiSize var6, int var7);

    public static int nppiSub_16sc_C1IRSfs(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSub_16sc_C1IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSub_16sc_C1IRSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, int var5);

    public static int nppiSub_16sc_C3RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pSrc2, int nSrc2Step, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSub_16sc_C3RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSub_16sc_C3RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, TypedPointer<Npp16s> var4, int var5, NppiSize var6, int var7);

    public static int nppiSub_16sc_C3IRSfs(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSub_16sc_C3IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSub_16sc_C3IRSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, int var5);

    public static int nppiSub_16sc_AC4RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pSrc2, int nSrc2Step, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSub_16sc_AC4RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSub_16sc_AC4RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, TypedPointer<Npp16s> var4, int var5, NppiSize var6, int var7);

    public static int nppiSub_16sc_AC4IRSfs(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSub_16sc_AC4IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSub_16sc_AC4IRSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, int var5);

    public static int nppiSub_32s_C1RSfs(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pSrc2, int nSrc2Step, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSub_32s_C1RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSub_32s_C1RSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, TypedPointer<Npp32s> var4, int var5, NppiSize var6, int var7);

    public static int nppiSub_32s_C1R(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pSrc2, int nSrc2Step, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSub_32s_C1RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSub_32s_C1RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, TypedPointer<Npp32s> var4, int var5, NppiSize var6);

    public static int nppiSub_32s_C1IRSfs(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSub_32s_C1IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSub_32s_C1IRSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4, int var5);

    public static int nppiSub_32s_C3RSfs(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pSrc2, int nSrc2Step, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSub_32s_C3RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSub_32s_C3RSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, TypedPointer<Npp32s> var4, int var5, NppiSize var6, int var7);

    public static int nppiSub_32s_C3IRSfs(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSub_32s_C3IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSub_32s_C3IRSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4, int var5);

    public static int nppiSub_32sc_C1RSfs(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pSrc2, int nSrc2Step, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSub_32sc_C1RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSub_32sc_C1RSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, TypedPointer<Npp32s> var4, int var5, NppiSize var6, int var7);

    public static int nppiSub_32sc_C1IRSfs(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSub_32sc_C1IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSub_32sc_C1IRSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4, int var5);

    public static int nppiSub_32sc_C3RSfs(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pSrc2, int nSrc2Step, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSub_32sc_C3RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSub_32sc_C3RSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, TypedPointer<Npp32s> var4, int var5, NppiSize var6, int var7);

    public static int nppiSub_32sc_C3IRSfs(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSub_32sc_C3IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSub_32sc_C3IRSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4, int var5);

    public static int nppiSub_32sc_AC4RSfs(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pSrc2, int nSrc2Step, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSub_32sc_AC4RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSub_32sc_AC4RSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, TypedPointer<Npp32s> var4, int var5, NppiSize var6, int var7);

    public static int nppiSub_32sc_AC4IRSfs(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSub_32sc_AC4IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSub_32sc_AC4IRSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4, int var5);

    public static int nppiSub_32f_C1R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pSrc2, int nSrc2Step, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSub_32f_C1RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSub_32f_C1RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6);

    public static int nppiSub_32f_C1IR(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSub_32f_C1IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiSub_32f_C1IRNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiSub_32f_C3R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pSrc2, int nSrc2Step, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSub_32f_C3RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSub_32f_C3RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6);

    public static int nppiSub_32f_C3IR(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSub_32f_C3IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiSub_32f_C3IRNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiSub_32f_AC4R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pSrc2, int nSrc2Step, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSub_32f_AC4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSub_32f_AC4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6);

    public static int nppiSub_32f_AC4IR(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSub_32f_AC4IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiSub_32f_AC4IRNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiSub_32f_C4R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pSrc2, int nSrc2Step, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSub_32f_C4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSub_32f_C4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6);

    public static int nppiSub_32f_C4IR(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSub_32f_C4IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiSub_32f_C4IRNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiSub_32fc_C1R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pSrc2, int nSrc2Step, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSub_32fc_C1RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSub_32fc_C1RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6);

    public static int nppiSub_32fc_C1IR(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSub_32fc_C1IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiSub_32fc_C1IRNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiSub_32fc_C3R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pSrc2, int nSrc2Step, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSub_32fc_C3RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSub_32fc_C3RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6);

    public static int nppiSub_32fc_C3IR(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSub_32fc_C3IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiSub_32fc_C3IRNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiSub_32fc_AC4R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pSrc2, int nSrc2Step, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSub_32fc_AC4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSub_32fc_AC4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6);

    public static int nppiSub_32fc_AC4IR(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSub_32fc_AC4IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiSub_32fc_AC4IRNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiSub_32fc_C4R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pSrc2, int nSrc2Step, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSub_32fc_C4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSub_32fc_C4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6);

    public static int nppiSub_32fc_C4IR(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSub_32fc_C4IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiSub_32fc_C4IRNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiDiv_8u_C1RSfs(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_8u_C1RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDiv_8u_C1RSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6, int var7);

    public static int nppiDiv_8u_C1IRSfs(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_8u_C1IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDiv_8u_C1IRSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, int var5);

    public static int nppiDiv_8u_C3RSfs(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_8u_C3RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDiv_8u_C3RSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6, int var7);

    public static int nppiDiv_8u_C3IRSfs(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_8u_C3IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDiv_8u_C3IRSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, int var5);

    public static int nppiDiv_8u_AC4RSfs(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_8u_AC4RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDiv_8u_AC4RSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6, int var7);

    public static int nppiDiv_8u_AC4IRSfs(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_8u_AC4IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDiv_8u_AC4IRSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, int var5);

    public static int nppiDiv_8u_C4RSfs(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_8u_C4RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDiv_8u_C4RSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6, int var7);

    public static int nppiDiv_8u_C4IRSfs(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_8u_C4IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDiv_8u_C4IRSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, int var5);

    public static int nppiDiv_16u_C1RSfs(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pSrc2, int nSrc2Step, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_16u_C1RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDiv_16u_C1RSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, TypedPointer<Npp16u> var4, int var5, NppiSize var6, int var7);

    public static int nppiDiv_16u_C1IRSfs(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_16u_C1IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDiv_16u_C1IRSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4, int var5);

    public static int nppiDiv_16u_C3RSfs(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pSrc2, int nSrc2Step, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_16u_C3RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDiv_16u_C3RSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, TypedPointer<Npp16u> var4, int var5, NppiSize var6, int var7);

    public static int nppiDiv_16u_C3IRSfs(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_16u_C3IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDiv_16u_C3IRSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4, int var5);

    public static int nppiDiv_16u_AC4RSfs(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pSrc2, int nSrc2Step, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_16u_AC4RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDiv_16u_AC4RSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, TypedPointer<Npp16u> var4, int var5, NppiSize var6, int var7);

    public static int nppiDiv_16u_AC4IRSfs(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_16u_AC4IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDiv_16u_AC4IRSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4, int var5);

    public static int nppiDiv_16u_C4RSfs(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pSrc2, int nSrc2Step, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_16u_C4RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDiv_16u_C4RSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, TypedPointer<Npp16u> var4, int var5, NppiSize var6, int var7);

    public static int nppiDiv_16u_C4IRSfs(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_16u_C4IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDiv_16u_C4IRSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4, int var5);

    public static int nppiDiv_16s_C1RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pSrc2, int nSrc2Step, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_16s_C1RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDiv_16s_C1RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, TypedPointer<Npp16s> var4, int var5, NppiSize var6, int var7);

    public static int nppiDiv_16s_C1IRSfs(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_16s_C1IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDiv_16s_C1IRSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, int var5);

    public static int nppiDiv_16s_C3RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pSrc2, int nSrc2Step, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_16s_C3RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDiv_16s_C3RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, TypedPointer<Npp16s> var4, int var5, NppiSize var6, int var7);

    public static int nppiDiv_16s_C3IRSfs(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_16s_C3IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDiv_16s_C3IRSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, int var5);

    public static int nppiDiv_16s_AC4RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pSrc2, int nSrc2Step, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_16s_AC4RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDiv_16s_AC4RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, TypedPointer<Npp16s> var4, int var5, NppiSize var6, int var7);

    public static int nppiDiv_16s_AC4IRSfs(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_16s_AC4IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDiv_16s_AC4IRSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, int var5);

    public static int nppiDiv_16s_C4RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pSrc2, int nSrc2Step, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_16s_C4RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDiv_16s_C4RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, TypedPointer<Npp16s> var4, int var5, NppiSize var6, int var7);

    public static int nppiDiv_16s_C4IRSfs(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_16s_C4IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDiv_16s_C4IRSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, int var5);

    public static int nppiDiv_16sc_C1RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pSrc2, int nSrc2Step, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_16sc_C1RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDiv_16sc_C1RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, TypedPointer<Npp16s> var4, int var5, NppiSize var6, int var7);

    public static int nppiDiv_16sc_C1IRSfs(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_16sc_C1IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDiv_16sc_C1IRSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, int var5);

    public static int nppiDiv_16sc_C3RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pSrc2, int nSrc2Step, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_16sc_C3RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDiv_16sc_C3RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, TypedPointer<Npp16s> var4, int var5, NppiSize var6, int var7);

    public static int nppiDiv_16sc_C3IRSfs(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_16sc_C3IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDiv_16sc_C3IRSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, int var5);

    public static int nppiDiv_16sc_AC4RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pSrc2, int nSrc2Step, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_16sc_AC4RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDiv_16sc_AC4RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, TypedPointer<Npp16s> var4, int var5, NppiSize var6, int var7);

    public static int nppiDiv_16sc_AC4IRSfs(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_16sc_AC4IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDiv_16sc_AC4IRSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, int var5);

    public static int nppiDiv_32s_C1RSfs(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pSrc2, int nSrc2Step, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_32s_C1RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDiv_32s_C1RSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, TypedPointer<Npp32s> var4, int var5, NppiSize var6, int var7);

    public static int nppiDiv_32s_C1R(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pSrc2, int nSrc2Step, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiDiv_32s_C1RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiDiv_32s_C1RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, TypedPointer<Npp32s> var4, int var5, NppiSize var6);

    public static int nppiDiv_32s_C1IRSfs(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_32s_C1IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDiv_32s_C1IRSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4, int var5);

    public static int nppiDiv_32s_C3RSfs(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pSrc2, int nSrc2Step, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_32s_C3RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDiv_32s_C3RSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, TypedPointer<Npp32s> var4, int var5, NppiSize var6, int var7);

    public static int nppiDiv_32s_C3IRSfs(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_32s_C3IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDiv_32s_C3IRSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4, int var5);

    public static int nppiDiv_32sc_C1RSfs(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pSrc2, int nSrc2Step, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_32sc_C1RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDiv_32sc_C1RSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, TypedPointer<Npp32s> var4, int var5, NppiSize var6, int var7);

    public static int nppiDiv_32sc_C1IRSfs(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_32sc_C1IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDiv_32sc_C1IRSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4, int var5);

    public static int nppiDiv_32sc_C3RSfs(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pSrc2, int nSrc2Step, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_32sc_C3RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDiv_32sc_C3RSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, TypedPointer<Npp32s> var4, int var5, NppiSize var6, int var7);

    public static int nppiDiv_32sc_C3IRSfs(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_32sc_C3IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDiv_32sc_C3IRSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4, int var5);

    public static int nppiDiv_32sc_AC4RSfs(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pSrc2, int nSrc2Step, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_32sc_AC4RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDiv_32sc_AC4RSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, TypedPointer<Npp32s> var4, int var5, NppiSize var6, int var7);

    public static int nppiDiv_32sc_AC4IRSfs(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_32sc_AC4IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiDiv_32sc_AC4IRSfsNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4, int var5);

    public static int nppiDiv_32f_C1R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pSrc2, int nSrc2Step, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiDiv_32f_C1RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiDiv_32f_C1RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6);

    public static int nppiDiv_32f_C1IR(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiDiv_32f_C1IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiDiv_32f_C1IRNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiDiv_32f_C3R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pSrc2, int nSrc2Step, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiDiv_32f_C3RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiDiv_32f_C3RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6);

    public static int nppiDiv_32f_C3IR(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiDiv_32f_C3IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiDiv_32f_C3IRNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiDiv_32f_AC4R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pSrc2, int nSrc2Step, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiDiv_32f_AC4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiDiv_32f_AC4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6);

    public static int nppiDiv_32f_AC4IR(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiDiv_32f_AC4IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiDiv_32f_AC4IRNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiDiv_32f_C4R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pSrc2, int nSrc2Step, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiDiv_32f_C4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiDiv_32f_C4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6);

    public static int nppiDiv_32f_C4IR(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiDiv_32f_C4IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiDiv_32f_C4IRNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiDiv_32fc_C1R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pSrc2, int nSrc2Step, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiDiv_32fc_C1RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiDiv_32fc_C1RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6);

    public static int nppiDiv_32fc_C1IR(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiDiv_32fc_C1IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiDiv_32fc_C1IRNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiDiv_32fc_C3R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pSrc2, int nSrc2Step, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiDiv_32fc_C3RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiDiv_32fc_C3RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6);

    public static int nppiDiv_32fc_C3IR(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiDiv_32fc_C3IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiDiv_32fc_C3IRNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiDiv_32fc_AC4R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pSrc2, int nSrc2Step, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiDiv_32fc_AC4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiDiv_32fc_AC4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6);

    public static int nppiDiv_32fc_AC4IR(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiDiv_32fc_AC4IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiDiv_32fc_AC4IRNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiDiv_32fc_C4R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pSrc2, int nSrc2Step, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiDiv_32fc_C4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiDiv_32fc_C4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6);

    public static int nppiDiv_32fc_C4IR(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiDiv_32fc_C4IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiDiv_32fc_C4IRNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiDiv_Round_8u_C1RSfs(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int rndMode, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_Round_8u_C1RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, rndMode, nScaleFactor));
    }

    private static native int nppiDiv_Round_8u_C1RSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6, int var7, int var8);

    public static int nppiDiv_Round_8u_C1IRSfs(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int rndMode, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_Round_8u_C1IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, rndMode, nScaleFactor));
    }

    private static native int nppiDiv_Round_8u_C1IRSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, int var5, int var6);

    public static int nppiDiv_Round_8u_C3RSfs(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int rndMode, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_Round_8u_C3RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, rndMode, nScaleFactor));
    }

    private static native int nppiDiv_Round_8u_C3RSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6, int var7, int var8);

    public static int nppiDiv_Round_8u_C3IRSfs(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int rndMode, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_Round_8u_C3IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, rndMode, nScaleFactor));
    }

    private static native int nppiDiv_Round_8u_C3IRSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, int var5, int var6);

    public static int nppiDiv_Round_8u_AC4RSfs(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int rndMode, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_Round_8u_AC4RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, rndMode, nScaleFactor));
    }

    private static native int nppiDiv_Round_8u_AC4RSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6, int var7, int var8);

    public static int nppiDiv_Round_8u_AC4IRSfs(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int rndMode, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_Round_8u_AC4IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, rndMode, nScaleFactor));
    }

    private static native int nppiDiv_Round_8u_AC4IRSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, int var5, int var6);

    public static int nppiDiv_Round_8u_C4RSfs(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int rndMode, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_Round_8u_C4RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, rndMode, nScaleFactor));
    }

    private static native int nppiDiv_Round_8u_C4RSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6, int var7, int var8);

    public static int nppiDiv_Round_8u_C4IRSfs(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int rndMode, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_Round_8u_C4IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, rndMode, nScaleFactor));
    }

    private static native int nppiDiv_Round_8u_C4IRSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, int var5, int var6);

    public static int nppiDiv_Round_16u_C1RSfs(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pSrc2, int nSrc2Step, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int rndMode, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_Round_16u_C1RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, rndMode, nScaleFactor));
    }

    private static native int nppiDiv_Round_16u_C1RSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, TypedPointer<Npp16u> var4, int var5, NppiSize var6, int var7, int var8);

    public static int nppiDiv_Round_16u_C1IRSfs(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int rndMode, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_Round_16u_C1IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, rndMode, nScaleFactor));
    }

    private static native int nppiDiv_Round_16u_C1IRSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4, int var5, int var6);

    public static int nppiDiv_Round_16u_C3RSfs(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pSrc2, int nSrc2Step, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int rndMode, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_Round_16u_C3RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, rndMode, nScaleFactor));
    }

    private static native int nppiDiv_Round_16u_C3RSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, TypedPointer<Npp16u> var4, int var5, NppiSize var6, int var7, int var8);

    public static int nppiDiv_Round_16u_C3IRSfs(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int rndMode, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_Round_16u_C3IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, rndMode, nScaleFactor));
    }

    private static native int nppiDiv_Round_16u_C3IRSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4, int var5, int var6);

    public static int nppiDiv_Round_16u_AC4RSfs(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pSrc2, int nSrc2Step, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int rndMode, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_Round_16u_AC4RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, rndMode, nScaleFactor));
    }

    private static native int nppiDiv_Round_16u_AC4RSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, TypedPointer<Npp16u> var4, int var5, NppiSize var6, int var7, int var8);

    public static int nppiDiv_Round_16u_AC4IRSfs(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int rndMode, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_Round_16u_AC4IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, rndMode, nScaleFactor));
    }

    private static native int nppiDiv_Round_16u_AC4IRSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4, int var5, int var6);

    public static int nppiDiv_Round_16u_C4RSfs(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pSrc2, int nSrc2Step, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int rndMode, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_Round_16u_C4RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, rndMode, nScaleFactor));
    }

    private static native int nppiDiv_Round_16u_C4RSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, TypedPointer<Npp16u> var4, int var5, NppiSize var6, int var7, int var8);

    public static int nppiDiv_Round_16u_C4IRSfs(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int rndMode, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_Round_16u_C4IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, rndMode, nScaleFactor));
    }

    private static native int nppiDiv_Round_16u_C4IRSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4, int var5, int var6);

    public static int nppiDiv_Round_16s_C1RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pSrc2, int nSrc2Step, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int rndMode, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_Round_16s_C1RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, rndMode, nScaleFactor));
    }

    private static native int nppiDiv_Round_16s_C1RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, TypedPointer<Npp16s> var4, int var5, NppiSize var6, int var7, int var8);

    public static int nppiDiv_Round_16s_C1IRSfs(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int rndMode, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_Round_16s_C1IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, rndMode, nScaleFactor));
    }

    private static native int nppiDiv_Round_16s_C1IRSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, int var5, int var6);

    public static int nppiDiv_Round_16s_C3RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pSrc2, int nSrc2Step, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int rndMode, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_Round_16s_C3RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, rndMode, nScaleFactor));
    }

    private static native int nppiDiv_Round_16s_C3RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, TypedPointer<Npp16s> var4, int var5, NppiSize var6, int var7, int var8);

    public static int nppiDiv_Round_16s_C3IRSfs(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int rndMode, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_Round_16s_C3IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, rndMode, nScaleFactor));
    }

    private static native int nppiDiv_Round_16s_C3IRSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, int var5, int var6);

    public static int nppiDiv_Round_16s_AC4RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pSrc2, int nSrc2Step, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int rndMode, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_Round_16s_AC4RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, rndMode, nScaleFactor));
    }

    private static native int nppiDiv_Round_16s_AC4RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, TypedPointer<Npp16s> var4, int var5, NppiSize var6, int var7, int var8);

    public static int nppiDiv_Round_16s_AC4IRSfs(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int rndMode, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_Round_16s_AC4IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, rndMode, nScaleFactor));
    }

    private static native int nppiDiv_Round_16s_AC4IRSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, int var5, int var6);

    public static int nppiDiv_Round_16s_C4RSfs(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pSrc2, int nSrc2Step, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int rndMode, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_Round_16s_C4RSfsNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, rndMode, nScaleFactor));
    }

    private static native int nppiDiv_Round_16s_C4RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, TypedPointer<Npp16s> var4, int var5, NppiSize var6, int var7, int var8);

    public static int nppiDiv_Round_16s_C4IRSfs(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int rndMode, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiDiv_Round_16s_C4IRSfsNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI, rndMode, nScaleFactor));
    }

    private static native int nppiDiv_Round_16s_C4IRSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, int var5, int var6);

    public static int nppiAbs_16s_C1R(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAbs_16s_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAbs_16s_C1RNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4);

    public static int nppiAbs_16s_C1IR(TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAbs_16s_C1IRNative(pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAbs_16s_C1IRNative(TypedPointer<Npp16s> var0, int var1, NppiSize var2);

    public static int nppiAbs_16s_C3R(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAbs_16s_C3RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAbs_16s_C3RNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4);

    public static int nppiAbs_16s_C3IR(TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAbs_16s_C3IRNative(pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAbs_16s_C3IRNative(TypedPointer<Npp16s> var0, int var1, NppiSize var2);

    public static int nppiAbs_16s_AC4R(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAbs_16s_AC4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAbs_16s_AC4RNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4);

    public static int nppiAbs_16s_AC4IR(TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAbs_16s_AC4IRNative(pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAbs_16s_AC4IRNative(TypedPointer<Npp16s> var0, int var1, NppiSize var2);

    public static int nppiAbs_16s_C4R(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAbs_16s_C4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAbs_16s_C4RNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4);

    public static int nppiAbs_16s_C4IR(TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAbs_16s_C4IRNative(pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAbs_16s_C4IRNative(TypedPointer<Npp16s> var0, int var1, NppiSize var2);

    public static int nppiAbs_32f_C1R(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAbs_32f_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAbs_32f_C1RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiAbs_32f_C1IR(TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAbs_32f_C1IRNative(pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAbs_32f_C1IRNative(TypedPointer<Npp32f> var0, int var1, NppiSize var2);

    public static int nppiAbs_32f_C3R(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAbs_32f_C3RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAbs_32f_C3RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiAbs_32f_C3IR(TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAbs_32f_C3IRNative(pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAbs_32f_C3IRNative(TypedPointer<Npp32f> var0, int var1, NppiSize var2);

    public static int nppiAbs_32f_AC4R(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAbs_32f_AC4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAbs_32f_AC4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiAbs_32f_AC4IR(TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAbs_32f_AC4IRNative(pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAbs_32f_AC4IRNative(TypedPointer<Npp32f> var0, int var1, NppiSize var2);

    public static int nppiAbs_32f_C4R(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAbs_32f_C4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAbs_32f_C4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiAbs_32f_C4IR(TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAbs_32f_C4IRNative(pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAbs_32f_C4IRNative(TypedPointer<Npp32f> var0, int var1, NppiSize var2);

    public static int nppiAbsDiff_8u_C1R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAbsDiff_8u_C1RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAbsDiff_8u_C1RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6);

    public static int nppiAbsDiff_16u_C1R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pSrc2, int nSrc2Step, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAbsDiff_16u_C1RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAbsDiff_16u_C1RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, TypedPointer<Npp16u> var4, int var5, NppiSize var6);

    public static int nppiAbsDiff_32f_C1R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pSrc2, int nSrc2Step, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAbsDiff_32f_C1RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAbsDiff_32f_C1RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6);

    public static int nppiSqr_8u_C1RSfs(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSqr_8u_C1RSfsNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSqr_8u_C1RSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, int var5);

    public static int nppiSqr_8u_C1IRSfs(TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSqr_8u_C1IRSfsNative(pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSqr_8u_C1IRSfsNative(TypedPointer<Npp8u> var0, int var1, NppiSize var2, int var3);

    public static int nppiSqr_8u_C3RSfs(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSqr_8u_C3RSfsNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSqr_8u_C3RSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, int var5);

    public static int nppiSqr_8u_C3IRSfs(TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSqr_8u_C3IRSfsNative(pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSqr_8u_C3IRSfsNative(TypedPointer<Npp8u> var0, int var1, NppiSize var2, int var3);

    public static int nppiSqr_8u_AC4RSfs(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSqr_8u_AC4RSfsNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSqr_8u_AC4RSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, int var5);

    public static int nppiSqr_8u_AC4IRSfs(TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSqr_8u_AC4IRSfsNative(pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSqr_8u_AC4IRSfsNative(TypedPointer<Npp8u> var0, int var1, NppiSize var2, int var3);

    public static int nppiSqr_8u_C4RSfs(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSqr_8u_C4RSfsNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSqr_8u_C4RSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, int var5);

    public static int nppiSqr_8u_C4IRSfs(TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSqr_8u_C4IRSfsNative(pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSqr_8u_C4IRSfsNative(TypedPointer<Npp8u> var0, int var1, NppiSize var2, int var3);

    public static int nppiSqr_16u_C1RSfs(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSqr_16u_C1RSfsNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSqr_16u_C1RSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4, int var5);

    public static int nppiSqr_16u_C1IRSfs(TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSqr_16u_C1IRSfsNative(pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSqr_16u_C1IRSfsNative(TypedPointer<Npp16u> var0, int var1, NppiSize var2, int var3);

    public static int nppiSqr_16u_C3RSfs(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSqr_16u_C3RSfsNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSqr_16u_C3RSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4, int var5);

    public static int nppiSqr_16u_C3IRSfs(TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSqr_16u_C3IRSfsNative(pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSqr_16u_C3IRSfsNative(TypedPointer<Npp16u> var0, int var1, NppiSize var2, int var3);

    public static int nppiSqr_16u_AC4RSfs(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSqr_16u_AC4RSfsNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSqr_16u_AC4RSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4, int var5);

    public static int nppiSqr_16u_AC4IRSfs(TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSqr_16u_AC4IRSfsNative(pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSqr_16u_AC4IRSfsNative(TypedPointer<Npp16u> var0, int var1, NppiSize var2, int var3);

    public static int nppiSqr_16u_C4RSfs(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSqr_16u_C4RSfsNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSqr_16u_C4RSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4, int var5);

    public static int nppiSqr_16u_C4IRSfs(TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSqr_16u_C4IRSfsNative(pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSqr_16u_C4IRSfsNative(TypedPointer<Npp16u> var0, int var1, NppiSize var2, int var3);

    public static int nppiSqr_16s_C1RSfs(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSqr_16s_C1RSfsNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSqr_16s_C1RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, int var5);

    public static int nppiSqr_16s_C1IRSfs(TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSqr_16s_C1IRSfsNative(pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSqr_16s_C1IRSfsNative(TypedPointer<Npp16s> var0, int var1, NppiSize var2, int var3);

    public static int nppiSqr_16s_C3RSfs(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSqr_16s_C3RSfsNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSqr_16s_C3RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, int var5);

    public static int nppiSqr_16s_C3IRSfs(TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSqr_16s_C3IRSfsNative(pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSqr_16s_C3IRSfsNative(TypedPointer<Npp16s> var0, int var1, NppiSize var2, int var3);

    public static int nppiSqr_16s_AC4RSfs(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSqr_16s_AC4RSfsNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSqr_16s_AC4RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, int var5);

    public static int nppiSqr_16s_AC4IRSfs(TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSqr_16s_AC4IRSfsNative(pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSqr_16s_AC4IRSfsNative(TypedPointer<Npp16s> var0, int var1, NppiSize var2, int var3);

    public static int nppiSqr_16s_C4RSfs(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSqr_16s_C4RSfsNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSqr_16s_C4RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, int var5);

    public static int nppiSqr_16s_C4IRSfs(TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSqr_16s_C4IRSfsNative(pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSqr_16s_C4IRSfsNative(TypedPointer<Npp16s> var0, int var1, NppiSize var2, int var3);

    public static int nppiSqr_32f_C1R(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSqr_32f_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSqr_32f_C1RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiSqr_32f_C1IR(TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSqr_32f_C1IRNative(pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiSqr_32f_C1IRNative(TypedPointer<Npp32f> var0, int var1, NppiSize var2);

    public static int nppiSqr_32f_C3R(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSqr_32f_C3RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSqr_32f_C3RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiSqr_32f_C3IR(TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSqr_32f_C3IRNative(pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiSqr_32f_C3IRNative(TypedPointer<Npp32f> var0, int var1, NppiSize var2);

    public static int nppiSqr_32f_AC4R(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSqr_32f_AC4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSqr_32f_AC4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiSqr_32f_AC4IR(TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSqr_32f_AC4IRNative(pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiSqr_32f_AC4IRNative(TypedPointer<Npp32f> var0, int var1, NppiSize var2);

    public static int nppiSqr_32f_C4R(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSqr_32f_C4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSqr_32f_C4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiSqr_32f_C4IR(TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSqr_32f_C4IRNative(pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiSqr_32f_C4IRNative(TypedPointer<Npp32f> var0, int var1, NppiSize var2);

    public static int nppiSqrt_8u_C1RSfs(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSqrt_8u_C1RSfsNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSqrt_8u_C1RSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, int var5);

    public static int nppiSqrt_8u_C1IRSfs(TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSqrt_8u_C1IRSfsNative(pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSqrt_8u_C1IRSfsNative(TypedPointer<Npp8u> var0, int var1, NppiSize var2, int var3);

    public static int nppiSqrt_8u_C3RSfs(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSqrt_8u_C3RSfsNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSqrt_8u_C3RSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, int var5);

    public static int nppiSqrt_8u_C3IRSfs(TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSqrt_8u_C3IRSfsNative(pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSqrt_8u_C3IRSfsNative(TypedPointer<Npp8u> var0, int var1, NppiSize var2, int var3);

    public static int nppiSqrt_8u_AC4RSfs(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSqrt_8u_AC4RSfsNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSqrt_8u_AC4RSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, int var5);

    public static int nppiSqrt_8u_AC4IRSfs(TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSqrt_8u_AC4IRSfsNative(pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSqrt_8u_AC4IRSfsNative(TypedPointer<Npp8u> var0, int var1, NppiSize var2, int var3);

    public static int nppiSqrt_16u_C1RSfs(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSqrt_16u_C1RSfsNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSqrt_16u_C1RSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4, int var5);

    public static int nppiSqrt_16u_C1IRSfs(TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSqrt_16u_C1IRSfsNative(pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSqrt_16u_C1IRSfsNative(TypedPointer<Npp16u> var0, int var1, NppiSize var2, int var3);

    public static int nppiSqrt_16u_C3RSfs(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSqrt_16u_C3RSfsNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSqrt_16u_C3RSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4, int var5);

    public static int nppiSqrt_16u_C3IRSfs(TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSqrt_16u_C3IRSfsNative(pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSqrt_16u_C3IRSfsNative(TypedPointer<Npp16u> var0, int var1, NppiSize var2, int var3);

    public static int nppiSqrt_16u_AC4RSfs(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSqrt_16u_AC4RSfsNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSqrt_16u_AC4RSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4, int var5);

    public static int nppiSqrt_16u_AC4IRSfs(TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSqrt_16u_AC4IRSfsNative(pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSqrt_16u_AC4IRSfsNative(TypedPointer<Npp16u> var0, int var1, NppiSize var2, int var3);

    public static int nppiSqrt_16s_C1RSfs(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSqrt_16s_C1RSfsNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSqrt_16s_C1RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, int var5);

    public static int nppiSqrt_16s_C1IRSfs(TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSqrt_16s_C1IRSfsNative(pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSqrt_16s_C1IRSfsNative(TypedPointer<Npp16s> var0, int var1, NppiSize var2, int var3);

    public static int nppiSqrt_16s_C3RSfs(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSqrt_16s_C3RSfsNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSqrt_16s_C3RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, int var5);

    public static int nppiSqrt_16s_C3IRSfs(TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSqrt_16s_C3IRSfsNative(pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSqrt_16s_C3IRSfsNative(TypedPointer<Npp16s> var0, int var1, NppiSize var2, int var3);

    public static int nppiSqrt_16s_AC4RSfs(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSqrt_16s_AC4RSfsNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSqrt_16s_AC4RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, int var5);

    public static int nppiSqrt_16s_AC4IRSfs(TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiSqrt_16s_AC4IRSfsNative(pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiSqrt_16s_AC4IRSfsNative(TypedPointer<Npp16s> var0, int var1, NppiSize var2, int var3);

    public static int nppiSqrt_32f_C1R(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSqrt_32f_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSqrt_32f_C1RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiSqrt_32f_C1IR(TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSqrt_32f_C1IRNative(pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiSqrt_32f_C1IRNative(TypedPointer<Npp32f> var0, int var1, NppiSize var2);

    public static int nppiSqrt_32f_C3R(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSqrt_32f_C3RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSqrt_32f_C3RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiSqrt_32f_C3IR(TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSqrt_32f_C3IRNative(pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiSqrt_32f_C3IRNative(TypedPointer<Npp32f> var0, int var1, NppiSize var2);

    public static int nppiSqrt_32f_AC4R(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSqrt_32f_AC4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSqrt_32f_AC4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiSqrt_32f_AC4IR(TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSqrt_32f_AC4IRNative(pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiSqrt_32f_AC4IRNative(TypedPointer<Npp32f> var0, int var1, NppiSize var2);

    public static int nppiSqrt_32f_C4R(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSqrt_32f_C4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiSqrt_32f_C4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiSqrt_32f_C4IR(TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiSqrt_32f_C4IRNative(pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiSqrt_32f_C4IRNative(TypedPointer<Npp32f> var0, int var1, NppiSize var2);

    public static int nppiLn_8u_C1RSfs(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiLn_8u_C1RSfsNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiLn_8u_C1RSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, int var5);

    public static int nppiLn_8u_C1IRSfs(TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiLn_8u_C1IRSfsNative(pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiLn_8u_C1IRSfsNative(TypedPointer<Npp8u> var0, int var1, NppiSize var2, int var3);

    public static int nppiLn_8u_C3RSfs(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiLn_8u_C3RSfsNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiLn_8u_C3RSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, int var5);

    public static int nppiLn_8u_C3IRSfs(TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiLn_8u_C3IRSfsNative(pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiLn_8u_C3IRSfsNative(TypedPointer<Npp8u> var0, int var1, NppiSize var2, int var3);

    public static int nppiLn_16u_C1RSfs(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiLn_16u_C1RSfsNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiLn_16u_C1RSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4, int var5);

    public static int nppiLn_16u_C1IRSfs(TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiLn_16u_C1IRSfsNative(pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiLn_16u_C1IRSfsNative(TypedPointer<Npp16u> var0, int var1, NppiSize var2, int var3);

    public static int nppiLn_16u_C3RSfs(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiLn_16u_C3RSfsNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiLn_16u_C3RSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4, int var5);

    public static int nppiLn_16u_C3IRSfs(TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiLn_16u_C3IRSfsNative(pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiLn_16u_C3IRSfsNative(TypedPointer<Npp16u> var0, int var1, NppiSize var2, int var3);

    public static int nppiLn_16s_C1RSfs(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiLn_16s_C1RSfsNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiLn_16s_C1RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, int var5);

    public static int nppiLn_16s_C1IRSfs(TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiLn_16s_C1IRSfsNative(pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiLn_16s_C1IRSfsNative(TypedPointer<Npp16s> var0, int var1, NppiSize var2, int var3);

    public static int nppiLn_16s_C3RSfs(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiLn_16s_C3RSfsNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiLn_16s_C3RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, int var5);

    public static int nppiLn_16s_C3IRSfs(TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiLn_16s_C3IRSfsNative(pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiLn_16s_C3IRSfsNative(TypedPointer<Npp16s> var0, int var1, NppiSize var2, int var3);

    public static int nppiLn_32f_C1R(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiLn_32f_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiLn_32f_C1RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiLn_32f_C1IR(TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiLn_32f_C1IRNative(pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiLn_32f_C1IRNative(TypedPointer<Npp32f> var0, int var1, NppiSize var2);

    public static int nppiLn_32f_C3R(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiLn_32f_C3RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiLn_32f_C3RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiLn_32f_C3IR(TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiLn_32f_C3IRNative(pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiLn_32f_C3IRNative(TypedPointer<Npp32f> var0, int var1, NppiSize var2);

    public static int nppiExp_8u_C1RSfs(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiExp_8u_C1RSfsNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiExp_8u_C1RSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, int var5);

    public static int nppiExp_8u_C1IRSfs(TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiExp_8u_C1IRSfsNative(pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiExp_8u_C1IRSfsNative(TypedPointer<Npp8u> var0, int var1, NppiSize var2, int var3);

    public static int nppiExp_8u_C3RSfs(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiExp_8u_C3RSfsNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiExp_8u_C3RSfsNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, int var5);

    public static int nppiExp_8u_C3IRSfs(TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiExp_8u_C3IRSfsNative(pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiExp_8u_C3IRSfsNative(TypedPointer<Npp8u> var0, int var1, NppiSize var2, int var3);

    public static int nppiExp_16u_C1RSfs(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiExp_16u_C1RSfsNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiExp_16u_C1RSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4, int var5);

    public static int nppiExp_16u_C1IRSfs(TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiExp_16u_C1IRSfsNative(pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiExp_16u_C1IRSfsNative(TypedPointer<Npp16u> var0, int var1, NppiSize var2, int var3);

    public static int nppiExp_16u_C3RSfs(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiExp_16u_C3RSfsNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiExp_16u_C3RSfsNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4, int var5);

    public static int nppiExp_16u_C3IRSfs(TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiExp_16u_C3IRSfsNative(pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiExp_16u_C3IRSfsNative(TypedPointer<Npp16u> var0, int var1, NppiSize var2, int var3);

    public static int nppiExp_16s_C1RSfs(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiExp_16s_C1RSfsNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiExp_16s_C1RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, int var5);

    public static int nppiExp_16s_C1IRSfs(TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiExp_16s_C1IRSfsNative(pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiExp_16s_C1IRSfsNative(TypedPointer<Npp16s> var0, int var1, NppiSize var2, int var3);

    public static int nppiExp_16s_C3RSfs(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiExp_16s_C3RSfsNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiExp_16s_C3RSfsNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, NppiSize var4, int var5);

    public static int nppiExp_16s_C3IRSfs(TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI, int nScaleFactor) {
        return JNppi.checkResult(JNppi.nppiExp_16s_C3IRSfsNative(pSrcDst, nSrcDstStep, oSizeROI, nScaleFactor));
    }

    private static native int nppiExp_16s_C3IRSfsNative(TypedPointer<Npp16s> var0, int var1, NppiSize var2, int var3);

    public static int nppiExp_32f_C1R(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiExp_32f_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiExp_32f_C1RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiExp_32f_C1IR(TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiExp_32f_C1IRNative(pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiExp_32f_C1IRNative(TypedPointer<Npp32f> var0, int var1, NppiSize var2);

    public static int nppiExp_32f_C3R(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiExp_32f_C3RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiExp_32f_C3RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiExp_32f_C3IR(TypedPointer<Npp32f> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiExp_32f_C3IRNative(pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiExp_32f_C3IRNative(TypedPointer<Npp32f> var0, int var1, NppiSize var2);

    public static int nppiAndC_8u_C1R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, byte nConstant, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAndC_8u_C1RNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAndC_8u_C1RNative(TypedPointer<Npp8u> var0, int var1, byte var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5);

    public static int nppiAndC_8u_C1IR(byte nConstant, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAndC_8u_C1IRNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAndC_8u_C1IRNative(byte var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3);

    public static int nppiAndC_8u_C3R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAndC_8u_C3RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAndC_8u_C3RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5);

    public static int nppiAndC_8u_C3IR(TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAndC_8u_C3IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAndC_8u_C3IRNative(TypedPointer<Npp8u> var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3);

    public static int nppiAndC_8u_AC4R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAndC_8u_AC4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAndC_8u_AC4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5);

    public static int nppiAndC_8u_AC4IR(TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAndC_8u_AC4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAndC_8u_AC4IRNative(TypedPointer<Npp8u> var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3);

    public static int nppiAndC_8u_C4R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAndC_8u_C4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAndC_8u_C4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5);

    public static int nppiAndC_8u_C4IR(TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAndC_8u_C4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAndC_8u_C4IRNative(TypedPointer<Npp8u> var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3);

    public static int nppiAndC_16u_C1R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, short nConstant, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAndC_16u_C1RNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAndC_16u_C1RNative(TypedPointer<Npp16u> var0, int var1, short var2, TypedPointer<Npp16u> var3, int var4, NppiSize var5);

    public static int nppiAndC_16u_C1IR(short nConstant, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAndC_16u_C1IRNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAndC_16u_C1IRNative(short var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3);

    public static int nppiAndC_16u_C3R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAndC_16u_C3RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAndC_16u_C3RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, TypedPointer<Npp16u> var3, int var4, NppiSize var5);

    public static int nppiAndC_16u_C3IR(TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAndC_16u_C3IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAndC_16u_C3IRNative(TypedPointer<Npp16u> var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3);

    public static int nppiAndC_16u_AC4R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAndC_16u_AC4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAndC_16u_AC4RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, TypedPointer<Npp16u> var3, int var4, NppiSize var5);

    public static int nppiAndC_16u_AC4IR(TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAndC_16u_AC4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAndC_16u_AC4IRNative(TypedPointer<Npp16u> var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3);

    public static int nppiAndC_16u_C4R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAndC_16u_C4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAndC_16u_C4RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, TypedPointer<Npp16u> var3, int var4, NppiSize var5);

    public static int nppiAndC_16u_C4IR(TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAndC_16u_C4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAndC_16u_C4IRNative(TypedPointer<Npp16u> var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3);

    public static int nppiAndC_32s_C1R(TypedPointer<Npp32s> pSrc1, int nSrc1Step, int nConstant, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAndC_32s_C1RNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAndC_32s_C1RNative(TypedPointer<Npp32s> var0, int var1, int var2, TypedPointer<Npp32s> var3, int var4, NppiSize var5);

    public static int nppiAndC_32s_C1IR(int nConstant, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAndC_32s_C1IRNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAndC_32s_C1IRNative(int var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3);

    public static int nppiAndC_32s_C3R(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pConstants, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAndC_32s_C3RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAndC_32s_C3RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, TypedPointer<Npp32s> var3, int var4, NppiSize var5);

    public static int nppiAndC_32s_C3IR(TypedPointer<Npp32s> pConstants, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAndC_32s_C3IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAndC_32s_C3IRNative(TypedPointer<Npp32s> var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3);

    public static int nppiAndC_32s_AC4R(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pConstants, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAndC_32s_AC4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAndC_32s_AC4RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, TypedPointer<Npp32s> var3, int var4, NppiSize var5);

    public static int nppiAndC_32s_AC4IR(TypedPointer<Npp32s> pConstants, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAndC_32s_AC4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAndC_32s_AC4IRNative(TypedPointer<Npp32s> var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3);

    public static int nppiAndC_32s_C4R(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pConstants, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAndC_32s_C4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAndC_32s_C4RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, TypedPointer<Npp32s> var3, int var4, NppiSize var5);

    public static int nppiAndC_32s_C4IR(TypedPointer<Npp32s> pConstants, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAndC_32s_C4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAndC_32s_C4IRNative(TypedPointer<Npp32s> var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3);

    public static int nppiOrC_8u_C1R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, byte nConstant, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOrC_8u_C1RNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiOrC_8u_C1RNative(TypedPointer<Npp8u> var0, int var1, byte var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5);

    public static int nppiOrC_8u_C1IR(byte nConstant, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOrC_8u_C1IRNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiOrC_8u_C1IRNative(byte var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3);

    public static int nppiOrC_8u_C3R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOrC_8u_C3RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiOrC_8u_C3RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5);

    public static int nppiOrC_8u_C3IR(TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOrC_8u_C3IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiOrC_8u_C3IRNative(TypedPointer<Npp8u> var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3);

    public static int nppiOrC_8u_AC4R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOrC_8u_AC4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiOrC_8u_AC4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5);

    public static int nppiOrC_8u_AC4IR(TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOrC_8u_AC4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiOrC_8u_AC4IRNative(TypedPointer<Npp8u> var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3);

    public static int nppiOrC_8u_C4R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOrC_8u_C4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiOrC_8u_C4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5);

    public static int nppiOrC_8u_C4IR(TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOrC_8u_C4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiOrC_8u_C4IRNative(TypedPointer<Npp8u> var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3);

    public static int nppiOrC_16u_C1R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, short nConstant, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOrC_16u_C1RNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiOrC_16u_C1RNative(TypedPointer<Npp16u> var0, int var1, short var2, TypedPointer<Npp16u> var3, int var4, NppiSize var5);

    public static int nppiOrC_16u_C1IR(short nConstant, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOrC_16u_C1IRNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiOrC_16u_C1IRNative(short var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3);

    public static int nppiOrC_16u_C3R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOrC_16u_C3RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiOrC_16u_C3RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, TypedPointer<Npp16u> var3, int var4, NppiSize var5);

    public static int nppiOrC_16u_C3IR(TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOrC_16u_C3IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiOrC_16u_C3IRNative(TypedPointer<Npp16u> var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3);

    public static int nppiOrC_16u_AC4R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOrC_16u_AC4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiOrC_16u_AC4RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, TypedPointer<Npp16u> var3, int var4, NppiSize var5);

    public static int nppiOrC_16u_AC4IR(TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOrC_16u_AC4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiOrC_16u_AC4IRNative(TypedPointer<Npp16u> var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3);

    public static int nppiOrC_16u_C4R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOrC_16u_C4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiOrC_16u_C4RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, TypedPointer<Npp16u> var3, int var4, NppiSize var5);

    public static int nppiOrC_16u_C4IR(TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOrC_16u_C4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiOrC_16u_C4IRNative(TypedPointer<Npp16u> var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3);

    public static int nppiOrC_32s_C1R(TypedPointer<Npp32s> pSrc1, int nSrc1Step, int nConstant, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOrC_32s_C1RNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiOrC_32s_C1RNative(TypedPointer<Npp32s> var0, int var1, int var2, TypedPointer<Npp32s> var3, int var4, NppiSize var5);

    public static int nppiOrC_32s_C1IR(int nConstant, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOrC_32s_C1IRNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiOrC_32s_C1IRNative(int var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3);

    public static int nppiOrC_32s_C3R(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pConstants, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOrC_32s_C3RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiOrC_32s_C3RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, TypedPointer<Npp32s> var3, int var4, NppiSize var5);

    public static int nppiOrC_32s_C3IR(TypedPointer<Npp32s> pConstants, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOrC_32s_C3IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiOrC_32s_C3IRNative(TypedPointer<Npp32s> var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3);

    public static int nppiOrC_32s_AC4R(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pConstants, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOrC_32s_AC4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiOrC_32s_AC4RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, TypedPointer<Npp32s> var3, int var4, NppiSize var5);

    public static int nppiOrC_32s_AC4IR(TypedPointer<Npp32s> pConstants, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOrC_32s_AC4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiOrC_32s_AC4IRNative(TypedPointer<Npp32s> var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3);

    public static int nppiOrC_32s_C4R(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pConstants, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOrC_32s_C4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiOrC_32s_C4RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, TypedPointer<Npp32s> var3, int var4, NppiSize var5);

    public static int nppiOrC_32s_C4IR(TypedPointer<Npp32s> pConstants, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOrC_32s_C4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiOrC_32s_C4IRNative(TypedPointer<Npp32s> var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3);

    public static int nppiXorC_8u_C1R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, byte nConstant, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXorC_8u_C1RNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiXorC_8u_C1RNative(TypedPointer<Npp8u> var0, int var1, byte var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5);

    public static int nppiXorC_8u_C1IR(byte nConstant, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXorC_8u_C1IRNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiXorC_8u_C1IRNative(byte var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3);

    public static int nppiXorC_8u_C3R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXorC_8u_C3RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiXorC_8u_C3RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5);

    public static int nppiXorC_8u_C3IR(TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXorC_8u_C3IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiXorC_8u_C3IRNative(TypedPointer<Npp8u> var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3);

    public static int nppiXorC_8u_AC4R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXorC_8u_AC4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiXorC_8u_AC4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5);

    public static int nppiXorC_8u_AC4IR(TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXorC_8u_AC4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiXorC_8u_AC4IRNative(TypedPointer<Npp8u> var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3);

    public static int nppiXorC_8u_C4R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXorC_8u_C4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiXorC_8u_C4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5);

    public static int nppiXorC_8u_C4IR(TypedPointer<Npp8u> pConstants, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXorC_8u_C4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiXorC_8u_C4IRNative(TypedPointer<Npp8u> var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3);

    public static int nppiXorC_16u_C1R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, short nConstant, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXorC_16u_C1RNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiXorC_16u_C1RNative(TypedPointer<Npp16u> var0, int var1, short var2, TypedPointer<Npp16u> var3, int var4, NppiSize var5);

    public static int nppiXorC_16u_C1IR(short nConstant, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXorC_16u_C1IRNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiXorC_16u_C1IRNative(short var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3);

    public static int nppiXorC_16u_C3R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXorC_16u_C3RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiXorC_16u_C3RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, TypedPointer<Npp16u> var3, int var4, NppiSize var5);

    public static int nppiXorC_16u_C3IR(TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXorC_16u_C3IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiXorC_16u_C3IRNative(TypedPointer<Npp16u> var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3);

    public static int nppiXorC_16u_AC4R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXorC_16u_AC4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiXorC_16u_AC4RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, TypedPointer<Npp16u> var3, int var4, NppiSize var5);

    public static int nppiXorC_16u_AC4IR(TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXorC_16u_AC4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiXorC_16u_AC4IRNative(TypedPointer<Npp16u> var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3);

    public static int nppiXorC_16u_C4R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXorC_16u_C4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiXorC_16u_C4RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, TypedPointer<Npp16u> var3, int var4, NppiSize var5);

    public static int nppiXorC_16u_C4IR(TypedPointer<Npp16u> pConstants, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXorC_16u_C4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiXorC_16u_C4IRNative(TypedPointer<Npp16u> var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3);

    public static int nppiXorC_32s_C1R(TypedPointer<Npp32s> pSrc1, int nSrc1Step, int nConstant, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXorC_32s_C1RNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiXorC_32s_C1RNative(TypedPointer<Npp32s> var0, int var1, int var2, TypedPointer<Npp32s> var3, int var4, NppiSize var5);

    public static int nppiXorC_32s_C1IR(int nConstant, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXorC_32s_C1IRNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiXorC_32s_C1IRNative(int var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3);

    public static int nppiXorC_32s_C3R(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pConstants, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXorC_32s_C3RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiXorC_32s_C3RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, TypedPointer<Npp32s> var3, int var4, NppiSize var5);

    public static int nppiXorC_32s_C3IR(TypedPointer<Npp32s> pConstants, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXorC_32s_C3IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiXorC_32s_C3IRNative(TypedPointer<Npp32s> var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3);

    public static int nppiXorC_32s_AC4R(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pConstants, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXorC_32s_AC4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiXorC_32s_AC4RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, TypedPointer<Npp32s> var3, int var4, NppiSize var5);

    public static int nppiXorC_32s_AC4IR(TypedPointer<Npp32s> pConstants, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXorC_32s_AC4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiXorC_32s_AC4IRNative(TypedPointer<Npp32s> var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3);

    public static int nppiXorC_32s_C4R(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pConstants, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXorC_32s_C4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiXorC_32s_C4RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, TypedPointer<Npp32s> var3, int var4, NppiSize var5);

    public static int nppiXorC_32s_C4IR(TypedPointer<Npp32s> pConstants, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXorC_32s_C4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiXorC_32s_C4IRNative(TypedPointer<Npp32s> var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3);

    public static int nppiRShiftC_8u_C1R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, int nConstant, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRShiftC_8u_C1RNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiRShiftC_8u_C1RNative(TypedPointer<Npp8u> var0, int var1, int var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5);

    public static int nppiRShiftC_8u_C1IR(int nConstant, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRShiftC_8u_C1IRNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiRShiftC_8u_C1IRNative(int var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3);

    public static int nppiRShiftC_8u_C3R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp32u> pConstants, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRShiftC_8u_C3RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiRShiftC_8u_C3RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp32u> var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5);

    public static int nppiRShiftC_8u_C3IR(TypedPointer<Npp32u> pConstants, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRShiftC_8u_C3IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiRShiftC_8u_C3IRNative(TypedPointer<Npp32u> var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3);

    public static int nppiRShiftC_8u_AC4R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp32u> pConstants, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRShiftC_8u_AC4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiRShiftC_8u_AC4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp32u> var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5);

    public static int nppiRShiftC_8u_AC4IR(TypedPointer<Npp32u> pConstants, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRShiftC_8u_AC4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiRShiftC_8u_AC4IRNative(TypedPointer<Npp32u> var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3);

    public static int nppiRShiftC_8u_C4R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp32u> pConstants, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRShiftC_8u_C4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiRShiftC_8u_C4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp32u> var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5);

    public static int nppiRShiftC_8u_C4IR(TypedPointer<Npp32u> pConstants, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRShiftC_8u_C4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiRShiftC_8u_C4IRNative(TypedPointer<Npp32u> var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3);

    public static int nppiRShiftC_8s_C1R(TypedPointer<Npp8s> pSrc1, int nSrc1Step, int nConstant, TypedPointer<Npp8s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRShiftC_8s_C1RNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiRShiftC_8s_C1RNative(TypedPointer<Npp8s> var0, int var1, int var2, TypedPointer<Npp8s> var3, int var4, NppiSize var5);

    public static int nppiRShiftC_8s_C1IR(int nConstant, TypedPointer<Npp8s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRShiftC_8s_C1IRNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiRShiftC_8s_C1IRNative(int var0, TypedPointer<Npp8s> var1, int var2, NppiSize var3);

    public static int nppiRShiftC_8s_C3R(TypedPointer<Npp8s> pSrc1, int nSrc1Step, TypedPointer<Npp32u> pConstants, TypedPointer<Npp8s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRShiftC_8s_C3RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiRShiftC_8s_C3RNative(TypedPointer<Npp8s> var0, int var1, TypedPointer<Npp32u> var2, TypedPointer<Npp8s> var3, int var4, NppiSize var5);

    public static int nppiRShiftC_8s_C3IR(TypedPointer<Npp32u> pConstants, TypedPointer<Npp8s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRShiftC_8s_C3IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiRShiftC_8s_C3IRNative(TypedPointer<Npp32u> var0, TypedPointer<Npp8s> var1, int var2, NppiSize var3);

    public static int nppiRShiftC_8s_AC4R(TypedPointer<Npp8s> pSrc1, int nSrc1Step, TypedPointer<Npp32u> pConstants, TypedPointer<Npp8s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRShiftC_8s_AC4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiRShiftC_8s_AC4RNative(TypedPointer<Npp8s> var0, int var1, TypedPointer<Npp32u> var2, TypedPointer<Npp8s> var3, int var4, NppiSize var5);

    public static int nppiRShiftC_8s_AC4IR(TypedPointer<Npp32u> pConstants, TypedPointer<Npp8s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRShiftC_8s_AC4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiRShiftC_8s_AC4IRNative(TypedPointer<Npp32u> var0, TypedPointer<Npp8s> var1, int var2, NppiSize var3);

    public static int nppiRShiftC_8s_C4R(TypedPointer<Npp8s> pSrc1, int nSrc1Step, TypedPointer<Npp32u> pConstants, TypedPointer<Npp8s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRShiftC_8s_C4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiRShiftC_8s_C4RNative(TypedPointer<Npp8s> var0, int var1, TypedPointer<Npp32u> var2, TypedPointer<Npp8s> var3, int var4, NppiSize var5);

    public static int nppiRShiftC_8s_C4IR(TypedPointer<Npp32u> pConstants, TypedPointer<Npp8s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRShiftC_8s_C4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiRShiftC_8s_C4IRNative(TypedPointer<Npp32u> var0, TypedPointer<Npp8s> var1, int var2, NppiSize var3);

    public static int nppiRShiftC_16u_C1R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, int nConstant, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRShiftC_16u_C1RNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiRShiftC_16u_C1RNative(TypedPointer<Npp16u> var0, int var1, int var2, TypedPointer<Npp16u> var3, int var4, NppiSize var5);

    public static int nppiRShiftC_16u_C1IR(int nConstant, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRShiftC_16u_C1IRNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiRShiftC_16u_C1IRNative(int var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3);

    public static int nppiRShiftC_16u_C3R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp32u> pConstants, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRShiftC_16u_C3RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiRShiftC_16u_C3RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp32u> var2, TypedPointer<Npp16u> var3, int var4, NppiSize var5);

    public static int nppiRShiftC_16u_C3IR(TypedPointer<Npp32u> pConstants, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRShiftC_16u_C3IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiRShiftC_16u_C3IRNative(TypedPointer<Npp32u> var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3);

    public static int nppiRShiftC_16u_AC4R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp32u> pConstants, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRShiftC_16u_AC4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiRShiftC_16u_AC4RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp32u> var2, TypedPointer<Npp16u> var3, int var4, NppiSize var5);

    public static int nppiRShiftC_16u_AC4IR(TypedPointer<Npp32u> pConstants, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRShiftC_16u_AC4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiRShiftC_16u_AC4IRNative(TypedPointer<Npp32u> var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3);

    public static int nppiRShiftC_16u_C4R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp32u> pConstants, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRShiftC_16u_C4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiRShiftC_16u_C4RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp32u> var2, TypedPointer<Npp16u> var3, int var4, NppiSize var5);

    public static int nppiRShiftC_16u_C4IR(TypedPointer<Npp32u> pConstants, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRShiftC_16u_C4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiRShiftC_16u_C4IRNative(TypedPointer<Npp32u> var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3);

    public static int nppiRShiftC_16s_C1R(TypedPointer<Npp16s> pSrc1, int nSrc1Step, int nConstant, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRShiftC_16s_C1RNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiRShiftC_16s_C1RNative(TypedPointer<Npp16s> var0, int var1, int var2, TypedPointer<Npp16s> var3, int var4, NppiSize var5);

    public static int nppiRShiftC_16s_C1IR(int nConstant, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRShiftC_16s_C1IRNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiRShiftC_16s_C1IRNative(int var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3);

    public static int nppiRShiftC_16s_C3R(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp32u> pConstants, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRShiftC_16s_C3RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiRShiftC_16s_C3RNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp32u> var2, TypedPointer<Npp16s> var3, int var4, NppiSize var5);

    public static int nppiRShiftC_16s_C3IR(TypedPointer<Npp32u> pConstants, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRShiftC_16s_C3IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiRShiftC_16s_C3IRNative(TypedPointer<Npp32u> var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3);

    public static int nppiRShiftC_16s_AC4R(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp32u> pConstants, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRShiftC_16s_AC4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiRShiftC_16s_AC4RNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp32u> var2, TypedPointer<Npp16s> var3, int var4, NppiSize var5);

    public static int nppiRShiftC_16s_AC4IR(TypedPointer<Npp32u> pConstants, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRShiftC_16s_AC4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiRShiftC_16s_AC4IRNative(TypedPointer<Npp32u> var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3);

    public static int nppiRShiftC_16s_C4R(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp32u> pConstants, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRShiftC_16s_C4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiRShiftC_16s_C4RNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp32u> var2, TypedPointer<Npp16s> var3, int var4, NppiSize var5);

    public static int nppiRShiftC_16s_C4IR(TypedPointer<Npp32u> pConstants, TypedPointer<Npp16s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRShiftC_16s_C4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiRShiftC_16s_C4IRNative(TypedPointer<Npp32u> var0, TypedPointer<Npp16s> var1, int var2, NppiSize var3);

    public static int nppiRShiftC_32s_C1R(TypedPointer<Npp32s> pSrc1, int nSrc1Step, int nConstant, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRShiftC_32s_C1RNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiRShiftC_32s_C1RNative(TypedPointer<Npp32s> var0, int var1, int var2, TypedPointer<Npp32s> var3, int var4, NppiSize var5);

    public static int nppiRShiftC_32s_C1IR(int nConstant, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRShiftC_32s_C1IRNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiRShiftC_32s_C1IRNative(int var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3);

    public static int nppiRShiftC_32s_C3R(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32u> pConstants, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRShiftC_32s_C3RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiRShiftC_32s_C3RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32u> var2, TypedPointer<Npp32s> var3, int var4, NppiSize var5);

    public static int nppiRShiftC_32s_C3IR(TypedPointer<Npp32u> pConstants, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRShiftC_32s_C3IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiRShiftC_32s_C3IRNative(TypedPointer<Npp32u> var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3);

    public static int nppiRShiftC_32s_AC4R(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32u> pConstants, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRShiftC_32s_AC4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiRShiftC_32s_AC4RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32u> var2, TypedPointer<Npp32s> var3, int var4, NppiSize var5);

    public static int nppiRShiftC_32s_AC4IR(TypedPointer<Npp32u> pConstants, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRShiftC_32s_AC4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiRShiftC_32s_AC4IRNative(TypedPointer<Npp32u> var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3);

    public static int nppiRShiftC_32s_C4R(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32u> pConstants, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRShiftC_32s_C4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiRShiftC_32s_C4RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32u> var2, TypedPointer<Npp32s> var3, int var4, NppiSize var5);

    public static int nppiRShiftC_32s_C4IR(TypedPointer<Npp32u> pConstants, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRShiftC_32s_C4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiRShiftC_32s_C4IRNative(TypedPointer<Npp32u> var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3);

    public static int nppiLShiftC_8u_C1R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, int nConstant, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiLShiftC_8u_C1RNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiLShiftC_8u_C1RNative(TypedPointer<Npp8u> var0, int var1, int var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5);

    public static int nppiLShiftC_8u_C1IR(int nConstant, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiLShiftC_8u_C1IRNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiLShiftC_8u_C1IRNative(int var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3);

    public static int nppiLShiftC_8u_C3R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp32u> pConstants, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiLShiftC_8u_C3RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiLShiftC_8u_C3RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp32u> var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5);

    public static int nppiLShiftC_8u_C3IR(TypedPointer<Npp32u> pConstants, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiLShiftC_8u_C3IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiLShiftC_8u_C3IRNative(TypedPointer<Npp32u> var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3);

    public static int nppiLShiftC_8u_AC4R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp32u> pConstants, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiLShiftC_8u_AC4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiLShiftC_8u_AC4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp32u> var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5);

    public static int nppiLShiftC_8u_AC4IR(TypedPointer<Npp32u> pConstants, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiLShiftC_8u_AC4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiLShiftC_8u_AC4IRNative(TypedPointer<Npp32u> var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3);

    public static int nppiLShiftC_8u_C4R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp32u> pConstants, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiLShiftC_8u_C4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiLShiftC_8u_C4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp32u> var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5);

    public static int nppiLShiftC_8u_C4IR(TypedPointer<Npp32u> pConstants, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiLShiftC_8u_C4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiLShiftC_8u_C4IRNative(TypedPointer<Npp32u> var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3);

    public static int nppiLShiftC_16u_C1R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, int nConstant, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiLShiftC_16u_C1RNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiLShiftC_16u_C1RNative(TypedPointer<Npp16u> var0, int var1, int var2, TypedPointer<Npp16u> var3, int var4, NppiSize var5);

    public static int nppiLShiftC_16u_C1IR(int nConstant, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiLShiftC_16u_C1IRNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiLShiftC_16u_C1IRNative(int var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3);

    public static int nppiLShiftC_16u_C3R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp32u> pConstants, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiLShiftC_16u_C3RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiLShiftC_16u_C3RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp32u> var2, TypedPointer<Npp16u> var3, int var4, NppiSize var5);

    public static int nppiLShiftC_16u_C3IR(TypedPointer<Npp32u> pConstants, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiLShiftC_16u_C3IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiLShiftC_16u_C3IRNative(TypedPointer<Npp32u> var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3);

    public static int nppiLShiftC_16u_AC4R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp32u> pConstants, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiLShiftC_16u_AC4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiLShiftC_16u_AC4RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp32u> var2, TypedPointer<Npp16u> var3, int var4, NppiSize var5);

    public static int nppiLShiftC_16u_AC4IR(TypedPointer<Npp32u> pConstants, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiLShiftC_16u_AC4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiLShiftC_16u_AC4IRNative(TypedPointer<Npp32u> var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3);

    public static int nppiLShiftC_16u_C4R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp32u> pConstants, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiLShiftC_16u_C4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiLShiftC_16u_C4RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp32u> var2, TypedPointer<Npp16u> var3, int var4, NppiSize var5);

    public static int nppiLShiftC_16u_C4IR(TypedPointer<Npp32u> pConstants, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiLShiftC_16u_C4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiLShiftC_16u_C4IRNative(TypedPointer<Npp32u> var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3);

    public static int nppiLShiftC_32s_C1R(TypedPointer<Npp32s> pSrc1, int nSrc1Step, int nConstant, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiLShiftC_32s_C1RNative(pSrc1, nSrc1Step, nConstant, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiLShiftC_32s_C1RNative(TypedPointer<Npp32s> var0, int var1, int var2, TypedPointer<Npp32s> var3, int var4, NppiSize var5);

    public static int nppiLShiftC_32s_C1IR(int nConstant, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiLShiftC_32s_C1IRNative(nConstant, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiLShiftC_32s_C1IRNative(int var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3);

    public static int nppiLShiftC_32s_C3R(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32u> pConstants, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiLShiftC_32s_C3RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiLShiftC_32s_C3RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32u> var2, TypedPointer<Npp32s> var3, int var4, NppiSize var5);

    public static int nppiLShiftC_32s_C3IR(TypedPointer<Npp32u> pConstants, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiLShiftC_32s_C3IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiLShiftC_32s_C3IRNative(TypedPointer<Npp32u> var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3);

    public static int nppiLShiftC_32s_AC4R(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32u> pConstants, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiLShiftC_32s_AC4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiLShiftC_32s_AC4RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32u> var2, TypedPointer<Npp32s> var3, int var4, NppiSize var5);

    public static int nppiLShiftC_32s_AC4IR(TypedPointer<Npp32u> pConstants, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiLShiftC_32s_AC4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiLShiftC_32s_AC4IRNative(TypedPointer<Npp32u> var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3);

    public static int nppiLShiftC_32s_C4R(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32u> pConstants, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiLShiftC_32s_C4RNative(pSrc1, nSrc1Step, pConstants, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiLShiftC_32s_C4RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32u> var2, TypedPointer<Npp32s> var3, int var4, NppiSize var5);

    public static int nppiLShiftC_32s_C4IR(TypedPointer<Npp32u> pConstants, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiLShiftC_32s_C4IRNative(pConstants, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiLShiftC_32s_C4IRNative(TypedPointer<Npp32u> var0, TypedPointer<Npp32s> var1, int var2, NppiSize var3);

    public static int nppiAnd_8u_C1R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAnd_8u_C1RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAnd_8u_C1RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6);

    public static int nppiAnd_8u_C1IR(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAnd_8u_C1IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAnd_8u_C1IRNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiAnd_8u_C3R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAnd_8u_C3RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAnd_8u_C3RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6);

    public static int nppiAnd_8u_C3IR(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAnd_8u_C3IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAnd_8u_C3IRNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiAnd_8u_AC4R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAnd_8u_AC4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAnd_8u_AC4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6);

    public static int nppiAnd_8u_AC4IR(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAnd_8u_AC4IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAnd_8u_AC4IRNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiAnd_8u_C4R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAnd_8u_C4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAnd_8u_C4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6);

    public static int nppiAnd_8u_C4IR(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAnd_8u_C4IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAnd_8u_C4IRNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiAnd_16u_C1R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pSrc2, int nSrc2Step, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAnd_16u_C1RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAnd_16u_C1RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, TypedPointer<Npp16u> var4, int var5, NppiSize var6);

    public static int nppiAnd_16u_C1IR(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAnd_16u_C1IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAnd_16u_C1IRNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4);

    public static int nppiAnd_16u_C3R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pSrc2, int nSrc2Step, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAnd_16u_C3RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAnd_16u_C3RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, TypedPointer<Npp16u> var4, int var5, NppiSize var6);

    public static int nppiAnd_16u_C3IR(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAnd_16u_C3IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAnd_16u_C3IRNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4);

    public static int nppiAnd_16u_AC4R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pSrc2, int nSrc2Step, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAnd_16u_AC4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAnd_16u_AC4RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, TypedPointer<Npp16u> var4, int var5, NppiSize var6);

    public static int nppiAnd_16u_AC4IR(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAnd_16u_AC4IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAnd_16u_AC4IRNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4);

    public static int nppiAnd_16u_C4R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pSrc2, int nSrc2Step, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAnd_16u_C4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAnd_16u_C4RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, TypedPointer<Npp16u> var4, int var5, NppiSize var6);

    public static int nppiAnd_16u_C4IR(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAnd_16u_C4IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAnd_16u_C4IRNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4);

    public static int nppiAnd_32s_C1R(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pSrc2, int nSrc2Step, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAnd_32s_C1RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAnd_32s_C1RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, TypedPointer<Npp32s> var4, int var5, NppiSize var6);

    public static int nppiAnd_32s_C1IR(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAnd_32s_C1IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAnd_32s_C1IRNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4);

    public static int nppiAnd_32s_C3R(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pSrc2, int nSrc2Step, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAnd_32s_C3RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAnd_32s_C3RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, TypedPointer<Npp32s> var4, int var5, NppiSize var6);

    public static int nppiAnd_32s_C3IR(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAnd_32s_C3IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAnd_32s_C3IRNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4);

    public static int nppiAnd_32s_AC4R(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pSrc2, int nSrc2Step, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAnd_32s_AC4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAnd_32s_AC4RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, TypedPointer<Npp32s> var4, int var5, NppiSize var6);

    public static int nppiAnd_32s_AC4IR(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAnd_32s_AC4IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAnd_32s_AC4IRNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4);

    public static int nppiAnd_32s_C4R(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pSrc2, int nSrc2Step, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAnd_32s_C4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAnd_32s_C4RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, TypedPointer<Npp32s> var4, int var5, NppiSize var6);

    public static int nppiAnd_32s_C4IR(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAnd_32s_C4IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAnd_32s_C4IRNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4);

    public static int nppiOr_8u_C1R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOr_8u_C1RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiOr_8u_C1RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6);

    public static int nppiOr_8u_C1IR(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOr_8u_C1IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiOr_8u_C1IRNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiOr_8u_C3R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOr_8u_C3RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiOr_8u_C3RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6);

    public static int nppiOr_8u_C3IR(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOr_8u_C3IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiOr_8u_C3IRNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiOr_8u_AC4R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOr_8u_AC4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiOr_8u_AC4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6);

    public static int nppiOr_8u_AC4IR(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOr_8u_AC4IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiOr_8u_AC4IRNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiOr_8u_C4R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOr_8u_C4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiOr_8u_C4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6);

    public static int nppiOr_8u_C4IR(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOr_8u_C4IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiOr_8u_C4IRNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiOr_16u_C1R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pSrc2, int nSrc2Step, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOr_16u_C1RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiOr_16u_C1RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, TypedPointer<Npp16u> var4, int var5, NppiSize var6);

    public static int nppiOr_16u_C1IR(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOr_16u_C1IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiOr_16u_C1IRNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4);

    public static int nppiOr_16u_C3R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pSrc2, int nSrc2Step, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOr_16u_C3RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiOr_16u_C3RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, TypedPointer<Npp16u> var4, int var5, NppiSize var6);

    public static int nppiOr_16u_C3IR(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOr_16u_C3IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiOr_16u_C3IRNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4);

    public static int nppiOr_16u_AC4R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pSrc2, int nSrc2Step, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOr_16u_AC4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiOr_16u_AC4RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, TypedPointer<Npp16u> var4, int var5, NppiSize var6);

    public static int nppiOr_16u_AC4IR(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOr_16u_AC4IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiOr_16u_AC4IRNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4);

    public static int nppiOr_16u_C4R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pSrc2, int nSrc2Step, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOr_16u_C4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiOr_16u_C4RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, TypedPointer<Npp16u> var4, int var5, NppiSize var6);

    public static int nppiOr_16u_C4IR(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOr_16u_C4IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiOr_16u_C4IRNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4);

    public static int nppiOr_32s_C1R(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pSrc2, int nSrc2Step, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOr_32s_C1RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiOr_32s_C1RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, TypedPointer<Npp32s> var4, int var5, NppiSize var6);

    public static int nppiOr_32s_C1IR(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOr_32s_C1IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiOr_32s_C1IRNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4);

    public static int nppiOr_32s_C3R(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pSrc2, int nSrc2Step, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOr_32s_C3RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiOr_32s_C3RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, TypedPointer<Npp32s> var4, int var5, NppiSize var6);

    public static int nppiOr_32s_C3IR(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOr_32s_C3IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiOr_32s_C3IRNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4);

    public static int nppiOr_32s_AC4R(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pSrc2, int nSrc2Step, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOr_32s_AC4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiOr_32s_AC4RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, TypedPointer<Npp32s> var4, int var5, NppiSize var6);

    public static int nppiOr_32s_AC4IR(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOr_32s_AC4IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiOr_32s_AC4IRNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4);

    public static int nppiOr_32s_C4R(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pSrc2, int nSrc2Step, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOr_32s_C4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiOr_32s_C4RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, TypedPointer<Npp32s> var4, int var5, NppiSize var6);

    public static int nppiOr_32s_C4IR(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiOr_32s_C4IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiOr_32s_C4IRNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4);

    public static int nppiXor_8u_C1R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXor_8u_C1RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiXor_8u_C1RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6);

    public static int nppiXor_8u_C1IR(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXor_8u_C1IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiXor_8u_C1IRNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiXor_8u_C3R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXor_8u_C3RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiXor_8u_C3RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6);

    public static int nppiXor_8u_C3IR(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXor_8u_C3IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiXor_8u_C3IRNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiXor_8u_AC4R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXor_8u_AC4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiXor_8u_AC4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6);

    public static int nppiXor_8u_AC4IR(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXor_8u_AC4IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiXor_8u_AC4IRNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiXor_8u_C4R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXor_8u_C4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiXor_8u_C4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6);

    public static int nppiXor_8u_C4IR(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXor_8u_C4IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiXor_8u_C4IRNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiXor_16u_C1R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pSrc2, int nSrc2Step, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXor_16u_C1RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiXor_16u_C1RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, TypedPointer<Npp16u> var4, int var5, NppiSize var6);

    public static int nppiXor_16u_C1IR(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXor_16u_C1IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiXor_16u_C1IRNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4);

    public static int nppiXor_16u_C3R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pSrc2, int nSrc2Step, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXor_16u_C3RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiXor_16u_C3RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, TypedPointer<Npp16u> var4, int var5, NppiSize var6);

    public static int nppiXor_16u_C3IR(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXor_16u_C3IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiXor_16u_C3IRNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4);

    public static int nppiXor_16u_AC4R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pSrc2, int nSrc2Step, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXor_16u_AC4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiXor_16u_AC4RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, TypedPointer<Npp16u> var4, int var5, NppiSize var6);

    public static int nppiXor_16u_AC4IR(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXor_16u_AC4IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiXor_16u_AC4IRNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4);

    public static int nppiXor_16u_C4R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pSrc2, int nSrc2Step, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXor_16u_C4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiXor_16u_C4RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, TypedPointer<Npp16u> var4, int var5, NppiSize var6);

    public static int nppiXor_16u_C4IR(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXor_16u_C4IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiXor_16u_C4IRNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4);

    public static int nppiXor_32s_C1R(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pSrc2, int nSrc2Step, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXor_32s_C1RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiXor_32s_C1RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, TypedPointer<Npp32s> var4, int var5, NppiSize var6);

    public static int nppiXor_32s_C1IR(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXor_32s_C1IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiXor_32s_C1IRNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4);

    public static int nppiXor_32s_C3R(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pSrc2, int nSrc2Step, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXor_32s_C3RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiXor_32s_C3RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, TypedPointer<Npp32s> var4, int var5, NppiSize var6);

    public static int nppiXor_32s_C3IR(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXor_32s_C3IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiXor_32s_C3IRNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4);

    public static int nppiXor_32s_AC4R(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pSrc2, int nSrc2Step, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXor_32s_AC4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiXor_32s_AC4RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, TypedPointer<Npp32s> var4, int var5, NppiSize var6);

    public static int nppiXor_32s_AC4IR(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXor_32s_AC4IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiXor_32s_AC4IRNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4);

    public static int nppiXor_32s_C4R(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pSrc2, int nSrc2Step, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXor_32s_C4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiXor_32s_C4RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, TypedPointer<Npp32s> var4, int var5, NppiSize var6);

    public static int nppiXor_32s_C4IR(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiXor_32s_C4IRNative(pSrc, nSrcStep, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiXor_32s_C4IRNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4);

    public static int nppiNot_8u_C1R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiNot_8u_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiNot_8u_C1RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiNot_8u_C1IR(TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiNot_8u_C1IRNative(pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiNot_8u_C1IRNative(TypedPointer<Npp8u> var0, int var1, NppiSize var2);

    public static int nppiNot_8u_C3R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiNot_8u_C3RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiNot_8u_C3RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiNot_8u_C3IR(TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiNot_8u_C3IRNative(pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiNot_8u_C3IRNative(TypedPointer<Npp8u> var0, int var1, NppiSize var2);

    public static int nppiNot_8u_AC4R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiNot_8u_AC4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiNot_8u_AC4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiNot_8u_AC4IR(TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiNot_8u_AC4IRNative(pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiNot_8u_AC4IRNative(TypedPointer<Npp8u> var0, int var1, NppiSize var2);

    public static int nppiNot_8u_C4R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiNot_8u_C4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiNot_8u_C4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiNot_8u_C4IR(TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiNot_8u_C4IRNative(pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiNot_8u_C4IRNative(TypedPointer<Npp8u> var0, int var1, NppiSize var2);

    public static int nppiAlphaCompC_8u_C1R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, byte nAlpha1, TypedPointer<Npp8u> pSrc2, int nSrc2Step, byte nAlpha2, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int eAlphaOp) {
        return JNppi.checkResult(JNppi.nppiAlphaCompC_8u_C1RNative(pSrc1, nSrc1Step, nAlpha1, pSrc2, nSrc2Step, nAlpha2, pDst, nDstStep, oSizeROI, eAlphaOp));
    }

    private static native int nppiAlphaCompC_8u_C1RNative(TypedPointer<Npp8u> var0, int var1, byte var2, TypedPointer<Npp8u> var3, int var4, byte var5, TypedPointer<Npp8u> var6, int var7, NppiSize var8, int var9);

    public static int nppiAlphaCompC_8u_C3R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, byte nAlpha1, TypedPointer<Npp8u> pSrc2, int nSrc2Step, byte nAlpha2, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int eAlphaOp) {
        return JNppi.checkResult(JNppi.nppiAlphaCompC_8u_C3RNative(pSrc1, nSrc1Step, nAlpha1, pSrc2, nSrc2Step, nAlpha2, pDst, nDstStep, oSizeROI, eAlphaOp));
    }

    private static native int nppiAlphaCompC_8u_C3RNative(TypedPointer<Npp8u> var0, int var1, byte var2, TypedPointer<Npp8u> var3, int var4, byte var5, TypedPointer<Npp8u> var6, int var7, NppiSize var8, int var9);

    public static int nppiAlphaCompC_8u_C4R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, byte nAlpha1, TypedPointer<Npp8u> pSrc2, int nSrc2Step, byte nAlpha2, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int eAlphaOp) {
        return JNppi.checkResult(JNppi.nppiAlphaCompC_8u_C4RNative(pSrc1, nSrc1Step, nAlpha1, pSrc2, nSrc2Step, nAlpha2, pDst, nDstStep, oSizeROI, eAlphaOp));
    }

    private static native int nppiAlphaCompC_8u_C4RNative(TypedPointer<Npp8u> var0, int var1, byte var2, TypedPointer<Npp8u> var3, int var4, byte var5, TypedPointer<Npp8u> var6, int var7, NppiSize var8, int var9);

    public static int nppiAlphaCompC_8u_AC4R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, byte nAlpha1, TypedPointer<Npp8u> pSrc2, int nSrc2Step, byte nAlpha2, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int eAlphaOp) {
        return JNppi.checkResult(JNppi.nppiAlphaCompC_8u_AC4RNative(pSrc1, nSrc1Step, nAlpha1, pSrc2, nSrc2Step, nAlpha2, pDst, nDstStep, oSizeROI, eAlphaOp));
    }

    private static native int nppiAlphaCompC_8u_AC4RNative(TypedPointer<Npp8u> var0, int var1, byte var2, TypedPointer<Npp8u> var3, int var4, byte var5, TypedPointer<Npp8u> var6, int var7, NppiSize var8, int var9);

    public static int nppiAlphaCompC_8s_C1R(TypedPointer<Npp8s> pSrc1, int nSrc1Step, byte nAlpha1, TypedPointer<Npp8s> pSrc2, int nSrc2Step, byte nAlpha2, TypedPointer<Npp8s> pDst, int nDstStep, NppiSize oSizeROI, int eAlphaOp) {
        return JNppi.checkResult(JNppi.nppiAlphaCompC_8s_C1RNative(pSrc1, nSrc1Step, nAlpha1, pSrc2, nSrc2Step, nAlpha2, pDst, nDstStep, oSizeROI, eAlphaOp));
    }

    private static native int nppiAlphaCompC_8s_C1RNative(TypedPointer<Npp8s> var0, int var1, byte var2, TypedPointer<Npp8s> var3, int var4, byte var5, TypedPointer<Npp8s> var6, int var7, NppiSize var8, int var9);

    public static int nppiAlphaCompC_16u_C1R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, short nAlpha1, TypedPointer<Npp16u> pSrc2, int nSrc2Step, short nAlpha2, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int eAlphaOp) {
        return JNppi.checkResult(JNppi.nppiAlphaCompC_16u_C1RNative(pSrc1, nSrc1Step, nAlpha1, pSrc2, nSrc2Step, nAlpha2, pDst, nDstStep, oSizeROI, eAlphaOp));
    }

    private static native int nppiAlphaCompC_16u_C1RNative(TypedPointer<Npp16u> var0, int var1, short var2, TypedPointer<Npp16u> var3, int var4, short var5, TypedPointer<Npp16u> var6, int var7, NppiSize var8, int var9);

    public static int nppiAlphaCompC_16u_C3R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, short nAlpha1, TypedPointer<Npp16u> pSrc2, int nSrc2Step, short nAlpha2, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int eAlphaOp) {
        return JNppi.checkResult(JNppi.nppiAlphaCompC_16u_C3RNative(pSrc1, nSrc1Step, nAlpha1, pSrc2, nSrc2Step, nAlpha2, pDst, nDstStep, oSizeROI, eAlphaOp));
    }

    private static native int nppiAlphaCompC_16u_C3RNative(TypedPointer<Npp16u> var0, int var1, short var2, TypedPointer<Npp16u> var3, int var4, short var5, TypedPointer<Npp16u> var6, int var7, NppiSize var8, int var9);

    public static int nppiAlphaCompC_16u_C4R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, short nAlpha1, TypedPointer<Npp16u> pSrc2, int nSrc2Step, short nAlpha2, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int eAlphaOp) {
        return JNppi.checkResult(JNppi.nppiAlphaCompC_16u_C4RNative(pSrc1, nSrc1Step, nAlpha1, pSrc2, nSrc2Step, nAlpha2, pDst, nDstStep, oSizeROI, eAlphaOp));
    }

    private static native int nppiAlphaCompC_16u_C4RNative(TypedPointer<Npp16u> var0, int var1, short var2, TypedPointer<Npp16u> var3, int var4, short var5, TypedPointer<Npp16u> var6, int var7, NppiSize var8, int var9);

    public static int nppiAlphaCompC_16u_AC4R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, short nAlpha1, TypedPointer<Npp16u> pSrc2, int nSrc2Step, short nAlpha2, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int eAlphaOp) {
        return JNppi.checkResult(JNppi.nppiAlphaCompC_16u_AC4RNative(pSrc1, nSrc1Step, nAlpha1, pSrc2, nSrc2Step, nAlpha2, pDst, nDstStep, oSizeROI, eAlphaOp));
    }

    private static native int nppiAlphaCompC_16u_AC4RNative(TypedPointer<Npp16u> var0, int var1, short var2, TypedPointer<Npp16u> var3, int var4, short var5, TypedPointer<Npp16u> var6, int var7, NppiSize var8, int var9);

    public static int nppiAlphaCompC_16s_C1R(TypedPointer<Npp16s> pSrc1, int nSrc1Step, short nAlpha1, TypedPointer<Npp16s> pSrc2, int nSrc2Step, short nAlpha2, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int eAlphaOp) {
        return JNppi.checkResult(JNppi.nppiAlphaCompC_16s_C1RNative(pSrc1, nSrc1Step, nAlpha1, pSrc2, nSrc2Step, nAlpha2, pDst, nDstStep, oSizeROI, eAlphaOp));
    }

    private static native int nppiAlphaCompC_16s_C1RNative(TypedPointer<Npp16s> var0, int var1, short var2, TypedPointer<Npp16s> var3, int var4, short var5, TypedPointer<Npp16s> var6, int var7, NppiSize var8, int var9);

    public static int nppiAlphaCompC_32u_C1R(TypedPointer<Npp32u> pSrc1, int nSrc1Step, int nAlpha1, TypedPointer<Npp32u> pSrc2, int nSrc2Step, int nAlpha2, TypedPointer<Npp32u> pDst, int nDstStep, NppiSize oSizeROI, int eAlphaOp) {
        return JNppi.checkResult(JNppi.nppiAlphaCompC_32u_C1RNative(pSrc1, nSrc1Step, nAlpha1, pSrc2, nSrc2Step, nAlpha2, pDst, nDstStep, oSizeROI, eAlphaOp));
    }

    private static native int nppiAlphaCompC_32u_C1RNative(TypedPointer<Npp32u> var0, int var1, int var2, TypedPointer<Npp32u> var3, int var4, int var5, TypedPointer<Npp32u> var6, int var7, NppiSize var8, int var9);

    public static int nppiAlphaCompC_32s_C1R(TypedPointer<Npp32s> pSrc1, int nSrc1Step, int nAlpha1, TypedPointer<Npp32s> pSrc2, int nSrc2Step, int nAlpha2, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, int eAlphaOp) {
        return JNppi.checkResult(JNppi.nppiAlphaCompC_32s_C1RNative(pSrc1, nSrc1Step, nAlpha1, pSrc2, nSrc2Step, nAlpha2, pDst, nDstStep, oSizeROI, eAlphaOp));
    }

    private static native int nppiAlphaCompC_32s_C1RNative(TypedPointer<Npp32s> var0, int var1, int var2, TypedPointer<Npp32s> var3, int var4, int var5, TypedPointer<Npp32s> var6, int var7, NppiSize var8, int var9);

    public static int nppiAlphaCompC_32f_C1R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, float nAlpha1, TypedPointer<Npp32f> pSrc2, int nSrc2Step, float nAlpha2, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI, int eAlphaOp) {
        return JNppi.checkResult(JNppi.nppiAlphaCompC_32f_C1RNative(pSrc1, nSrc1Step, nAlpha1, pSrc2, nSrc2Step, nAlpha2, pDst, nDstStep, oSizeROI, eAlphaOp));
    }

    private static native int nppiAlphaCompC_32f_C1RNative(TypedPointer<Npp32f> var0, int var1, float var2, TypedPointer<Npp32f> var3, int var4, float var5, TypedPointer<Npp32f> var6, int var7, NppiSize var8, int var9);

    public static int nppiAlphaPremulC_8u_C1R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, byte nAlpha1, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAlphaPremulC_8u_C1RNative(pSrc1, nSrc1Step, nAlpha1, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAlphaPremulC_8u_C1RNative(TypedPointer<Npp8u> var0, int var1, byte var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5);

    public static int nppiAlphaPremulC_8u_C1IR(byte nAlpha1, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAlphaPremulC_8u_C1IRNative(nAlpha1, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAlphaPremulC_8u_C1IRNative(byte var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3);

    public static int nppiAlphaPremulC_8u_C3R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, byte nAlpha1, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAlphaPremulC_8u_C3RNative(pSrc1, nSrc1Step, nAlpha1, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAlphaPremulC_8u_C3RNative(TypedPointer<Npp8u> var0, int var1, byte var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5);

    public static int nppiAlphaPremulC_8u_C3IR(byte nAlpha1, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAlphaPremulC_8u_C3IRNative(nAlpha1, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAlphaPremulC_8u_C3IRNative(byte var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3);

    public static int nppiAlphaPremulC_8u_C4R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, byte nAlpha1, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAlphaPremulC_8u_C4RNative(pSrc1, nSrc1Step, nAlpha1, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAlphaPremulC_8u_C4RNative(TypedPointer<Npp8u> var0, int var1, byte var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5);

    public static int nppiAlphaPremulC_8u_C4IR(byte nAlpha1, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAlphaPremulC_8u_C4IRNative(nAlpha1, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAlphaPremulC_8u_C4IRNative(byte var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3);

    public static int nppiAlphaPremulC_8u_AC4R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, byte nAlpha1, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAlphaPremulC_8u_AC4RNative(pSrc1, nSrc1Step, nAlpha1, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAlphaPremulC_8u_AC4RNative(TypedPointer<Npp8u> var0, int var1, byte var2, TypedPointer<Npp8u> var3, int var4, NppiSize var5);

    public static int nppiAlphaPremulC_8u_AC4IR(byte nAlpha1, TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAlphaPremulC_8u_AC4IRNative(nAlpha1, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAlphaPremulC_8u_AC4IRNative(byte var0, TypedPointer<Npp8u> var1, int var2, NppiSize var3);

    public static int nppiAlphaPremulC_16u_C1R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, short nAlpha1, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAlphaPremulC_16u_C1RNative(pSrc1, nSrc1Step, nAlpha1, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAlphaPremulC_16u_C1RNative(TypedPointer<Npp16u> var0, int var1, short var2, TypedPointer<Npp16u> var3, int var4, NppiSize var5);

    public static int nppiAlphaPremulC_16u_C1IR(short nAlpha1, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAlphaPremulC_16u_C1IRNative(nAlpha1, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAlphaPremulC_16u_C1IRNative(short var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3);

    public static int nppiAlphaPremulC_16u_C3R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, short nAlpha1, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAlphaPremulC_16u_C3RNative(pSrc1, nSrc1Step, nAlpha1, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAlphaPremulC_16u_C3RNative(TypedPointer<Npp16u> var0, int var1, short var2, TypedPointer<Npp16u> var3, int var4, NppiSize var5);

    public static int nppiAlphaPremulC_16u_C3IR(short nAlpha1, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAlphaPremulC_16u_C3IRNative(nAlpha1, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAlphaPremulC_16u_C3IRNative(short var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3);

    public static int nppiAlphaPremulC_16u_C4R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, short nAlpha1, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAlphaPremulC_16u_C4RNative(pSrc1, nSrc1Step, nAlpha1, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAlphaPremulC_16u_C4RNative(TypedPointer<Npp16u> var0, int var1, short var2, TypedPointer<Npp16u> var3, int var4, NppiSize var5);

    public static int nppiAlphaPremulC_16u_C4IR(short nAlpha1, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAlphaPremulC_16u_C4IRNative(nAlpha1, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAlphaPremulC_16u_C4IRNative(short var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3);

    public static int nppiAlphaPremulC_16u_AC4R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, short nAlpha1, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAlphaPremulC_16u_AC4RNative(pSrc1, nSrc1Step, nAlpha1, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAlphaPremulC_16u_AC4RNative(TypedPointer<Npp16u> var0, int var1, short var2, TypedPointer<Npp16u> var3, int var4, NppiSize var5);

    public static int nppiAlphaPremulC_16u_AC4IR(short nAlpha1, TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAlphaPremulC_16u_AC4IRNative(nAlpha1, pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAlphaPremulC_16u_AC4IRNative(short var0, TypedPointer<Npp16u> var1, int var2, NppiSize var3);

    public static int nppiAlphaComp_8u_AC1R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int eAlphaOp) {
        return JNppi.checkResult(JNppi.nppiAlphaComp_8u_AC1RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, eAlphaOp));
    }

    private static native int nppiAlphaComp_8u_AC1RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6, int var7);

    public static int nppiAlphaComp_8u_AC4R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int eAlphaOp) {
        return JNppi.checkResult(JNppi.nppiAlphaComp_8u_AC4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, eAlphaOp));
    }

    private static native int nppiAlphaComp_8u_AC4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6, int var7);

    public static int nppiAlphaComp_8s_AC1R(TypedPointer<Npp8s> pSrc1, int nSrc1Step, TypedPointer<Npp8s> pSrc2, int nSrc2Step, TypedPointer<Npp8s> pDst, int nDstStep, NppiSize oSizeROI, int eAlphaOp) {
        return JNppi.checkResult(JNppi.nppiAlphaComp_8s_AC1RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, eAlphaOp));
    }

    private static native int nppiAlphaComp_8s_AC1RNative(TypedPointer<Npp8s> var0, int var1, TypedPointer<Npp8s> var2, int var3, TypedPointer<Npp8s> var4, int var5, NppiSize var6, int var7);

    public static int nppiAlphaComp_16u_AC1R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pSrc2, int nSrc2Step, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int eAlphaOp) {
        return JNppi.checkResult(JNppi.nppiAlphaComp_16u_AC1RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, eAlphaOp));
    }

    private static native int nppiAlphaComp_16u_AC1RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, TypedPointer<Npp16u> var4, int var5, NppiSize var6, int var7);

    public static int nppiAlphaComp_16u_AC4R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pSrc2, int nSrc2Step, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI, int eAlphaOp) {
        return JNppi.checkResult(JNppi.nppiAlphaComp_16u_AC4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, eAlphaOp));
    }

    private static native int nppiAlphaComp_16u_AC4RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, TypedPointer<Npp16u> var4, int var5, NppiSize var6, int var7);

    public static int nppiAlphaComp_16s_AC1R(TypedPointer<Npp16s> pSrc1, int nSrc1Step, TypedPointer<Npp16s> pSrc2, int nSrc2Step, TypedPointer<Npp16s> pDst, int nDstStep, NppiSize oSizeROI, int eAlphaOp) {
        return JNppi.checkResult(JNppi.nppiAlphaComp_16s_AC1RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, eAlphaOp));
    }

    private static native int nppiAlphaComp_16s_AC1RNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp16s> var2, int var3, TypedPointer<Npp16s> var4, int var5, NppiSize var6, int var7);

    public static int nppiAlphaComp_32u_AC1R(TypedPointer<Npp32u> pSrc1, int nSrc1Step, TypedPointer<Npp32u> pSrc2, int nSrc2Step, TypedPointer<Npp32u> pDst, int nDstStep, NppiSize oSizeROI, int eAlphaOp) {
        return JNppi.checkResult(JNppi.nppiAlphaComp_32u_AC1RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, eAlphaOp));
    }

    private static native int nppiAlphaComp_32u_AC1RNative(TypedPointer<Npp32u> var0, int var1, TypedPointer<Npp32u> var2, int var3, TypedPointer<Npp32u> var4, int var5, NppiSize var6, int var7);

    public static int nppiAlphaComp_32u_AC4R(TypedPointer<Npp32u> pSrc1, int nSrc1Step, TypedPointer<Npp32u> pSrc2, int nSrc2Step, TypedPointer<Npp32u> pDst, int nDstStep, NppiSize oSizeROI, int eAlphaOp) {
        return JNppi.checkResult(JNppi.nppiAlphaComp_32u_AC4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, eAlphaOp));
    }

    private static native int nppiAlphaComp_32u_AC4RNative(TypedPointer<Npp32u> var0, int var1, TypedPointer<Npp32u> var2, int var3, TypedPointer<Npp32u> var4, int var5, NppiSize var6, int var7);

    public static int nppiAlphaComp_32s_AC1R(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pSrc2, int nSrc2Step, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, int eAlphaOp) {
        return JNppi.checkResult(JNppi.nppiAlphaComp_32s_AC1RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, eAlphaOp));
    }

    private static native int nppiAlphaComp_32s_AC1RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, TypedPointer<Npp32s> var4, int var5, NppiSize var6, int var7);

    public static int nppiAlphaComp_32s_AC4R(TypedPointer<Npp32s> pSrc1, int nSrc1Step, TypedPointer<Npp32s> pSrc2, int nSrc2Step, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oSizeROI, int eAlphaOp) {
        return JNppi.checkResult(JNppi.nppiAlphaComp_32s_AC4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, eAlphaOp));
    }

    private static native int nppiAlphaComp_32s_AC4RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, TypedPointer<Npp32s> var4, int var5, NppiSize var6, int var7);

    public static int nppiAlphaComp_32f_AC1R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pSrc2, int nSrc2Step, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI, int eAlphaOp) {
        return JNppi.checkResult(JNppi.nppiAlphaComp_32f_AC1RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, eAlphaOp));
    }

    private static native int nppiAlphaComp_32f_AC1RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6, int var7);

    public static int nppiAlphaComp_32f_AC4R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pSrc2, int nSrc2Step, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI, int eAlphaOp) {
        return JNppi.checkResult(JNppi.nppiAlphaComp_32f_AC4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, eAlphaOp));
    }

    private static native int nppiAlphaComp_32f_AC4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6, int var7);

    public static int nppiAlphaPremul_8u_AC4R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAlphaPremul_8u_AC4RNative(pSrc1, nSrc1Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAlphaPremul_8u_AC4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiAlphaPremul_8u_AC4IR(TypedPointer<Npp8u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAlphaPremul_8u_AC4IRNative(pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAlphaPremul_8u_AC4IRNative(TypedPointer<Npp8u> var0, int var1, NppiSize var2);

    public static int nppiAlphaPremul_16u_AC4R(TypedPointer<Npp16u> pSrc1, int nSrc1Step, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAlphaPremul_16u_AC4RNative(pSrc1, nSrc1Step, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiAlphaPremul_16u_AC4RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4);

    public static int nppiAlphaPremul_16u_AC4IR(TypedPointer<Npp16u> pSrcDst, int nSrcDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiAlphaPremul_16u_AC4IRNative(pSrcDst, nSrcDstStep, oSizeROI));
    }

    private static native int nppiAlphaPremul_16u_AC4IRNative(TypedPointer<Npp16u> var0, int var1, NppiSize var2);

    public static int nppiThreshold_32f_C1R(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI, float nThreshold, int eComparisonOperation) {
        return JNppi.checkResult(JNppi.nppiThreshold_32f_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, nThreshold, eComparisonOperation));
    }

    private static native int nppiThreshold_32f_C1RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4, float var5, int var6);

    public static int nppiThreshold_8u_AC4R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, byte[] aThresholds, int eComparisonOperation) {
        return JNppi.checkResult(JNppi.nppiThreshold_8u_AC4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, aThresholds, eComparisonOperation));
    }

    private static native int nppiThreshold_8u_AC4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, byte[] var5, int var6);

    public static int nppiCompare_8u_C4R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int eComparisonOperation) {
        return JNppi.checkResult(JNppi.nppiCompare_8u_C4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, eComparisonOperation));
    }

    private static native int nppiCompare_8u_C4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6, int var7);

    public static int nppiCompare_8u_AC4R(TypedPointer<Npp8u> pSrc1, int nSrc1Step, TypedPointer<Npp8u> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int eComparisonOperation) {
        return JNppi.checkResult(JNppi.nppiCompare_8u_AC4RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, eComparisonOperation));
    }

    private static native int nppiCompare_8u_AC4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6, int var7);

    public static int nppiCompare_32f_C1R(TypedPointer<Npp32f> pSrc1, int nSrc1Step, TypedPointer<Npp32f> pSrc2, int nSrc2Step, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, int eComparisonOperation) {
        return JNppi.checkResult(JNppi.nppiCompare_32f_C1RNative(pSrc1, nSrc1Step, pSrc2, nSrc2Step, pDst, nDstStep, oSizeROI, eComparisonOperation));
    }

    private static native int nppiCompare_32f_C1RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6, int var7);

    public static int nppiMeanStdDev8uC1RGetBufferHostSize(NppiSize oSizeROI, int[] hpBufferSize) {
        return JNppi.checkResult(JNppi.nppiMeanStdDev8uC1RGetBufferHostSizeNative(oSizeROI, hpBufferSize));
    }

    private static native int nppiMeanStdDev8uC1RGetBufferHostSizeNative(NppiSize var0, int[] var1);

    public static int nppiMean_StdDev_8u_C1R(TypedPointer<Npp8u> pSrc, int nSrcStep, NppiSize oSizeROI, TypedPointer<Npp8u> pDeviceBuffer, TypedPointer<Npp64f> pMean, TypedPointer<Npp64f> pStdDev) {
        return JNppi.checkResult(JNppi.nppiMean_StdDev_8u_C1RNative(pSrc, nSrcStep, oSizeROI, pDeviceBuffer, pMean, pStdDev));
    }

    private static native int nppiMean_StdDev_8u_C1RNative(TypedPointer<Npp8u> var0, int var1, NppiSize var2, TypedPointer<Npp8u> var3, TypedPointer<Npp64f> var4, TypedPointer<Npp64f> var5);

    public static int nppiNormDiff_L1_8u_C1R(TypedPointer<Npp8u> pSrc1, int nSrcStep1, TypedPointer<Npp8u> pSrc2, int nSrcStep2, NppiSize oSizeROI, TypedPointer<Npp64f> pRetVal) {
        return JNppi.checkResult(JNppi.nppiNormDiff_L1_8u_C1RNative(pSrc1, nSrcStep1, pSrc2, nSrcStep2, oSizeROI, pRetVal));
    }

    private static native int nppiNormDiff_L1_8u_C1RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, TypedPointer<Npp64f> var5);

    public static int nppiNormDiff_L2_8u_C1R(TypedPointer<Npp8u> pSrc1, int nSrcStep1, TypedPointer<Npp8u> pSrc2, int nSrcStep2, NppiSize oSizeROI, TypedPointer<Npp64f> pRetVal) {
        return JNppi.checkResult(JNppi.nppiNormDiff_L2_8u_C1RNative(pSrc1, nSrcStep1, pSrc2, nSrcStep2, oSizeROI, pRetVal));
    }

    private static native int nppiNormDiff_L2_8u_C1RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, TypedPointer<Npp64f> var5);

    public static int nppiNormDiff_Inf_8u_C1R(TypedPointer<Npp8u> pSrc1, int nSrcStep1, TypedPointer<Npp8u> pSrc2, int nSrcStep2, NppiSize oSizeROI, TypedPointer<Npp64f> pRetVal) {
        return JNppi.checkResult(JNppi.nppiNormDiff_Inf_8u_C1RNative(pSrc1, nSrcStep1, pSrc2, nSrcStep2, oSizeROI, pRetVal));
    }

    private static native int nppiNormDiff_Inf_8u_C1RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, TypedPointer<Npp64f> var5);

    public static int nppiSqrIntegral_8u32s32f_C1R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp32s> pDst, int nDstStep, TypedPointer<Npp32f> pSqr, int nSqrStep, NppiSize oSrcROI, int val, float valSqr, int integralImageNewHeight) {
        return JNppi.checkResult(JNppi.nppiSqrIntegral_8u32s32f_C1RNative(pSrc, nSrcStep, pDst, nDstStep, pSqr, nSqrStep, oSrcROI, val, valSqr, integralImageNewHeight));
    }

    private static native int nppiSqrIntegral_8u32s32f_C1RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp32s> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6, int var7, float var8, int var9);

    public static int nppiRectStdDev_32s32f_C1R(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp64f> pSqr, int nSqrStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI, NppiRect rect) {
        return JNppi.checkResult(JNppi.nppiRectStdDev_32s32f_C1RNative(pSrc, nSrcStep, pSqr, nSqrStep, pDst, nDstStep, oSizeROI, rect));
    }

    private static native int nppiRectStdDev_32s32f_C1RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp64f> var2, int var3, TypedPointer<Npp32f> var4, int var5, NppiSize var6, NppiRect var7);

    public static int nppiReductionGetBufferHostSize_8u_C1R(NppiSize oSizeROI, int[] hpBufferSize) {
        return JNppi.checkResult(JNppi.nppiReductionGetBufferHostSize_8u_C1RNative(oSizeROI, hpBufferSize));
    }

    private static native int nppiReductionGetBufferHostSize_8u_C1RNative(NppiSize var0, int[] var1);

    public static int nppiReductionGetBufferHostSize_8u_C4R(NppiSize oSizeROI, int[] hpBufferSize) {
        return JNppi.checkResult(JNppi.nppiReductionGetBufferHostSize_8u_C4RNative(oSizeROI, hpBufferSize));
    }

    private static native int nppiReductionGetBufferHostSize_8u_C4RNative(NppiSize var0, int[] var1);

    public static int nppiSum_8u64s_C1R(TypedPointer<Npp8u> pSrc, int nSrcStep, NppiSize oSizeROI, TypedPointer<Npp8u> pDeviceBuffer, long[] pSum) {
        return JNppi.checkResult(JNppi.nppiSum_8u64s_C1RNative(pSrc, nSrcStep, oSizeROI, pDeviceBuffer, pSum));
    }

    private static native int nppiSum_8u64s_C1RNative(TypedPointer<Npp8u> var0, int var1, NppiSize var2, TypedPointer<Npp8u> var3, long[] var4);

    public static int nppiSum_8u_C1R(TypedPointer<Npp8u> pSrc, int nSrcStep, NppiSize oSizeROI, TypedPointer<Npp8u> pDeviceBuffer, double[] pSum) {
        return JNppi.checkResult(JNppi.nppiSum_8u_C1RNative(pSrc, nSrcStep, oSizeROI, pDeviceBuffer, pSum));
    }

    private static native int nppiSum_8u_C1RNative(TypedPointer<Npp8u> var0, int var1, NppiSize var2, TypedPointer<Npp8u> var3, double[] var4);

    public static int nppiSum_8u64s_C4R(TypedPointer<Npp8u> pSrc, int nSrcStep, NppiSize oSizeROI, TypedPointer<Npp8u> pDeviceBuffer, long[] aSum) {
        return JNppi.checkResult(JNppi.nppiSum_8u64s_C4RNative(pSrc, nSrcStep, oSizeROI, pDeviceBuffer, aSum));
    }

    private static native int nppiSum_8u64s_C4RNative(TypedPointer<Npp8u> var0, int var1, NppiSize var2, TypedPointer<Npp8u> var3, long[] var4);

    public static int nppiSum_8u_C4R(TypedPointer<Npp8u> pSrc, int nSrcStep, NppiSize oSizeROI, TypedPointer<Npp8u> pDeviceBuffer, double[] aSum) {
        return JNppi.checkResult(JNppi.nppiSum_8u_C4RNative(pSrc, nSrcStep, oSizeROI, pDeviceBuffer, aSum));
    }

    private static native int nppiSum_8u_C4RNative(TypedPointer<Npp8u> var0, int var1, NppiSize var2, TypedPointer<Npp8u> var3, double[] var4);

    public static int nppiMinMaxGetBufferSize_8u_C1R(NppiSize oSizeROI, int[] hpBufferSize) {
        return JNppi.checkResult(JNppi.nppiMinMaxGetBufferSize_8u_C1RNative(oSizeROI, hpBufferSize));
    }

    private static native int nppiMinMaxGetBufferSize_8u_C1RNative(NppiSize var0, int[] var1);

    public static int nppiMinMax_8u_C1R(TypedPointer<Npp8u> pSrc, int nSrcStep, NppiSize oSizeROI, TypedPointer<Npp8u> pMin, TypedPointer<Npp8u> pMax, TypedPointer<Npp8u> pDeviceBuffer) {
        return JNppi.checkResult(JNppi.nppiMinMax_8u_C1RNative(pSrc, nSrcStep, oSizeROI, pMin, pMax, pDeviceBuffer));
    }

    private static native int nppiMinMax_8u_C1RNative(TypedPointer<Npp8u> var0, int var1, NppiSize var2, TypedPointer<Npp8u> var3, TypedPointer<Npp8u> var4, TypedPointer<Npp8u> var5);

    public static int nppiMinMaxGetBufferSize_8u_C4R(NppiSize oSizeROI, int[] hpBufferSize) {
        return JNppi.checkResult(JNppi.nppiMinMaxGetBufferSize_8u_C4RNative(oSizeROI, hpBufferSize));
    }

    private static native int nppiMinMaxGetBufferSize_8u_C4RNative(NppiSize var0, int[] var1);

    public static int nppiMinMax_8u_C4R(TypedPointer<Npp8u> pSrc, int nSrcStep, NppiSize oSizeROI, byte[] aMin, byte[] aMax, TypedPointer<Npp8u> pDeviceBuffer) {
        return JNppi.checkResult(JNppi.nppiMinMax_8u_C4RNative(pSrc, nSrcStep, oSizeROI, aMin, aMax, pDeviceBuffer));
    }

    private static native int nppiMinMax_8u_C4RNative(TypedPointer<Npp8u> var0, int var1, NppiSize var2, byte[] var3, byte[] var4, TypedPointer<Npp8u> var5);

    public static int nppiEvenLevelsHost_32s(TypedPointer<Npp32s> hpLevels, int nLevels, int nLowerLevel, int nUpperLevel) {
        return JNppi.checkResult(JNppi.nppiEvenLevelsHost_32sNative(hpLevels, nLevels, nLowerLevel, nUpperLevel));
    }

    private static native int nppiEvenLevelsHost_32sNative(TypedPointer<Npp32s> var0, int var1, int var2, int var3);

    public static int nppiHistogramEvenGetBufferSize_8u_C1R(NppiSize oSizeROI, int nLevels, int[] hpBufferSize) {
        return JNppi.checkResult(JNppi.nppiHistogramEvenGetBufferSize_8u_C1RNative(oSizeROI, nLevels, hpBufferSize));
    }

    private static native int nppiHistogramEvenGetBufferSize_8u_C1RNative(NppiSize var0, int var1, int[] var2);

    public static int nppiHistogramEven_8u_C1R(TypedPointer<Npp8u> pSrc, int nSrcStep, NppiSize oSizeROI, TypedPointer<Npp32s> pHist, int nLevels, int nLowerLevel, int nUpperLevel, TypedPointer<Npp8u> pBuffer) {
        return JNppi.checkResult(JNppi.nppiHistogramEven_8u_C1RNative(pSrc, nSrcStep, oSizeROI, pHist, nLevels, nLowerLevel, nUpperLevel, pBuffer));
    }

    private static native int nppiHistogramEven_8u_C1RNative(TypedPointer<Npp8u> var0, int var1, NppiSize var2, TypedPointer<Npp32s> var3, int var4, int var5, int var6, TypedPointer<Npp8u> var7);

    public static int nppiHistogramEvenGetBufferSize_8u_C4R(NppiSize oSizeROI, int[] nLevels, int[] hpBufferSize) {
        return JNppi.checkResult(JNppi.nppiHistogramEvenGetBufferSize_8u_C4RNative(oSizeROI, nLevels, hpBufferSize));
    }

    private static native int nppiHistogramEvenGetBufferSize_8u_C4RNative(NppiSize var0, int[] var1, int[] var2);

    public static int nppiHistogramEven_8u_C4R(TypedPointer<Npp8u> pSrc, int nSrcStep, NppiSize oSizeROI, TypedPointer<Npp32s>[] pHist, int[] nLevels, int[] nLowerLevel, int[] nUpperLevel, TypedPointer<Npp8u> pBuffer) {
        return JNppi.checkResult(JNppi.nppiHistogramEven_8u_C4RNative(pSrc, nSrcStep, oSizeROI, pHist, nLevels, nLowerLevel, nUpperLevel, pBuffer));
    }

    private static native int nppiHistogramEven_8u_C4RNative(TypedPointer<Npp8u> var0, int var1, NppiSize var2, TypedPointer<Npp32s>[] var3, int[] var4, int[] var5, int[] var6, TypedPointer<Npp8u> var7);

    public static int nppiHistogramEvenGetBufferSize_8u_AC4R(NppiSize oSizeROI, int[] nLevels, int[] hpBufferSize) {
        return JNppi.checkResult(JNppi.nppiHistogramEvenGetBufferSize_8u_AC4RNative(oSizeROI, nLevels, hpBufferSize));
    }

    private static native int nppiHistogramEvenGetBufferSize_8u_AC4RNative(NppiSize var0, int[] var1, int[] var2);

    public static int nppiHistogramEven_8u_AC4R(TypedPointer<Npp8u> pSrc, int nSrcStep, NppiSize oSizeROI, TypedPointer<Npp32s>[] pHist, int[] nLevels, int[] nLowerLevel, int[] nUpperLevel, TypedPointer<Npp8u> pBuffer) {
        return JNppi.checkResult(JNppi.nppiHistogramEven_8u_AC4RNative(pSrc, nSrcStep, oSizeROI, pHist, nLevels, nLowerLevel, nUpperLevel, pBuffer));
    }

    private static native int nppiHistogramEven_8u_AC4RNative(TypedPointer<Npp8u> var0, int var1, NppiSize var2, TypedPointer<Npp32s>[] var3, int[] var4, int[] var5, int[] var6, TypedPointer<Npp8u> var7);

    public static int nppiHistogramEvenGetBufferSize_16u_C1R(NppiSize oSizeROI, int nLevels, int[] hpBufferSize) {
        return JNppi.checkResult(JNppi.nppiHistogramEvenGetBufferSize_16u_C1RNative(oSizeROI, nLevels, hpBufferSize));
    }

    private static native int nppiHistogramEvenGetBufferSize_16u_C1RNative(NppiSize var0, int var1, int[] var2);

    public static int nppiHistogramEven_16u_C1R(TypedPointer<Npp16u> pSrc, int nSrcStep, NppiSize oSizeROI, TypedPointer<Npp32s> pHist, int nLevels, int nLowerLevel, int nUpperLevel, TypedPointer<Npp8u> pBuffer) {
        return JNppi.checkResult(JNppi.nppiHistogramEven_16u_C1RNative(pSrc, nSrcStep, oSizeROI, pHist, nLevels, nLowerLevel, nUpperLevel, pBuffer));
    }

    private static native int nppiHistogramEven_16u_C1RNative(TypedPointer<Npp16u> var0, int var1, NppiSize var2, TypedPointer<Npp32s> var3, int var4, int var5, int var6, TypedPointer<Npp8u> var7);

    public static int nppiHistogramEvenGetBufferSize_16u_C4R(NppiSize oSizeROI, int[] nLevels, int[] hpBufferSize) {
        return JNppi.checkResult(JNppi.nppiHistogramEvenGetBufferSize_16u_C4RNative(oSizeROI, nLevels, hpBufferSize));
    }

    private static native int nppiHistogramEvenGetBufferSize_16u_C4RNative(NppiSize var0, int[] var1, int[] var2);

    public static int nppiHistogramEven_16u_C4R(TypedPointer<Npp16u> pSrc, int nSrcStep, NppiSize oSizeROI, TypedPointer<Npp32s>[] pHist, int[] nLevels, int[] nLowerLevel, int[] nUpperLevel, TypedPointer<Npp8u> pBuffer) {
        return JNppi.checkResult(JNppi.nppiHistogramEven_16u_C4RNative(pSrc, nSrcStep, oSizeROI, pHist, nLevels, nLowerLevel, nUpperLevel, pBuffer));
    }

    private static native int nppiHistogramEven_16u_C4RNative(TypedPointer<Npp16u> var0, int var1, NppiSize var2, TypedPointer<Npp32s>[] var3, int[] var4, int[] var5, int[] var6, TypedPointer<Npp8u> var7);

    public static int nppiHistogramEvenGetBufferSize_16u_AC4R(NppiSize oSizeROI, int[] nLevels, int[] hpBufferSize) {
        return JNppi.checkResult(JNppi.nppiHistogramEvenGetBufferSize_16u_AC4RNative(oSizeROI, nLevels, hpBufferSize));
    }

    private static native int nppiHistogramEvenGetBufferSize_16u_AC4RNative(NppiSize var0, int[] var1, int[] var2);

    public static int nppiHistogramEven_16u_AC4R(TypedPointer<Npp16u> pSrc, int nSrcStep, NppiSize oSizeROI, TypedPointer<Npp32s>[] pHist, int[] nLevels, int[] nLowerLevel, int[] nUpperLevel, TypedPointer<Npp8u> pBuffer) {
        return JNppi.checkResult(JNppi.nppiHistogramEven_16u_AC4RNative(pSrc, nSrcStep, oSizeROI, pHist, nLevels, nLowerLevel, nUpperLevel, pBuffer));
    }

    private static native int nppiHistogramEven_16u_AC4RNative(TypedPointer<Npp16u> var0, int var1, NppiSize var2, TypedPointer<Npp32s>[] var3, int[] var4, int[] var5, int[] var6, TypedPointer<Npp8u> var7);

    public static int nppiHistogramEvenGetBufferSize_16s_C1R(NppiSize oSizeROI, int nLevels, int[] hpBufferSize) {
        return JNppi.checkResult(JNppi.nppiHistogramEvenGetBufferSize_16s_C1RNative(oSizeROI, nLevels, hpBufferSize));
    }

    private static native int nppiHistogramEvenGetBufferSize_16s_C1RNative(NppiSize var0, int var1, int[] var2);

    public static int nppiHistogramEven_16s_C1R(TypedPointer<Npp16s> pSrc, int nSrcStep, NppiSize oSizeROI, TypedPointer<Npp32s> pHist, int nLevels, int nLowerLevel, int nUpperLevel, TypedPointer<Npp8u> pBuffer) {
        return JNppi.checkResult(JNppi.nppiHistogramEven_16s_C1RNative(pSrc, nSrcStep, oSizeROI, pHist, nLevels, nLowerLevel, nUpperLevel, pBuffer));
    }

    private static native int nppiHistogramEven_16s_C1RNative(TypedPointer<Npp16s> var0, int var1, NppiSize var2, TypedPointer<Npp32s> var3, int var4, int var5, int var6, TypedPointer<Npp8u> var7);

    public static int nppiHistogramEvenGetBufferSize_16s_C4R(NppiSize oSizeROI, int[] nLevels, int[] hpBufferSize) {
        return JNppi.checkResult(JNppi.nppiHistogramEvenGetBufferSize_16s_C4RNative(oSizeROI, nLevels, hpBufferSize));
    }

    private static native int nppiHistogramEvenGetBufferSize_16s_C4RNative(NppiSize var0, int[] var1, int[] var2);

    public static int nppiHistogramEven_16s_C4R(TypedPointer<Npp16s> pSrc, int nSrcStep, NppiSize oSizeROI, TypedPointer<Npp32s>[] pHist, int[] nLevels, int[] nLowerLevel, int[] nUpperLevel, TypedPointer<Npp8u> pBuffer) {
        return JNppi.checkResult(JNppi.nppiHistogramEven_16s_C4RNative(pSrc, nSrcStep, oSizeROI, pHist, nLevels, nLowerLevel, nUpperLevel, pBuffer));
    }

    private static native int nppiHistogramEven_16s_C4RNative(TypedPointer<Npp16s> var0, int var1, NppiSize var2, TypedPointer<Npp32s>[] var3, int[] var4, int[] var5, int[] var6, TypedPointer<Npp8u> var7);

    public static int nppiHistogramEvenGetBufferSize_16s_AC4R(NppiSize oSizeROI, int[] nLevels, int[] hpBufferSize) {
        return JNppi.checkResult(JNppi.nppiHistogramEvenGetBufferSize_16s_AC4RNative(oSizeROI, nLevels, hpBufferSize));
    }

    private static native int nppiHistogramEvenGetBufferSize_16s_AC4RNative(NppiSize var0, int[] var1, int[] var2);

    public static int nppiHistogramEven_16s_AC4R(TypedPointer<Npp16s> pSrc, int nSrcStep, NppiSize oSizeROI, TypedPointer<Npp32s>[] pHist, int[] nLevels, int[] nLowerLevel, int[] nUpperLevel, TypedPointer<Npp8u> pBuffer) {
        return JNppi.checkResult(JNppi.nppiHistogramEven_16s_AC4RNative(pSrc, nSrcStep, oSizeROI, pHist, nLevels, nLowerLevel, nUpperLevel, pBuffer));
    }

    private static native int nppiHistogramEven_16s_AC4RNative(TypedPointer<Npp16s> var0, int var1, NppiSize var2, TypedPointer<Npp32s>[] var3, int[] var4, int[] var5, int[] var6, TypedPointer<Npp8u> var7);

    public static int nppiHistogramRangeGetBufferSize_8u_C1R(NppiSize oSizeROI, int nLevels, int[] hpBufferSize) {
        return JNppi.checkResult(JNppi.nppiHistogramRangeGetBufferSize_8u_C1RNative(oSizeROI, nLevels, hpBufferSize));
    }

    private static native int nppiHistogramRangeGetBufferSize_8u_C1RNative(NppiSize var0, int var1, int[] var2);

    public static int nppiHistogramRange_8u_C1R(TypedPointer<Npp8u> pSrc, int nSrcStep, NppiSize oSizeROI, TypedPointer<Npp32s> pHist, TypedPointer<Npp32s> pLevels, int nLevels, TypedPointer<Npp8u> pBuffer) {
        return JNppi.checkResult(JNppi.nppiHistogramRange_8u_C1RNative(pSrc, nSrcStep, oSizeROI, pHist, pLevels, nLevels, pBuffer));
    }

    private static native int nppiHistogramRange_8u_C1RNative(TypedPointer<Npp8u> var0, int var1, NppiSize var2, TypedPointer<Npp32s> var3, TypedPointer<Npp32s> var4, int var5, TypedPointer<Npp8u> var6);

    public static int nppiHistogramRangeGetBufferSize_8u_C4R(NppiSize oSizeROI, int[] nLevels, int[] hpBufferSize) {
        return JNppi.checkResult(JNppi.nppiHistogramRangeGetBufferSize_8u_C4RNative(oSizeROI, nLevels, hpBufferSize));
    }

    private static native int nppiHistogramRangeGetBufferSize_8u_C4RNative(NppiSize var0, int[] var1, int[] var2);

    public static int nppiHistogramRange_8u_C4R(TypedPointer<Npp8u> pSrc, int nSrcStep, NppiSize oSizeROI, TypedPointer<Npp32s>[] pHist, TypedPointer<Npp32s>[] pLevels, int[] nLevels, TypedPointer<Npp8u> pBuffer) {
        return JNppi.checkResult(JNppi.nppiHistogramRange_8u_C4RNative(pSrc, nSrcStep, oSizeROI, pHist, pLevels, nLevels, pBuffer));
    }

    private static native int nppiHistogramRange_8u_C4RNative(TypedPointer<Npp8u> var0, int var1, NppiSize var2, TypedPointer<Npp32s>[] var3, TypedPointer<Npp32s>[] var4, int[] var5, TypedPointer<Npp8u> var6);

    public static int nppiHistogramRangeGetBufferSize_8u_AC4R(NppiSize oSizeROI, int[] nLevels, int[] hpBufferSize) {
        return JNppi.checkResult(JNppi.nppiHistogramRangeGetBufferSize_8u_AC4RNative(oSizeROI, nLevels, hpBufferSize));
    }

    private static native int nppiHistogramRangeGetBufferSize_8u_AC4RNative(NppiSize var0, int[] var1, int[] var2);

    public static int nppiHistogramRange_8u_AC4R(TypedPointer<Npp8u> pSrc, int nSrcStep, NppiSize oSizeROI, TypedPointer<Npp32s>[] pHist, TypedPointer<Npp32s>[] pLevels, int[] nLevels, TypedPointer<Npp8u> pBuffer) {
        return JNppi.checkResult(JNppi.nppiHistogramRange_8u_AC4RNative(pSrc, nSrcStep, oSizeROI, pHist, pLevels, nLevels, pBuffer));
    }

    private static native int nppiHistogramRange_8u_AC4RNative(TypedPointer<Npp8u> var0, int var1, NppiSize var2, TypedPointer<Npp32s>[] var3, TypedPointer<Npp32s>[] var4, int[] var5, TypedPointer<Npp8u> var6);

    public static int nppiHistogramRangeGetBufferSize_16u_C1R(NppiSize oSizeROI, int nLevels, int[] hpBufferSize) {
        return JNppi.checkResult(JNppi.nppiHistogramRangeGetBufferSize_16u_C1RNative(oSizeROI, nLevels, hpBufferSize));
    }

    private static native int nppiHistogramRangeGetBufferSize_16u_C1RNative(NppiSize var0, int var1, int[] var2);

    public static int nppiHistogramRange_16u_C1R(TypedPointer<Npp16u> pSrc, int nSrcStep, NppiSize oSizeROI, TypedPointer<Npp32s> pHist, TypedPointer<Npp32s> pLevels, int nLevels, TypedPointer<Npp8u> pBuffer) {
        return JNppi.checkResult(JNppi.nppiHistogramRange_16u_C1RNative(pSrc, nSrcStep, oSizeROI, pHist, pLevels, nLevels, pBuffer));
    }

    private static native int nppiHistogramRange_16u_C1RNative(TypedPointer<Npp16u> var0, int var1, NppiSize var2, TypedPointer<Npp32s> var3, TypedPointer<Npp32s> var4, int var5, TypedPointer<Npp8u> var6);

    public static int nppiHistogramRangeGetBufferSize_16u_C4R(NppiSize oSizeROI, int[] nLevels, int[] hpBufferSize) {
        return JNppi.checkResult(JNppi.nppiHistogramRangeGetBufferSize_16u_C4RNative(oSizeROI, nLevels, hpBufferSize));
    }

    private static native int nppiHistogramRangeGetBufferSize_16u_C4RNative(NppiSize var0, int[] var1, int[] var2);

    public static int nppiHistogramRange_16u_C4R(TypedPointer<Npp16u> pSrc, int nSrcStep, NppiSize oSizeROI, TypedPointer<Npp32s>[] pHist, TypedPointer<Npp32s>[] pLevels, int[] nLevels, TypedPointer<Npp8u> pBuffer) {
        return JNppi.checkResult(JNppi.nppiHistogramRange_16u_C4RNative(pSrc, nSrcStep, oSizeROI, pHist, pLevels, nLevels, pBuffer));
    }

    private static native int nppiHistogramRange_16u_C4RNative(TypedPointer<Npp16u> var0, int var1, NppiSize var2, TypedPointer<Npp32s>[] var3, TypedPointer<Npp32s>[] var4, int[] var5, TypedPointer<Npp8u> var6);

    public static int nppiHistogramRangeGetBufferSize_16u_AC4R(NppiSize oSizeROI, int[] nLevels, int[] hpBufferSize) {
        return JNppi.checkResult(JNppi.nppiHistogramRangeGetBufferSize_16u_AC4RNative(oSizeROI, nLevels, hpBufferSize));
    }

    private static native int nppiHistogramRangeGetBufferSize_16u_AC4RNative(NppiSize var0, int[] var1, int[] var2);

    public static int nppiHistogramRange_16u_AC4R(TypedPointer<Npp16u> pSrc, int nSrcStep, NppiSize oSizeROI, TypedPointer<Npp32s>[] pHist, TypedPointer<Npp32s>[] pLevels, int[] nLevels, TypedPointer<Npp8u> pBuffer) {
        return JNppi.checkResult(JNppi.nppiHistogramRange_16u_AC4RNative(pSrc, nSrcStep, oSizeROI, pHist, pLevels, nLevels, pBuffer));
    }

    private static native int nppiHistogramRange_16u_AC4RNative(TypedPointer<Npp16u> var0, int var1, NppiSize var2, TypedPointer<Npp32s>[] var3, TypedPointer<Npp32s>[] var4, int[] var5, TypedPointer<Npp8u> var6);

    public static int nppiHistogramRangeGetBufferSize_16s_C1R(NppiSize oSizeROI, int nLevels, int[] hpBufferSize) {
        return JNppi.checkResult(JNppi.nppiHistogramRangeGetBufferSize_16s_C1RNative(oSizeROI, nLevels, hpBufferSize));
    }

    private static native int nppiHistogramRangeGetBufferSize_16s_C1RNative(NppiSize var0, int var1, int[] var2);

    public static int nppiHistogramRange_16s_C1R(TypedPointer<Npp16s> pSrc, int nSrcStep, NppiSize oSizeROI, TypedPointer<Npp32s> pHist, TypedPointer<Npp32s> pLevels, int nLevels, TypedPointer<Npp8u> pBuffer) {
        return JNppi.checkResult(JNppi.nppiHistogramRange_16s_C1RNative(pSrc, nSrcStep, oSizeROI, pHist, pLevels, nLevels, pBuffer));
    }

    private static native int nppiHistogramRange_16s_C1RNative(TypedPointer<Npp16s> var0, int var1, NppiSize var2, TypedPointer<Npp32s> var3, TypedPointer<Npp32s> var4, int var5, TypedPointer<Npp8u> var6);

    public static int nppiHistogramRangeGetBufferSize_16s_C4R(NppiSize oSizeROI, int[] nLevels, int[] hpBufferSize) {
        return JNppi.checkResult(JNppi.nppiHistogramRangeGetBufferSize_16s_C4RNative(oSizeROI, nLevels, hpBufferSize));
    }

    private static native int nppiHistogramRangeGetBufferSize_16s_C4RNative(NppiSize var0, int[] var1, int[] var2);

    public static int nppiHistogramRange_16s_C4R(TypedPointer<Npp16s> pSrc, int nSrcStep, NppiSize oSizeROI, TypedPointer<Npp32s>[] pHist, TypedPointer<Npp32s>[] pLevels, int[] nLevels, TypedPointer<Npp8u> pBuffer) {
        return JNppi.checkResult(JNppi.nppiHistogramRange_16s_C4RNative(pSrc, nSrcStep, oSizeROI, pHist, pLevels, nLevels, pBuffer));
    }

    private static native int nppiHistogramRange_16s_C4RNative(TypedPointer<Npp16s> var0, int var1, NppiSize var2, TypedPointer<Npp32s>[] var3, TypedPointer<Npp32s>[] var4, int[] var5, TypedPointer<Npp8u> var6);

    public static int nppiHistogramRangeGetBufferSize_16s_AC4R(NppiSize oSizeROI, int[] nLevels, int[] hpBufferSize) {
        return JNppi.checkResult(JNppi.nppiHistogramRangeGetBufferSize_16s_AC4RNative(oSizeROI, nLevels, hpBufferSize));
    }

    private static native int nppiHistogramRangeGetBufferSize_16s_AC4RNative(NppiSize var0, int[] var1, int[] var2);

    public static int nppiHistogramRange_16s_AC4R(TypedPointer<Npp16s> pSrc, int nSrcStep, NppiSize oSizeROI, TypedPointer<Npp32s>[] pHist, TypedPointer<Npp32s>[] pLevels, int[] nLevels, TypedPointer<Npp8u> pBuffer) {
        return JNppi.checkResult(JNppi.nppiHistogramRange_16s_AC4RNative(pSrc, nSrcStep, oSizeROI, pHist, pLevels, nLevels, pBuffer));
    }

    private static native int nppiHistogramRange_16s_AC4RNative(TypedPointer<Npp16s> var0, int var1, NppiSize var2, TypedPointer<Npp32s>[] var3, TypedPointer<Npp32s>[] var4, int[] var5, TypedPointer<Npp8u> var6);

    public static int nppiHistogramRangeGetBufferSize_32f_C1R(NppiSize oSizeROI, int nLevels, int[] hpBufferSize) {
        return JNppi.checkResult(JNppi.nppiHistogramRangeGetBufferSize_32f_C1RNative(oSizeROI, nLevels, hpBufferSize));
    }

    private static native int nppiHistogramRangeGetBufferSize_32f_C1RNative(NppiSize var0, int var1, int[] var2);

    public static int nppiHistogramRange_32f_C1R(TypedPointer<Npp32f> pSrc, int nSrcStep, NppiSize oSizeROI, TypedPointer<Npp32s> pHist, TypedPointer<Npp32f> pLevels, int nLevels, TypedPointer<Npp8u> pBuffer) {
        return JNppi.checkResult(JNppi.nppiHistogramRange_32f_C1RNative(pSrc, nSrcStep, oSizeROI, pHist, pLevels, nLevels, pBuffer));
    }

    private static native int nppiHistogramRange_32f_C1RNative(TypedPointer<Npp32f> var0, int var1, NppiSize var2, TypedPointer<Npp32s> var3, TypedPointer<Npp32f> var4, int var5, TypedPointer<Npp8u> var6);

    public static int nppiHistogramRangeGetBufferSize_32f_C4R(NppiSize oSizeROI, int[] nLevels, int[] hpBufferSize) {
        return JNppi.checkResult(JNppi.nppiHistogramRangeGetBufferSize_32f_C4RNative(oSizeROI, nLevels, hpBufferSize));
    }

    private static native int nppiHistogramRangeGetBufferSize_32f_C4RNative(NppiSize var0, int[] var1, int[] var2);

    public static int nppiHistogramRange_32f_C4R(TypedPointer<Npp32f> pSrc, int nSrcStep, NppiSize oSizeROI, TypedPointer<Npp32s>[] pHist, TypedPointer<Npp32f>[] pLevels, int[] nLevels, TypedPointer<Npp8u> pBuffer) {
        return JNppi.checkResult(JNppi.nppiHistogramRange_32f_C4RNative(pSrc, nSrcStep, oSizeROI, pHist, pLevels, nLevels, pBuffer));
    }

    private static native int nppiHistogramRange_32f_C4RNative(TypedPointer<Npp32f> var0, int var1, NppiSize var2, TypedPointer<Npp32s>[] var3, TypedPointer<Npp32f>[] var4, int[] var5, TypedPointer<Npp8u> var6);

    public static int nppiHistogramRangeGetBufferSize_32f_AC4R(NppiSize oSizeROI, int[] nLevels, int[] hpBufferSize) {
        return JNppi.checkResult(JNppi.nppiHistogramRangeGetBufferSize_32f_AC4RNative(oSizeROI, nLevels, hpBufferSize));
    }

    private static native int nppiHistogramRangeGetBufferSize_32f_AC4RNative(NppiSize var0, int[] var1, int[] var2);

    public static int nppiHistogramRange_32f_AC4R(TypedPointer<Npp32f> pSrc, int nSrcStep, NppiSize oSizeROI, TypedPointer<Npp32s>[] pHist, TypedPointer<Npp32f>[] pLevels, int[] nLevels, TypedPointer<Npp8u> pBuffer) {
        return JNppi.checkResult(JNppi.nppiHistogramRange_32f_AC4RNative(pSrc, nSrcStep, oSizeROI, pHist, pLevels, nLevels, pBuffer));
    }

    private static native int nppiHistogramRange_32f_AC4RNative(TypedPointer<Npp32f> var0, int var1, NppiSize var2, TypedPointer<Npp32s>[] var3, TypedPointer<Npp32f>[] var4, int[] var5, TypedPointer<Npp8u> var6);

    public static int nppiFilterColumn_8u_C1R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oROI, TypedPointer<Npp32s> pKernel, int nMaskSize, int nAnchor, int nDivisor) {
        return JNppi.checkResult(JNppi.nppiFilterColumn_8u_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oROI, pKernel, nMaskSize, nAnchor, nDivisor));
    }

    private static native int nppiFilterColumn_8u_C1RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, TypedPointer<Npp32s> var5, int var6, int var7, int var8);

    public static int nppiFilterColumn_8u_C4R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oROI, TypedPointer<Npp32s> pKernel, int nMaskSize, int nAnchor, int nDivisor) {
        return JNppi.checkResult(JNppi.nppiFilterColumn_8u_C4RNative(pSrc, nSrcStep, pDst, nDstStep, oROI, pKernel, nMaskSize, nAnchor, nDivisor));
    }

    private static native int nppiFilterColumn_8u_C4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, TypedPointer<Npp32s> var5, int var6, int var7, int var8);

    public static int nppiFilterRow_8u_C1R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oROI, TypedPointer<Npp32s> pKernel, int nMaskSize, int nAnchor, int nDivisor) {
        return JNppi.checkResult(JNppi.nppiFilterRow_8u_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oROI, pKernel, nMaskSize, nAnchor, nDivisor));
    }

    private static native int nppiFilterRow_8u_C1RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, TypedPointer<Npp32s> var5, int var6, int var7, int var8);

    public static int nppiFilterRow_8u_C4R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oROI, TypedPointer<Npp32s> pKernel, int nMaskSize, int nAnchor, int nDivisor) {
        return JNppi.checkResult(JNppi.nppiFilterRow_8u_C4RNative(pSrc, nSrcStep, pDst, nDstStep, oROI, pKernel, nMaskSize, nAnchor, nDivisor));
    }

    private static native int nppiFilterRow_8u_C4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, TypedPointer<Npp32s> var5, int var6, int var7, int var8);

    public static int nppiSumWindowColumn_8u32f_C1R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oROI, int nMaskSize, int nAnchor) {
        return JNppi.checkResult(JNppi.nppiSumWindowColumn_8u32f_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oROI, nMaskSize, nAnchor));
    }

    private static native int nppiSumWindowColumn_8u32f_C1RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4, int var5, int var6);

    public static int nppiSumWindowRow_8u32f_C1R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oROI, int nMaskSize, int nAnchor) {
        return JNppi.checkResult(JNppi.nppiSumWindowRow_8u32f_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oROI, nMaskSize, nAnchor));
    }

    private static native int nppiSumWindowRow_8u32f_C1RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4, int var5, int var6);

    public static int nppiFilter_8u_C1R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, TypedPointer<Npp32s> pKernel, NppiSize oKernelSize, NppiPoint oAnchor, int nDivisor) {
        return JNppi.checkResult(JNppi.nppiFilter_8u_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, pKernel, oKernelSize, oAnchor, nDivisor));
    }

    private static native int nppiFilter_8u_C1RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, TypedPointer<Npp32s> var5, NppiSize var6, NppiPoint var7, int var8);

    public static int nppiFilter_8u_C4R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, TypedPointer<Npp32s> pKernel, NppiSize oKernelSize, NppiPoint oAnchor, int nDivisor) {
        return JNppi.checkResult(JNppi.nppiFilter_8u_C4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, pKernel, oKernelSize, oAnchor, nDivisor));
    }

    private static native int nppiFilter_8u_C4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, TypedPointer<Npp32s> var5, NppiSize var6, NppiPoint var7, int var8);

    public static int nppiFilterBox_8u_C1R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, NppiSize oMaskSize, NppiPoint oAnchor) {
        return JNppi.checkResult(JNppi.nppiFilterBox_8u_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, oMaskSize, oAnchor));
    }

    private static native int nppiFilterBox_8u_C1RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, NppiSize var5, NppiPoint var6);

    public static int nppiFilterBox_8u_C4R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, NppiSize oMaskSize, NppiPoint oAnchor) {
        return JNppi.checkResult(JNppi.nppiFilterBox_8u_C4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, oMaskSize, oAnchor));
    }

    private static native int nppiFilterBox_8u_C4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, NppiSize var5, NppiPoint var6);

    public static int nppiFilterMax_8u_C1R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, NppiSize oMaskSize, NppiPoint oAnchor) {
        return JNppi.checkResult(JNppi.nppiFilterMax_8u_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, oMaskSize, oAnchor));
    }

    private static native int nppiFilterMax_8u_C1RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, NppiSize var5, NppiPoint var6);

    public static int nppiFilterMax_8u_C4R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, NppiSize oMaskSize, NppiPoint oAnchor) {
        return JNppi.checkResult(JNppi.nppiFilterMax_8u_C4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, oMaskSize, oAnchor));
    }

    private static native int nppiFilterMax_8u_C4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, NppiSize var5, NppiPoint var6);

    public static int nppiFilterMin_8u_C1R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, NppiSize oMaskSize, NppiPoint oAnchor) {
        return JNppi.checkResult(JNppi.nppiFilterMin_8u_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, oMaskSize, oAnchor));
    }

    private static native int nppiFilterMin_8u_C1RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, NppiSize var5, NppiPoint var6);

    public static int nppiFilterMin_8u_C4R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, NppiSize oMaskSize, NppiPoint oAnchor) {
        return JNppi.checkResult(JNppi.nppiFilterMin_8u_C4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, oMaskSize, oAnchor));
    }

    private static native int nppiFilterMin_8u_C4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, NppiSize var5, NppiPoint var6);

    public static int nppiDilate_8u_C1R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, TypedPointer<Npp8u> pMask, NppiSize oMaskSize, NppiPoint oAnchor) {
        return JNppi.checkResult(JNppi.nppiDilate_8u_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, pMask, oMaskSize, oAnchor));
    }

    private static native int nppiDilate_8u_C1RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, TypedPointer<Npp8u> var5, NppiSize var6, NppiPoint var7);

    public static int nppiDilate_8u_C4R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, TypedPointer<Npp8u> pMask, NppiSize oMaskSize, NppiPoint oAnchor) {
        return JNppi.checkResult(JNppi.nppiDilate_8u_C4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, pMask, oMaskSize, oAnchor));
    }

    private static native int nppiDilate_8u_C4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, TypedPointer<Npp8u> var5, NppiSize var6, NppiPoint var7);

    public static int nppiErode_8u_C1R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, TypedPointer<Npp8u> pMask, NppiSize oMaskSize, NppiPoint oAnchor) {
        return JNppi.checkResult(JNppi.nppiErode_8u_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, pMask, oMaskSize, oAnchor));
    }

    private static native int nppiErode_8u_C1RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, TypedPointer<Npp8u> var5, NppiSize var6, NppiPoint var7);

    public static int nppiErode_8u_C4R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, TypedPointer<Npp8u> pMask, NppiSize oMaskSize, NppiPoint oAnchor) {
        return JNppi.checkResult(JNppi.nppiErode_8u_C4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, pMask, oMaskSize, oAnchor));
    }

    private static native int nppiErode_8u_C4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, TypedPointer<Npp8u> var5, NppiSize var6, NppiPoint var7);

    public static int nppiMagnitude_32fc32f_C1R(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMagnitude_32fc32f_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiMagnitude_32fc32f_C1RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiMagnitudeSqr_32fc32f_C1R(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiMagnitudeSqr_32fc32f_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiMagnitudeSqr_32fc32f_C1RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4);

    public static int nppiQuantFwdRawTableInit_JPEG_8u(TypedPointer<Npp8u> hpQuantRawTable, int nQualityFactor) {
        return JNppi.checkResult(JNppi.nppiQuantFwdRawTableInit_JPEG_8uNative(hpQuantRawTable, nQualityFactor));
    }

    private static native int nppiQuantFwdRawTableInit_JPEG_8uNative(TypedPointer<Npp8u> var0, int var1);

    public static int nppiQuantFwdTableInit_JPEG_8u16u(TypedPointer<Npp8u> hpQuantRawTable, TypedPointer<Npp16u> hpQuantFwdRawTable) {
        return JNppi.checkResult(JNppi.nppiQuantFwdTableInit_JPEG_8u16uNative(hpQuantRawTable, hpQuantFwdRawTable));
    }

    private static native int nppiQuantFwdTableInit_JPEG_8u16uNative(TypedPointer<Npp8u> var0, TypedPointer<Npp16u> var1);

    public static int nppiQuantInvTableInit_JPEG_8u16u(TypedPointer<Npp8u> hpQuantRawTable, TypedPointer<Npp16u> hpQuantFwdRawTable) {
        return JNppi.checkResult(JNppi.nppiQuantInvTableInit_JPEG_8u16uNative(hpQuantRawTable, hpQuantFwdRawTable));
    }

    private static native int nppiQuantInvTableInit_JPEG_8u16uNative(TypedPointer<Npp8u> var0, TypedPointer<Npp16u> var1);

    public static int nppiDCTQuantFwd8x8LS_JPEG_8u16s_C1R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp16s> pDst, int nDstStep, TypedPointer<Npp16u> pQuantFwdTable, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiDCTQuantFwd8x8LS_JPEG_8u16s_C1RNative(pSrc, nSrcStep, pDst, nDstStep, pQuantFwdTable, oSizeROI));
    }

    private static native int nppiDCTQuantFwd8x8LS_JPEG_8u16s_C1RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp16s> var2, int var3, TypedPointer<Npp16u> var4, NppiSize var5);

    public static int nppiDCTQuantInv8x8LS_JPEG_16s8u_C1R(TypedPointer<Npp16s> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, TypedPointer<Npp16u> pQuantInvTable, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiDCTQuantInv8x8LS_JPEG_16s8u_C1RNative(pSrc, nSrcStep, pDst, nDstStep, pQuantInvTable, oSizeROI));
    }

    private static native int nppiDCTQuantInv8x8LS_JPEG_16s8u_C1RNative(TypedPointer<Npp16s> var0, int var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp16u> var4, NppiSize var5);

    public static int nppiResize_8u_C1R(TypedPointer<Npp8u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect oSrcROI, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize dstROISize, double xFactor, double yFactor, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiResize_8u_C1RNative(pSrc, oSrcSize, nSrcStep, oSrcROI, pDst, nDstStep, dstROISize, xFactor, yFactor, eInterpolation));
    }

    private static native int nppiResize_8u_C1RNative(TypedPointer<Npp8u> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6, double var7, double var9, int var11);

    public static int nppiResize_8u_C4R(TypedPointer<Npp8u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect oSrcROI, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize dstROISize, double xFactor, double yFactor, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiResize_8u_C4RNative(pSrc, oSrcSize, nSrcStep, oSrcROI, pDst, nDstStep, dstROISize, xFactor, yFactor, eInterpolation));
    }

    private static native int nppiResize_8u_C4RNative(TypedPointer<Npp8u> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6, double var7, double var9, int var11);

    public static int nppiGetRotateQuad(NppiRect oSrcROI, double[][] aQuad, double nAngle, double nShiftX, double nShiftY) {
        return JNppi.checkResult(JNppi.nppiGetRotateQuadNative(oSrcROI, aQuad, nAngle, nShiftX, nShiftY));
    }

    private static native int nppiGetRotateQuadNative(NppiRect var0, double[][] var1, double var2, double var4, double var6);

    public static int nppiGetRotateBound(NppiRect oSrcROI, double[][] aBoundingBox, double nAngle, double nShiftX, double nShiftY) {
        return JNppi.checkResult(JNppi.nppiGetRotateBoundNative(oSrcROI, aBoundingBox, nAngle, nShiftX, nShiftY));
    }

    private static native int nppiGetRotateBoundNative(NppiRect var0, double[][] var1, double var2, double var4, double var6);

    public static int nppiRotate_8u_C1R(TypedPointer<Npp8u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect oSrcROI, TypedPointer<Npp8u> pDst, int nDstStep, NppiRect oDstROI, double nAngle, double nShiftX, double nShiftY, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiRotate_8u_C1RNative(pSrc, oSrcSize, nSrcStep, oSrcROI, pDst, nDstStep, oDstROI, nAngle, nShiftX, nShiftY, eInterpolation));
    }

    private static native int nppiRotate_8u_C1RNative(TypedPointer<Npp8u> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp8u> var4, int var5, NppiRect var6, double var7, double var9, double var11, int var13);

    public static int nppiRotate_8u_C3R(TypedPointer<Npp8u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect oSrcROI, TypedPointer<Npp8u> pDst, int nDstStep, NppiRect oDstROI, double nAngle, double nShiftX, double nShiftY, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiRotate_8u_C3RNative(pSrc, oSrcSize, nSrcStep, oSrcROI, pDst, nDstStep, oDstROI, nAngle, nShiftX, nShiftY, eInterpolation));
    }

    private static native int nppiRotate_8u_C3RNative(TypedPointer<Npp8u> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp8u> var4, int var5, NppiRect var6, double var7, double var9, double var11, int var13);

    public static int nppiRotate_8u_C4R(TypedPointer<Npp8u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect oSrcROI, TypedPointer<Npp8u> pDst, int nDstStep, NppiRect oDstROI, double nAngle, double nShiftX, double nShiftY, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiRotate_8u_C4RNative(pSrc, oSrcSize, nSrcStep, oSrcROI, pDst, nDstStep, oDstROI, nAngle, nShiftX, nShiftY, eInterpolation));
    }

    private static native int nppiRotate_8u_C4RNative(TypedPointer<Npp8u> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp8u> var4, int var5, NppiRect var6, double var7, double var9, double var11, int var13);

    public static int nppiRotate_8u_AC4R(TypedPointer<Npp8u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect oSrcROI, TypedPointer<Npp8u> pDst, int nDstStep, NppiRect oDstROI, double nAngle, double nShiftX, double nShiftY, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiRotate_8u_AC4RNative(pSrc, oSrcSize, nSrcStep, oSrcROI, pDst, nDstStep, oDstROI, nAngle, nShiftX, nShiftY, eInterpolation));
    }

    private static native int nppiRotate_8u_AC4RNative(TypedPointer<Npp8u> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp8u> var4, int var5, NppiRect var6, double var7, double var9, double var11, int var13);

    public static int nppiRotate_16u_C1R(TypedPointer<Npp16u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect oSrcROI, TypedPointer<Npp16u> pDst, int nDstStep, NppiRect oDstROI, double nAngle, double nShiftX, double nShiftY, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiRotate_16u_C1RNative(pSrc, oSrcSize, nSrcStep, oSrcROI, pDst, nDstStep, oDstROI, nAngle, nShiftX, nShiftY, eInterpolation));
    }

    private static native int nppiRotate_16u_C1RNative(TypedPointer<Npp16u> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp16u> var4, int var5, NppiRect var6, double var7, double var9, double var11, int var13);

    public static int nppiRotate_16u_C3R(TypedPointer<Npp16u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect oSrcROI, TypedPointer<Npp16u> pDst, int nDstStep, NppiRect oDstROI, double nAngle, double nShiftX, double nShiftY, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiRotate_16u_C3RNative(pSrc, oSrcSize, nSrcStep, oSrcROI, pDst, nDstStep, oDstROI, nAngle, nShiftX, nShiftY, eInterpolation));
    }

    private static native int nppiRotate_16u_C3RNative(TypedPointer<Npp16u> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp16u> var4, int var5, NppiRect var6, double var7, double var9, double var11, int var13);

    public static int nppiRotate_16u_C4R(TypedPointer<Npp16u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect oSrcROI, TypedPointer<Npp16u> pDst, int nDstStep, NppiRect oDstROI, double nAngle, double nShiftX, double nShiftY, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiRotate_16u_C4RNative(pSrc, oSrcSize, nSrcStep, oSrcROI, pDst, nDstStep, oDstROI, nAngle, nShiftX, nShiftY, eInterpolation));
    }

    private static native int nppiRotate_16u_C4RNative(TypedPointer<Npp16u> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp16u> var4, int var5, NppiRect var6, double var7, double var9, double var11, int var13);

    public static int nppiRotate_16u_AC4R(TypedPointer<Npp16u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect oSrcROI, TypedPointer<Npp16u> pDst, int nDstStep, NppiRect oDstROI, double nAngle, double nShiftX, double nShiftY, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiRotate_16u_AC4RNative(pSrc, oSrcSize, nSrcStep, oSrcROI, pDst, nDstStep, oDstROI, nAngle, nShiftX, nShiftY, eInterpolation));
    }

    private static native int nppiRotate_16u_AC4RNative(TypedPointer<Npp16u> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp16u> var4, int var5, NppiRect var6, double var7, double var9, double var11, int var13);

    public static int nppiRotate_32f_C1R(TypedPointer<Npp32f> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect oSrcROI, TypedPointer<Npp32f> pDst, int nDstStep, NppiRect oDstROI, double nAngle, double nShiftX, double nShiftY, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiRotate_32f_C1RNative(pSrc, oSrcSize, nSrcStep, oSrcROI, pDst, nDstStep, oDstROI, nAngle, nShiftX, nShiftY, eInterpolation));
    }

    private static native int nppiRotate_32f_C1RNative(TypedPointer<Npp32f> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32f> var4, int var5, NppiRect var6, double var7, double var9, double var11, int var13);

    public static int nppiRotate_32f_C3R(TypedPointer<Npp32f> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect oSrcROI, TypedPointer<Npp32f> pDst, int nDstStep, NppiRect oDstROI, double nAngle, double nShiftX, double nShiftY, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiRotate_32f_C3RNative(pSrc, oSrcSize, nSrcStep, oSrcROI, pDst, nDstStep, oDstROI, nAngle, nShiftX, nShiftY, eInterpolation));
    }

    private static native int nppiRotate_32f_C3RNative(TypedPointer<Npp32f> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32f> var4, int var5, NppiRect var6, double var7, double var9, double var11, int var13);

    public static int nppiRotate_32f_C4R(TypedPointer<Npp32f> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect oSrcROI, TypedPointer<Npp32f> pDst, int nDstStep, NppiRect oDstROI, double nAngle, double nShiftX, double nShiftY, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiRotate_32f_C4RNative(pSrc, oSrcSize, nSrcStep, oSrcROI, pDst, nDstStep, oDstROI, nAngle, nShiftX, nShiftY, eInterpolation));
    }

    private static native int nppiRotate_32f_C4RNative(TypedPointer<Npp32f> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32f> var4, int var5, NppiRect var6, double var7, double var9, double var11, int var13);

    public static int nppiRotate_32f_AC4R(TypedPointer<Npp32f> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect oSrcROI, TypedPointer<Npp32f> pDst, int nDstStep, NppiRect oDstROI, double nAngle, double nShiftX, double nShiftY, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiRotate_32f_AC4RNative(pSrc, oSrcSize, nSrcStep, oSrcROI, pDst, nDstStep, oDstROI, nAngle, nShiftX, nShiftY, eInterpolation));
    }

    private static native int nppiRotate_32f_AC4RNative(TypedPointer<Npp32f> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32f> var4, int var5, NppiRect var6, double var7, double var9, double var11, int var13);

    public static int nppiMirror_8u_C1R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oROI, int flip) {
        return JNppi.checkResult(JNppi.nppiMirror_8u_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oROI, flip));
    }

    private static native int nppiMirror_8u_C1RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, int var5);

    public static int nppiMirror_8u_C3R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oROI, int flip) {
        return JNppi.checkResult(JNppi.nppiMirror_8u_C3RNative(pSrc, nSrcStep, pDst, nDstStep, oROI, flip));
    }

    private static native int nppiMirror_8u_C3RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, int var5);

    public static int nppiMirror_8u_C4R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oROI, int flip) {
        return JNppi.checkResult(JNppi.nppiMirror_8u_C4RNative(pSrc, nSrcStep, pDst, nDstStep, oROI, flip));
    }

    private static native int nppiMirror_8u_C4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, int var5);

    public static int nppiMirror_8u_AC4R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oROI, int flip) {
        return JNppi.checkResult(JNppi.nppiMirror_8u_AC4RNative(pSrc, nSrcStep, pDst, nDstStep, oROI, flip));
    }

    private static native int nppiMirror_8u_AC4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, int var5);

    public static int nppiMirror_16u_C1R(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oROI, int flip) {
        return JNppi.checkResult(JNppi.nppiMirror_16u_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oROI, flip));
    }

    private static native int nppiMirror_16u_C1RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4, int var5);

    public static int nppiMirror_16u_C3R(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oROI, int flip) {
        return JNppi.checkResult(JNppi.nppiMirror_16u_C3RNative(pSrc, nSrcStep, pDst, nDstStep, oROI, flip));
    }

    private static native int nppiMirror_16u_C3RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4, int var5);

    public static int nppiMirror_16u_C4R(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oROI, int flip) {
        return JNppi.checkResult(JNppi.nppiMirror_16u_C4RNative(pSrc, nSrcStep, pDst, nDstStep, oROI, flip));
    }

    private static native int nppiMirror_16u_C4RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4, int var5);

    public static int nppiMirror_16u_AC4R(TypedPointer<Npp16u> pSrc, int nSrcStep, TypedPointer<Npp16u> pDst, int nDstStep, NppiSize oROI, int flip) {
        return JNppi.checkResult(JNppi.nppiMirror_16u_AC4RNative(pSrc, nSrcStep, pDst, nDstStep, oROI, flip));
    }

    private static native int nppiMirror_16u_AC4RNative(TypedPointer<Npp16u> var0, int var1, TypedPointer<Npp16u> var2, int var3, NppiSize var4, int var5);

    public static int nppiMirror_32s_C1R(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oROI, int flip) {
        return JNppi.checkResult(JNppi.nppiMirror_32s_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oROI, flip));
    }

    private static native int nppiMirror_32s_C1RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4, int var5);

    public static int nppiMirror_32s_C3R(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oROI, int flip) {
        return JNppi.checkResult(JNppi.nppiMirror_32s_C3RNative(pSrc, nSrcStep, pDst, nDstStep, oROI, flip));
    }

    private static native int nppiMirror_32s_C3RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4, int var5);

    public static int nppiMirror_32s_C4R(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oROI, int flip) {
        return JNppi.checkResult(JNppi.nppiMirror_32s_C4RNative(pSrc, nSrcStep, pDst, nDstStep, oROI, flip));
    }

    private static native int nppiMirror_32s_C4RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4, int var5);

    public static int nppiMirror_32s_AC4R(TypedPointer<Npp32s> pSrc, int nSrcStep, TypedPointer<Npp32s> pDst, int nDstStep, NppiSize oROI, int flip) {
        return JNppi.checkResult(JNppi.nppiMirror_32s_AC4RNative(pSrc, nSrcStep, pDst, nDstStep, oROI, flip));
    }

    private static native int nppiMirror_32s_AC4RNative(TypedPointer<Npp32s> var0, int var1, TypedPointer<Npp32s> var2, int var3, NppiSize var4, int var5);

    public static int nppiMirror_32f_C1R(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oROI, int flip) {
        return JNppi.checkResult(JNppi.nppiMirror_32f_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oROI, flip));
    }

    private static native int nppiMirror_32f_C1RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4, int var5);

    public static int nppiMirror_32f_C3R(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oROI, int flip) {
        return JNppi.checkResult(JNppi.nppiMirror_32f_C3RNative(pSrc, nSrcStep, pDst, nDstStep, oROI, flip));
    }

    private static native int nppiMirror_32f_C3RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4, int var5);

    public static int nppiMirror_32f_C4R(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oROI, int flip) {
        return JNppi.checkResult(JNppi.nppiMirror_32f_C4RNative(pSrc, nSrcStep, pDst, nDstStep, oROI, flip));
    }

    private static native int nppiMirror_32f_C4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4, int var5);

    public static int nppiMirror_32f_AC4R(TypedPointer<Npp32f> pSrc, int nSrcStep, TypedPointer<Npp32f> pDst, int nDstStep, NppiSize oROI, int flip) {
        return JNppi.checkResult(JNppi.nppiMirror_32f_AC4RNative(pSrc, nSrcStep, pDst, nDstStep, oROI, flip));
    }

    private static native int nppiMirror_32f_AC4RNative(TypedPointer<Npp32f> var0, int var1, TypedPointer<Npp32f> var2, int var3, NppiSize var4, int var5);

    public static int nppiGetAffineTransform(NppiRect srcRoi, double[][] quad, double[][] coeffs) {
        return JNppi.checkResult(JNppi.nppiGetAffineTransformNative(srcRoi, quad, coeffs));
    }

    private static native int nppiGetAffineTransformNative(NppiRect var0, double[][] var1, double[][] var2);

    public static int nppiGetAffineQuad(NppiRect srcRoi, double[][] quad, double[][] coeffs) {
        return JNppi.checkResult(JNppi.nppiGetAffineQuadNative(srcRoi, quad, coeffs));
    }

    private static native int nppiGetAffineQuadNative(NppiRect var0, double[][] var1, double[][] var2);

    public static int nppiGetAffineBound(NppiRect srcRoi, double[][] bound, double[][] coeffs) {
        return JNppi.checkResult(JNppi.nppiGetAffineBoundNative(srcRoi, bound, coeffs));
    }

    private static native int nppiGetAffineBoundNative(NppiRect var0, double[][] var1, double[][] var2);

    public static int nppiWarpAffine_8u_C1R(TypedPointer<Npp8u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp8u> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffine_8u_C1RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffine_8u_C1RNative(TypedPointer<Npp8u> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp8u> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffine_8u_C3R(TypedPointer<Npp8u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp8u> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffine_8u_C3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffine_8u_C3RNative(TypedPointer<Npp8u> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp8u> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffine_8u_C4R(TypedPointer<Npp8u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp8u> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffine_8u_C4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffine_8u_C4RNative(TypedPointer<Npp8u> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp8u> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffine_8u_AC4R(TypedPointer<Npp8u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp8u> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffine_8u_AC4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffine_8u_AC4RNative(TypedPointer<Npp8u> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp8u> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffine_8u_P3R(TypedPointer<Npp8u>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp8u>[] pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffine_8u_P3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffine_8u_P3RNative(TypedPointer<Npp8u>[] var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp8u>[] var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffine_8u_P4R(TypedPointer<Npp8u>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp8u>[] pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffine_8u_P4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffine_8u_P4RNative(TypedPointer<Npp8u>[] var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp8u>[] var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffineBack_8u_C1R(TypedPointer<Npp8u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp8u> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineBack_8u_C1RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffineBack_8u_C1RNative(TypedPointer<Npp8u> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp8u> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffineBack_8u_C3R(TypedPointer<Npp8u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp8u> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineBack_8u_C3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffineBack_8u_C3RNative(TypedPointer<Npp8u> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp8u> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffineBack_8u_C4R(TypedPointer<Npp8u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp8u> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineBack_8u_C4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffineBack_8u_C4RNative(TypedPointer<Npp8u> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp8u> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffineBack_8u_AC4R(TypedPointer<Npp8u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp8u> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineBack_8u_AC4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffineBack_8u_AC4RNative(TypedPointer<Npp8u> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp8u> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffineBack_8u_P3R(TypedPointer<Npp8u>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp8u>[] pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineBack_8u_P3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffineBack_8u_P3RNative(TypedPointer<Npp8u>[] var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp8u>[] var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffineBack_8u_P4R(TypedPointer<Npp8u>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp8u>[] pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineBack_8u_P4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffineBack_8u_P4RNative(TypedPointer<Npp8u>[] var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp8u>[] var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffineQuad_8u_C1R(TypedPointer<Npp8u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp8u> pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineQuad_8u_C1RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpAffineQuad_8u_C1RNative(TypedPointer<Npp8u> var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp8u> var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpAffineQuad_8u_C3R(TypedPointer<Npp8u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp8u> pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineQuad_8u_C3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpAffineQuad_8u_C3RNative(TypedPointer<Npp8u> var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp8u> var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpAffineQuad_8u_C4R(TypedPointer<Npp8u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp8u> pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineQuad_8u_C4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpAffineQuad_8u_C4RNative(TypedPointer<Npp8u> var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp8u> var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpAffineQuad_8u_AC4R(TypedPointer<Npp8u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp8u> pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineQuad_8u_AC4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpAffineQuad_8u_AC4RNative(TypedPointer<Npp8u> var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp8u> var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpAffineQuad_8u_P3R(TypedPointer<Npp8u>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp8u>[] pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineQuad_8u_P3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpAffineQuad_8u_P3RNative(TypedPointer<Npp8u>[] var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp8u>[] var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpAffineQuad_8u_P4R(TypedPointer<Npp8u>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp8u>[] pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineQuad_8u_P4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpAffineQuad_8u_P4RNative(TypedPointer<Npp8u>[] var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp8u>[] var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpAffine_16u_C1R(TypedPointer<Npp16u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp16u> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffine_16u_C1RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffine_16u_C1RNative(TypedPointer<Npp16u> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp16u> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffine_16u_C3R(TypedPointer<Npp16u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp16u> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffine_16u_C3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffine_16u_C3RNative(TypedPointer<Npp16u> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp16u> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffine_16u_C4R(TypedPointer<Npp16u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp16u> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffine_16u_C4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffine_16u_C4RNative(TypedPointer<Npp16u> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp16u> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffine_16u_AC4R(TypedPointer<Npp16u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp16u> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffine_16u_AC4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffine_16u_AC4RNative(TypedPointer<Npp16u> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp16u> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffine_16u_P3R(TypedPointer<Npp16u>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp16u>[] pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffine_16u_P3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffine_16u_P3RNative(TypedPointer<Npp16u>[] var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp16u>[] var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffine_16u_P4R(TypedPointer<Npp16u>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp16u>[] pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffine_16u_P4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffine_16u_P4RNative(TypedPointer<Npp16u>[] var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp16u>[] var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffineBack_16u_C1R(TypedPointer<Npp16u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp16u> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineBack_16u_C1RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffineBack_16u_C1RNative(TypedPointer<Npp16u> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp16u> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffineBack_16u_C3R(TypedPointer<Npp16u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp16u> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineBack_16u_C3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffineBack_16u_C3RNative(TypedPointer<Npp16u> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp16u> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffineBack_16u_C4R(TypedPointer<Npp16u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp16u> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineBack_16u_C4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffineBack_16u_C4RNative(TypedPointer<Npp16u> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp16u> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffineBack_16u_AC4R(TypedPointer<Npp16u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp16u> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineBack_16u_AC4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffineBack_16u_AC4RNative(TypedPointer<Npp16u> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp16u> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffineBack_16u_P3R(TypedPointer<Npp16u>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp16u>[] pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineBack_16u_P3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffineBack_16u_P3RNative(TypedPointer<Npp16u>[] var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp16u>[] var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffineBack_16u_P4R(TypedPointer<Npp16u>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp16u>[] pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineBack_16u_P4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffineBack_16u_P4RNative(TypedPointer<Npp16u>[] var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp16u>[] var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffineQuad_16u_C1R(TypedPointer<Npp16u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp16u> pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineQuad_16u_C1RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpAffineQuad_16u_C1RNative(TypedPointer<Npp16u> var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp16u> var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpAffineQuad_16u_C3R(TypedPointer<Npp16u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp16u> pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineQuad_16u_C3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpAffineQuad_16u_C3RNative(TypedPointer<Npp16u> var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp16u> var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpAffineQuad_16u_C4R(TypedPointer<Npp16u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp16u> pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineQuad_16u_C4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpAffineQuad_16u_C4RNative(TypedPointer<Npp16u> var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp16u> var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpAffineQuad_16u_AC4R(TypedPointer<Npp16u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp16u> pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineQuad_16u_AC4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpAffineQuad_16u_AC4RNative(TypedPointer<Npp16u> var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp16u> var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpAffineQuad_16u_P3R(TypedPointer<Npp16u>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp16u>[] pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineQuad_16u_P3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpAffineQuad_16u_P3RNative(TypedPointer<Npp16u>[] var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp16u>[] var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpAffineQuad_16u_P4R(TypedPointer<Npp16u>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp16u>[] pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineQuad_16u_P4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpAffineQuad_16u_P4RNative(TypedPointer<Npp16u>[] var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp16u>[] var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpAffine_32f_C1R(TypedPointer<Npp32f> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32f> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffine_32f_C1RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffine_32f_C1RNative(TypedPointer<Npp32f> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32f> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffine_32f_C3R(TypedPointer<Npp32f> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32f> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffine_32f_C3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffine_32f_C3RNative(TypedPointer<Npp32f> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32f> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffine_32f_C4R(TypedPointer<Npp32f> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32f> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffine_32f_C4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffine_32f_C4RNative(TypedPointer<Npp32f> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32f> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffine_32f_AC4R(TypedPointer<Npp32f> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32f> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffine_32f_AC4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffine_32f_AC4RNative(TypedPointer<Npp32f> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32f> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffine_32f_P3R(TypedPointer<Npp32f>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32f>[] pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffine_32f_P3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffine_32f_P3RNative(TypedPointer<Npp32f>[] var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32f>[] var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffine_32f_P4R(TypedPointer<Npp32f>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32f>[] pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffine_32f_P4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffine_32f_P4RNative(TypedPointer<Npp32f>[] var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32f>[] var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffineBack_32f_C1R(TypedPointer<Npp32f> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32f> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineBack_32f_C1RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffineBack_32f_C1RNative(TypedPointer<Npp32f> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32f> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffineBack_32f_C3R(TypedPointer<Npp32f> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32f> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineBack_32f_C3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffineBack_32f_C3RNative(TypedPointer<Npp32f> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32f> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffineBack_32f_C4R(TypedPointer<Npp32f> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32f> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineBack_32f_C4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffineBack_32f_C4RNative(TypedPointer<Npp32f> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32f> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffineBack_32f_AC4R(TypedPointer<Npp32f> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32f> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineBack_32f_AC4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffineBack_32f_AC4RNative(TypedPointer<Npp32f> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32f> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffineBack_32f_P3R(TypedPointer<Npp32f>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32f>[] pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineBack_32f_P3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffineBack_32f_P3RNative(TypedPointer<Npp32f>[] var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32f>[] var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffineBack_32f_P4R(TypedPointer<Npp32f>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32f>[] pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineBack_32f_P4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffineBack_32f_P4RNative(TypedPointer<Npp32f>[] var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32f>[] var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffineQuad_32f_C1R(TypedPointer<Npp32f> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp32f> pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineQuad_32f_C1RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpAffineQuad_32f_C1RNative(TypedPointer<Npp32f> var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp32f> var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpAffineQuad_32f_C3R(TypedPointer<Npp32f> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp32f> pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineQuad_32f_C3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpAffineQuad_32f_C3RNative(TypedPointer<Npp32f> var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp32f> var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpAffineQuad_32f_C4R(TypedPointer<Npp32f> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp32f> pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineQuad_32f_C4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpAffineQuad_32f_C4RNative(TypedPointer<Npp32f> var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp32f> var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpAffineQuad_32f_AC4R(TypedPointer<Npp32f> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp32f> pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineQuad_32f_AC4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpAffineQuad_32f_AC4RNative(TypedPointer<Npp32f> var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp32f> var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpAffineQuad_32f_P3R(TypedPointer<Npp32f>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp32f>[] pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineQuad_32f_P3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpAffineQuad_32f_P3RNative(TypedPointer<Npp32f>[] var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp32f>[] var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpAffineQuad_32f_P4R(TypedPointer<Npp32f>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp32f>[] pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineQuad_32f_P4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpAffineQuad_32f_P4RNative(TypedPointer<Npp32f>[] var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp32f>[] var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpAffine_32s_C1R(TypedPointer<Npp32s> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32s> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffine_32s_C1RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffine_32s_C1RNative(TypedPointer<Npp32s> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32s> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffine_32s_C3R(TypedPointer<Npp32s> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32s> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int interpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffine_32s_C3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, interpolation));
    }

    private static native int nppiWarpAffine_32s_C3RNative(TypedPointer<Npp32s> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32s> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffine_32s_C4R(TypedPointer<Npp32s> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32s> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffine_32s_C4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffine_32s_C4RNative(TypedPointer<Npp32s> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32s> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffine_32s_AC4R(TypedPointer<Npp32s> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32s> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffine_32s_AC4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffine_32s_AC4RNative(TypedPointer<Npp32s> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32s> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffine_32s_P3R(TypedPointer<Npp32s>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32s>[] pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffine_32s_P3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffine_32s_P3RNative(TypedPointer<Npp32s>[] var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32s>[] var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffine_32s_P4R(TypedPointer<Npp32s>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32s>[] pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffine_32s_P4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffine_32s_P4RNative(TypedPointer<Npp32s>[] var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32s>[] var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffineBack_32s_C1R(TypedPointer<Npp32s> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32s> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineBack_32s_C1RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffineBack_32s_C1RNative(TypedPointer<Npp32s> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32s> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffineBack_32s_C3R(TypedPointer<Npp32s> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32s> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineBack_32s_C3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffineBack_32s_C3RNative(TypedPointer<Npp32s> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32s> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffineBack_32s_C4R(TypedPointer<Npp32s> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32s> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineBack_32s_C4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffineBack_32s_C4RNative(TypedPointer<Npp32s> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32s> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffineBack_32s_AC4R(TypedPointer<Npp32s> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32s> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineBack_32s_AC4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffineBack_32s_AC4RNative(TypedPointer<Npp32s> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32s> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffineBack_32s_P3R(TypedPointer<Npp32s>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32s>[] pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineBack_32s_P3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffineBack_32s_P3RNative(TypedPointer<Npp32s>[] var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32s>[] var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffineBack_32s_P4R(TypedPointer<Npp32s>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32s>[] pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineBack_32s_P4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpAffineBack_32s_P4RNative(TypedPointer<Npp32s>[] var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32s>[] var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpAffineQuad_32s_C1R(TypedPointer<Npp32s> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp32s> pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineQuad_32s_C1RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpAffineQuad_32s_C1RNative(TypedPointer<Npp32s> var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp32s> var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpAffineQuad_32s_C3R(TypedPointer<Npp32s> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp32s> pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineQuad_32s_C3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpAffineQuad_32s_C3RNative(TypedPointer<Npp32s> var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp32s> var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpAffineQuad_32s_C4R(TypedPointer<Npp32s> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp32s> pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineQuad_32s_C4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpAffineQuad_32s_C4RNative(TypedPointer<Npp32s> var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp32s> var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpAffineQuad_32s_AC4R(TypedPointer<Npp32s> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp32s> pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineQuad_32s_AC4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpAffineQuad_32s_AC4RNative(TypedPointer<Npp32s> var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp32s> var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpAffineQuad_32s_P3R(TypedPointer<Npp32s>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp32s>[] pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineQuad_32s_P3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpAffineQuad_32s_P3RNative(TypedPointer<Npp32s>[] var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp32s>[] var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpAffineQuad_32s_P4R(TypedPointer<Npp32s>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp32s>[] pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpAffineQuad_32s_P4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpAffineQuad_32s_P4RNative(TypedPointer<Npp32s>[] var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp32s>[] var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiGetPerspectiveTransform(NppiRect srcRoi, double[][] quad, double[][] coeffs) {
        return JNppi.checkResult(JNppi.nppiGetPerspectiveTransformNative(srcRoi, quad, coeffs));
    }

    private static native int nppiGetPerspectiveTransformNative(NppiRect var0, double[][] var1, double[][] var2);

    public static int nppiGetPerspectiveQuad(NppiRect srcRoi, double[][] quad, double[][] coeffs) {
        return JNppi.checkResult(JNppi.nppiGetPerspectiveQuadNative(srcRoi, quad, coeffs));
    }

    private static native int nppiGetPerspectiveQuadNative(NppiRect var0, double[][] var1, double[][] var2);

    public static int nppiGetPerspectiveBound(NppiRect srcRoi, double[][] bound, double[][] coeffs) {
        return JNppi.checkResult(JNppi.nppiGetPerspectiveBoundNative(srcRoi, bound, coeffs));
    }

    private static native int nppiGetPerspectiveBoundNative(NppiRect var0, double[][] var1, double[][] var2);

    public static int nppiWarpPerspective_8u_C1R(TypedPointer<Npp8u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp8u> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspective_8u_C1RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspective_8u_C1RNative(TypedPointer<Npp8u> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp8u> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspective_8u_C3R(TypedPointer<Npp8u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp8u> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspective_8u_C3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspective_8u_C3RNative(TypedPointer<Npp8u> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp8u> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspective_8u_C4R(TypedPointer<Npp8u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp8u> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspective_8u_C4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspective_8u_C4RNative(TypedPointer<Npp8u> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp8u> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspective_8u_AC4R(TypedPointer<Npp8u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp8u> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspective_8u_AC4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspective_8u_AC4RNative(TypedPointer<Npp8u> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp8u> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspective_8u_P3R(TypedPointer<Npp8u>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp8u>[] pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspective_8u_P3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspective_8u_P3RNative(TypedPointer<Npp8u>[] var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp8u>[] var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspective_8u_P4R(TypedPointer<Npp8u>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp8u>[] pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspective_8u_P4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspective_8u_P4RNative(TypedPointer<Npp8u>[] var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp8u>[] var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspectiveBack_8u_C1R(TypedPointer<Npp8u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp8u> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveBack_8u_C1RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspectiveBack_8u_C1RNative(TypedPointer<Npp8u> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp8u> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspectiveBack_8u_C3R(TypedPointer<Npp8u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp8u> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveBack_8u_C3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspectiveBack_8u_C3RNative(TypedPointer<Npp8u> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp8u> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspectiveBack_8u_C4R(TypedPointer<Npp8u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp8u> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveBack_8u_C4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspectiveBack_8u_C4RNative(TypedPointer<Npp8u> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp8u> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspectiveBack_8u_AC4R(TypedPointer<Npp8u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp8u> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveBack_8u_AC4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspectiveBack_8u_AC4RNative(TypedPointer<Npp8u> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp8u> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspectiveBack_8u_P3R(TypedPointer<Npp8u>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp8u>[] pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveBack_8u_P3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspectiveBack_8u_P3RNative(TypedPointer<Npp8u>[] var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp8u>[] var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspectiveBack_8u_P4R(TypedPointer<Npp8u>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp8u>[] pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveBack_8u_P4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspectiveBack_8u_P4RNative(TypedPointer<Npp8u>[] var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp8u>[] var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspectiveQuad_8u_C1R(TypedPointer<Npp8u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp8u> pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveQuad_8u_C1RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpPerspectiveQuad_8u_C1RNative(TypedPointer<Npp8u> var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp8u> var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpPerspectiveQuad_8u_C3R(TypedPointer<Npp8u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp8u> pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveQuad_8u_C3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpPerspectiveQuad_8u_C3RNative(TypedPointer<Npp8u> var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp8u> var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpPerspectiveQuad_8u_C4R(TypedPointer<Npp8u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp8u> pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveQuad_8u_C4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpPerspectiveQuad_8u_C4RNative(TypedPointer<Npp8u> var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp8u> var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpPerspectiveQuad_8u_AC4R(TypedPointer<Npp8u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp8u> pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveQuad_8u_AC4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpPerspectiveQuad_8u_AC4RNative(TypedPointer<Npp8u> var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp8u> var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpPerspectiveQuad_8u_P3R(TypedPointer<Npp8u>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp8u>[] pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveQuad_8u_P3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpPerspectiveQuad_8u_P3RNative(TypedPointer<Npp8u>[] var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp8u>[] var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpPerspectiveQuad_8u_P4R(TypedPointer<Npp8u>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp8u>[] pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveQuad_8u_P4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpPerspectiveQuad_8u_P4RNative(TypedPointer<Npp8u>[] var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp8u>[] var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpPerspective_16u_C1R(TypedPointer<Npp16u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp16u> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspective_16u_C1RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspective_16u_C1RNative(TypedPointer<Npp16u> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp16u> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspective_16u_C3R(TypedPointer<Npp16u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp16u> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspective_16u_C3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspective_16u_C3RNative(TypedPointer<Npp16u> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp16u> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspective_16u_C4R(TypedPointer<Npp16u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp16u> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspective_16u_C4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspective_16u_C4RNative(TypedPointer<Npp16u> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp16u> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspective_16u_AC4R(TypedPointer<Npp16u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp16u> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspective_16u_AC4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspective_16u_AC4RNative(TypedPointer<Npp16u> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp16u> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspective_16u_P3R(TypedPointer<Npp16u>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp16u>[] pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspective_16u_P3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspective_16u_P3RNative(TypedPointer<Npp16u>[] var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp16u>[] var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspective_16u_P4R(TypedPointer<Npp16u>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp16u>[] pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspective_16u_P4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspective_16u_P4RNative(TypedPointer<Npp16u>[] var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp16u>[] var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspectiveBack_16u_C1R(TypedPointer<Npp16u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp16u> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveBack_16u_C1RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspectiveBack_16u_C1RNative(TypedPointer<Npp16u> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp16u> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspectiveBack_16u_C3R(TypedPointer<Npp16u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp16u> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveBack_16u_C3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspectiveBack_16u_C3RNative(TypedPointer<Npp16u> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp16u> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspectiveBack_16u_C4R(TypedPointer<Npp16u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp16u> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveBack_16u_C4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspectiveBack_16u_C4RNative(TypedPointer<Npp16u> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp16u> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspectiveBack_16u_AC4R(TypedPointer<Npp16u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp16u> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveBack_16u_AC4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspectiveBack_16u_AC4RNative(TypedPointer<Npp16u> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp16u> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspectiveBack_16u_P3R(TypedPointer<Npp16u>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp16u>[] pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveBack_16u_P3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspectiveBack_16u_P3RNative(TypedPointer<Npp16u>[] var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp16u>[] var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspectiveBack_16u_P4R(TypedPointer<Npp16u>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp16u>[] pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveBack_16u_P4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspectiveBack_16u_P4RNative(TypedPointer<Npp16u>[] var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp16u>[] var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspectiveQuad_16u_C1R(TypedPointer<Npp16u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp16u> pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveQuad_16u_C1RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpPerspectiveQuad_16u_C1RNative(TypedPointer<Npp16u> var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp16u> var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpPerspectiveQuad_16u_C3R(TypedPointer<Npp16u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp16u> pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveQuad_16u_C3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpPerspectiveQuad_16u_C3RNative(TypedPointer<Npp16u> var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp16u> var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpPerspectiveQuad_16u_C4R(TypedPointer<Npp16u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp16u> pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveQuad_16u_C4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpPerspectiveQuad_16u_C4RNative(TypedPointer<Npp16u> var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp16u> var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpPerspectiveQuad_16u_AC4R(TypedPointer<Npp16u> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp16u> pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveQuad_16u_AC4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpPerspectiveQuad_16u_AC4RNative(TypedPointer<Npp16u> var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp16u> var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpPerspectiveQuad_16u_P3R(TypedPointer<Npp16u>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp16u>[] pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveQuad_16u_P3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpPerspectiveQuad_16u_P3RNative(TypedPointer<Npp16u>[] var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp16u>[] var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpPerspectiveQuad_16u_P4R(TypedPointer<Npp16u>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp16u>[] pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveQuad_16u_P4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpPerspectiveQuad_16u_P4RNative(TypedPointer<Npp16u>[] var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp16u>[] var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpPerspective_32f_C1R(TypedPointer<Npp32f> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32f> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspective_32f_C1RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspective_32f_C1RNative(TypedPointer<Npp32f> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32f> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspective_32f_C3R(TypedPointer<Npp32f> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32f> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspective_32f_C3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspective_32f_C3RNative(TypedPointer<Npp32f> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32f> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspective_32f_C4R(TypedPointer<Npp32f> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32f> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspective_32f_C4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspective_32f_C4RNative(TypedPointer<Npp32f> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32f> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspective_32f_AC4R(TypedPointer<Npp32f> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32f> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspective_32f_AC4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspective_32f_AC4RNative(TypedPointer<Npp32f> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32f> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspective_32f_P3R(TypedPointer<Npp32f>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32f>[] pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspective_32f_P3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspective_32f_P3RNative(TypedPointer<Npp32f>[] var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32f>[] var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspective_32f_P4R(TypedPointer<Npp32f>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32f>[] pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspective_32f_P4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspective_32f_P4RNative(TypedPointer<Npp32f>[] var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32f>[] var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspectiveBack_32f_C1R(TypedPointer<Npp32f> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32f> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveBack_32f_C1RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspectiveBack_32f_C1RNative(TypedPointer<Npp32f> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32f> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspectiveBack_32f_C3R(TypedPointer<Npp32f> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32f> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveBack_32f_C3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspectiveBack_32f_C3RNative(TypedPointer<Npp32f> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32f> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspectiveBack_32f_C4R(TypedPointer<Npp32f> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32f> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveBack_32f_C4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspectiveBack_32f_C4RNative(TypedPointer<Npp32f> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32f> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspectiveBack_32f_AC4R(TypedPointer<Npp32f> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32f> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveBack_32f_AC4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspectiveBack_32f_AC4RNative(TypedPointer<Npp32f> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32f> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspectiveBack_32f_P3R(TypedPointer<Npp32f>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32f>[] pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveBack_32f_P3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspectiveBack_32f_P3RNative(TypedPointer<Npp32f>[] var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32f>[] var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspectiveBack_32f_P4R(TypedPointer<Npp32f>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32f>[] pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveBack_32f_P4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspectiveBack_32f_P4RNative(TypedPointer<Npp32f>[] var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32f>[] var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspectiveQuad_32f_C1R(TypedPointer<Npp32f> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp32f> pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveQuad_32f_C1RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpPerspectiveQuad_32f_C1RNative(TypedPointer<Npp32f> var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp32f> var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpPerspectiveQuad_32f_C3R(TypedPointer<Npp32f> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp32f> pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveQuad_32f_C3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpPerspectiveQuad_32f_C3RNative(TypedPointer<Npp32f> var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp32f> var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpPerspectiveQuad_32f_C4R(TypedPointer<Npp32f> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp32f> pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveQuad_32f_C4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpPerspectiveQuad_32f_C4RNative(TypedPointer<Npp32f> var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp32f> var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpPerspectiveQuad_32f_AC4R(TypedPointer<Npp32f> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp32f> pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveQuad_32f_AC4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpPerspectiveQuad_32f_AC4RNative(TypedPointer<Npp32f> var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp32f> var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpPerspectiveQuad_32f_P3R(TypedPointer<Npp32f>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp32f>[] pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveQuad_32f_P3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpPerspectiveQuad_32f_P3RNative(TypedPointer<Npp32f>[] var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp32f>[] var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpPerspectiveQuad_32f_P4R(TypedPointer<Npp32f>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp32f>[] pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveQuad_32f_P4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpPerspectiveQuad_32f_P4RNative(TypedPointer<Npp32f>[] var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp32f>[] var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpPerspective_32s_C1R(TypedPointer<Npp32s> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32s> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspective_32s_C1RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspective_32s_C1RNative(TypedPointer<Npp32s> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32s> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspective_32s_C3R(TypedPointer<Npp32s> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32s> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspective_32s_C3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspective_32s_C3RNative(TypedPointer<Npp32s> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32s> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspective_32s_C4R(TypedPointer<Npp32s> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32s> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspective_32s_C4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspective_32s_C4RNative(TypedPointer<Npp32s> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32s> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspective_32s_AC4R(TypedPointer<Npp32s> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32s> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspective_32s_AC4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspective_32s_AC4RNative(TypedPointer<Npp32s> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32s> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspective_32s_P3R(TypedPointer<Npp32s>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32s>[] pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspective_32s_P3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspective_32s_P3RNative(TypedPointer<Npp32s>[] var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32s>[] var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspective_32s_P4R(TypedPointer<Npp32s>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32s>[] pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspective_32s_P4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspective_32s_P4RNative(TypedPointer<Npp32s>[] var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32s>[] var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspectiveBack_32s_C1R(TypedPointer<Npp32s> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32s> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveBack_32s_C1RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspectiveBack_32s_C1RNative(TypedPointer<Npp32s> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32s> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspectiveBack_32s_C3R(TypedPointer<Npp32s> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32s> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveBack_32s_C3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspectiveBack_32s_C3RNative(TypedPointer<Npp32s> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32s> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspectiveBack_32s_C4R(TypedPointer<Npp32s> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32s> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveBack_32s_C4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspectiveBack_32s_C4RNative(TypedPointer<Npp32s> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32s> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspectiveBack_32s_AC4R(TypedPointer<Npp32s> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32s> pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveBack_32s_AC4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspectiveBack_32s_AC4RNative(TypedPointer<Npp32s> var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32s> var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspectiveBack_32s_P3R(TypedPointer<Npp32s>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32s>[] pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveBack_32s_P3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspectiveBack_32s_P3RNative(TypedPointer<Npp32s>[] var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32s>[] var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspectiveBack_32s_P4R(TypedPointer<Npp32s>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, TypedPointer<Npp32s>[] pDst, int nDstStep, NppiRect dstRoi, double[][] coeffs, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveBack_32s_P4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, pDst, nDstStep, dstRoi, coeffs, eInterpolation));
    }

    private static native int nppiWarpPerspectiveBack_32s_P4RNative(TypedPointer<Npp32s>[] var0, NppiSize var1, int var2, NppiRect var3, TypedPointer<Npp32s>[] var4, int var5, NppiRect var6, double[][] var7, int var8);

    public static int nppiWarpPerspectiveQuad_32s_C1R(TypedPointer<Npp32s> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp32s> pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveQuad_32s_C1RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpPerspectiveQuad_32s_C1RNative(TypedPointer<Npp32s> var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp32s> var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpPerspectiveQuad_32s_C3R(TypedPointer<Npp32s> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp32s> pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveQuad_32s_C3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpPerspectiveQuad_32s_C3RNative(TypedPointer<Npp32s> var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp32s> var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpPerspectiveQuad_32s_C4R(TypedPointer<Npp32s> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp32s> pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveQuad_32s_C4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpPerspectiveQuad_32s_C4RNative(TypedPointer<Npp32s> var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp32s> var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpPerspectiveQuad_32s_AC4R(TypedPointer<Npp32s> pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp32s> pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveQuad_32s_AC4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpPerspectiveQuad_32s_AC4RNative(TypedPointer<Npp32s> var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp32s> var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpPerspectiveQuad_32s_P3R(TypedPointer<Npp32s>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp32s>[] pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveQuad_32s_P3RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpPerspectiveQuad_32s_P3RNative(TypedPointer<Npp32s>[] var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp32s>[] var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiWarpPerspectiveQuad_32s_P4R(TypedPointer<Npp32s>[] pSrc, NppiSize oSrcSize, int nSrcStep, NppiRect srcRoi, double[][] srcQuad, TypedPointer<Npp32s>[] pDst, int nDstStep, NppiRect dstRoi, double[][] dstQuad, int eInterpolation) {
        return JNppi.checkResult(JNppi.nppiWarpPerspectiveQuad_32s_P4RNative(pSrc, oSrcSize, nSrcStep, srcRoi, srcQuad, pDst, nDstStep, dstRoi, dstQuad, eInterpolation));
    }

    private static native int nppiWarpPerspectiveQuad_32s_P4RNative(TypedPointer<Npp32s>[] var0, NppiSize var1, int var2, NppiRect var3, double[][] var4, TypedPointer<Npp32s>[] var5, int var6, NppiRect var7, double[][] var8, int var9);

    public static int nppiRGBToYCbCr_8u_C3R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRGBToYCbCr_8u_C3RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiRGBToYCbCr_8u_C3RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiRGBToYCbCr422_8u_C3C2R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRGBToYCbCr422_8u_C3C2RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiRGBToYCbCr422_8u_C3C2RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiRGBToYCbCr420_8u_C3P3R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u>[] pDst, int[] nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRGBToYCbCr420_8u_C3P3RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiRGBToYCbCr420_8u_C3P3RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u>[] var2, int[] var3, NppiSize var4);

    public static int nppiRGBToYCbCr_8u_P3R(TypedPointer<Npp8u>[] pSrc, int nSrcStep, TypedPointer<Npp8u>[] pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRGBToYCbCr_8u_P3RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiRGBToYCbCr_8u_P3RNative(TypedPointer<Npp8u>[] var0, int var1, TypedPointer<Npp8u>[] var2, int var3, NppiSize var4);

    public static int nppiRGBToYCbCr_8u_AC4R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiRGBToYCbCr_8u_AC4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiRGBToYCbCr_8u_AC4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiYCbCrToRGB_8u_C3R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiYCbCrToRGB_8u_C3RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiYCbCrToRGB_8u_C3RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiYCbCrToRGB_8u_P3R(TypedPointer<Npp8u>[] pSrc, int nSrcStep, TypedPointer<Npp8u>[] pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiYCbCrToRGB_8u_P3RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiYCbCrToRGB_8u_P3RNative(TypedPointer<Npp8u>[] var0, int var1, TypedPointer<Npp8u>[] var2, int var3, NppiSize var4);

    public static int nppiYCbCrToRGB_8u_AC4R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiYCbCrToRGB_8u_AC4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiYCbCrToRGB_8u_AC4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiYCbCr422ToRGB_8u_C2C3R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiYCbCr422ToRGB_8u_C2C3RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiYCbCr422ToRGB_8u_C2C3RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiYCbCr420ToRGB_8u_P3C3R(TypedPointer<Npp8u>[] pSrc, int[] nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiYCbCr420ToRGB_8u_P3C3RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiYCbCr420ToRGB_8u_P3C3RNative(TypedPointer<Npp8u>[] var0, int[] var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4);

    public static int nppiYCbCr422ToYCbCr420_8u_P3R(TypedPointer<Npp8u>[] pSrc, int[] nSrcStep, TypedPointer<Npp8u>[] pDst, int[] nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiYCbCr422ToYCbCr420_8u_P3RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiYCbCr422ToYCbCr420_8u_P3RNative(TypedPointer<Npp8u>[] var0, int[] var1, TypedPointer<Npp8u>[] var2, int[] var3, NppiSize var4);

    public static int nppiYCbCr422ToYCbCr411_8u_P3R(TypedPointer<Npp8u>[] pSrc, int[] nSrcStep, TypedPointer<Npp8u>[] pDst, int[] nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiYCbCr422ToYCbCr411_8u_P3RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiYCbCr422ToYCbCr411_8u_P3RNative(TypedPointer<Npp8u>[] var0, int[] var1, TypedPointer<Npp8u>[] var2, int[] var3, NppiSize var4);

    public static int nppiYCbCr420ToYCbCr422_8u_P3R(TypedPointer<Npp8u>[] pSrc, int[] nSrcStep, TypedPointer<Npp8u>[] pDst, int[] nDstStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiYCbCr420ToYCbCr422_8u_P3RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI));
    }

    private static native int nppiYCbCr420ToYCbCr422_8u_P3RNative(TypedPointer<Npp8u>[] var0, int[] var1, TypedPointer<Npp8u>[] var2, int[] var3, NppiSize var4);

    public static int nppiYCbCr420ToYCbCr411_8u_P3P2R(TypedPointer<Npp8u>[] pSrc, int[] aSrcStep, TypedPointer<Npp8u> pDstY, int nDstYStep, TypedPointer<Npp8u> pDstCbCr, int nDstCbCrStep, NppiSize oSizeROI) {
        return JNppi.checkResult(JNppi.nppiYCbCr420ToYCbCr411_8u_P3P2RNative(pSrc, aSrcStep, pDstY, nDstYStep, pDstCbCr, nDstCbCrStep, oSizeROI));
    }

    private static native int nppiYCbCr420ToYCbCr411_8u_P3P2RNative(TypedPointer<Npp8u>[] var0, int[] var1, TypedPointer<Npp8u> var2, int var3, TypedPointer<Npp8u> var4, int var5, NppiSize var6);

    public static int nppiColorTwist32f_8u_C3R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, float[][] twist) {
        return JNppi.checkResult(JNppi.nppiColorTwist32f_8u_C3RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, twist));
    }

    private static native int nppiColorTwist32f_8u_C3RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, float[][] var5);

    public static int nppiColorTwist32f_8u_P3R(TypedPointer<Npp8u>[] pSrc, int nSrcStep, TypedPointer<Npp8u>[] pDst, int nDstStep, NppiSize oSizeROI, float[][] twist) {
        return JNppi.checkResult(JNppi.nppiColorTwist32f_8u_P3RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, twist));
    }

    private static native int nppiColorTwist32f_8u_P3RNative(TypedPointer<Npp8u>[] var0, int var1, TypedPointer<Npp8u>[] var2, int var3, NppiSize var4, float[][] var5);

    public static int nppiColorTwist32f_8u_AC4R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, float[][] twist) {
        return JNppi.checkResult(JNppi.nppiColorTwist32f_8u_AC4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, twist));
    }

    private static native int nppiColorTwist32f_8u_AC4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, float[][] var5);

    public static int nppiLUT_Linear_8u_C1R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, TypedPointer<Npp32s> pValues, TypedPointer<Npp32s> pLevels, int nLevels) {
        return JNppi.checkResult(JNppi.nppiLUT_Linear_8u_C1RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, pValues, pLevels, nLevels));
    }

    private static native int nppiLUT_Linear_8u_C1RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, TypedPointer<Npp32s> var5, TypedPointer<Npp32s> var6, int var7);

    public static int nppiLUT_Linear_8u_C3R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, TypedPointer<Npp32s>[] pValues, TypedPointer<Npp32s>[] pLevels, int[] nLevels) {
        return JNppi.checkResult(JNppi.nppiLUT_Linear_8u_C3RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, pValues, pLevels, nLevels));
    }

    private static native int nppiLUT_Linear_8u_C3RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, TypedPointer<Npp32s>[] var5, TypedPointer<Npp32s>[] var6, int[] var7);

    public static int nppiLUT_Linear_8u_AC4R(TypedPointer<Npp8u> pSrc, int nSrcStep, TypedPointer<Npp8u> pDst, int nDstStep, NppiSize oSizeROI, TypedPointer<Npp32s>[] pValues, TypedPointer<Npp32s>[] pLevels, int[] nLevels) {
        return JNppi.checkResult(JNppi.nppiLUT_Linear_8u_AC4RNative(pSrc, nSrcStep, pDst, nDstStep, oSizeROI, pValues, pLevels, nLevels));
    }

    private static native int nppiLUT_Linear_8u_AC4RNative(TypedPointer<Npp8u> var0, int var1, TypedPointer<Npp8u> var2, int var3, NppiSize var4, TypedPointer<Npp32s>[] var5, TypedPointer<Npp32s>[] var6, int[] var7);

    public static int nppiGraphcutGetSize(NppiSize oSize, int[] pBufSize) {
        return JNppi.checkResult(JNppi.nppiGraphcutGetSizeNative(oSize, pBufSize));
    }

    private static native int nppiGraphcutGetSizeNative(NppiSize var0, int[] var1);

    public static int nppiGraphcut8GetSize(NppiSize oSize, int[] pBufSize) {
        return JNppi.checkResult(JNppi.nppiGraphcut8GetSizeNative(oSize, pBufSize));
    }

    private static native int nppiGraphcut8GetSizeNative(NppiSize var0, int[] var1);

    public static int nppiGraphcutInitAlloc(NppiSize oSize, NppiGraphcutState[] ppState, TypedPointer<Npp8u> pDeviceMem) {
        return JNppi.checkResult(JNppi.nppiGraphcutInitAllocNative(oSize, ppState, pDeviceMem));
    }

    private static native int nppiGraphcutInitAllocNative(NppiSize var0, NppiGraphcutState[] var1, TypedPointer<Npp8u> var2);

    public static int nppiGraphcut8InitAlloc(NppiSize oSize, NppiGraphcutState[] ppState, TypedPointer<Npp8u> pDeviceMem) {
        return JNppi.checkResult(JNppi.nppiGraphcut8InitAllocNative(oSize, ppState, pDeviceMem));
    }

    private static native int nppiGraphcut8InitAllocNative(NppiSize var0, NppiGraphcutState[] var1, TypedPointer<Npp8u> var2);

    public static int nppiGraphcutFree(NppiGraphcutState pState) {
        return JNppi.checkResult(JNppi.nppiGraphcutFreeNative(pState));
    }

    private static native int nppiGraphcutFreeNative(NppiGraphcutState var0);

    public static int nppiGraphcut_32s8u(TypedPointer<Npp32s> pTerminals, TypedPointer<Npp32s> pLeftTransposed, TypedPointer<Npp32s> pRightTransposed, TypedPointer<Npp32s> pTop, TypedPointer<Npp32s> pBottom, int nStep, int nTransposedStep, NppiSize size, TypedPointer<Npp8u> pLabel, int nLabelStep, NppiGraphcutState pState) {
        return JNppi.checkResult(JNppi.nppiGraphcut_32s8uNative(pTerminals, pLeftTransposed, pRightTransposed, pTop, pBottom, nStep, nTransposedStep, size, pLabel, nLabelStep, pState));
    }

    private static native int nppiGraphcut_32s8uNative(TypedPointer<Npp32s> var0, TypedPointer<Npp32s> var1, TypedPointer<Npp32s> var2, TypedPointer<Npp32s> var3, TypedPointer<Npp32s> var4, int var5, int var6, NppiSize var7, TypedPointer<Npp8u> var8, int var9, NppiGraphcutState var10);

    public static int nppiGraphcut8_32s8u(TypedPointer<Npp32s> pTerminals, TypedPointer<Npp32s> pLeftTransposed, TypedPointer<Npp32s> pRightTransposed, TypedPointer<Npp32s> pTop, TypedPointer<Npp32s> pTopLeft, TypedPointer<Npp32s> pTopRight, TypedPointer<Npp32s> pBottom, TypedPointer<Npp32s> pBottomLeft, TypedPointer<Npp32s> pBottomRight, int nStep, int nTransposedStep, NppiSize size, TypedPointer<Npp8u> pLabel, int nLabelStep, NppiGraphcutState pState) {
        return JNppi.checkResult(JNppi.nppiGraphcut8_32s8uNative(pTerminals, pLeftTransposed, pRightTransposed, pTop, pTopLeft, pTopRight, pBottom, pBottomLeft, pBottomRight, nStep, nTransposedStep, size, pLabel, nLabelStep, pState));
    }

    private static native int nppiGraphcut8_32s8uNative(TypedPointer<Npp32s> var0, TypedPointer<Npp32s> var1, TypedPointer<Npp32s> var2, TypedPointer<Npp32s> var3, TypedPointer<Npp32s> var4, TypedPointer<Npp32s> var5, TypedPointer<Npp32s> var6, TypedPointer<Npp32s> var7, TypedPointer<Npp32s> var8, int var9, int var10, NppiSize var11, TypedPointer<Npp8u> var12, int var13, NppiGraphcutState var14);
}

