/*
 * Decompiled with CFR 0.152.
 */
package jcuda.jnpp.utilnpp;

import jcuda.jnpp.TypedPointer;
import jcuda.jnpp.types.NppType;
import jcuda.jnpp.utilnpp.AbstractImage;
import jcuda.jnpp.utilnpp.Allocator;
import jcuda.jnpp.utilnpp.Image;
import jcuda.jnpp.utilnpp.ImagePacked;

abstract class AbstractImagePacked<T extends NppType>
extends AbstractImage
implements ImagePacked<T> {
    protected TypedPointer<T> aPixels_;
    protected int nPitch_;

    protected AbstractImagePacked() {
        super(0, 0);
        this.aPixels_ = null;
        this.nPitch_ = 0;
    }

    protected AbstractImagePacked(int width, int height) {
        super(width, height);
        int[] pPitch = new int[1];
        this.aPixels_ = this.allocator().Malloc2D(width, height, pPitch);
        this.nPitch_ = pPitch[0];
    }

    protected AbstractImagePacked(Image.Size rSize) {
        this(rSize.nWidth(), rSize.nHeight());
    }

    protected AbstractImagePacked(ImagePacked<T> rImage) {
        super(rImage.size());
        this.nPitch_ = rImage.pitch();
        this.allocator().Copy2D(this.aPixels_, this.nPitch_, rImage.data(), rImage.pitch(), this.width(), this.height());
    }

    public void destroy() {
        this.allocator().Free2D(this.aPixels_);
    }

    protected abstract Allocator<T> allocator();

    @Override
    public void set(ImagePacked<T> rImage) {
        if (rImage == this) {
            return;
        }
        this.allocator().Free2D(this.aPixels_);
        this.aPixels_ = null;
        this.nPitch_ = 0;
        super.set(rImage);
        int[] pPitch = new int[1];
        this.aPixels_ = this.allocator().Malloc2D(this.width(), this.height(), pPitch);
        this.nPitch_ = pPitch[0];
        this.allocator().Copy2D(this.aPixels_, this.nPitch_, rImage.data(), rImage.pitch(), this.width(), this.height());
    }

    @Override
    public int pitch() {
        return this.nPitch_;
    }

    @Override
    public ImagePacked.Pixel[] pixels(int nx, int ny) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public TypedPointer<T> data() {
        return this.aPixels_;
    }
}

