/*
 * Decompiled with CFR 0.152.
 */
package jcuda.jnpp.utilnpp;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import jcuda.jnpp.JNppUtils;
import jcuda.jnpp.TypedPointer;
import jcuda.jnpp.types.Npp16s;
import jcuda.jnpp.types.Npp16u;
import jcuda.jnpp.types.Npp32f;
import jcuda.jnpp.types.Npp32s;
import jcuda.jnpp.types.Npp8u;
import jcuda.jnpp.types.NppType;
import jcuda.jnpp.utilnpp.Allocator;

public class ImageAllocatorsCPU {
    static Allocator<Npp8u> allocator8u1() {
        return new AllocatorCPU<Npp8u>(Npp8u.class, 1);
    }

    static Allocator<Npp8u> allocator8u2() {
        return new AllocatorCPU<Npp8u>(Npp8u.class, 2);
    }

    static Allocator<Npp8u> allocator8u3() {
        return new AllocatorCPU<Npp8u>(Npp8u.class, 3);
    }

    static Allocator<Npp8u> allocator8u4() {
        return new AllocatorCPU<Npp8u>(Npp8u.class, 4);
    }

    static Allocator<Npp16u> allocator16u1() {
        return new AllocatorCPU<Npp16u>(Npp16u.class, 1);
    }

    static Allocator<Npp16u> allocator16u3() {
        return new AllocatorCPU<Npp16u>(Npp16u.class, 3);
    }

    static Allocator<Npp16u> allocator16u4() {
        return new AllocatorCPU<Npp16u>(Npp16u.class, 4);
    }

    static Allocator<Npp16s> allocator16s1() {
        return new AllocatorCPU<Npp16s>(Npp16s.class, 1);
    }

    static Allocator<Npp16s> allocator16s3() {
        return new AllocatorCPU<Npp16s>(Npp16s.class, 3);
    }

    static Allocator<Npp16s> allocator16s4() {
        return new AllocatorCPU<Npp16s>(Npp16s.class, 4);
    }

    static Allocator<Npp32s> allocator32s1() {
        return new AllocatorCPU<Npp32s>(Npp32s.class, 1);
    }

    static Allocator<Npp32s> allocator32s3() {
        return new AllocatorCPU<Npp32s>(Npp32s.class, 3);
    }

    static Allocator<Npp32s> allocator32s4() {
        return new AllocatorCPU<Npp32s>(Npp32s.class, 4);
    }

    static Allocator<Npp32f> allocator32f1() {
        return new AllocatorCPU<Npp32f>(Npp32f.class, 1);
    }

    static Allocator<Npp32f> allocator32f3() {
        return new AllocatorCPU<Npp32f>(Npp32f.class, 3);
    }

    static Allocator<Npp32f> allocator32f4() {
        return new AllocatorCPU<Npp32f>(Npp32f.class, 4);
    }

    private static class AllocatorCPU<T extends NppType>
    implements Allocator<T> {
        private int N = 0;
        private Class<? extends NppType> typeClass;

        AllocatorCPU(Class<? extends NppType> typeClass, int channels) {
            this.typeClass = typeClass;
            this.N = channels;
        }

        @Override
        public TypedPointer<T> Malloc2D(int nWidth, int nHeight, int[] pPitch) {
            JNppUtils.NPP_ASSERT((nWidth * nHeight > 0 ? 1 : 0) != 0);
            int capacity = nWidth * this.N * nHeight * JNppUtils.sizeof(this.typeClass);
            ByteBuffer buffer = ByteBuffer.allocateDirect(capacity).order(ByteOrder.nativeOrder());
            TypedPointer pResult = TypedPointer.to((ByteBuffer)buffer);
            pPitch[0] = nWidth * JNppUtils.sizeof(this.typeClass) * this.N;
            return pResult;
        }

        @Override
        public void Free2D(TypedPointer<T> pixels) {
        }

        @Override
        public void Copy2D(TypedPointer<T> pDst, long nDstPitch, TypedPointer<T> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            long srcOffset = 0L;
            long dstOffset = 0L;
            long lineSize = nWidth * (long)this.N * (long)JNppUtils.sizeof(this.typeClass);
            ByteBuffer srcBuffer = pSrc.getByteBuffer(srcOffset, lineSize);
            ByteBuffer dstBuffer = pDst.getByteBuffer(dstOffset, lineSize);
            int iLine = 0;
            while ((long)iLine < nHeight) {
                dstBuffer.put(srcBuffer);
                srcBuffer = pSrc.getByteBuffer(srcOffset += nSrcPitch, lineSize);
                dstBuffer = pDst.getByteBuffer(dstOffset += nDstPitch, lineSize);
                ++iLine;
            }
        }

        @Override
        public void DeviceToHostCopy2D(TypedPointer<T> dst, long dstPitch, TypedPointer<T> src, long srcPitch, long width, long height) {
            throw new UnsupportedOperationException("CPU allocator can not copy from device");
        }

        @Override
        public void HostToDeviceCopy2D(TypedPointer<T> dst, long dstPitch, TypedPointer<T> src, long srcPitch, long width, long height) {
            throw new UnsupportedOperationException("CPU allocator can not copy to device");
        }
    }
}

