/*
 * Decompiled with CFR 0.152.
 */
package jcuda.jnpp.utilnpp;

import jcuda.jnpp.JNppUtils;
import jcuda.jnpp.JNppi;
import jcuda.jnpp.TypedPointer;
import jcuda.jnpp.types.Npp16s;
import jcuda.jnpp.types.Npp16u;
import jcuda.jnpp.types.Npp32f;
import jcuda.jnpp.types.Npp32s;
import jcuda.jnpp.types.Npp8u;
import jcuda.jnpp.utilnpp.Allocator;
import jcuda.runtime.JCuda;

class ImageAllocatorsNPP {
    ImageAllocatorsNPP() {
    }

    static Allocator<Npp8u> allocator8u1() {
        return new Allocator_8u_1();
    }

    static Allocator<Npp8u> allocator8u2() {
        return new Allocator_8u_2();
    }

    static Allocator<Npp8u> allocator8u3() {
        return new Allocator_8u_3();
    }

    static Allocator<Npp8u> allocator8u4() {
        return new Allocator_8u_4();
    }

    static Allocator<Npp16u> allocator16u1() {
        return new Allocator_16u_1();
    }

    static Allocator<Npp16u> allocator16u2() {
        return new Allocator_16u_2();
    }

    static Allocator<Npp16u> allocator16u3() {
        return new Allocator_16u_3();
    }

    static Allocator<Npp16u> allocator16u4() {
        return new Allocator_16u_4();
    }

    static Allocator<Npp16s> allocator16s1() {
        return new Allocator_16s_1();
    }

    static Allocator<Npp16s> allocator16s2() {
        return new Allocator_16s_2();
    }

    static Allocator<Npp16s> allocator16s4() {
        return new Allocator_16s_4();
    }

    static Allocator<Npp32s> allocator32s1() {
        return new Allocator_32s_1();
    }

    static Allocator<Npp32s> allocator32s3() {
        return new Allocator_32s_3();
    }

    static Allocator<Npp32s> allocator32s4() {
        return new Allocator_32s_4();
    }

    static Allocator<Npp32f> allocator32f1() {
        return new Allocator_32f_1();
    }

    static Allocator<Npp32f> allocator32f2() {
        return new Allocator_32f_2();
    }

    static Allocator<Npp32f> allocator32f3() {
        return new Allocator_32f_3();
    }

    static Allocator<Npp32f> allocator32f4() {
        return new Allocator_32f_4();
    }

    private static class Allocator_16s_1
    implements Allocator<Npp16s> {
        private Allocator_16s_1() {
        }

        @Override
        public TypedPointer<Npp16s> Malloc2D(int nWidth, int nHeight, int[] pPitch) {
            assert (nWidth * nHeight > 0);
            TypedPointer pResult = JNppi.nppiMalloc_16s_C1((int)nWidth, (int)nHeight, (int[])pPitch);
            JNppUtils.NPP_ASSERT((pResult != null ? 1 : 0) != 0);
            return pResult;
        }

        @Override
        public void Free2D(TypedPointer<Npp16s> pPixels) {
            JNppi.nppiFree(pPixels);
        }

        @Override
        public void Copy2D(TypedPointer<Npp16s> pDst, long nDstPitch, TypedPointer<Npp16s> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 1L * (long)JNppUtils.sizeof(Npp16s.class)), (long)nHeight, (int)3);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }

        @Override
        public void HostToDeviceCopy2D(TypedPointer<Npp16s> pDst, long nDstPitch, TypedPointer<Npp16s> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 1L * (long)JNppUtils.sizeof(Npp16s.class)), (long)nHeight, (int)1);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }

        @Override
        public void DeviceToHostCopy2D(TypedPointer<Npp16s> pDst, long nDstPitch, TypedPointer<Npp16s> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 1L * (long)JNppUtils.sizeof(Npp16s.class)), (long)nHeight, (int)2);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }
    }

    private static class Allocator_16s_2
    implements Allocator<Npp16s> {
        private Allocator_16s_2() {
        }

        @Override
        public TypedPointer<Npp16s> Malloc2D(int nWidth, int nHeight, int[] pPitch) {
            assert (nWidth * nHeight > 0);
            TypedPointer pResult = JNppi.nppiMalloc_16s_C2((int)nWidth, (int)nHeight, (int[])pPitch);
            JNppUtils.NPP_ASSERT((pResult != null ? 1 : 0) != 0);
            return pResult;
        }

        @Override
        public void Free2D(TypedPointer<Npp16s> pPixels) {
            JNppi.nppiFree(pPixels);
        }

        @Override
        public void Copy2D(TypedPointer<Npp16s> pDst, long nDstPitch, TypedPointer<Npp16s> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 2L * (long)JNppUtils.sizeof(Npp16s.class)), (long)nHeight, (int)3);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }

        @Override
        public void HostToDeviceCopy2D(TypedPointer<Npp16s> pDst, long nDstPitch, TypedPointer<Npp16s> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 2L * (long)JNppUtils.sizeof(Npp16s.class)), (long)nHeight, (int)1);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }

        @Override
        public void DeviceToHostCopy2D(TypedPointer<Npp16s> pDst, long nDstPitch, TypedPointer<Npp16s> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 2L * (long)JNppUtils.sizeof(Npp16s.class)), (long)nHeight, (int)2);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }
    }

    private static class Allocator_16s_4
    implements Allocator<Npp16s> {
        private Allocator_16s_4() {
        }

        @Override
        public TypedPointer<Npp16s> Malloc2D(int nWidth, int nHeight, int[] pPitch) {
            assert (nWidth * nHeight > 0);
            TypedPointer pResult = JNppi.nppiMalloc_16s_C4((int)nWidth, (int)nHeight, (int[])pPitch);
            JNppUtils.NPP_ASSERT((pResult != null ? 1 : 0) != 0);
            return pResult;
        }

        @Override
        public void Free2D(TypedPointer<Npp16s> pPixels) {
            JNppi.nppiFree(pPixels);
        }

        @Override
        public void Copy2D(TypedPointer<Npp16s> pDst, long nDstPitch, TypedPointer<Npp16s> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 4L * (long)JNppUtils.sizeof(Npp16s.class)), (long)nHeight, (int)3);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }

        @Override
        public void HostToDeviceCopy2D(TypedPointer<Npp16s> pDst, long nDstPitch, TypedPointer<Npp16s> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 4L * (long)JNppUtils.sizeof(Npp16s.class)), (long)nHeight, (int)1);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }

        @Override
        public void DeviceToHostCopy2D(TypedPointer<Npp16s> pDst, long nDstPitch, TypedPointer<Npp16s> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 4L * (long)JNppUtils.sizeof(Npp16s.class)), (long)nHeight, (int)2);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }
    }

    private static class Allocator_16u_1
    implements Allocator<Npp16u> {
        private Allocator_16u_1() {
        }

        @Override
        public TypedPointer<Npp16u> Malloc2D(int nWidth, int nHeight, int[] pPitch) {
            assert (nWidth * nHeight > 0);
            TypedPointer pResult = JNppi.nppiMalloc_16u_C1((int)nWidth, (int)nHeight, (int[])pPitch);
            JNppUtils.NPP_ASSERT((pResult != null ? 1 : 0) != 0);
            return pResult;
        }

        @Override
        public void Free2D(TypedPointer<Npp16u> pPixels) {
            JNppi.nppiFree(pPixels);
        }

        @Override
        public void Copy2D(TypedPointer<Npp16u> pDst, long nDstPitch, TypedPointer<Npp16u> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 1L * (long)JNppUtils.sizeof(Npp16u.class)), (long)nHeight, (int)3);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }

        @Override
        public void HostToDeviceCopy2D(TypedPointer<Npp16u> pDst, long nDstPitch, TypedPointer<Npp16u> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 1L * (long)JNppUtils.sizeof(Npp16u.class)), (long)nHeight, (int)1);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }

        @Override
        public void DeviceToHostCopy2D(TypedPointer<Npp16u> pDst, long nDstPitch, TypedPointer<Npp16u> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 1L * (long)JNppUtils.sizeof(Npp16u.class)), (long)nHeight, (int)2);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }
    }

    private static class Allocator_16u_2
    implements Allocator<Npp16u> {
        private Allocator_16u_2() {
        }

        @Override
        public TypedPointer<Npp16u> Malloc2D(int nWidth, int nHeight, int[] pPitch) {
            assert (nWidth * nHeight > 0);
            TypedPointer pResult = JNppi.nppiMalloc_16u_C2((int)nWidth, (int)nHeight, (int[])pPitch);
            JNppUtils.NPP_ASSERT((pResult != null ? 1 : 0) != 0);
            return pResult;
        }

        @Override
        public void Free2D(TypedPointer<Npp16u> pPixels) {
            JNppi.nppiFree(pPixels);
        }

        @Override
        public void Copy2D(TypedPointer<Npp16u> pDst, long nDstPitch, TypedPointer<Npp16u> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 2L * (long)JNppUtils.sizeof(Npp16u.class)), (long)nHeight, (int)3);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }

        @Override
        public void HostToDeviceCopy2D(TypedPointer<Npp16u> pDst, long nDstPitch, TypedPointer<Npp16u> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 2L * (long)JNppUtils.sizeof(Npp16u.class)), (long)nHeight, (int)1);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }

        @Override
        public void DeviceToHostCopy2D(TypedPointer<Npp16u> pDst, long nDstPitch, TypedPointer<Npp16u> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 2L * (long)JNppUtils.sizeof(Npp16u.class)), (long)nHeight, (int)2);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }
    }

    private static class Allocator_16u_3
    implements Allocator<Npp16u> {
        private Allocator_16u_3() {
        }

        @Override
        public TypedPointer<Npp16u> Malloc2D(int nWidth, int nHeight, int[] pPitch) {
            assert (nWidth * nHeight > 0);
            TypedPointer pResult = JNppi.nppiMalloc_16u_C3((int)nWidth, (int)nHeight, (int[])pPitch);
            JNppUtils.NPP_ASSERT((pResult != null ? 1 : 0) != 0);
            return pResult;
        }

        @Override
        public void Free2D(TypedPointer<Npp16u> pPixels) {
            JNppi.nppiFree(pPixels);
        }

        @Override
        public void Copy2D(TypedPointer<Npp16u> pDst, long nDstPitch, TypedPointer<Npp16u> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 3L * (long)JNppUtils.sizeof(Npp16u.class)), (long)nHeight, (int)3);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }

        @Override
        public void HostToDeviceCopy2D(TypedPointer<Npp16u> pDst, long nDstPitch, TypedPointer<Npp16u> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 3L * (long)JNppUtils.sizeof(Npp16u.class)), (long)nHeight, (int)1);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }

        @Override
        public void DeviceToHostCopy2D(TypedPointer<Npp16u> pDst, long nDstPitch, TypedPointer<Npp16u> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 3L * (long)JNppUtils.sizeof(Npp16u.class)), (long)nHeight, (int)2);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }
    }

    private static class Allocator_16u_4
    implements Allocator<Npp16u> {
        private Allocator_16u_4() {
        }

        @Override
        public TypedPointer<Npp16u> Malloc2D(int nWidth, int nHeight, int[] pPitch) {
            assert (nWidth * nHeight > 0);
            TypedPointer pResult = JNppi.nppiMalloc_16u_C4((int)nWidth, (int)nHeight, (int[])pPitch);
            JNppUtils.NPP_ASSERT((pResult != null ? 1 : 0) != 0);
            return pResult;
        }

        @Override
        public void Free2D(TypedPointer<Npp16u> pPixels) {
            JNppi.nppiFree(pPixels);
        }

        @Override
        public void Copy2D(TypedPointer<Npp16u> pDst, long nDstPitch, TypedPointer<Npp16u> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 4L * (long)JNppUtils.sizeof(Npp16u.class)), (long)nHeight, (int)3);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }

        @Override
        public void HostToDeviceCopy2D(TypedPointer<Npp16u> pDst, long nDstPitch, TypedPointer<Npp16u> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 4L * (long)JNppUtils.sizeof(Npp16u.class)), (long)nHeight, (int)1);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }

        @Override
        public void DeviceToHostCopy2D(TypedPointer<Npp16u> pDst, long nDstPitch, TypedPointer<Npp16u> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 4L * (long)JNppUtils.sizeof(Npp16u.class)), (long)nHeight, (int)2);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }
    }

    private static class Allocator_32f_1
    implements Allocator<Npp32f> {
        private Allocator_32f_1() {
        }

        @Override
        public TypedPointer<Npp32f> Malloc2D(int nWidth, int nHeight, int[] pPitch) {
            assert (nWidth * nHeight > 0);
            TypedPointer pResult = JNppi.nppiMalloc_32f_C1((int)nWidth, (int)nHeight, (int[])pPitch);
            JNppUtils.NPP_ASSERT((pResult != null ? 1 : 0) != 0);
            return pResult;
        }

        @Override
        public void Free2D(TypedPointer<Npp32f> pPixels) {
            JNppi.nppiFree(pPixels);
        }

        @Override
        public void Copy2D(TypedPointer<Npp32f> pDst, long nDstPitch, TypedPointer<Npp32f> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 1L * (long)JNppUtils.sizeof(Npp32f.class)), (long)nHeight, (int)3);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }

        @Override
        public void HostToDeviceCopy2D(TypedPointer<Npp32f> pDst, long nDstPitch, TypedPointer<Npp32f> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 1L * (long)JNppUtils.sizeof(Npp32f.class)), (long)nHeight, (int)1);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }

        @Override
        public void DeviceToHostCopy2D(TypedPointer<Npp32f> pDst, long nDstPitch, TypedPointer<Npp32f> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 1L * (long)JNppUtils.sizeof(Npp32f.class)), (long)nHeight, (int)2);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }
    }

    private static class Allocator_32f_2
    implements Allocator<Npp32f> {
        private Allocator_32f_2() {
        }

        @Override
        public TypedPointer<Npp32f> Malloc2D(int nWidth, int nHeight, int[] pPitch) {
            assert (nWidth * nHeight > 0);
            TypedPointer pResult = JNppi.nppiMalloc_32f_C2((int)nWidth, (int)nHeight, (int[])pPitch);
            JNppUtils.NPP_ASSERT((pResult != null ? 1 : 0) != 0);
            return pResult;
        }

        @Override
        public void Free2D(TypedPointer<Npp32f> pPixels) {
            JNppi.nppiFree(pPixels);
        }

        @Override
        public void Copy2D(TypedPointer<Npp32f> pDst, long nDstPitch, TypedPointer<Npp32f> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 2L * (long)JNppUtils.sizeof(Npp32f.class)), (long)nHeight, (int)3);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }

        @Override
        public void HostToDeviceCopy2D(TypedPointer<Npp32f> pDst, long nDstPitch, TypedPointer<Npp32f> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 2L * (long)JNppUtils.sizeof(Npp32f.class)), (long)nHeight, (int)1);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }

        @Override
        public void DeviceToHostCopy2D(TypedPointer<Npp32f> pDst, long nDstPitch, TypedPointer<Npp32f> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 2L * (long)JNppUtils.sizeof(Npp32f.class)), (long)nHeight, (int)2);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }
    }

    private static class Allocator_32f_3
    implements Allocator<Npp32f> {
        private Allocator_32f_3() {
        }

        @Override
        public TypedPointer<Npp32f> Malloc2D(int nWidth, int nHeight, int[] pPitch) {
            assert (nWidth * nHeight > 0);
            TypedPointer pResult = JNppi.nppiMalloc_32f_C3((int)nWidth, (int)nHeight, (int[])pPitch);
            JNppUtils.NPP_ASSERT((pResult != null ? 1 : 0) != 0);
            return pResult;
        }

        @Override
        public void Free2D(TypedPointer<Npp32f> pPixels) {
            JNppi.nppiFree(pPixels);
        }

        @Override
        public void Copy2D(TypedPointer<Npp32f> pDst, long nDstPitch, TypedPointer<Npp32f> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 3L * (long)JNppUtils.sizeof(Npp32f.class)), (long)nHeight, (int)3);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }

        @Override
        public void HostToDeviceCopy2D(TypedPointer<Npp32f> pDst, long nDstPitch, TypedPointer<Npp32f> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 3L * (long)JNppUtils.sizeof(Npp32f.class)), (long)nHeight, (int)1);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }

        @Override
        public void DeviceToHostCopy2D(TypedPointer<Npp32f> pDst, long nDstPitch, TypedPointer<Npp32f> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 3L * (long)JNppUtils.sizeof(Npp32f.class)), (long)nHeight, (int)2);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }
    }

    private static class Allocator_32f_4
    implements Allocator<Npp32f> {
        private Allocator_32f_4() {
        }

        @Override
        public TypedPointer<Npp32f> Malloc2D(int nWidth, int nHeight, int[] pPitch) {
            assert (nWidth * nHeight > 0);
            TypedPointer pResult = JNppi.nppiMalloc_32f_C4((int)nWidth, (int)nHeight, (int[])pPitch);
            JNppUtils.NPP_ASSERT((pResult != null ? 1 : 0) != 0);
            return pResult;
        }

        @Override
        public void Free2D(TypedPointer<Npp32f> pPixels) {
            JNppi.nppiFree(pPixels);
        }

        @Override
        public void Copy2D(TypedPointer<Npp32f> pDst, long nDstPitch, TypedPointer<Npp32f> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 4L * (long)JNppUtils.sizeof(Npp32f.class)), (long)nHeight, (int)3);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }

        @Override
        public void HostToDeviceCopy2D(TypedPointer<Npp32f> pDst, long nDstPitch, TypedPointer<Npp32f> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 4L * (long)JNppUtils.sizeof(Npp32f.class)), (long)nHeight, (int)1);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }

        @Override
        public void DeviceToHostCopy2D(TypedPointer<Npp32f> pDst, long nDstPitch, TypedPointer<Npp32f> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 4L * (long)JNppUtils.sizeof(Npp32f.class)), (long)nHeight, (int)2);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }
    }

    private static class Allocator_32s_1
    implements Allocator<Npp32s> {
        private Allocator_32s_1() {
        }

        @Override
        public TypedPointer<Npp32s> Malloc2D(int nWidth, int nHeight, int[] pPitch) {
            assert (nWidth * nHeight > 0);
            TypedPointer pResult = JNppi.nppiMalloc_32s_C1((int)nWidth, (int)nHeight, (int[])pPitch);
            JNppUtils.NPP_ASSERT((pResult != null ? 1 : 0) != 0);
            return pResult;
        }

        @Override
        public void Free2D(TypedPointer<Npp32s> pPixels) {
            JNppi.nppiFree(pPixels);
        }

        @Override
        public void Copy2D(TypedPointer<Npp32s> pDst, long nDstPitch, TypedPointer<Npp32s> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 1L * (long)JNppUtils.sizeof(Npp32s.class)), (long)nHeight, (int)3);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }

        @Override
        public void HostToDeviceCopy2D(TypedPointer<Npp32s> pDst, long nDstPitch, TypedPointer<Npp32s> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 1L * (long)JNppUtils.sizeof(Npp32s.class)), (long)nHeight, (int)1);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }

        @Override
        public void DeviceToHostCopy2D(TypedPointer<Npp32s> pDst, long nDstPitch, TypedPointer<Npp32s> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 1L * (long)JNppUtils.sizeof(Npp32s.class)), (long)nHeight, (int)2);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }
    }

    private static class Allocator_32s_3
    implements Allocator<Npp32s> {
        private Allocator_32s_3() {
        }

        @Override
        public TypedPointer<Npp32s> Malloc2D(int nWidth, int nHeight, int[] pPitch) {
            assert (nWidth * nHeight > 0);
            TypedPointer pResult = JNppi.nppiMalloc_32s_C3((int)nWidth, (int)nHeight, (int[])pPitch);
            JNppUtils.NPP_ASSERT((pResult != null ? 1 : 0) != 0);
            return pResult;
        }

        @Override
        public void Free2D(TypedPointer<Npp32s> pPixels) {
            JNppi.nppiFree(pPixels);
        }

        @Override
        public void Copy2D(TypedPointer<Npp32s> pDst, long nDstPitch, TypedPointer<Npp32s> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 3L * (long)JNppUtils.sizeof(Npp32s.class)), (long)nHeight, (int)3);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }

        @Override
        public void HostToDeviceCopy2D(TypedPointer<Npp32s> pDst, long nDstPitch, TypedPointer<Npp32s> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 3L * (long)JNppUtils.sizeof(Npp32s.class)), (long)nHeight, (int)1);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }

        @Override
        public void DeviceToHostCopy2D(TypedPointer<Npp32s> pDst, long nDstPitch, TypedPointer<Npp32s> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 3L * (long)JNppUtils.sizeof(Npp32s.class)), (long)nHeight, (int)2);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }
    }

    private static class Allocator_32s_4
    implements Allocator<Npp32s> {
        private Allocator_32s_4() {
        }

        @Override
        public TypedPointer<Npp32s> Malloc2D(int nWidth, int nHeight, int[] pPitch) {
            assert (nWidth * nHeight > 0);
            TypedPointer pResult = JNppi.nppiMalloc_32s_C4((int)nWidth, (int)nHeight, (int[])pPitch);
            JNppUtils.NPP_ASSERT((pResult != null ? 1 : 0) != 0);
            return pResult;
        }

        @Override
        public void Free2D(TypedPointer<Npp32s> pPixels) {
            JNppi.nppiFree(pPixels);
        }

        @Override
        public void Copy2D(TypedPointer<Npp32s> pDst, long nDstPitch, TypedPointer<Npp32s> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 4L * (long)JNppUtils.sizeof(Npp32s.class)), (long)nHeight, (int)3);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }

        @Override
        public void HostToDeviceCopy2D(TypedPointer<Npp32s> pDst, long nDstPitch, TypedPointer<Npp32s> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 4L * (long)JNppUtils.sizeof(Npp32s.class)), (long)nHeight, (int)1);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }

        @Override
        public void DeviceToHostCopy2D(TypedPointer<Npp32s> pDst, long nDstPitch, TypedPointer<Npp32s> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 4L * (long)JNppUtils.sizeof(Npp32s.class)), (long)nHeight, (int)2);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }
    }

    private static class Allocator_8u_1
    implements Allocator<Npp8u> {
        private Allocator_8u_1() {
        }

        @Override
        public TypedPointer<Npp8u> Malloc2D(int nWidth, int nHeight, int[] pPitch) {
            assert (nWidth * nHeight > 0);
            TypedPointer pResult = JNppi.nppiMalloc_8u_C1((int)nWidth, (int)nHeight, (int[])pPitch);
            JNppUtils.NPP_ASSERT((pResult != null ? 1 : 0) != 0);
            return pResult;
        }

        @Override
        public void Free2D(TypedPointer<Npp8u> pPixels) {
            JNppi.nppiFree(pPixels);
        }

        @Override
        public void Copy2D(TypedPointer<Npp8u> pDst, long nDstPitch, TypedPointer<Npp8u> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 1L * (long)JNppUtils.sizeof(Npp8u.class)), (long)nHeight, (int)3);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }

        @Override
        public void HostToDeviceCopy2D(TypedPointer<Npp8u> pDst, long nDstPitch, TypedPointer<Npp8u> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 1L * (long)JNppUtils.sizeof(Npp8u.class)), (long)nHeight, (int)1);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }

        @Override
        public void DeviceToHostCopy2D(TypedPointer<Npp8u> pDst, long nDstPitch, TypedPointer<Npp8u> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 1L * (long)JNppUtils.sizeof(Npp8u.class)), (long)nHeight, (int)2);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }
    }

    private static class Allocator_8u_2
    implements Allocator<Npp8u> {
        private Allocator_8u_2() {
        }

        @Override
        public TypedPointer<Npp8u> Malloc2D(int nWidth, int nHeight, int[] pPitch) {
            assert (nWidth * nHeight > 0);
            TypedPointer pResult = JNppi.nppiMalloc_8u_C2((int)nWidth, (int)nHeight, (int[])pPitch);
            JNppUtils.NPP_ASSERT((pResult != null ? 1 : 0) != 0);
            return pResult;
        }

        @Override
        public void Free2D(TypedPointer<Npp8u> pPixels) {
            JNppi.nppiFree(pPixels);
        }

        @Override
        public void Copy2D(TypedPointer<Npp8u> pDst, long nDstPitch, TypedPointer<Npp8u> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 2L * (long)JNppUtils.sizeof(Npp8u.class)), (long)nHeight, (int)3);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }

        @Override
        public void HostToDeviceCopy2D(TypedPointer<Npp8u> pDst, long nDstPitch, TypedPointer<Npp8u> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 2L * (long)JNppUtils.sizeof(Npp8u.class)), (long)nHeight, (int)1);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }

        @Override
        public void DeviceToHostCopy2D(TypedPointer<Npp8u> pDst, long nDstPitch, TypedPointer<Npp8u> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 2L * (long)JNppUtils.sizeof(Npp8u.class)), (long)nHeight, (int)2);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }
    }

    private static class Allocator_8u_3
    implements Allocator<Npp8u> {
        private Allocator_8u_3() {
        }

        @Override
        public TypedPointer<Npp8u> Malloc2D(int nWidth, int nHeight, int[] pPitch) {
            assert (nWidth * nHeight > 0);
            TypedPointer pResult = JNppi.nppiMalloc_8u_C3((int)nWidth, (int)nHeight, (int[])pPitch);
            JNppUtils.NPP_ASSERT((pResult != null ? 1 : 0) != 0);
            return pResult;
        }

        @Override
        public void Free2D(TypedPointer<Npp8u> pPixels) {
            JNppi.nppiFree(pPixels);
        }

        @Override
        public void Copy2D(TypedPointer<Npp8u> pDst, long nDstPitch, TypedPointer<Npp8u> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 3L * (long)JNppUtils.sizeof(Npp8u.class)), (long)nHeight, (int)3);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }

        @Override
        public void HostToDeviceCopy2D(TypedPointer<Npp8u> pDst, long nDstPitch, TypedPointer<Npp8u> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 3L * (long)JNppUtils.sizeof(Npp8u.class)), (long)nHeight, (int)1);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }

        @Override
        public void DeviceToHostCopy2D(TypedPointer<Npp8u> pDst, long nDstPitch, TypedPointer<Npp8u> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 3L * (long)JNppUtils.sizeof(Npp8u.class)), (long)nHeight, (int)2);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }
    }

    private static class Allocator_8u_4
    implements Allocator<Npp8u> {
        private Allocator_8u_4() {
        }

        @Override
        public TypedPointer<Npp8u> Malloc2D(int nWidth, int nHeight, int[] pPitch) {
            assert (nWidth * nHeight > 0);
            TypedPointer pResult = JNppi.nppiMalloc_8u_C4((int)nWidth, (int)nHeight, (int[])pPitch);
            JNppUtils.NPP_ASSERT((pResult != null ? 1 : 0) != 0);
            return pResult;
        }

        @Override
        public void Free2D(TypedPointer<Npp8u> pPixels) {
            JNppi.nppiFree(pPixels);
        }

        @Override
        public void Copy2D(TypedPointer<Npp8u> pDst, long nDstPitch, TypedPointer<Npp8u> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 4L * (long)JNppUtils.sizeof(Npp8u.class)), (long)nHeight, (int)3);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }

        @Override
        public void HostToDeviceCopy2D(TypedPointer<Npp8u> pDst, long nDstPitch, TypedPointer<Npp8u> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 4L * (long)JNppUtils.sizeof(Npp8u.class)), (long)nHeight, (int)1);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }

        @Override
        public void DeviceToHostCopy2D(TypedPointer<Npp8u> pDst, long nDstPitch, TypedPointer<Npp8u> pSrc, long nSrcPitch, long nWidth, long nHeight) {
            int eResult = JCuda.cudaMemcpy2D(pDst, (long)nDstPitch, pSrc, (long)nSrcPitch, (long)(nWidth * 4L * (long)JNppUtils.sizeof(Npp8u.class)), (long)nHeight, (int)2);
            JNppUtils.NPP_ASSERT((eResult == 0 ? 1 : 0) != 0);
        }
    }
}

