/*
 * Decompiled with CFR 0.152.
 */
package jcuda.jnpp.utilnpp;

import jcuda.jnpp.TypedPointer;
import jcuda.jnpp.types.Npp16s;
import jcuda.jnpp.types.Npp16u;
import jcuda.jnpp.types.Npp32f;
import jcuda.jnpp.types.Npp32s;
import jcuda.jnpp.types.Npp8u;
import jcuda.jnpp.types.NppType;
import jcuda.jnpp.utilnpp.AbstractImagePacked;
import jcuda.jnpp.utilnpp.Allocator;
import jcuda.jnpp.utilnpp.Image;
import jcuda.jnpp.utilnpp.ImageAllocatorsNPP;
import jcuda.jnpp.utilnpp.ImagePacked;
import jcuda.jnpp.utilnpp.ImagesCPU;

public class ImagesNPP {
    private ImagesNPP() {
    }

    public static abstract class ImageNPP<T extends NppType>
    extends AbstractImagePacked<T>
    implements ImagePacked<T> {
        protected ImageNPP() {
        }

        protected ImageNPP(int width, int height) {
            super(width, height);
        }

        protected ImageNPP(Image.Size rSize) {
            super(rSize);
        }

        protected ImageNPP(ImageNPP<T> rImage) {
            super(rImage);
        }

        protected ImageNPP(ImagesCPU.ImageCPU<T> rImage) {
            super(rImage.width(), rImage.height());
            this.allocator().HostToDeviceCopy2D(this.data(), this.pitch(), rImage.data(), rImage.pitch(), this.width(), this.height());
        }

        public void copyTo(TypedPointer<T> pData, int nPitch) {
            this.allocator().DeviceToHostCopy2D(pData, nPitch, this.data(), this.pitch(), this.width(), this.height());
        }

        public void copyFrom(TypedPointer<T> pData, int nPitch) {
            this.allocator().HostToDeviceCopy2D(this.data(), this.pitch(), pData, nPitch, this.width(), this.height());
        }
    }

    public static class ImageNPP_16s_C1
    extends ImageNPP<Npp16s> {
        private static Allocator<Npp16s> allocator = ImageAllocatorsNPP.allocator16s1();

        public ImageNPP_16s_C1() {
        }

        public ImageNPP_16s_C1(int width, int height) {
            super(width, height);
        }

        public ImageNPP_16s_C1(Image.Size rSize) {
            super(rSize);
        }

        public ImageNPP_16s_C1(ImageNPP<Npp16s> rImage) {
            super(rImage);
        }

        public ImageNPP_16s_C1(ImagesCPU.ImageCPU<Npp16s> rImage) {
            super(rImage);
        }

        @Override
        protected Allocator<Npp16s> allocator() {
            return allocator;
        }
    }

    public static class ImageNPP_16s_C4
    extends ImageNPP<Npp16s> {
        private static Allocator<Npp16s> allocator = ImageAllocatorsNPP.allocator16s4();

        public ImageNPP_16s_C4() {
        }

        public ImageNPP_16s_C4(int width, int height) {
            super(width, height);
        }

        public ImageNPP_16s_C4(Image.Size rSize) {
            super(rSize);
        }

        public ImageNPP_16s_C4(ImageNPP<Npp16s> rImage) {
            super(rImage);
        }

        public ImageNPP_16s_C4(ImagesCPU.ImageCPU<Npp16s> rImage) {
            super(rImage);
        }

        @Override
        protected Allocator<Npp16s> allocator() {
            return allocator;
        }
    }

    public static class ImageNPP_16u_C1
    extends ImageNPP<Npp16u> {
        private static Allocator<Npp16u> allocator = ImageAllocatorsNPP.allocator16u1();

        public ImageNPP_16u_C1() {
        }

        public ImageNPP_16u_C1(int width, int height) {
            super(width, height);
        }

        public ImageNPP_16u_C1(Image.Size rSize) {
            super(rSize);
        }

        public ImageNPP_16u_C1(ImageNPP<Npp16u> rImage) {
            super(rImage);
        }

        public ImageNPP_16u_C1(ImagesCPU.ImageCPU<Npp16u> rImage) {
            super(rImage);
        }

        @Override
        protected Allocator<Npp16u> allocator() {
            return allocator;
        }
    }

    public static class ImageNPP_16u_C2
    extends ImageNPP<Npp16u> {
        private static Allocator<Npp16u> allocator = ImageAllocatorsNPP.allocator16u2();

        public ImageNPP_16u_C2() {
        }

        public ImageNPP_16u_C2(int width, int height) {
            super(width, height);
        }

        public ImageNPP_16u_C2(Image.Size rSize) {
            super(rSize);
        }

        public ImageNPP_16u_C2(ImageNPP<Npp16u> rImage) {
            super(rImage);
        }

        public ImageNPP_16u_C2(ImagesCPU.ImageCPU<Npp16u> rImage) {
            super(rImage);
        }

        @Override
        protected Allocator<Npp16u> allocator() {
            return allocator;
        }
    }

    public static class ImageNPP_16u_C3
    extends ImageNPP<Npp16u> {
        private static Allocator<Npp16u> allocator = ImageAllocatorsNPP.allocator16u3();

        public ImageNPP_16u_C3() {
        }

        public ImageNPP_16u_C3(int width, int height) {
            super(width, height);
        }

        public ImageNPP_16u_C3(Image.Size rSize) {
            super(rSize);
        }

        public ImageNPP_16u_C3(ImageNPP<Npp16u> rImage) {
            super(rImage);
        }

        public ImageNPP_16u_C3(ImagesCPU.ImageCPU<Npp16u> rImage) {
            super(rImage);
        }

        @Override
        protected Allocator<Npp16u> allocator() {
            return allocator;
        }
    }

    public static class ImageNPP_16u_C4
    extends ImageNPP<Npp16u> {
        private static Allocator<Npp16u> allocator = ImageAllocatorsNPP.allocator16u4();

        public ImageNPP_16u_C4() {
        }

        public ImageNPP_16u_C4(int width, int height) {
            super(width, height);
        }

        public ImageNPP_16u_C4(Image.Size rSize) {
            super(rSize);
        }

        public ImageNPP_16u_C4(ImageNPP<Npp16u> rImage) {
            super(rImage);
        }

        public ImageNPP_16u_C4(ImagesCPU.ImageCPU<Npp16u> rImage) {
            super(rImage);
        }

        @Override
        protected Allocator<Npp16u> allocator() {
            return allocator;
        }
    }

    public static class ImageNPP_32f_C1
    extends ImageNPP<Npp32f> {
        private static Allocator<Npp32f> allocator = ImageAllocatorsNPP.allocator32f1();

        public ImageNPP_32f_C1() {
        }

        public ImageNPP_32f_C1(int width, int height) {
            super(width, height);
        }

        public ImageNPP_32f_C1(Image.Size rSize) {
            super(rSize);
        }

        public ImageNPP_32f_C1(ImageNPP<Npp32f> rImage) {
            super(rImage);
        }

        public ImageNPP_32f_C1(ImagesCPU.ImageCPU<Npp32f> rImage) {
            super(rImage);
        }

        @Override
        protected Allocator<Npp32f> allocator() {
            return allocator;
        }
    }

    public static class ImageNPP_32f_C2
    extends ImageNPP<Npp32f> {
        private static Allocator<Npp32f> allocator = ImageAllocatorsNPP.allocator32f2();

        public ImageNPP_32f_C2() {
        }

        public ImageNPP_32f_C2(int width, int height) {
            super(width, height);
        }

        public ImageNPP_32f_C2(Image.Size rSize) {
            super(rSize);
        }

        public ImageNPP_32f_C2(ImageNPP<Npp32f> rImage) {
            super(rImage);
        }

        public ImageNPP_32f_C2(ImagesCPU.ImageCPU<Npp32f> rImage) {
            super(rImage);
        }

        @Override
        protected Allocator<Npp32f> allocator() {
            return allocator;
        }
    }

    public static class ImageNPP_32f_C3
    extends ImageNPP<Npp32f> {
        private static Allocator<Npp32f> allocator = ImageAllocatorsNPP.allocator32f3();

        public ImageNPP_32f_C3() {
        }

        public ImageNPP_32f_C3(int width, int height) {
            super(width, height);
        }

        public ImageNPP_32f_C3(Image.Size rSize) {
            super(rSize);
        }

        public ImageNPP_32f_C3(ImageNPP<Npp32f> rImage) {
            super(rImage);
        }

        public ImageNPP_32f_C3(ImagesCPU.ImageCPU<Npp32f> rImage) {
            super(rImage);
        }

        @Override
        protected Allocator<Npp32f> allocator() {
            return allocator;
        }
    }

    public static class ImageNPP_32f_C4
    extends ImageNPP<Npp32f> {
        private static Allocator<Npp32f> allocator = ImageAllocatorsNPP.allocator32f4();

        public ImageNPP_32f_C4() {
        }

        public ImageNPP_32f_C4(int width, int height) {
            super(width, height);
        }

        public ImageNPP_32f_C4(Image.Size rSize) {
            super(rSize);
        }

        public ImageNPP_32f_C4(ImageNPP<Npp32f> rImage) {
            super(rImage);
        }

        public ImageNPP_32f_C4(ImagesCPU.ImageCPU<Npp32f> rImage) {
            super(rImage);
        }

        @Override
        protected Allocator<Npp32f> allocator() {
            return allocator;
        }
    }

    public static class ImageNPP_32s_C1
    extends ImageNPP<Npp32s> {
        private static Allocator<Npp32s> allocator = ImageAllocatorsNPP.allocator32s1();

        public ImageNPP_32s_C1() {
        }

        public ImageNPP_32s_C1(int width, int height) {
            super(width, height);
        }

        public ImageNPP_32s_C1(Image.Size rSize) {
            super(rSize);
        }

        public ImageNPP_32s_C1(ImageNPP<Npp32s> rImage) {
            super(rImage);
        }

        public ImageNPP_32s_C1(ImagesCPU.ImageCPU<Npp32s> rImage) {
            super(rImage);
        }

        @Override
        protected Allocator<Npp32s> allocator() {
            return allocator;
        }
    }

    public static class ImageNPP_32s_C3
    extends ImageNPP<Npp32s> {
        private static Allocator<Npp32s> allocator = ImageAllocatorsNPP.allocator32s3();

        public ImageNPP_32s_C3() {
        }

        public ImageNPP_32s_C3(int width, int height) {
            super(width, height);
        }

        public ImageNPP_32s_C3(Image.Size rSize) {
            super(rSize);
        }

        public ImageNPP_32s_C3(ImageNPP<Npp32s> rImage) {
            super(rImage);
        }

        public ImageNPP_32s_C3(ImagesCPU.ImageCPU<Npp32s> rImage) {
            super(rImage);
        }

        @Override
        protected Allocator<Npp32s> allocator() {
            return allocator;
        }
    }

    public static class ImageNPP_32s_C4
    extends ImageNPP<Npp32s> {
        private static Allocator<Npp32s> allocator = ImageAllocatorsNPP.allocator32s4();

        public ImageNPP_32s_C4() {
        }

        public ImageNPP_32s_C4(int width, int height) {
            super(width, height);
        }

        public ImageNPP_32s_C4(Image.Size rSize) {
            super(rSize);
        }

        public ImageNPP_32s_C4(ImageNPP<Npp32s> rImage) {
            super(rImage);
        }

        public ImageNPP_32s_C4(ImagesCPU.ImageCPU<Npp32s> rImage) {
            super(rImage);
        }

        @Override
        protected Allocator<Npp32s> allocator() {
            return allocator;
        }
    }

    public static class ImageNPP_8u_C1
    extends ImageNPP<Npp8u> {
        private static Allocator<Npp8u> allocator = ImageAllocatorsNPP.allocator8u1();

        public ImageNPP_8u_C1() {
        }

        public ImageNPP_8u_C1(int width, int height) {
            super(width, height);
        }

        public ImageNPP_8u_C1(Image.Size rSize) {
            super(rSize);
        }

        public ImageNPP_8u_C1(ImageNPP<Npp8u> rImage) {
            super(rImage);
        }

        public ImageNPP_8u_C1(ImagesCPU.ImageCPU<Npp8u> rImage) {
            super(rImage);
        }

        @Override
        protected Allocator<Npp8u> allocator() {
            return allocator;
        }
    }

    public static class ImageNPP_8u_C2
    extends ImageNPP<Npp8u> {
        private static Allocator<Npp8u> allocator = ImageAllocatorsNPP.allocator8u2();

        public ImageNPP_8u_C2() {
        }

        public ImageNPP_8u_C2(int width, int height) {
            super(width, height);
        }

        public ImageNPP_8u_C2(Image.Size rSize) {
            super(rSize);
        }

        public ImageNPP_8u_C2(ImageNPP<Npp8u> rImage) {
            super(rImage);
        }

        public ImageNPP_8u_C2(ImagesCPU.ImageCPU<Npp8u> rImage) {
            super(rImage);
        }

        @Override
        protected Allocator<Npp8u> allocator() {
            return allocator;
        }
    }

    public static class ImageNPP_8u_C3
    extends ImageNPP<Npp8u> {
        private static Allocator<Npp8u> allocator = ImageAllocatorsNPP.allocator8u3();

        public ImageNPP_8u_C3() {
        }

        public ImageNPP_8u_C3(int width, int height) {
            super(width, height);
        }

        public ImageNPP_8u_C3(Image.Size rSize) {
            super(rSize);
        }

        public ImageNPP_8u_C3(ImageNPP<Npp8u> rImage) {
            super(rImage);
        }

        public ImageNPP_8u_C3(ImagesCPU.ImageCPU<Npp8u> rImage) {
            super(rImage);
        }

        @Override
        protected Allocator<Npp8u> allocator() {
            return allocator;
        }
    }

    public static class ImageNPP_8u_C4
    extends ImageNPP<Npp8u> {
        private static Allocator<Npp8u> allocator = ImageAllocatorsNPP.allocator8u4();

        public ImageNPP_8u_C4() {
        }

        public ImageNPP_8u_C4(int width, int height) {
            super(width, height);
        }

        public ImageNPP_8u_C4(Image.Size rSize) {
            super(rSize);
        }

        public ImageNPP_8u_C4(ImageNPP<Npp8u> rImage) {
            super(rImage);
        }

        public ImageNPP_8u_C4(ImagesCPU.ImageCPU<Npp8u> rImage) {
            super(rImage);
        }

        @Override
        protected Allocator<Npp8u> allocator() {
            return allocator;
        }
    }
}

