/*
 * JNpp - Java bindings for NPP, to be used with JCuda
 *
 * Copyright (c) 2010-2012 Marco Hutter - http://www.jcuda.org
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

package jcuda.jnpp;
/** 
 * Filtering methods.
 */
class FilteringMethod
{
    /**
     * Nearest neighbor filtering.
     */
    public static final int NPPI_INTER_NN     = 1;
    
    /**
     * Linear interpolation.
     */
    public static final int NPPI_INTER_LINEAR = 2;
    
    /**
     * Cubic interpolation.
     */
    public static final int NPPI_INTER_CUBIC  = 4;
    
    /**
     * ???
     */
    public static final int NPPI_INTER_SUPER  = 8;
    
    /**
     * Lanczos filtering.
     */
    public static final int NPPI_INTER_LANCZOS = 16;
    
    /**
     * Smooth edge filtering.
     */
    public static final int NPPI_SMOOTH_EDGE  = (1 << 31);

    
    /**
     * Returns the String identifying the given FilteringMethod
     *
     * @param m The FilteringMethod
     * @return The String identifying the given FilteringMethod
     */
    public static String stringFor(int m)
    {
        if (m==0)
        {
            return "NO FilteringMethod";
        }
        StringBuilder sb = new StringBuilder();
        if ((m & NPPI_INTER_NN     ) != 0) sb.append("NPPI_INTER_NN ");
        if ((m & NPPI_INTER_LINEAR ) != 0) sb.append("NPPI_INTER_LINEAR ");
        if ((m & NPPI_INTER_CUBIC  ) != 0) sb.append("NPPI_INTER_CUBIC ");
        if ((m & NPPI_INTER_SUPER  ) != 0) sb.append("NPPI_INTER_SUPER ");
        if ((m & NPPI_INTER_LANCZOS) != 0) sb.append("NPPI_INTER_LANCZOS ");
        if ((m & NPPI_SMOOTH_EDGE  ) != 0) sb.append("NPPI_SMOOTH_EDGE ");
        return sb.toString();
    }

    /**
     * Private constructor to prevent instantiation.
     */
    private FilteringMethod()
    {
    }
    
}; 
