/*
 * JNpp - Java bindings for NPP, to be used with JCuda
 *
 * Copyright (c) 2010-2012 Marco Hutter - http://www.jcuda.org
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

package jcuda.jnpp;

import jcuda.CudaException;
import jcuda.jnpp.types.*;

/**
 * <b>Preliminary</b> utility methods for JNpp
 */
public class JNppUtils
{
    /**
     * Simple assertion that throws a CudaException if the given
     * argument is <code>false</code>
     * 
     * @param b The argument to check
     * @throws CudaException if the argument is <code>false</code>
     */
    public static void NPP_ASSERT(boolean b)
    {
        if (!b)
        {
            throw new CudaException("Assertion failed");
        }
    }
    
    /**
     * Returns the size of the type represented by the given 
     * {@link NppType} class.
     *  
     * @param <T> The type
     * @param t The type class
     * @return The size
     * @throws CudaException If the given type is not known
     */
    public static <T extends NppType> int sizeof(Class<T> t)
    {
        if (t.equals(Npp8u.class))
        {
            return 1;
        }
        if (t.equals(Npp16s.class))
        {
            return 2;
        }
        if (t.equals(Npp16u.class))
        {
            return 2;
        }
        if (t.equals(Npp32s.class))
        {
            return 4;
        }
        if (t.equals(Npp32u.class))
        {
            return 4;
        }
        if (t.equals(Npp64s.class))
        {
            return 8;
        }
        if (t.equals(Npp64u.class))
        {
            return 8;
        }
        if (t.equals(Npp32f.class))
        {
            return 4;
        }
        if (t.equals(Npp64f.class))
        {
            return 8;
        }
        
        if (t.equals(Npp16sc.class))
        {
            return 2*2;
        }
        if (t.equals(Npp32sc.class))
        {
            return 2*4;
        }
        if (t.equals(Npp64sc.class))
        {
            return 2*8;
        }
        if (t.equals(Npp32fc.class))
        {
            return 2*4;
        }
        if (t.equals(Npp64fc.class))
        {
            return 2*8;
        }
        
        // Should never get here
        throw new CudaException("Invalid type: "+t);
    }

    /**
     * Private constructor to prevent instantiation
     */
    private JNppUtils()
    {
    }
}
