/*
 * JNpp - Java bindings for NPP, to be used with JCuda
 *
 * Copyright (c) 2010-2012 Marco Hutter - http://www.jcuda.org
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

package jcuda.jnpp;

/**
 * Comparison operations
 */
public class NppCmpOp
{
    public static final int NPP_CMP_LESS =  0;
    public static final int NPP_CMP_LESS_EQ =  1;
    public static final int NPP_CMP_EQ =  2;
    public static final int NPP_CMP_GREATER_EQ =  3;
    public static final int NPP_CMP_GREATER =  4;
    
    /**
     * Returns the String identifying the given NppCmpOp
     *
     * @param m The NppCmpOp
     * @return The String identifying the given NppCmpOp
     */
    public static String stringFor(int m)
    {
        switch (m)
        {
            case NPP_CMP_LESS: return "NPP_CMP_LESS";
            case NPP_CMP_LESS_EQ: return "NPP_CMP_LESS_EQ";
            case NPP_CMP_EQ: return "NPP_CMP_EQ";
            case NPP_CMP_GREATER_EQ: return "NPP_CMP_GREATER_EQ";
            case NPP_CMP_GREATER: return "NPP_CMP_GREATER";
        }
        return "INVALID NppCmpOp: " + m;
    }

    /**
     * Private constructor to prevent instantiation.
     */
    private NppCmpOp()
    {
    }
    
}
