/*
 * JNpp - Java bindings for NPP, to be used with JCuda
 *
 * Copyright (c) 2010-2012 Marco Hutter - http://www.jcuda.org
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

package jcuda.jnpp;


/**
 * GPU Compute Capabilities
 */ 
public class NppGpuComputeCapability
{
    
    /**
     * Indicates that the compute-capability query failed
     */
    public static final int NPP_CUDA_UNKNOWN_VERSION = -1;
    
    
    /**
     * Indicates that no CUDA capable device was found on machine
     */
    public static final int NPP_CUDA_NOT_CAPABLE = 0;
    
    
    /**
     * Indicates that CUDA 1.0 capable device is default device on machine
     */
    public static final int NPP_CUDA_1_0 = 1;
    
    
    /**
     * Indicates that CUDA 1.1 capable device
     */
    public static final int NPP_CUDA_1_1 = 2;
    
    
    /**
     * Indicates that CUDA 1.2 capable device
     */
    public static final int NPP_CUDA_1_2 = 3;
    
    
    /**
     * Indicates that CUDA 1.3 or better is default device on machine
     */
    public static final int NPP_CUDA_1_3 = 4;
    
    
    /**
     * Indicates that CUDA 2.0 or better is default device on machine
     */
    public static final int NPP_CUDA_2_0 = 5;                       
    
    /**
     * Returns the String identifying the given NppGpuComputeCapability
     *
     * @param m The NppGpuComputeCapability
     * @return The String identifying the given NppGpuComputeCapability
     */
    public static String stringFor(int m)
    {
        switch (m)
        {
            case NPP_CUDA_UNKNOWN_VERSION: return "NPP_CUDA_UNKNOWN_VERSION";
            case NPP_CUDA_NOT_CAPABLE: return "NPP_CUDA_NOT_CAPABLE";
            case NPP_CUDA_1_0: return "NPP_CUDA_1_0";
            case NPP_CUDA_1_1: return "NPP_CUDA_1_1";
            case NPP_CUDA_1_2: return "NPP_CUDA_1_2";
            case NPP_CUDA_1_3: return "NPP_CUDA_1_3";
            case NPP_CUDA_2_0: return "NPP_CUDA_2_0";
        }
        return "INVALID NppGpuComputeCapability: " + m;
    }

    /**
     * Private constructor to prevent instantiation.
     */
    private NppGpuComputeCapability()
    {
    }
    
}
