/*
 * JNpp - Java bindings for NPP, to be used with JCuda
 *
 * Copyright (c) 2010-2012 Marco Hutter - http://www.jcuda.org
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

package jcuda.jnpp;

/**
 * Java port of a NppLibraryVersion
 */
public class NppLibraryVersion
{
    /**
     * Major version number
     */
    public int    major; 
    
    /**
     * Minor version number
     */
    public int    minor;
    
    /**
     * Build number. This reflects the nightly build this release was made from.
     */
    public int    build;
    
    
    /**
     * Creates a new NppLibraryVersion with the given version information
     * 
     * @param major The major version number
     * @param minor The minor version number
     * @param build The build number
     */
    public NppLibraryVersion(int major, int minor, int build)
    {
        this.major = major;
        this.minor = minor;
        this.build = build;
    }
    
    @Override
    public String toString()
    {
        return "NppLibraryVersion "+major+"."+minor+"b"+build;
    }
    
};