/*
 * JNpp - Java bindings for NPP, to be used with JCuda
 *
 * Copyright (c) 2010-2012 Marco Hutter - http://www.jcuda.org
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

package jcuda.jnpp;

/**
 * Rounding modes
 */
public class NppRoundMode
{
    public static final int NPP_RND_ZERO =  0;
    public static final int NPP_RND_NEAR =  1;
    public static final int NPP_RND_FINANCIAL =  2;
    
    /**
     * Returns the String identifying the given NppRoundMode
     *
     * @param m The NppRoundMode
     * @return The String identifying the given NppRoundMode
     */
    public static String stringFor(int m)
    {
        switch (m)
        {
            case NPP_RND_ZERO: return "NPP_RND_ZERO";
            case NPP_RND_NEAR: return "NPP_RND_NEAR";
            case NPP_RND_FINANCIAL: return "NPP_RND_FINANCIAL";
        }
        return "INVALID NppRoundMode: " + m;
    }

    /**
     * Private constructor to prevent instantiation.
     */
    private NppRoundMode()
    {
    }
    
}
