/*
 * JNpp - Java bindings for NPP, to be used with JCuda
 *
 * Copyright (c) 2010-2012 Marco Hutter - http://www.jcuda.org
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

package jcuda.jnpp;
/** 
 * Alpha operators
 */
public class NppiAlphaOp
{
    public static final int NPPI_OP_ALPHA_OVER = 0;
    public static final int NPPI_OP_ALPHA_IN = 1;
    public static final int NPPI_OP_ALPHA_OUT = 2;
    public static final int NPPI_OP_ALPHA_ATOP = 3;
    public static final int NPPI_OP_ALPHA_XOR = 4;
    public static final int NPPI_OP_ALPHA_PLUS = 5;
    public static final int NPPI_OP_ALPHA_OVER_PREMUL = 6;
    public static final int NPPI_OP_ALPHA_IN_PREMUL = 7;
    public static final int NPPI_OP_ALPHA_OUT_PREMUL = 8;
    public static final int NPPI_OP_ALPHA_ATOP_PREMUL = 9;
    public static final int NPPI_OP_ALPHA_XOR_PREMUL = 10;
    public static final int NPPI_OP_ALPHA_PLUS_PREMUL = 11;
    public static final int NPPI_OP_ALPHA_PREMUL = 12;

    /**
     * Private constructor to prevent instantiation
     */
    private NppiAlphaOp(){}

    /**
     * Returns a string representation of the given constant
     *
     * @return A string representation of the given constant
     */
    public static String stringFor(int n)
    {
        switch (n)
        {
            case NPPI_OP_ALPHA_OVER: return "NPPI_OP_ALPHA_OVER";
            case NPPI_OP_ALPHA_IN: return "NPPI_OP_ALPHA_IN";
            case NPPI_OP_ALPHA_OUT: return "NPPI_OP_ALPHA_OUT";
            case NPPI_OP_ALPHA_ATOP: return "NPPI_OP_ALPHA_ATOP";
            case NPPI_OP_ALPHA_XOR: return "NPPI_OP_ALPHA_XOR";
            case NPPI_OP_ALPHA_PLUS: return "NPPI_OP_ALPHA_PLUS";
            case NPPI_OP_ALPHA_OVER_PREMUL: return "NPPI_OP_ALPHA_OVER_PREMUL";
            case NPPI_OP_ALPHA_IN_PREMUL: return "NPPI_OP_ALPHA_IN_PREMUL";
            case NPPI_OP_ALPHA_OUT_PREMUL: return "NPPI_OP_ALPHA_OUT_PREMUL";
            case NPPI_OP_ALPHA_ATOP_PREMUL: return "NPPI_OP_ALPHA_ATOP_PREMUL";
            case NPPI_OP_ALPHA_XOR_PREMUL: return "NPPI_OP_ALPHA_XOR_PREMUL";
            case NPPI_OP_ALPHA_PLUS_PREMUL: return "NPPI_OP_ALPHA_PLUS_PREMUL";
            case NPPI_OP_ALPHA_PREMUL: return "NPPI_OP_ALPHA_PREMUL";
        }
        return "INVALID NppiAlphaOp: "+n;
    }
}

