/*
 * JNpp - Java bindings for NPP, to be used with JCuda
 *
 * Copyright (c) 2010-2012 Marco Hutter - http://www.jcuda.org
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

package jcuda.jnpp;

/**
 * Sampling Conversion Modes
 */
public class NppiSamplingConvMode
{
    public static final int NPPI_FROM_444_TO_422 =  0;
    public static final int NPPI_FROM_444_TO_411 =  1;
    public static final int NPPI_FROM_444_TO_420 =  2;

    public static final int NPPI_FROM_422_TO_444 =  3;
    public static final int NPPI_FROM_422_TO_411 =  4;
    public static final int NPPI_FROM_422_TO_420 =  5;
    
    public static final int NPPI_FROM_411_TO_444 =  6;
    public static final int NPPI_FROM_411_TO_422 =  7;
    public static final int NPPI_FROM_411_TO_420 =  8;
    
    public static final int NPPI_FROM_420_TO_444 =  9;
    public static final int NPPI_FROM_420_TO_422 = 10;
    public static final int NPPI_FROM_420_TO_411 = 11;
    
    
    /**
     * Returns the String identifying the given NppiSamplingConvMode
     *
     * @param m The NppiSamplingConvMode
     * @return The String identifying the given NppiSamplingConvMode
     */
    public static String stringFor(int m)
    {
        switch (m)
        {
            case NPPI_FROM_444_TO_422: return "NPPI_FROM_444_TO_422";
            case NPPI_FROM_444_TO_411: return "NPPI_FROM_444_TO_411";
            case NPPI_FROM_444_TO_420: return "NPPI_FROM_444_TO_420";
            case NPPI_FROM_422_TO_444: return "NPPI_FROM_422_TO_444";
            case NPPI_FROM_422_TO_411: return "NPPI_FROM_422_TO_411";
            case NPPI_FROM_422_TO_420: return "NPPI_FROM_422_TO_420";
            case NPPI_FROM_411_TO_444: return "NPPI_FROM_411_TO_444";
            case NPPI_FROM_411_TO_422: return "NPPI_FROM_411_TO_422";
            case NPPI_FROM_411_TO_420: return "NPPI_FROM_411_TO_420";
            case NPPI_FROM_420_TO_444: return "NPPI_FROM_420_TO_444";
            case NPPI_FROM_420_TO_422: return "NPPI_FROM_420_TO_422";
            case NPPI_FROM_420_TO_411: return "NPPI_FROM_420_TO_411";
        }
        return "INVALID NppiSamplingConvMode: " + m;
    }

    /**
     * Private constructor to prevent instantiation.
     */
    private NppiSamplingConvMode()
    {
    }
    
}
