/*
 * JNpp - Java bindings for NPP, to be used with JCuda
 *
 * Copyright (c) 2010-2012 Marco Hutter - http://www.jcuda.org
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

package jcuda.jnpp.utilnpp;

/**
 * Abstract base class for {@link Image Images} 
 */
class AbstractImage implements Image
{
    /**
     * The size of this image
     */
    private Size oSize_;
    
    /**
     * Creates an AbstractImage with the given size
     * 
     * @param nWidth The width
     * @param nHeight The height
     */
    protected AbstractImage(int nWidth, int nHeight)
    {
        this.oSize_ = new DefaultSize(nWidth, nHeight);
    }
    
    /**
     * Creates an AbstractImage with the given size
     * 
     * @param rSize The size
     */
    protected AbstractImage(Size rSize)
    {
        this.oSize_ = new DefaultSize(rSize);
    }

    @Override
    public int width()
    {
        return oSize_.nHeight();
    }
    
    @Override
    public int height()
    {
        return oSize_.nHeight();
    }

    @Override
    public Size size()
    {
        return oSize_;
    }
    
    @Override
    public void set(Image rImage)
    {
        if (rImage == this)
        {
            return;
        }
        oSize_  = new DefaultSize(rImage.size());        
    }

    @Override
    public void swap(Image rImage)
    {
        oSize_.swap(rImage.size());
    }

    @Override
    public int hashCode()
    {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((oSize_ == null) ? 0 : oSize_.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj)
    {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        final AbstractImage other = (AbstractImage) obj;
        if (oSize_ == null)
        {
            if (other.oSize_ != null)
                return false;
        }
        else if (!oSize_.equals(other.oSize_))
            return false;
        return true;
    }
    
}
