/*
 * JNpp - Java bindings for NPP, to be used with JCuda
 *
 * Copyright (c) 2010-2012 Marco Hutter - http://www.jcuda.org
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

package jcuda.jnpp.utilnpp;

import jcuda.jnpp.utilnpp.Image.Size;

/**
 * Default implementation of a {@link Size}
 */
public class DefaultSize implements Image.Size
{
    /**
     * The width
     */
    private int nWidth;
    
    /**
     * The height
     */
    private int nHeight;
    
    /**
     * Creates a new size as specified
     * 
     * @param nWidthNew The width
     * @param nHeightNew The height
     */
    DefaultSize(int nWidthNew, int nHeightNew)
    { 
        this.nWidth = nWidthNew;
        this.nHeight = nHeightNew;
    }

    /**
     * Copy constructor
     * 
     * @param rSize The other size
     */
    DefaultSize(Size rSize)
    {
        this.nWidth = rSize.nWidth();
        this.nHeight = rSize.nHeight();
    }
    
    @Override
    public void set(Size rSize)
    {
        this.nWidth = rSize.nWidth();
        this.nHeight = rSize.nHeight();
    }

    @Override
    public void setHeight(int height)
    {
        this.nHeight = height;
    }

    @Override
    public void setWidth(int width)
    {
        this.nWidth = width;
    }

    @Override
    public void swap(Size rSize)
    {
        int tempW = rSize.nWidth();
        rSize.setWidth(nWidth());
        setWidth(tempW);

        int tempH = rSize.nHeight();
        rSize.setHeight(nHeight());
        setHeight(tempH);
        
    }
    

    @Override
    public int nWidth()
    {
        return nWidth;
    }

    @Override
    public int nHeight()
    {
        return nHeight;
    }

    @Override
    public int hashCode()
    {
        final int prime = 31;
        int result = 1;
        result = prime * result + nHeight;
        result = prime * result + nWidth;
        return result;
    }

    @Override
    public boolean equals(Object obj)
    {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        final DefaultSize other = (DefaultSize) obj;
        if (nHeight != other.nHeight)
            return false;
        if (nWidth != other.nWidth)
            return false;
        return true;
    }


}
