/*
 * JNpp - Java bindings for NPP, to be used with JCuda
 *
 * Copyright (c) 2010-2012 Marco Hutter - http://www.jcuda.org
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

package jcuda.jnpp.utilnpp;

/**
 * Java interface that corresponds to the npp::Image class
 */
public interface Image
{
    /**
     * Interface that corresponds to the npp::Image::Size struct
     */
    interface Size
    {
        /**
         * Returns the width
         * 
         * @return The width
         */
        int nWidth();

        /**
         * Returns the height
         * 
         * @return The height
         */
        int nHeight();
        
        /**
         * Set the width
         * 
         * @param width The width
         */
        void setWidth(int width);

        /**
         * Set the height
         * 
         * @param height The height
         */
        void setHeight(int height);
        
        /**
         * Assignment operator: Set this size to be the same 
         * as the given size
         * 
         * @param rSize The other size
         */
        void set(Size rSize);
        
        /**
         * Swap this size and the given size
         * 
         * @param rSize The other size
         */
        void swap(Size rSize);
        
        /**
         * @see Object#equals(Object)
         */
        boolean equals(Object object);

        /**
         * @see Object#hashCode()
         */
        int hashCode();
    }
    
    /**
     * Return the width of this image
     * 
     * @return The width of this image
     */
    int width();

    /**
     * Return the height of this image
     * 
     * @return The height of this image
     */
    int height();
    
    /**
     * Return the size of this image
     * 
     * @return The size of this image
     */
    Size size();
    
    /**
     * Assignment operator: Set this image to have the same 
     * contents as the given image.
     * 
     * @param rImage The other image
     */
    void set(Image rImage);
    
    /**
     * Swap the contents of this image and the given image
     * 
     * @param rImage The other image
     */
    void swap(Image rImage);
}
