/*
 * JNpp - Java bindings for NPP, to be used with JCuda
 *
 * Copyright (c) 2010-2012 Marco Hutter - http://www.jcuda.org
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

package jcuda.jnpp.utilnpp;

import jcuda.jnpp.TypedPointer;
import jcuda.jnpp.types.NppType;

/**
 * Interface that corresponds to the npp::ImagePacked class.
 * The original ImagePacked class has three template parameters:
 * <pre>
 * template&lt;typename D, size_t N, class A&gt;
 * </pre>
 * Where <code>D</code> represents the data type, <code>N</code>
 * is the number of channels, and <code>A</code> is the 
 * allocator. These data type is represented using the generic
 * type parameter, and the other template parameters are covered
 * by the concrete classes implementing this interface, namely
 * the static inner classes of the {@link ImagesCPU} and 
 * {@link ImagesNPP}
 * class.<br />  
 * <br />
 * <br />
 * 
 * TODO: This class is not completely implemented yet: It is not possible to obtain the Pixels from such an image!
 *  
 * @param <T> The data type
 */
public interface ImagePacked<T extends NppType> extends Image
{
    /**
     * Dummy interface - not implemented yet
     */
    interface Pixel
    {
    }
//    interface Pixel_u8_1
//    {
//        byte x();
//    }
//    interface Pixel_u8_2
//    {
//        byte x();
//        byte y();
//    }
//    interface Pixel_u8_3
//    {
//        byte x();
//        byte y();
//        byte z();
//    }
//    interface Pixel_u8_4
//    {
//        byte x();
//        byte y();
//        byte z();
//        byte w();
//    }
    
    /**
     * Set this image to have the contents of the given image
     * 
     * @param rImage The other image
     */
    void set(ImagePacked<T> rImage);
    
    /**
     * Returns the pitch of this image
     * 
     * @return The pitch of this image
     */
    int pitch();
    
    /**
     * TODO: <b>ImagePacked#pixels(int, int) NOT IMPLEMENTED YET</b>
     * @param nX
     * @param nY
     * @return
     */
    Pixel[] pixels(int nX, int nY);
    
    /**
     * Returns the pointer to the image data
     * 
     * @return The pointer to the image data
     */
    TypedPointer<T> data();
    
}
