/*
 * JNpp - Java bindings for NPP, to be used with JCuda
 *
 * Copyright (c) 2010-2012 Marco Hutter - http://www.jcuda.org
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

package jcuda.jnpp.utilnpp;

import jcuda.jnpp.types.*;

/**
 * This class provides a set of static inner classes for images with
 * different types.<br />
 * <br /> 
 * Note: This class serves the same purpose as the ImagesNPP header file, 
 * which defines a set of "typedefs" in the form
 * <pre>
 * <code>
 * typedef ImageCPU&lt;Npp8u,  1, npp::ImageAllocatorCPU&lt;Npp8u,      1&gt;  &gt;   ImageCPU_8u_C1;
 * </code>
 * </pre>
 * This, the inner classes of this class correspond to concrete template 
 * instantiations with appropriate allocators for the image data.   
 */
public class ImagesCPU
{
    /**
     * Private constructor to prevent instantiation
     */
    private ImagesCPU()
    {
    }
    
    /**
     * This class is the abstract base class for all CPU images. That is,
     * for all images that are handled by NPP and are using host memory.
     *
     * @param <T> The data type of this image
     */
    public static abstract class ImageCPU<T extends NppType> extends AbstractImagePacked<T> implements ImagePacked<T>
    {
        /**
         * Creates a new Image
         */
        protected ImageCPU()
        {
            super();
        }
        
        /**
         * Creates a new Image with the given size
         * 
         * @param width The width
         * @param height The height
         */
        protected ImageCPU(int width, int height)
        {
            super(width, height);
        }
        
        /**
         * Creates a new Image with the given size
         * 
         * @param rSize The size
         */
        protected ImageCPU(Size rSize)
        {
            super(rSize);
        }
        
        /**
         * Copy-constructor
         * 
         * @param rImage The other image
         */
        protected ImageCPU(ImageCPU<T> rImage)
        {
            super(rImage);
        }
    }

    
    
    //=== auto-generated: =====================================================
    
    
    /**
     * Implementation of an image 
     */
    public static class ImageCPU_8u_C1 extends ImageCPU<Npp8u>
    {
        /** The allocator used in this image class */
        private static Allocator<Npp8u> allocator = ImageAllocatorsCPU.allocator8u1();
        
        /**
         * Creates a new Image
         */
        public ImageCPU_8u_C1()
        {
            super();
        }

        /**
         * Creates a new Image with the given size
         * 
         * @param width The width
         * @param height The height
         */
        public ImageCPU_8u_C1(int width, int height)
        {
            super(width, height);
        }

        /**
         * Creates a new Image with the given size
         * 
         * @param rSize The size
         */
        public ImageCPU_8u_C1(Size rSize)
        {
            super(rSize);
        }

        /**
         * Copy-constructor
         * 
         * @param rImage The other image
         */
        public ImageCPU_8u_C1(ImageCPU<Npp8u> rImage)
        {
            super(rImage);
        }

        @Override
        protected Allocator<Npp8u> allocator()
        {
            return allocator;
        }
    }


    /**
     * Implementation of an image 
     */
    public static class ImageCPU_8u_C2 extends ImageCPU<Npp8u>
    {
        /** The allocator used in this image class */
        private static Allocator<Npp8u> allocator = ImageAllocatorsCPU.allocator8u2();
        
        /**
         * Creates a new Image
         */
        public ImageCPU_8u_C2()
        {
            super();
        }

        /**
         * Creates a new Image with the given size
         * 
         * @param width The width
         * @param height The height
         */
        public ImageCPU_8u_C2(int width, int height)
        {
            super(width, height);
        }

        /**
         * Creates a new Image with the given size
         * 
         * @param rSize The size
         */
        public ImageCPU_8u_C2(Size rSize)
        {
            super(rSize);
        }

        /**
         * Copy-constructor
         * 
         * @param rImage The other image
         */
        public ImageCPU_8u_C2(ImageCPU<Npp8u> rImage)
        {
            super(rImage);
        }

        @Override
        protected Allocator<Npp8u> allocator()
        {
            return allocator;
        }
    }


    /**
     * Implementation of an image 
     */
    public static class ImageCPU_8u_C3 extends ImageCPU<Npp8u>
    {
        /** The allocator used in this image class */
        private static Allocator<Npp8u> allocator = ImageAllocatorsCPU.allocator8u3();
        
        /**
         * Creates a new Image
         */
        public ImageCPU_8u_C3()
        {
            super();
        }

        /**
         * Creates a new Image with the given size
         * 
         * @param width The width
         * @param height The height
         */
        public ImageCPU_8u_C3(int width, int height)
        {
            super(width, height);
        }

        /**
         * Creates a new Image with the given size
         * 
         * @param rSize The size
         */
        public ImageCPU_8u_C3(Size rSize)
        {
            super(rSize);
        }

        /**
         * Copy-constructor
         * 
         * @param rImage The other image
         */
        public ImageCPU_8u_C3(ImageCPU<Npp8u> rImage)
        {
            super(rImage);
        }

        @Override
        protected Allocator<Npp8u> allocator()
        {
            return allocator;
        }
    }


    /**
     * Implementation of an image 
     */
    public static class ImageCPU_8u_C4 extends ImageCPU<Npp8u>
    {
        /** The allocator used in this image class */
        private static Allocator<Npp8u> allocator = ImageAllocatorsCPU.allocator8u4();
        
        /**
         * Creates a new Image
         */
        public ImageCPU_8u_C4()
        {
            super();
        }

        /**
         * Creates a new Image with the given size
         * 
         * @param width The width
         * @param height The height
         */
        public ImageCPU_8u_C4(int width, int height)
        {
            super(width, height);
        }

        /**
         * Creates a new Image with the given size
         * 
         * @param rSize The size
         */
        public ImageCPU_8u_C4(Size rSize)
        {
            super(rSize);
        }

        /**
         * Copy-constructor
         * 
         * @param rImage The other image
         */
        public ImageCPU_8u_C4(ImageCPU<Npp8u> rImage)
        {
            super(rImage);
        }

        @Override
        protected Allocator<Npp8u> allocator()
        {
            return allocator;
        }
    }


    /**
     * Implementation of an image 
     */
    public static class ImageCPU_16u_C1 extends ImageCPU<Npp16u>
    {
        /** The allocator used in this image class */
        private static Allocator<Npp16u> allocator = ImageAllocatorsCPU.allocator16u1();
        
        /**
         * Creates a new Image
         */
        public ImageCPU_16u_C1()
        {
            super();
        }

        /**
         * Creates a new Image with the given size
         * 
         * @param width The width
         * @param height The height
         */
        public ImageCPU_16u_C1(int width, int height)
        {
            super(width, height);
        }

        /**
         * Creates a new Image with the given size
         * 
         * @param rSize The size
         */
        public ImageCPU_16u_C1(Size rSize)
        {
            super(rSize);
        }

        /**
         * Copy-constructor
         * 
         * @param rImage The other image
         */
        public ImageCPU_16u_C1(ImageCPU<Npp16u> rImage)
        {
            super(rImage);
        }

        @Override
        protected Allocator<Npp16u> allocator()
        {
            return allocator;
        }
    }



    /**
     * Implementation of an image 
     */
    public static class ImageCPU_16u_C3 extends ImageCPU<Npp16u>
    {
        /** The allocator used in this image class */
        private static Allocator<Npp16u> allocator = ImageAllocatorsCPU.allocator16u3();
        
        /**
         * Creates a new Image
         */
        public ImageCPU_16u_C3()
        {
            super();
        }

        /**
         * Creates a new Image with the given size
         * 
         * @param width The width
         * @param height The height
         */
        public ImageCPU_16u_C3(int width, int height)
        {
            super(width, height);
        }

        /**
         * Creates a new Image with the given size
         * 
         * @param rSize The size
         */
        public ImageCPU_16u_C3(Size rSize)
        {
            super(rSize);
        }

        /**
         * Copy-constructor
         * 
         * @param rImage The other image
         */
        public ImageCPU_16u_C3(ImageCPU<Npp16u> rImage)
        {
            super(rImage);
        }

        @Override
        protected Allocator<Npp16u> allocator()
        {
            return allocator;
        }
    }


    /**
     * Implementation of an image 
     */
    public static class ImageCPU_16u_C4 extends ImageCPU<Npp16u>
    {
        /** The allocator used in this image class */
        private static Allocator<Npp16u> allocator = ImageAllocatorsCPU.allocator16u4();
        
        /**
         * Creates a new Image
         */
        public ImageCPU_16u_C4()
        {
            super();
        }

        /**
         * Creates a new Image with the given size
         * 
         * @param width The width
         * @param height The height
         */
        public ImageCPU_16u_C4(int width, int height)
        {
            super(width, height);
        }

        /**
         * Creates a new Image with the given size
         * 
         * @param rSize The size
         */
        public ImageCPU_16u_C4(Size rSize)
        {
            super(rSize);
        }

        /**
         * Copy-constructor
         * 
         * @param rImage The other image
         */
        public ImageCPU_16u_C4(ImageCPU<Npp16u> rImage)
        {
            super(rImage);
        }

        @Override
        protected Allocator<Npp16u> allocator()
        {
            return allocator;
        }
    }


    /**
     * Implementation of an image 
     */
    public static class ImageCPU_16s_C1 extends ImageCPU<Npp16s>
    {
        /** The allocator used in this image class */
        private static Allocator<Npp16s> allocator = ImageAllocatorsCPU.allocator16s1();
        
        /**
         * Creates a new Image
         */
        public ImageCPU_16s_C1()
        {
            super();
        }

        /**
         * Creates a new Image with the given size
         * 
         * @param width The width
         * @param height The height
         */
        public ImageCPU_16s_C1(int width, int height)
        {
            super(width, height);
        }

        /**
         * Creates a new Image with the given size
         * 
         * @param rSize The size
         */
        public ImageCPU_16s_C1(Size rSize)
        {
            super(rSize);
        }

        /**
         * Copy-constructor
         * 
         * @param rImage The other image
         */
        public ImageCPU_16s_C1(ImageCPU<Npp16s> rImage)
        {
            super(rImage);
        }

        @Override
        protected Allocator<Npp16s> allocator()
        {
            return allocator;
        }
    }


    /**
     * Implementation of an image 
     */
    public static class ImageCPU_16s_C3 extends ImageCPU<Npp16s>
    {
        /** The allocator used in this image class */
        private static Allocator<Npp16s> allocator = ImageAllocatorsCPU.allocator16s3();
        
        /**
         * Creates a new Image
         */
        public ImageCPU_16s_C3()
        {
            super();
        }

        /**
         * Creates a new Image with the given size
         * 
         * @param width The width
         * @param height The height
         */
        public ImageCPU_16s_C3(int width, int height)
        {
            super(width, height);
        }

        /**
         * Creates a new Image with the given size
         * 
         * @param rSize The size
         */
        public ImageCPU_16s_C3(Size rSize)
        {
            super(rSize);
        }

        /**
         * Copy-constructor
         * 
         * @param rImage The other image
         */
        public ImageCPU_16s_C3(ImageCPU<Npp16s> rImage)
        {
            super(rImage);
        }

        @Override
        protected Allocator<Npp16s> allocator()
        {
            return allocator;
        }
    }


    /**
     * Implementation of an image 
     */
    public static class ImageCPU_16s_C4 extends ImageCPU<Npp16s>
    {
        /** The allocator used in this image class */
        private static Allocator<Npp16s> allocator = ImageAllocatorsCPU.allocator16s4();
        
        /**
         * Creates a new Image
         */
        public ImageCPU_16s_C4()
        {
            super();
        }

        /**
         * Creates a new Image with the given size
         * 
         * @param width The width
         * @param height The height
         */
        public ImageCPU_16s_C4(int width, int height)
        {
            super(width, height);
        }

        /**
         * Creates a new Image with the given size
         * 
         * @param rSize The size
         */
        public ImageCPU_16s_C4(Size rSize)
        {
            super(rSize);
        }

        /**
         * Copy-constructor
         * 
         * @param rImage The other image
         */
        public ImageCPU_16s_C4(ImageCPU<Npp16s> rImage)
        {
            super(rImage);
        }

        @Override
        protected Allocator<Npp16s> allocator()
        {
            return allocator;
        }
    }


    /**
     * Implementation of an image 
     */
    public static class ImageCPU_32s_C1 extends ImageCPU<Npp32s>
    {
        /** The allocator used in this image class */
        private static Allocator<Npp32s> allocator = ImageAllocatorsCPU.allocator32s1();
        
        /**
         * Creates a new Image
         */
        public ImageCPU_32s_C1()
        {
            super();
        }

        /**
         * Creates a new Image with the given size
         * 
         * @param width The width
         * @param height The height
         */
        public ImageCPU_32s_C1(int width, int height)
        {
            super(width, height);
        }

        /**
         * Creates a new Image with the given size
         * 
         * @param rSize The size
         */
        public ImageCPU_32s_C1(Size rSize)
        {
            super(rSize);
        }

        /**
         * Copy-constructor
         * 
         * @param rImage The other image
         */
        public ImageCPU_32s_C1(ImageCPU<Npp32s> rImage)
        {
            super(rImage);
        }

        @Override
        protected Allocator<Npp32s> allocator()
        {
            return allocator;
        }
    }


    /**
     * Implementation of an image 
     */
    public static class ImageCPU_32s_C3 extends ImageCPU<Npp32s>
    {
        /** The allocator used in this image class */
        private static Allocator<Npp32s> allocator = ImageAllocatorsCPU.allocator32s3();
        
        /**
         * Creates a new Image
         */
        public ImageCPU_32s_C3()
        {
            super();
        }

        /**
         * Creates a new Image with the given size
         * 
         * @param width The width
         * @param height The height
         */
        public ImageCPU_32s_C3(int width, int height)
        {
            super(width, height);
        }

        /**
         * Creates a new Image with the given size
         * 
         * @param rSize The size
         */
        public ImageCPU_32s_C3(Size rSize)
        {
            super(rSize);
        }

        /**
         * Copy-constructor
         * 
         * @param rImage The other image
         */
        public ImageCPU_32s_C3(ImageCPU<Npp32s> rImage)
        {
            super(rImage);
        }

        @Override
        protected Allocator<Npp32s> allocator()
        {
            return allocator;
        }
    }


    /**
     * Implementation of an image 
     */
    public static class ImageCPU_32s_C4 extends ImageCPU<Npp32s>
    {
        /** The allocator used in this image class */
        private static Allocator<Npp32s> allocator = ImageAllocatorsCPU.allocator32s4();
        
        /**
         * Creates a new Image
         */
        public ImageCPU_32s_C4()
        {
            super();
        }

        /**
         * Creates a new Image with the given size
         * 
         * @param width The width
         * @param height The height
         */
        public ImageCPU_32s_C4(int width, int height)
        {
            super(width, height);
        }

        /**
         * Creates a new Image with the given size
         * 
         * @param rSize The size
         */
        public ImageCPU_32s_C4(Size rSize)
        {
            super(rSize);
        }

        /**
         * Copy-constructor
         * 
         * @param rImage The other image
         */
        public ImageCPU_32s_C4(ImageCPU<Npp32s> rImage)
        {
            super(rImage);
        }

        @Override
        protected Allocator<Npp32s> allocator()
        {
            return allocator;
        }
    }


    /**
     * Implementation of an image 
     */
    public static class ImageCPU_32f_C1 extends ImageCPU<Npp32f>
    {
        /** The allocator used in this image class */
        private static Allocator<Npp32f> allocator = ImageAllocatorsCPU.allocator32f1();
        
        /**
         * Creates a new Image
         */
        public ImageCPU_32f_C1()
        {
            super();
        }

        /**
         * Creates a new Image with the given size
         * 
         * @param width The width
         * @param height The height
         */
        public ImageCPU_32f_C1(int width, int height)
        {
            super(width, height);
        }

        /**
         * Creates a new Image with the given size
         * 
         * @param rSize The size
         */
        public ImageCPU_32f_C1(Size rSize)
        {
            super(rSize);
        }

        /**
         * Copy-constructor
         * 
         * @param rImage The other image
         */
        public ImageCPU_32f_C1(ImageCPU<Npp32f> rImage)
        {
            super(rImage);
        }

        @Override
        protected Allocator<Npp32f> allocator()
        {
            return allocator;
        }
    }


    /**
     * Implementation of an image 
     */
    public static class ImageCPU_32f_C3 extends ImageCPU<Npp32f>
    {
        /** The allocator used in this image class */
        private static Allocator<Npp32f> allocator = ImageAllocatorsCPU.allocator32f3();
        
        /**
         * Creates a new Image
         */
        public ImageCPU_32f_C3()
        {
            super();
        }

        /**
         * Creates a new Image with the given size
         * 
         * @param width The width
         * @param height The height
         */
        public ImageCPU_32f_C3(int width, int height)
        {
            super(width, height);
        }

        /**
         * Creates a new Image with the given size
         * 
         * @param rSize The size
         */
        public ImageCPU_32f_C3(Size rSize)
        {
            super(rSize);
        }

        /**
         * Copy-constructor
         * 
         * @param rImage The other image
         */
        public ImageCPU_32f_C3(ImageCPU<Npp32f> rImage)
        {
            super(rImage);
        }

        @Override
        protected Allocator<Npp32f> allocator()
        {
            return allocator;
        }
    }


    /**
     * Implementation of an image 
     */
    public static class ImageCPU_32f_C4 extends ImageCPU<Npp32f>
    {
        /** The allocator used in this image class */
        private static Allocator<Npp32f> allocator = ImageAllocatorsCPU.allocator32f4();
        
        /**
         * Creates a new Image
         */
        public ImageCPU_32f_C4()
        {
            super();
        }

        /**
         * Creates a new Image with the given size
         * 
         * @param width The width
         * @param height The height
         */
        public ImageCPU_32f_C4(int width, int height)
        {
            super(width, height);
        }

        /**
         * Creates a new Image with the given size
         * 
         * @param rSize The size
         */
        public ImageCPU_32f_C4(Size rSize)
        {
            super(rSize);
        }

        /**
         * Copy-constructor
         * 
         * @param rImage The other image
         */
        public ImageCPU_32f_C4(ImageCPU<Npp32f> rImage)
        {
            super(rImage);
        }

        @Override
        protected Allocator<Npp32f> allocator()
        {
            return allocator;
        }
    }


    
}
